/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.app.ActivityManagerNative;
import android.app.Notification;
import android.app.PendingIntent;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.NetworkUtils;
import android.net.wifi.ScanResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiMonitor;
import android.net.wifi.WifiNative;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.app.IBatteryStats;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class WifiStateTracker
extends NetworkStateTracker {
    private static final int DEFAULT_MAX_DHCP_RETRIES = 9;
    private static final int DISCONNECT_DELAY_MSECS = 5000;
    private static final int DRIVER_HUNG = 2;
    private static final int DRIVER_POWER_MODE_ACTIVE = 1;
    private static final int DRIVER_POWER_MODE_AUTO = 0;
    private static final int DRIVER_STARTED = 0;
    private static final int DRIVER_STOPPED = 1;
    private static final int EVENTLOG_DRIVER_STATE_CHANGED = 50023;
    private static final int EVENTLOG_INTERFACE_CONFIGURATION_STATE_CHANGED = 50024;
    private static final int EVENTLOG_NETWORK_STATE_CHANGED = 50021;
    private static final int EVENTLOG_SUPPLICANT_CONNECTION_STATE_CHANGED = 50025;
    private static final int EVENTLOG_SUPPLICANT_STATE_CHANGED = 50022;
    private static final int EVENT_DEFERRED_DISCONNECT = 10;
    private static final int EVENT_DEFERRED_RECONNECT = 11;
    private static final int EVENT_DHCP_START = 9;
    private static final int EVENT_DRIVER_STATE_CHANGED = 12;
    private static final int EVENT_INTERFACE_CONFIGURATION_FAILED = 7;
    private static final int EVENT_INTERFACE_CONFIGURATION_SUCCEEDED = 6;
    private static final int EVENT_MAYBE_START_SCAN_POST_DISCONNECT = 14;
    private static final int EVENT_NETWORK_STATE_CHANGED = 4;
    private static final int EVENT_PASSWORD_KEY_MAY_BE_INCORRECT = 13;
    private static final int EVENT_POLL_INTERVAL = 8;
    private static final int EVENT_SCAN_RESULTS_AVAILABLE = 5;
    private static final int EVENT_SUPPLICANT_CONNECTION = 1;
    private static final int EVENT_SUPPLICANT_DISCONNECT = 2;
    private static final int EVENT_SUPPLICANT_STATE_CHANGED = 3;
    private static final int ICON_NETWORKS_AVAILABLE = 17302164;
    private static final int KICKSTART_SCANNING_DELAY_MSECS = 15000;
    private static final boolean LOCAL_LOGD = true;
    private static String LS;
    private static final int MAX_SUPPLICANT_LOOP_ITERATIONS = 4;
    private static final int NUM_SCANS_BEFORE_ACTUALLY_SCANNING = 3;
    private static final int POLL_STATUS_INTERVAL_MSECS = 3000;
    private static final int RECONNECT_DELAY_MSECS = 2000;
    private static final int RUN_STATE_RUNNING = 2;
    private static final int RUN_STATE_STARTING = 1;
    private static final int RUN_STATE_STOPPED = 4;
    private static final int RUN_STATE_STOPPING = 3;
    public static final int SUPPL_SCAN_HANDLING_LIST_ONLY = 2;
    public static final int SUPPL_SCAN_HANDLING_NORMAL = 1;
    private static final String TAG = "WifiStateTracker";
    private static final String[] mRunStateNames;
    private static String[] sDnsPropNames;
    private final long NOTIFICATION_REPEAT_DELAY_MS;
    private final IBatteryStats mBatteryStats;
    private BluetoothA2dp mBluetoothA2dp;
    private DhcpInfo mDhcpInfo;
    private DhcpHandler mDhcpTarget;
    private boolean mDisconnectExpected;
    private boolean mDisconnectPending;
    private boolean mEnableRssiPolling;
    private boolean mHaveIpAddress = false;
    private String mInterfaceName;
    private AtomicBoolean mIsAnyNetworkDisabled;
    private boolean mIsHighPerfEnabled;
    private boolean mIsScanModeActive;
    private boolean mIsScanOnly;
    private String mLastBssid;
    private int mLastNetworkId = -1;
    private final WorkSource mLastRunningWifiUids;
    private int mLastSignalLevel = -1;
    private String mLastSsid;
    private Notification mNotification;
    private boolean mNotificationEnabled;
    private NotificationEnabledSettingObserver mNotificationEnabledSettingObserver;
    private long mNotificationRepeatTime;
    private boolean mNotificationShown;
    private int mNumAllowedChannels = 0;
    private int mNumScansSinceNetworkStateChange;
    private int mNumSupplicantLoopIterations = 0;
    private int mNumSupplicantStateChanges = 0;
    private boolean mObtainingIpAddress = false;
    private int mOptimizationsDisabledRefCount = 0;
    private boolean mPasswordKeyMayBeIncorrect = false;
    private int mPowerModeRefCount = 0;
    private int mReconnectCount;
    private boolean mReportedRunning = false;
    private int mRunState;
    private final WorkSource mRunningWifiUids;
    private List<ScanResult> mScanResults;
    private SettingsObserver mSettingsObserver;
    private SupplicantState mSupplicantLoopState = SupplicantState.DISCONNECTED;
    private boolean mTornDownByConnMgr;
    private boolean mUseStaticIp = false;
    private WifiManager mWM;
    private WifiInfo mWifiInfo;
    private WifiMonitor mWifiMonitor;
    private final AtomicInteger mWifiState;

    static {
        mRunStateNames = new String[]{"Starting", "Running", "Stopping", "Stopped"};
        LS = System.getProperty("line.separator");
    }

    public WifiStateTracker(Context context, Handler handler) {
        super(context, handler, 1, 0, "WIFI", "");
        this.mIsAnyNetworkDisabled = new AtomicBoolean(false);
        this.mWifiState = new AtomicInteger(4);
        this.mRunningWifiUids = new WorkSource();
        this.mLastRunningWifiUids = new WorkSource();
        this.mWifiInfo = new WifiInfo();
        this.mWifiMonitor = new WifiMonitor(this);
        this.setTornDownByConnMgr(false);
        this.mDisconnectPending = false;
        this.mScanResults = new ArrayList<ScanResult>();
        this.mDhcpInfo = new DhcpInfo();
        this.mRunState = 1;
        this.NOTIFICATION_REPEAT_DELAY_MS = 1000L * (long)Settings.Secure.getInt(context.getContentResolver(), "wifi_networks_available_repeat_delay", 900);
        this.mNotificationEnabledSettingObserver = new NotificationEnabledSettingObserver(new Handler());
        this.mNotificationEnabledSettingObserver.register();
        this.mSettingsObserver = new SettingsObserver(new Handler());
        this.mInterfaceName = SystemProperties.get("wifi.interface", "tiwlan0");
        String[] stringArray = new String[]{"dhcp." + this.mInterfaceName + ".dns1", "dhcp." + this.mInterfaceName + ".dns2"};
        sDnsPropNames = stringArray;
        this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batteryinfo"));
    }

    static /* synthetic */ boolean access$1202(WifiStateTracker wifiStateTracker, boolean bl) {
        wifiStateTracker.mNotificationEnabled = bl;
        return bl;
    }

    private void cancelDisconnect() {
        this.mDisconnectPending = false;
        this.removeMessages(10);
    }

    private void checkIsBluetoothPlaying() {
        boolean bl;
        block1: {
            BluetoothDevice bluetoothDevice;
            Iterator<BluetoothDevice> iterator = this.mBluetoothA2dp.getConnectedSinks().iterator();
            do {
                boolean bl2 = iterator.hasNext();
                bl = false;
                if (!bl2) break block1;
            } while (this.mBluetoothA2dp.getSinkState(bluetoothDevice = iterator.next()) != 4);
            bl = true;
        }
        this.setBluetoothScanMode(bl);
    }

    private void checkPollTimer() {
        synchronized (this) {
            if (this.mEnableRssiPolling && this.mWifiInfo.getSupplicantState() == SupplicantState.COMPLETED && !this.hasMessages(8)) {
                this.sendEmptyMessageDelayed(8, 3000L);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkUseStaticIp() {
        ContentResolver contentResolver;
        block7: {
            this.mUseStaticIp = false;
            contentResolver = this.mContext.getContentResolver();
            try {
                int n = Settings.System.getInt(contentResolver, "wifi_use_static_ip");
                if (n != 0) break block7;
                return;
            }
            catch (Settings.SettingNotFoundException settingNotFoundException) {
                return;
            }
        }
        try {
            String string2 = Settings.System.getString(contentResolver, "wifi_static_ip");
            if (string2 == null) return;
            this.mDhcpInfo.ipAddress = WifiStateTracker.stringToIpAddr(string2);
            String string3 = Settings.System.getString(contentResolver, "wifi_static_gateway");
            if (string3 == null) return;
            this.mDhcpInfo.gateway = WifiStateTracker.stringToIpAddr(string3);
            String string4 = Settings.System.getString(contentResolver, "wifi_static_netmask");
            if (string4 == null) return;
            this.mDhcpInfo.netmask = WifiStateTracker.stringToIpAddr(string4);
            String string5 = Settings.System.getString(contentResolver, "wifi_static_dns1");
            if (string5 == null) {
                return;
            }
            this.mDhcpInfo.dns1 = WifiStateTracker.stringToIpAddr(string5);
            String string6 = Settings.System.getString(contentResolver, "wifi_static_dns2");
            this.mDhcpInfo.dns2 = string6 != null ? WifiStateTracker.stringToIpAddr(string6) : 0;
            this.mUseStaticIp = true;
            return;
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void configureInterface() {
        int n;
        this.checkPollTimer();
        this.mLastSignalLevel = -1;
        if (!this.mUseStaticIp) {
            if (!this.mHaveIpAddress && !this.mObtainingIpAddress) {
                this.mObtainingIpAddress = true;
                this.mDhcpTarget.sendEmptyMessage(9);
            }
            return;
        }
        if (NetworkUtils.configureInterface(this.mInterfaceName, this.mDhcpInfo)) {
            this.mHaveIpAddress = true;
            n = 6;
            Log.v(TAG, "Static IP configuration succeeded");
        } else {
            this.mHaveIpAddress = false;
            n = 7;
            Log.v(TAG, "Static IP configuration failed");
        }
        this.sendEmptyMessage(n);
    }

    private int getMaxDhcpRetries() {
        return Settings.Secure.getInt(this.mContext.getContentResolver(), "wifi_max_dhcp_retry_count", 9);
    }

    private void handleDisconnectedState(NetworkInfo.DetailedState detailedState, boolean bl) {
        if (this.mDisconnectPending) {
            this.cancelDisconnect();
        }
        this.mDisconnectExpected = false;
        this.resetConnections(bl);
        this.setDetailedState(detailedState);
        this.sendNetworkStateChangeBroadcast(this.mLastBssid);
        this.mWifiInfo.setBSSID(null);
        this.mLastBssid = null;
        this.mLastSsid = null;
        this.mDisconnectPending = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isSupplicantLooping(SupplicantState supplicantState) {
        if (SupplicantState.ASSOCIATING.ordinal() <= supplicantState.ordinal() && supplicantState.ordinal() < SupplicantState.COMPLETED.ordinal()) {
            if (this.mSupplicantLoopState == supplicantState) return this.mNumSupplicantLoopIterations >= 4;
            if (supplicantState.ordinal() < this.mSupplicantLoopState.ordinal()) {
                this.mNumSupplicantLoopIterations = 1 + this.mNumSupplicantLoopIterations;
            }
            this.mSupplicantLoopState = supplicantState;
            return this.mNumSupplicantLoopIterations >= 4;
        }
        if (supplicantState != SupplicantState.COMPLETED) return this.mNumSupplicantLoopIterations >= 4;
        this.resetSupplicantLoopState();
        return this.mNumSupplicantLoopIterations >= 4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void requestConnectionStatus(WifiInfo wifiInfo) {
        int n = -1;
        String string2 = this.status();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (string2 != null) {
            String[] stringArray = string2.split("\n");
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                String[] stringArray2 = stringArray[i].split(" *= *");
                if (stringArray2.length < 2) continue;
                String string6 = stringArray2[0];
                String string7 = stringArray2[1];
                if (string6.equalsIgnoreCase("id")) {
                    n = Integer.parseInt(string7);
                    continue;
                }
                if (string6.equalsIgnoreCase("ssid")) {
                    string4 = string7;
                    continue;
                }
                if (string6.equalsIgnoreCase("bssid")) {
                    string3 = string7;
                    continue;
                }
                if (!string6.equalsIgnoreCase("wpa_state")) continue;
                string5 = string7;
            }
        }
        wifiInfo.setNetworkId(n);
        wifiInfo.setSSID(string4);
        wifiInfo.setBSSID(string3);
        if (this.mWifiInfo.getSupplicantState() == SupplicantState.UNINITIALIZED && string5 != null) {
            this.setSupplicantState(string5);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void requestPolledInfo(WifiInfo wifiInfo, boolean bl) {
        synchronized (this) {
            int n;
            int n2 = bl ? this.getRssiApprox() : this.getRssi();
            if (n2 != -1 && -200 < n2 && n2 < 256) {
                if (n2 > 0) {
                    n2 -= 256;
                }
                wifiInfo.setRssi(n2);
                int n3 = WifiManager.calculateSignalLevel(n2, 4);
                if (n3 != this.mLastSignalLevel) {
                    this.sendRssiChangeBroadcast(n2);
                }
                this.mLastSignalLevel = n3;
            } else {
                wifiInfo.setRssi(-200);
            }
            if ((n = this.getLinkSpeed()) != -1) {
                wifiInfo.setLinkSpeed(n);
            }
            return;
        }
    }

    private void resetNotificationTimer() {
        this.mNotificationRepeatTime = 0L;
        this.mNumScansSinceNetworkStateChange = 0;
    }

    private void resetSupplicantLoopState() {
        this.mNumSupplicantLoopIterations = 0;
    }

    private void scheduleDisconnect() {
        this.mDisconnectPending = true;
        if (!this.hasMessages(10)) {
            this.sendEmptyMessageDelayed(10, 5000L);
        }
    }

    private void sendNetworkStateChangeBroadcast(String string2) {
        Intent intent = new Intent("android.net.wifi.STATE_CHANGE");
        intent.addFlags(0x30000000);
        intent.putExtra("networkInfo", this.mNetworkInfo);
        if (string2 != null) {
            intent.putExtra("bssid", string2);
        }
        this.mContext.sendStickyBroadcast(intent);
    }

    private void sendRssiChangeBroadcast(int n) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.net.wifi.RSSI_CHANGED");
            intent.putExtra("newRssi", n);
            this.mContext.sendBroadcast(intent);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setPowerMode(int n) {
        synchronized (this) {
            block9: {
                boolean bl;
                switch (n) {
                    case 1: {
                        this.mPowerModeRefCount = 1 + this.mPowerModeRefCount;
                        break;
                    }
                    case 0: {
                        --this.mPowerModeRefCount;
                        if (this.mPowerModeRefCount > 0) break block9;
                        this.mPowerModeRefCount = 0;
                    }
                }
                if (this.mWifiState.get() == 3 && !(bl = this.isDriverStopped())) {
                    WifiNative.setPowerModeCommand(n);
                }
            }
            return;
        }
    }

    private void setSupplicantState(SupplicantState supplicantState) {
        this.mWifiInfo.setSupplicantState(supplicantState);
        this.updateNetworkInfo();
        this.checkPollTimer();
    }

    private void setSupplicantState(String string2) {
        this.mWifiInfo.setSupplicantState(string2);
        this.updateNetworkInfo();
        this.checkPollTimer();
    }

    private void setTornDownByConnMgr(boolean bl) {
        this.mTornDownByConnMgr = bl;
        this.updateNetworkInfo();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int stringToIpAddr(String string2) throws UnknownHostException {
        String[] stringArray;
        try {
            stringArray = string2.split("\\.");
            if (stringArray.length != 4) {
                throw new UnknownHostException(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new UnknownHostException(string2);
        }
        {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]) << 8;
            int n3 = Integer.parseInt(stringArray[2]) << 16;
            int n4 = Integer.parseInt(stringArray[3]);
            return n4 << 24 | (n3 | (n | n2));
        }
    }

    private void updateNetworkInfo() {
        this.mNetworkInfo.setIsAvailable(this.isAvailable());
    }

    private boolean wifiManagerDisableNetwork(int n) {
        boolean bl = false;
        if (n >= 0 && (bl = this.mWM.disableNetwork(n))) {
            Log.v(TAG, "Disabled network: " + n);
        }
        if (!bl) {
            Log.e(TAG, "Failed to disable network: invalid network id: " + n);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int addNetwork() {
        synchronized (this) {
            block4: {
                int n = this.mWifiState.get();
                if (n == 3) break block4;
                return -1;
            }
            int n = WifiNative.addNetworkCommand();
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addToBlacklist(String string2) {
        synchronized (this) {
            block4: {
                int n = this.mWifiState.get();
                if (n == 3) break block4;
                return false;
            }
            boolean bl = WifiNative.addToBlacklistCommand(string2);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean clearBlacklist() {
        synchronized (this) {
            block4: {
                int n = this.mWifiState.get();
                if (n == 3) break block4;
                return false;
            }
            boolean bl = WifiNative.clearBlacklistCommand();
            return bl;
        }
    }

    public void closeSupplicantConnection() {
        synchronized (this) {
            WifiNative.closeSupplicantConnection();
            return;
        }
    }

    public boolean connectToSupplicant() {
        synchronized (this) {
            boolean bl = WifiNative.connectToSupplicant();
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disableNetwork(int n) {
        synchronized (this) {
            block4: {
                int n2 = this.mWifiState.get();
                if (n2 == 3) break block4;
                return false;
            }
            this.mIsAnyNetworkDisabled.set(true);
            boolean bl = WifiNative.disableNetworkCommand(n);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnect() {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return false;
                boolean bl = this.isDriverStopped();
                if (!bl) break block4;
                return false;
            }
            boolean bl = WifiNative.disconnectCommand();
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean disconnectAndStop() {
        synchronized (this) {
            boolean bl = true;
            if (this.mRunState != 3 && this.mRunState != 4) {
                boolean bl2;
                this.setNotificationVisible(false, 0, false, 0);
                bl = this.mWifiInfo.getSupplicantState() == SupplicantState.DORMANT ? this.stopDriver() : (bl2 = this.disconnect());
                this.mRunState = 3;
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enableAllNetworks(List<WifiConfiguration> list) {
        synchronized (this) {
            int n = this.mWifiState.get();
            if (n == 3) {
                this.mIsAnyNetworkDisabled.set(false);
                for (WifiConfiguration wifiConfiguration : list) {
                    if (wifiConfiguration.status != 1) continue;
                    WifiNative.enableNetworkCommand(wifiConfiguration.networkId, false);
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enableNetwork(int n, boolean bl) {
        synchronized (this) {
            block4: {
                int n2 = this.mWifiState.get();
                if (n2 == 3) break block4;
                return false;
            }
            boolean bl2 = WifiNative.enableNetworkCommand(n, bl);
            if (!bl) return bl2;
            this.mIsAnyNetworkDisabled.set(true);
            return bl2;
        }
    }

    public void enableRssiPolling(boolean bl) {
        if (this.mEnableRssiPolling != bl) {
            this.mEnableRssiPolling = bl;
            this.checkPollTimer();
        }
    }

    public DhcpInfo getDhcpInfo() {
        return this.mDhcpInfo;
    }

    public String getInterfaceName() {
        return this.mInterfaceName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLinkSpeed() {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return -1;
                boolean bl = this.isDriverStopped();
                if (!bl) break block4;
                return -1;
            }
            int n = WifiNative.getLinkSpeedCommand();
            return n;
        }
    }

    @Override
    public String[] getNameServers() {
        return WifiStateTracker.getNameServerList(sDnsPropNames);
    }

    public int getNetworkSubtype() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNetworkVariable(int n, String string2) {
        synchronized (this) {
            block4: {
                int n2 = this.mWifiState.get();
                if (n2 == 3) break block4;
                return null;
            }
            String string3 = WifiNative.getNetworkVariableCommand(n, string2);
            return string3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getNumAllowedChannels() {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return -1;
                boolean bl = this.isDriverStopped();
                if (!bl) break block4;
                return -1;
            }
            int n = WifiNative.getNumAllowedChannelsCommand();
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPowerMode() {
        synchronized (this) {
            block4: {
                boolean bl;
                if (this.mWifiState.get() == 3 || (bl = this.isDriverStopped())) break block4;
                return -1;
            }
            int n = WifiNative.getPowerModeCommand();
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRssi() {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return -1;
                boolean bl = this.isDriverStopped();
                if (!bl) break block4;
                return -1;
            }
            int n = WifiNative.getRssiApproxCommand();
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRssiApprox() {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return -1;
                boolean bl = this.isDriverStopped();
                if (!bl) break block4;
                return -1;
            }
            int n = WifiNative.getRssiApproxCommand();
            return n;
        }
    }

    public List<ScanResult> getScanResultsList() {
        synchronized (this) {
            List<ScanResult> list = this.mScanResults;
            return list;
        }
    }

    public SupplicantState getSupplicantState() {
        return this.mWifiInfo.getSupplicantState();
    }

    @Override
    public String getTcpBufferSizesPropName() {
        return "net.tcp.buffersize.wifi";
    }

    public int getWifiState() {
        return this.mWifiState.get();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message var1_1) {
        switch (var1_1.what) {
            case 1: {
                this.mRunState = 2;
                synchronized (this) {
                    this.updateBatteryWorkSourceLocked(null);
                    var62_2 = WifiNative.getMacAddressCommand();
                    ** if (var62_2 == null) goto lbl9
                }
lbl-1000:
                // 1 sources

                {
                    this.mWifiInfo.setMacAddress(var62_2);
                }
lbl9:
                // 2 sources

                this.checkUseStaticIp();
                this.resetNotificationTimer();
                var63_3 = new HandlerThread("DHCP Handler Thread");
                var63_3.start();
                this.mDhcpTarget = var64_4 = new DhcpHandler(var63_3.getLooper(), this);
                this.mIsScanModeActive = true;
                this.mIsHighPerfEnabled = false;
                this.mOptimizationsDisabledRefCount = 0;
                this.mPowerModeRefCount = 0;
                this.mTornDownByConnMgr = false;
                this.mLastBssid = null;
                this.mLastSsid = null;
                this.mIsAnyNetworkDisabled.set(false);
                this.requestConnectionInfo();
                var66_5 = this.mWifiInfo.getSupplicantState();
                Log.v("WifiStateTracker", "Connection to supplicant established, state=" + var66_5);
                EventLog.writeEvent(50025, 1);
                if (var66_5 == SupplicantState.COMPLETED) {
                    this.mLastBssid = this.mWifiInfo.getBSSID();
                    this.mLastSsid = this.mWifiInfo.getSSID();
                    this.configureInterface();
                }
                if (ActivityManagerNative.isSystemReady()) {
                    var69_6 = new Intent("android.net.wifi.supplicant.CONNECTION_CHANGE");
                    var69_6.putExtra("connected", true);
                    this.mContext.sendBroadcast(var69_6);
                }
                if (var66_5 == SupplicantState.COMPLETED && this.mHaveIpAddress) {
                    this.setDetailedState(NetworkInfo.DetailedState.CONNECTED);
                } else {
                    this.setDetailedState(WifiInfo.getDetailedStateOf(var66_5));
                }
                this.mWM.initializeMulticastFiltering();
                if (this.mBluetoothA2dp == null) {
                    this.mBluetoothA2dp = new BluetoothA2dp(this.mContext);
                }
                this.checkIsBluetoothPlaying();
                this.setNumAllowedChannels();
                return;
            }
            case 2: {
                this.mRunState = 4;
                synchronized (this) {
                    this.updateBatteryWorkSourceLocked(null);
                }
                var53_7 = this.mWifiState.get() != 1 && this.mWifiState.get() != 0;
                if (var53_7) {
                    Log.v("WifiStateTracker", "Supplicant died unexpectedly");
                } else {
                    Log.v("WifiStateTracker", "Connection to supplicant lost");
                }
                var55_8 = var53_7 != false ? 2 : 0;
                EventLog.writeEvent(50025, var55_8);
                this.closeSupplicantConnection();
                if (var53_7) {
                    this.resetConnections(true);
                }
                this.mDhcpTarget.getLooper().quit();
                this.mContext.removeStickyBroadcast(new Intent("android.net.wifi.STATE_CHANGE"));
                if (ActivityManagerNative.isSystemReady()) {
                    var57_9 = new Intent("android.net.wifi.supplicant.CONNECTION_CHANGE");
                    var57_9.putExtra("connected", false);
                    this.mContext.sendBroadcast(var57_9);
                }
                this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED);
                this.setSupplicantState(SupplicantState.UNINITIALIZED);
                this.mHaveIpAddress = false;
                this.mObtainingIpAddress = false;
                if (var53_7) {
                    this.mWM.setWifiEnabled(false);
                    return;
                }
                ** GOTO lbl258
            }
            case 14: {
                if (this.mNumSupplicantStateChanges == var1_1.arg1) {
                    this.scan(false);
                    return;
                }
                ** GOTO lbl258
            }
            case 3: {
                this.mNumSupplicantStateChanges = 1 + this.mNumSupplicantStateChanges;
                var28_10 = (SupplicantStateChangeResult)var1_1.obj;
                var29_11 = var28_10.state;
                var30_12 = this.mWifiInfo.getSupplicantState();
                EventLog.writeEvent(50022, 63 & var29_11.ordinal());
                Log.v("WifiStateTracker", "Changing supplicant state: " + var30_12 + " ==> " + var29_11);
                var33_13 = var28_10.networkId;
                if (var28_10.state == SupplicantState.ASSOCIATING) {
                    this.mLastBssid = var28_10.BSSID;
                }
                if (var29_11 == SupplicantState.DISCONNECTED || var29_11 == SupplicantState.INACTIVE) {
                    this.sendMessageDelayed(this.obtainMessage(14, this.mNumSupplicantStateChanges, 0), 15000L);
                }
                var35_14 = SupplicantState.DISCONNECTED;
                var36_15 = false;
                if (var29_11 == var35_14) {
                    var36_15 = this.mPasswordKeyMayBeIncorrect;
                }
                this.mPasswordKeyMayBeIncorrect = false;
                var37_16 = this.isSupplicantLooping(var29_11);
                var38_17 = false;
                if (var37_16) {
                    Log.v("WifiStateTracker", "Stop WPA supplicant loop and disable network");
                    var38_17 = this.wifiManagerDisableNetwork(var33_13);
                }
                if (var38_17) {
                    this.resetSupplicantLoopState();
                    return;
                }
                if (var29_11 == var30_12 && (var29_11 != SupplicantState.DISCONNECTED || !this.isDriverStopped())) ** GOTO lbl258
                this.setSupplicantState(var29_11);
                if (var29_11 != SupplicantState.DORMANT) ** GOTO lbl136
                var45_18 = this.obtainMessage(11, this.mLastBssid);
                var46_19 = this.mIsScanOnly != false || this.mRunState == 3 ? NetworkInfo.DetailedState.IDLE : NetworkInfo.DetailedState.FAILED;
                this.handleDisconnectedState(var46_19, true);
                if (this.mRunState != 2 || this.mIsScanOnly) ** GOTO lbl128
                this.sendMessageDelayed(var45_18, 2000L);
                ** GOTO lbl145
lbl128:
                // 1 sources

                if (this.mRunState == 3) {
                    this.stopDriver();
                } else if (this.mRunState == 1 && !this.mIsScanOnly) {
                    this.reconnectCommand();
                }
                ** GOTO lbl145
lbl136:
                // 1 sources

                if (var29_11 != SupplicantState.DISCONNECTED) ** GOTO lbl143
                this.mHaveIpAddress = false;
                if (this.isDriverStopped() || this.mDisconnectExpected) {
                    this.handleDisconnectedState(NetworkInfo.DetailedState.DISCONNECTED, true);
                } else {
                    this.scheduleDisconnect();
                }
                ** GOTO lbl145
lbl143:
                // 1 sources

                if (var29_11 != SupplicantState.COMPLETED && !this.mDisconnectPending && (var30_12 != SupplicantState.COMPLETED || var29_11 != SupplicantState.ASSOCIATING && var29_11 != SupplicantState.ASSOCIATED && var29_11 != SupplicantState.FOUR_WAY_HANDSHAKE && var29_11 != SupplicantState.GROUP_HANDSHAKE)) {
                    this.setDetailedState(WifiInfo.getDetailedStateOf(var29_11));
                }
lbl145:
                // 8 sources

                this.mDisconnectExpected = false;
                var39_20 = new Intent("android.net.wifi.supplicant.STATE_CHANGE");
                var39_20.addFlags(0x30000000);
                var39_20.putExtra("newState", var29_11);
                if (var36_15) {
                    Log.d("WifiStateTracker", "Failed to authenticate, disabling network " + var33_13);
                    this.wifiManagerDisableNetwork(var33_13);
                    var39_20.putExtra("supplicantError", 1);
                }
                this.mContext.sendStickyBroadcast(var39_20);
                return;
            }
            case 4: {
                var22_21 = (NetworkStateChangeResult)var1_1.obj;
                EventLog.writeEvent(50021, 63 & var22_21.state.ordinal());
                Log.v("WifiStateTracker", "New network state is " + (Object)var22_21.state);
                if (this.mIsScanOnly) {
                    Log.v("WifiStateTracker", "Dropping event in scan-only mode");
                    return;
                }
                if (var22_21.state != NetworkInfo.DetailedState.SCANNING) {
                    this.mNumScansSinceNetworkStateChange = 0;
                }
                if (var22_21.state == NetworkInfo.DetailedState.DISCONNECTED) {
                    if (this.mWifiInfo.getSupplicantState() != SupplicantState.DORMANT) {
                        this.scheduleDisconnect();
                        return;
                    }
                } else {
                    this.requestConnectionStatus(this.mWifiInfo);
                    if (var22_21.state != NetworkInfo.DetailedState.CONNECTED || this.mHaveIpAddress && !this.mDisconnectPending) {
                        this.setDetailedState(var22_21.state);
                    }
                    if (var22_21.state == NetworkInfo.DetailedState.CONNECTED) {
                        this.setNotificationVisible(false, 0, false, 0);
                        var25_22 = this.mDisconnectPending;
                        this.cancelDisconnect();
                        if (var25_22) {
                            var26_23 = this.getNetworkInfo().getDetailedState();
                            this.handleDisconnectedState(NetworkInfo.DetailedState.DISCONNECTED, false);
                            this.setDetailedStateInternal(var26_23);
                        }
                        this.configureInterface();
                        this.mLastBssid = var22_21.BSSID;
                        this.mLastSsid = this.mWifiInfo.getSSID();
                        this.mLastNetworkId = var22_21.networkId;
                        if (this.mHaveIpAddress) {
                            this.setDetailedState(NetworkInfo.DetailedState.CONNECTED);
                        } else {
                            this.setDetailedState(NetworkInfo.DetailedState.OBTAINING_IPADDR);
                        }
                    }
                    this.sendNetworkStateChangeBroadcast(this.mWifiInfo.getBSSID());
                    return;
                }
            }
            case 5: {
                if (ActivityManagerNative.isSystemReady()) {
                    this.mContext.sendBroadcast(new Intent("android.net.wifi.SCAN_RESULTS"));
                }
                this.sendScanResultsAvailable();
                this.setScanMode(false);
                return;
            }
            case 8: {
                if (this.mWifiInfo.getSupplicantState() != SupplicantState.UNINITIALIZED) {
                    this.requestPolledInfo(this.mWifiInfo, true);
                    this.checkPollTimer();
                    return;
                }
                ** GOTO lbl258
            }
            case 10: {
                if (this.mWifiInfo.getSupplicantState() != SupplicantState.UNINITIALIZED) {
                    this.handleDisconnectedState(NetworkInfo.DetailedState.DISCONNECTED, true);
                    return;
                }
                ** GOTO lbl258
            }
            case 11: {
                var16_24 = var1_1.obj != null ? var1_1.obj.toString() : null;
                if (this.mWifiInfo.getSupplicantState() != SupplicantState.UNINITIALIZED) {
                    this.mReconnectCount = var17_25 = 1 + this.mReconnectCount;
                    if (var17_25 > this.getMaxDhcpRetries()) {
                        Log.d("WifiStateTracker", "Failed reconnect count: " + this.mReconnectCount + " Disabling " + var16_24);
                        this.mWM.disableNetwork(this.mLastNetworkId);
                    }
                    this.reconnectCommand();
                    return;
                }
                ** GOTO lbl258
            }
            case 6: {
                if (this.mWifiInfo.getSupplicantState() != SupplicantState.UNINITIALIZED) {
                    this.mReconnectCount = 0;
                    this.mHaveIpAddress = true;
                    this.mObtainingIpAddress = false;
                    this.mWifiInfo.setIpAddress(this.mDhcpInfo.ipAddress);
                    this.mLastSignalLevel = -1;
                    if (this.mNetworkInfo.getDetailedState() != NetworkInfo.DetailedState.CONNECTED) {
                        this.setDetailedState(NetworkInfo.DetailedState.CONNECTED);
                        this.sendNetworkStateChangeBroadcast(this.mWifiInfo.getBSSID());
                    } else {
                        this.mTarget.obtainMessage(4, this.mNetworkInfo).sendToTarget();
                    }
                    Log.v("WifiStateTracker", "IP configuration: " + this.mDhcpInfo);
                    EventLog.writeEvent(50024, 1);
                    this.resetNotificationTimer();
                    return;
                }
                ** GOTO lbl258
            }
            case 7: {
                if (this.mWifiInfo.getSupplicantState() != SupplicantState.UNINITIALIZED) {
                    EventLog.writeEvent(50024, 0);
                    this.mHaveIpAddress = false;
                    this.mWifiInfo.setIpAddress(0);
                    this.mObtainingIpAddress = false;
                    this.disconnect();
                    return;
                }
            }
lbl258:
            // 11 sources

            default: {
                return;
            }
            case 12: {
                EventLog.writeEvent(50023, var1_1.arg1);
                switch (var1_1.arg1) {
                    case 0: {
                        this.setNumAllowedChannels();
                        synchronized (this) {
                            var9_26 = WifiNative.getMacAddressCommand();
                            if (var9_26 != null) {
                                this.mWifiInfo.setMacAddress(var9_26);
                            }
                            this.mRunState = 2;
                            if (!this.mIsScanOnly) {
                                this.reconnectCommand();
                            } else {
                                this.scan(true);
                            }
                            ** break;
                        }
                    }
                    case 1: {
                        this.mRunState = 4;
                    }
lbl281:
                    // 4 sources

                    default: {
                        ** GOTO lbl290
                    }
                    case 2: 
                }
                Log.e("WifiStateTracker", "Wifi Driver reports HUNG - reloading.");
                this.mWM.setWifiEnabled(false);
                this.mWM.setWifiEnabled(true);
lbl290:
                // 2 sources

                synchronized (this) {
                    this.updateBatteryWorkSourceLocked(null);
                    return;
                }
            }
            case 13: 
        }
        this.mPasswordKeyMayBeIncorrect = true;
    }

    public boolean hasIpAddress() {
        return this.mHaveIpAddress;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void interpretScanResultsAvailable() {
        block4: {
            int n;
            block5: {
                block3: {
                    int n2;
                    List<ScanResult> list;
                    if (!this.mNotificationEnabled) break block3;
                    NetworkInfo.State state = this.getNetworkInfo().getState();
                    if (state != NetworkInfo.State.DISCONNECTED && state != NetworkInfo.State.UNKNOWN || (list = this.getScanResultsList()) == null) break block4;
                    n = 0;
                    for (int i = list.size() - 1; i >= 0; --i) {
                        if (!TextUtils.isEmpty(list.get((int)i).capabilities)) continue;
                        ++n;
                    }
                    if (n <= 0) break block4;
                    this.mNumScansSinceNetworkStateChange = n2 = 1 + this.mNumScansSinceNetworkStateChange;
                    if (n2 >= 3) break block5;
                }
                return;
            }
            this.setNotificationVisible(true, n, false, 0);
            return;
        }
        this.setNotificationVisible(false, 0, false, 0);
    }

    public boolean isAnyNetworkDisabled() {
        return this.mIsAnyNetworkDisabled.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAvailable() {
        synchronized (this) {
            SupplicantState supplicantState = this.mWifiInfo.getSupplicantState();
            if (supplicantState == SupplicantState.UNINITIALIZED) return false;
            if (supplicantState == SupplicantState.INACTIVE) return false;
            if (this.mTornDownByConnMgr) return true;
            boolean bl = this.isDriverStopped();
            if (bl) return false;
            return true;
        }
    }

    public boolean isConnectionCompleted() {
        return this.mWifiInfo.getSupplicantState() == SupplicantState.COMPLETED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDriverStopped() {
        synchronized (this) {
            if (this.mRunState == 4) return true;
            int n = this.mRunState;
            if (n != 3) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String listNetworks() {
        synchronized (this) {
            block4: {
                int n = this.mWifiState.get();
                if (n == 3) break block4;
                return null;
            }
            String string2 = WifiNative.listNetworksCommand();
            return string2;
        }
    }

    public boolean loadDriver() {
        synchronized (this) {
            boolean bl = WifiNative.loadDriver();
            return bl;
        }
    }

    void notifyDriverHung() {
        Message.obtain(this, 12, 2, 0).sendToTarget();
    }

    void notifyDriverStarted() {
        Message.obtain(this, 12, 0, 0).sendToTarget();
    }

    void notifyDriverStopped() {
        Message.obtain(this, 12, 1, 0).sendToTarget();
    }

    void notifyPasswordKeyMayBeIncorrect() {
        this.sendEmptyMessage(13);
    }

    void notifyScanResultsAvailable() {
        this.setScanResultHandling(1);
        this.sendEmptyMessage(5);
    }

    void notifyStateChange(int n, String string2, SupplicantState supplicantState) {
        Message.obtain(this, 3, new SupplicantStateChangeResult(n, string2, supplicantState)).sendToTarget();
    }

    void notifyStateChange(NetworkInfo.DetailedState detailedState, String string2, int n) {
        Message.obtain(this, 4, new NetworkStateChangeResult(detailedState, string2, n)).sendToTarget();
    }

    void notifySupplicantConnection() {
        this.sendEmptyMessage(1);
    }

    void notifySupplicantLost() {
        this.sendEmptyMessage(2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean ping() {
        synchronized (this) {
            block4: {
                int n = this.mWifiState.get();
                if (n == 3) break block4;
                return false;
            }
            boolean bl = WifiNative.pingCommand();
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reassociate() {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return false;
                boolean bl = this.isDriverStopped();
                if (!bl) break block4;
                return false;
            }
            boolean bl = WifiNative.reassociateCommand();
            return bl;
        }
    }

    @Override
    public boolean reconnect() {
        if (this.mTornDownByConnMgr) {
            if (this.restart()) {
                this.setTornDownByConnMgr(false);
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reconnectCommand() {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return false;
                boolean bl = this.isDriverStopped();
                if (!bl) break block4;
                return false;
            }
            boolean bl = WifiNative.reconnectCommand();
            return bl;
        }
    }

    @Override
    public void releaseWakeLock() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean reloadConfig() {
        synchronized (this) {
            block4: {
                int n = this.mWifiState.get();
                if (n == 3) break block4;
                return false;
            }
            boolean bl = WifiNative.reloadConfigCommand();
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeNetwork(int n) {
        synchronized (this) {
            boolean bl;
            block6: {
                int n2 = this.mWifiState.get();
                if (n2 == 3) break block6;
                return false;
            }
            this.mDisconnectExpected = bl = WifiNative.removeNetworkCommand(n);
            return bl;
        }
    }

    public WifiInfo requestConnectionInfo() {
        this.requestConnectionStatus(this.mWifiInfo);
        this.requestPolledInfo(this.mWifiInfo, false);
        return this.mWifiInfo;
    }

    public void resetConnections(boolean bl) {
        Log.d(TAG, "Reset connections and stopping DHCP");
        this.mHaveIpAddress = false;
        this.mObtainingIpAddress = false;
        this.mWifiInfo.setIpAddress(0);
        NetworkUtils.resetConnections(this.mInterfaceName);
        this.mDhcpTarget.setCancelCallback(true);
        this.mDhcpTarget.removeMessages(9);
        if (!NetworkUtils.stopDhcp(this.mInterfaceName)) {
            Log.e(TAG, "Could not stop DHCP");
        }
        if (bl) {
            Log.d(TAG, "Disabling interface");
            NetworkUtils.disableInterface(this.mInterfaceName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean restart() {
        synchronized (this) {
            if (!this.isDriverStopped()) return true;
            this.mRunState = 1;
            this.resetConnections(true);
            boolean bl = this.startDriver();
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean saveConfig() {
        synchronized (this) {
            block4: {
                int n = this.mWifiState.get();
                if (n == 3) break block4;
                return false;
            }
            boolean bl = WifiNative.saveConfigCommand();
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean scan(boolean bl) {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return false;
                boolean bl2 = this.isDriverStopped();
                if (!bl2) break block4;
                return false;
            }
            boolean bl3 = WifiNative.scanCommand(bl);
            return bl3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String scanResults() {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return null;
                boolean bl = this.isDriverStopped();
                if (!bl) break block4;
                return null;
            }
            String string2 = WifiNative.scanResultsCommand();
            return string2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setBluetoothCoexistenceMode(int n) {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return false;
                boolean bl = this.isDriverStopped();
                if (!bl) break block4;
                return false;
            }
            boolean bl = WifiNative.setBluetoothCoexistenceModeCommand(n);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBluetoothScanMode(boolean bl) {
        synchronized (this) {
            block6: {
                boolean bl2;
                if (this.mWifiState.get() == 3 && !(bl2 = this.isDriverStopped())) break block6;
                return;
            }
            WifiNative.setBluetoothCoexistenceScanModeCommand(bl);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setHighPerfMode(boolean bl) {
        synchronized (this) {
            if (this.mIsHighPerfEnabled != bl) {
                if (bl) {
                    this.setPowerMode(1);
                    this.setSuspendModeOptimizations(false);
                } else {
                    this.setPowerMode(0);
                    this.setSuspendModeOptimizations(true);
                }
                this.mIsHighPerfEnabled = bl;
                Log.d(TAG, "high performance mode: " + bl);
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setNetworkVariable(int n, String string2, String string3) {
        synchronized (this) {
            block4: {
                int n2 = this.mWifiState.get();
                if (n2 == 3) break block4;
                return false;
            }
            boolean bl = WifiNative.setNetworkVariableCommand(n, string2, string3);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setNotificationVisible(boolean bl, int n, boolean bl2, int n2) {
        Message message;
        block7: {
            block5: {
                block6: {
                    block4: {
                        if (!bl && !this.mNotificationShown && !bl2) break block4;
                        if (!bl) break block5;
                        if (System.currentTimeMillis() >= this.mNotificationRepeatTime) break block6;
                    }
                    return;
                }
                if (this.mNotification == null) {
                    this.mNotification = new Notification();
                    this.mNotification.when = 0L;
                    this.mNotification.icon = 17302164;
                    this.mNotification.flags = 16;
                    this.mNotification.contentIntent = PendingIntent.getActivity(this.mContext, 0, new Intent("android.net.wifi.PICK_WIFI_NETWORK"), 0);
                }
                CharSequence charSequence = this.mContext.getResources().getQuantityText(0x10F0011, n);
                CharSequence charSequence2 = this.mContext.getResources().getQuantityText(17760274, n);
                this.mNotification.tickerText = charSequence;
                this.mNotification.setLatestEventInfo(this.mContext, charSequence, charSequence2, this.mNotification.contentIntent);
                this.mNotificationRepeatTime = System.currentTimeMillis() + this.NOTIFICATION_REPEAT_DELAY_MS;
                message = this.mTarget.obtainMessage(3, 1, 17302164, this.mNotification);
                break block7;
            }
            this.mTarget.removeMessages(3, this.mNotification);
            message = this.mTarget.obtainMessage(3, 0, 17302164);
        }
        this.mTarget.sendMessageDelayed(message, n2);
        this.mNotificationShown = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setNumAllowedChannels() {
        synchronized (this) {
            if (this.mWifiState.get() != 3) return false;
            boolean bl = this.isDriverStopped();
            if (bl) {
                return false;
            }
            try {
                bl = this.setNumAllowedChannels(Settings.Secure.getInt(this.mContext.getContentResolver(), "wifi_num_allowed_channels"));
                return bl;
            }
            catch (Settings.SettingNotFoundException settingNotFoundException) {
                if (this.mNumAllowedChannels == 0) return true;
                WifiNative.setNumAllowedChannelsCommand(this.mNumAllowedChannels);
                return true;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setNumAllowedChannels(int n) {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return false;
                boolean bl = this.isDriverStopped();
                if (!bl) break block4;
                return false;
            }
            this.mNumAllowedChannels = n;
            boolean bl = WifiNative.setNumAllowedChannelsCommand(n);
            return bl;
        }
    }

    @Override
    public boolean setRadio(boolean bl) {
        return this.mWM.setWifiEnabled(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setScanMode(boolean bl) {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return false;
                boolean bl2 = this.isDriverStopped();
                if (!bl2) break block4;
                return false;
            }
            if (this.mIsScanModeActive == bl) return true;
            this.mIsScanModeActive = bl;
            boolean bl3 = WifiNative.setScanModeCommand(bl);
            return bl3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setScanOnlyMode(boolean bl) {
        synchronized (this) {
            if (this.mIsScanOnly != bl) {
                int n = bl ? 2 : 1;
                Log.v(TAG, "Scan-only mode changing to " + bl + " scanType=" + n);
                if (this.setScanResultHandling(n)) {
                    this.mIsScanOnly = bl;
                    if (!this.isDriverStopped()) {
                        if (bl) {
                            this.disconnect();
                        } else {
                            this.reconnectCommand();
                        }
                    }
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setScanResultHandling(int n) {
        synchronized (this) {
            block4: {
                int n2 = this.mWifiState.get();
                if (n2 == 3) break block4;
                return false;
            }
            boolean bl = WifiNative.setScanResultHandlingCommand(n);
            return bl;
        }
    }

    public void setScanResultsList(List<ScanResult> list) {
        synchronized (this) {
            this.mScanResults = list;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSuspendModeOptimizations(boolean bl) {
        synchronized (this) {
            block10: {
                boolean bl2;
                block9: {
                    block8: {
                        if (bl) break block8;
                        this.mOptimizationsDisabledRefCount = 1 + this.mOptimizationsDisabledRefCount;
                        break block9;
                    }
                    --this.mOptimizationsDisabledRefCount;
                    if (this.mOptimizationsDisabledRefCount > 0) break block10;
                    this.mOptimizationsDisabledRefCount = 0;
                }
                if (this.mWifiState.get() == 3 && !(bl2 = this.isDriverStopped())) {
                    WifiNative.setSuspendOptimizationsCommand(bl);
                }
            }
            return;
        }
    }

    public void setWifiState(int n) {
        this.mWifiState.set(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startDriver() {
        synchronized (this) {
            block4: {
                int n = this.mWifiState.get();
                if (n == 3) break block4;
                return false;
            }
            boolean bl = WifiNative.startDriverCommand();
            return bl;
        }
    }

    public void startEventLoop() {
        this.mWifiMonitor.startMonitoring();
    }

    @Override
    public void startMonitoring() {
        this.mWM = (WifiManager)this.mContext.getSystemService("wifi");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startPacketFiltering() {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return false;
                boolean bl = this.isDriverStopped();
                if (!bl) break block4;
                return false;
            }
            boolean bl = WifiNative.startPacketFiltering();
            return bl;
        }
    }

    public boolean startSupplicant() {
        synchronized (this) {
            boolean bl = WifiNative.startSupplicant();
            return bl;
        }
    }

    @Override
    public int startUsingNetworkFeature(String string2, int n, int n2) {
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String status() {
        synchronized (this) {
            block4: {
                int n = this.mWifiState.get();
                if (n == 3) break block4;
                return null;
            }
            String string2 = WifiNative.statusCommand();
            return string2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean stopDriver() {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return false;
                int n = this.mRunState;
                if (n != 4) break block4;
                return false;
            }
            boolean bl = WifiNative.stopDriverCommand();
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean stopPacketFiltering() {
        synchronized (this) {
            block4: {
                if (this.mWifiState.get() != 3) return false;
                boolean bl = this.isDriverStopped();
                if (!bl) break block4;
                return false;
            }
            boolean bl = WifiNative.stopPacketFiltering();
            return bl;
        }
    }

    public boolean stopSupplicant() {
        synchronized (this) {
            boolean bl = WifiNative.stopSupplicant();
            return bl;
        }
    }

    @Override
    public int stopUsingNetworkFeature(String string2, int n, int n2) {
        return -1;
    }

    @Override
    public boolean teardown() {
        if (!this.mTornDownByConnMgr) {
            if (this.disconnectAndStop()) {
                this.setTornDownByConnMgr(true);
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("interface ").append(this.mInterfaceName);
        stringBuffer.append(" runState=");
        if (this.mRunState >= 1 && this.mRunState <= mRunStateNames.length) {
            stringBuffer.append(mRunStateNames[this.mRunState - 1]);
        } else {
            stringBuffer.append(this.mRunState);
        }
        stringBuffer.append(LS).append(this.mWifiInfo).append(LS);
        stringBuffer.append(this.mDhcpInfo).append(LS);
        stringBuffer.append("haveIpAddress=").append(this.mHaveIpAddress).append(", obtainingIpAddress=").append(this.mObtainingIpAddress).append(", scanModeActive=").append(this.mIsScanModeActive).append(LS).append("lastSignalLevel=").append(this.mLastSignalLevel).append(", explicitlyDisabled=").append(this.mTornDownByConnMgr);
        return stringBuffer.toString();
    }

    public boolean unloadDriver() {
        synchronized (this) {
            boolean bl = WifiNative.unloadDriver();
            return bl;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void updateBatteryWorkSourceLocked(WorkSource var1_1) {
        if (var1_1 == null) ** GOTO lbl4
        try {
            this.mRunningWifiUids.set(var1_1);
lbl4:
            // 2 sources

            if (this.mRunState != 2) ** GOTO lbl15
            if (this.mReportedRunning) {
                if (this.mLastRunningWifiUids.diff(this.mRunningWifiUids)) {
                    this.mBatteryStats.noteWifiRunningChanged(this.mLastRunningWifiUids, this.mRunningWifiUids);
                    this.mLastRunningWifiUids.set(this.mRunningWifiUids);
                    return;
                }
            } else {
                this.mBatteryStats.noteWifiRunning(this.mRunningWifiUids);
                this.mLastRunningWifiUids.set(this.mRunningWifiUids);
                this.mReportedRunning = true;
                return;
lbl15:
                // 1 sources

                if (this.mRunState == 4 && this.mReportedRunning) {
                    this.mBatteryStats.noteWifiStopped(this.mLastRunningWifiUids);
                    this.mLastRunningWifiUids.clear();
                    this.mReportedRunning = false;
                }
            }
            return;
        }
        catch (RemoteException var2_2) {
            return;
        }
    }

    private class DhcpHandler
    extends Handler {
        private BluetoothHeadset mBluetoothHeadset;
        private boolean mCancelCallback;
        private Handler mTarget;

        public DhcpHandler(Looper looper, Handler handler) {
            super(looper);
            this.mTarget = handler;
            this.mBluetoothHeadset = new BluetoothHeadset(WifiStateTracker.this.mContext, null);
        }

        private boolean shouldDisableCoexistenceMode() {
            return this.mBluetoothHeadset.getState(this.mBluetoothHeadset.getCurrentHeadset()) == 0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            int n;
            int n2;
            switch (message.what) {
                default: {
                    return;
                }
                case 9: 
            }
            boolean bl = this.shouldDisableCoexistenceMode();
            boolean bl2 = false;
            if (bl) {
                bl2 = true;
                WifiStateTracker.this.setBluetoothCoexistenceMode(1);
            }
            if ((n2 = WifiStateTracker.this.getPowerMode()) < 0) {
                n2 = 0;
            }
            if (n2 != 1) {
                WifiStateTracker.this.setPowerMode(1);
            }
            synchronized (this) {
                this.mCancelCallback = false;
            }
            Log.d(WifiStateTracker.TAG, "DhcpHandler: DHCP request started");
            if (NetworkUtils.runDhcp(WifiStateTracker.this.mInterfaceName, WifiStateTracker.this.mDhcpInfo)) {
                n = 6;
                Log.v(WifiStateTracker.TAG, "DhcpHandler: DHCP request succeeded");
            } else {
                n = 7;
                Log.i(WifiStateTracker.TAG, "DhcpHandler: DHCP request failed: " + NetworkUtils.getDhcpError());
            }
            if (n2 != 1) {
                WifiStateTracker.this.setPowerMode(n2);
            }
            if (bl2) {
                WifiStateTracker.this.setBluetoothCoexistenceMode(2);
            }
            synchronized (this) {
                if (!this.mCancelCallback) {
                    this.mTarget.sendEmptyMessage(n);
                }
                return;
            }
        }

        public void setCancelCallback(boolean bl) {
            synchronized (this) {
                this.mCancelCallback = bl;
                return;
            }
        }
    }

    private static class NetworkStateChangeResult {
        String BSSID;
        int networkId;
        NetworkInfo.DetailedState state;

        NetworkStateChangeResult(NetworkInfo.DetailedState detailedState, String string2, int n) {
            this.state = detailedState;
            this.BSSID = string2;
            this.networkId = n;
        }
    }

    private class NotificationEnabledSettingObserver
    extends ContentObserver {
        public NotificationEnabledSettingObserver(Handler handler) {
            super(handler);
        }

        private boolean getValue() {
            return Settings.Secure.getInt(WifiStateTracker.this.mContext.getContentResolver(), "wifi_networks_available_notification_on", 1) == 1;
        }

        @Override
        public void onChange(boolean bl) {
            super.onChange(bl);
            WifiStateTracker.access$1202(WifiStateTracker.this, this.getValue());
            if (!WifiStateTracker.this.mNotificationEnabled) {
                WifiStateTracker.this.setNotificationVisible(false, 0, true, 0);
            }
            WifiStateTracker.this.resetNotificationTimer();
        }

        public void register() {
            WifiStateTracker.this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("wifi_networks_available_notification_on"), true, this);
            WifiStateTracker.access$1202(WifiStateTracker.this, this.getValue());
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        public SettingsObserver(Handler handler) {
            super(handler);
            ContentResolver contentResolver = WifiStateTracker.this.mContext.getContentResolver();
            contentResolver.registerContentObserver(Settings.System.getUriFor("wifi_use_static_ip"), false, this);
            contentResolver.registerContentObserver(Settings.System.getUriFor("wifi_static_ip"), false, this);
            contentResolver.registerContentObserver(Settings.System.getUriFor("wifi_static_gateway"), false, this);
            contentResolver.registerContentObserver(Settings.System.getUriFor("wifi_static_netmask"), false, this);
            contentResolver.registerContentObserver(Settings.System.getUriFor("wifi_static_dns1"), false, this);
            contentResolver.registerContentObserver(Settings.System.getUriFor("wifi_static_dns2"), false, this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onChange(boolean bl) {
            super.onChange(bl);
            boolean bl2 = WifiStateTracker.this.mUseStaticIp;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (bl2) {
                n4 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.ipAddress;
                n3 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.gateway;
                n5 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.netmask;
                n = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns1;
                n2 = ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns2;
            }
            WifiStateTracker.this.checkUseStaticIp();
            if (WifiStateTracker.this.mWifiInfo.getSupplicantState() == SupplicantState.UNINITIALIZED) {
                return;
            }
            if (bl2 == WifiStateTracker.this.mUseStaticIp) {
                if (!bl2) return;
                if (n4 == ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.ipAddress && n3 == ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.gateway && n5 == ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.netmask && n == ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns1) {
                    if (n2 == ((WifiStateTracker)WifiStateTracker.this).mDhcpInfo.dns2) return;
                }
            }
            boolean bl3 = true;
            if (!bl3) return;
            WifiStateTracker.this.resetConnections(true);
            WifiStateTracker.this.configureInterface();
            if (!WifiStateTracker.this.mUseStaticIp) return;
            WifiStateTracker.this.mTarget.obtainMessage(4, WifiStateTracker.this.mNetworkInfo).sendToTarget();
        }
    }

    private static class SupplicantStateChangeResult {
        String BSSID;
        int networkId;
        SupplicantState state;

        SupplicantStateChangeResult(int n, String string2, SupplicantState supplicantState) {
            this.state = supplicantState;
            this.BSSID = string2;
            this.networkId = n;
        }
    }
}

