/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IP2pInitiator
extends IInterface {
    public byte[] getGeneralBytes(int var1) throws RemoteException;

    public int getMode(int var1) throws RemoteException;

    public byte[] receive(int var1) throws RemoteException;

    public boolean send(int var1, byte[] var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IP2pInitiator {
        private static final String DESCRIPTOR = "android.nfc.IP2pInitiator";
        static final int TRANSACTION_getGeneralBytes = 1;
        static final int TRANSACTION_getMode = 2;
        static final int TRANSACTION_receive = 3;
        static final int TRANSACTION_send = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IP2pInitiator asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IP2pInitiator) {
                return (IP2pInitiator)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    byte[] byArray = this.getGeneralBytes(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeByteArray(byArray);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = this.getMode(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n3);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    byte[] byArray = this.receive(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeByteArray(byArray);
                    return true;
                }
                case 4: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            boolean bl = this.send(parcel.readInt(), parcel.createByteArray());
            parcel2.writeNoException();
            int n4 = bl ? 1 : 0;
            parcel2.writeInt(n4);
            return true;
        }

        private static class Proxy
        implements IP2pInitiator {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public byte[] getGeneralBytes(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    byte[] byArray = parcel2.createByteArray();
                    return byArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public int getMode(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public byte[] receive(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    byte[] byArray = parcel2.createByteArray();
                    return byArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean send(int n, byte[] byArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeByteArray(byArray);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = n2 != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

