/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.nfc.ErrorCodes;
import android.nfc.INfcSecureElement;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public final class NfcSecureElement {
    private static final String TAG = "NfcSecureElement";
    private INfcSecureElement mService;

    public NfcSecureElement(INfcSecureElement iNfcSecureElement) {
        this.mService = iNfcSecureElement;
    }

    public void closeSecureElementConnection(int n) throws IOException {
        try {
            if (ErrorCodes.isError(this.mService.closeSecureElementConnection(n))) {
                throw new IOException("Error during the conection close");
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in closeSecureElement(): ", remoteException);
        }
    }

    public byte[] exchangeAPDU(int n, byte[] byArray) throws IOException {
        byte[] byArray2;
        block3: {
            try {
                byArray2 = this.mService.exchangeAPDU(n, byArray);
                if (byArray2 != null) break block3;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException in exchangeAPDU(): ", remoteException);
                return null;
            }
            throw new IOException("Exchange APDU failed");
        }
        return byArray2;
    }

    public int[] getSecureElementTechList(int n) throws IOException {
        try {
            int[] nArray = this.mService.getSecureElementTechList(n);
            return nArray;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in getType(): ", remoteException);
            return null;
        }
    }

    public byte[] getSecureElementUid(int n) throws IOException {
        byte[] byArray;
        block3: {
            try {
                byArray = this.mService.getSecureElementUid(n);
                if (byArray != null) break block3;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "RemoteException in getType(): ", remoteException);
                return null;
            }
            throw new IOException("Get Secure Element UID failed");
        }
        return byArray;
    }

    public int openSecureElementConnection(String string2) throws IOException {
        if (string2.equals("SmartMX")) {
            block5: {
                try {
                    int n = this.mService.openSecureElementConnection();
                    if (n == 0) break block5;
                    return n;
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "RemoteException in openSecureElementConnection(): ", remoteException);
                    return 0;
                }
            }
            throw new IOException("SmartMX connection not allowed");
        }
        if (string2.equals("UICC")) {
            return 0;
        }
        throw new IOException("Wrong Secure Element type");
    }
}

