/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.GLException;
import java.io.IOException;
import java.io.Writer;
import javax.microedition.khronos.egl.EGL;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGL11;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

class EGLLogWrapper
implements EGL11 {
    private int mArgCount;
    boolean mCheckError;
    private EGL10 mEgl10;
    Writer mLog;
    boolean mLogArgumentNames;

    /*
     * Enabled aggressive block sorting
     */
    public EGLLogWrapper(EGL eGL, int n, Writer writer) {
        this.mEgl10 = (EGL10)eGL;
        this.mLog = writer;
        boolean bl = (n & 4) != 0;
        this.mLogArgumentNames = bl;
        boolean bl2 = (n & 1) != 0;
        this.mCheckError = bl2;
    }

    private void arg(String string2, int n) {
        this.arg(string2, Integer.toString(n));
    }

    private void arg(String string2, Object object) {
        this.arg(string2, this.toString(object));
    }

    private void arg(String string2, String string3) {
        int n = this.mArgCount;
        this.mArgCount = n + 1;
        if (n > 0) {
            this.log(", ");
        }
        if (this.mLogArgumentNames) {
            this.log(string2 + "=");
        }
        this.log(string3);
    }

    private void arg(String string2, EGLContext eGLContext) {
        if (eGLContext == EGL10.EGL_NO_CONTEXT) {
            this.arg(string2, "EGL10.EGL_NO_CONTEXT");
            return;
        }
        this.arg(string2, this.toString(eGLContext));
    }

    private void arg(String string2, EGLDisplay eGLDisplay) {
        if (eGLDisplay == EGL10.EGL_DEFAULT_DISPLAY) {
            this.arg(string2, "EGL10.EGL_DEFAULT_DISPLAY");
            return;
        }
        if (eGLDisplay == EGL_NO_DISPLAY) {
            this.arg(string2, "EGL10.EGL_NO_DISPLAY");
            return;
        }
        this.arg(string2, this.toString(eGLDisplay));
    }

    private void arg(String string2, EGLSurface eGLSurface) {
        if (eGLSurface == EGL10.EGL_NO_SURFACE) {
            this.arg(string2, "EGL10.EGL_NO_SURFACE");
            return;
        }
        this.arg(string2, this.toString(eGLSurface));
    }

    private void arg(String string2, int[] nArray) {
        if (nArray == null) {
            this.arg(string2, "null");
            return;
        }
        this.arg(string2, this.toString(nArray.length, nArray, 0));
    }

    private void arg(String string2, Object[] objectArray) {
        if (objectArray == null) {
            this.arg(string2, "null");
            return;
        }
        this.arg(string2, this.toString(objectArray.length, objectArray, 0));
    }

    private void begin(String string2) {
        this.log(string2 + '(');
        this.mArgCount = 0;
    }

    private void checkError() {
        int n = this.mEgl10.eglGetError();
        if (n != 12288) {
            String string2 = "eglError: " + EGLLogWrapper.getErrorString(n);
            this.logLine(string2);
            if (this.mCheckError) {
                throw new GLException(n, string2);
            }
        }
    }

    private void end() {
        this.log(");\n");
        this.flush();
    }

    private void flush() {
        try {
            this.mLog.flush();
            return;
        }
        catch (IOException iOException) {
            this.mLog = null;
            return;
        }
    }

    public static String getErrorString(int n) {
        switch (n) {
            default: {
                return EGLLogWrapper.getHex(n);
            }
            case 12288: {
                return "EGL_SUCCESS";
            }
            case 12289: {
                return "EGL_NOT_INITIALIZED";
            }
            case 12290: {
                return "EGL_BAD_ACCESS";
            }
            case 12291: {
                return "EGL_BAD_ALLOC";
            }
            case 12292: {
                return "EGL_BAD_ATTRIBUTE";
            }
            case 12293: {
                return "EGL_BAD_CONFIG";
            }
            case 12294: {
                return "EGL_BAD_CONTEXT";
            }
            case 12295: {
                return "EGL_BAD_CURRENT_SURFACE";
            }
            case 12296: {
                return "EGL_BAD_DISPLAY";
            }
            case 12297: {
                return "EGL_BAD_MATCH";
            }
            case 12298: {
                return "EGL_BAD_NATIVE_PIXMAP";
            }
            case 12299: {
                return "EGL_BAD_NATIVE_WINDOW";
            }
            case 12300: {
                return "EGL_BAD_PARAMETER";
            }
            case 12301: {
                return "EGL_BAD_SURFACE";
            }
            case 12302: 
        }
        return "EGL_CONTEXT_LOST";
    }

    private static String getHex(int n) {
        return "0x" + Integer.toHexString(n);
    }

    private void log(String string2) {
        try {
            this.mLog.write(string2);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void logLine(String string2) {
        this.log(string2 + '\n');
    }

    private void returns(int n) {
        this.returns(Integer.toString(n));
    }

    private void returns(Object object) {
        this.returns(this.toString(object));
    }

    private void returns(String string2) {
        this.log(" returns " + string2 + ";\n");
        this.flush();
    }

    private void returns(boolean bl) {
        this.returns(Boolean.toString(bl));
    }

    /*
     * Enabled aggressive block sorting
     */
    private String toString(int n, int[] nArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\n");
        int n3 = nArray.length;
        int n4 = 0;
        while (true) {
            if (n4 >= n) {
                stringBuilder.append("}");
                return stringBuilder.toString();
            }
            int n5 = n2 + n4;
            stringBuilder.append(" [" + n5 + "] = ");
            if (n5 < 0 || n5 >= n3) {
                stringBuilder.append("out of bounds");
            } else {
                stringBuilder.append(nArray[n5]);
            }
            stringBuilder.append('\n');
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String toString(int n, Object[] objectArray, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\n");
        int n3 = objectArray.length;
        int n4 = 0;
        while (true) {
            if (n4 >= n) {
                stringBuilder.append("}");
                return stringBuilder.toString();
            }
            int n5 = n2 + n4;
            stringBuilder.append(" [" + n5 + "] = ");
            if (n5 < 0 || n5 >= n3) {
                stringBuilder.append("out of bounds");
            } else {
                stringBuilder.append(objectArray[n5]);
            }
            stringBuilder.append('\n');
            ++n4;
        }
    }

    private String toString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    @Override
    public boolean eglChooseConfig(EGLDisplay eGLDisplay, int[] nArray, EGLConfig[] eGLConfigArray, int n, int[] nArray2) {
        this.begin("eglChooseConfig");
        this.arg("display", eGLDisplay);
        this.arg("attrib_list", nArray);
        this.arg("config_size", n);
        this.end();
        boolean bl = this.mEgl10.eglChooseConfig(eGLDisplay, nArray, eGLConfigArray, n, nArray2);
        this.arg("configs", eGLConfigArray);
        this.arg("num_config", nArray2);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    @Override
    public boolean eglCopyBuffers(EGLDisplay eGLDisplay, EGLSurface eGLSurface, Object object) {
        this.begin("eglCopyBuffers");
        this.arg("display", eGLDisplay);
        this.arg("surface", eGLSurface);
        this.arg("native_pixmap", object);
        this.end();
        boolean bl = this.mEgl10.eglCopyBuffers(eGLDisplay, eGLSurface, object);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    @Override
    public EGLContext eglCreateContext(EGLDisplay eGLDisplay, EGLConfig eGLConfig, EGLContext eGLContext, int[] nArray) {
        this.begin("eglCreateContext");
        this.arg("display", eGLDisplay);
        this.arg("config", eGLConfig);
        this.arg("share_context", eGLContext);
        this.arg("attrib_list", nArray);
        this.end();
        EGLContext eGLContext2 = this.mEgl10.eglCreateContext(eGLDisplay, eGLConfig, eGLContext, nArray);
        this.returns(eGLContext2);
        this.checkError();
        return eGLContext2;
    }

    @Override
    public EGLSurface eglCreatePbufferSurface(EGLDisplay eGLDisplay, EGLConfig eGLConfig, int[] nArray) {
        this.begin("eglCreatePbufferSurface");
        this.arg("display", eGLDisplay);
        this.arg("config", eGLConfig);
        this.arg("attrib_list", nArray);
        this.end();
        EGLSurface eGLSurface = this.mEgl10.eglCreatePbufferSurface(eGLDisplay, eGLConfig, nArray);
        this.returns(eGLSurface);
        this.checkError();
        return eGLSurface;
    }

    @Override
    public EGLSurface eglCreatePixmapSurface(EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object, int[] nArray) {
        this.begin("eglCreatePixmapSurface");
        this.arg("display", eGLDisplay);
        this.arg("config", eGLConfig);
        this.arg("native_pixmap", object);
        this.arg("attrib_list", nArray);
        this.end();
        EGLSurface eGLSurface = this.mEgl10.eglCreatePixmapSurface(eGLDisplay, eGLConfig, object, nArray);
        this.returns(eGLSurface);
        this.checkError();
        return eGLSurface;
    }

    @Override
    public EGLSurface eglCreateWindowSurface(EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object, int[] nArray) {
        this.begin("eglCreateWindowSurface");
        this.arg("display", eGLDisplay);
        this.arg("config", eGLConfig);
        this.arg("native_window", object);
        this.arg("attrib_list", nArray);
        this.end();
        EGLSurface eGLSurface = this.mEgl10.eglCreateWindowSurface(eGLDisplay, eGLConfig, object, nArray);
        this.returns(eGLSurface);
        this.checkError();
        return eGLSurface;
    }

    @Override
    public boolean eglDestroyContext(EGLDisplay eGLDisplay, EGLContext eGLContext) {
        this.begin("eglDestroyContext");
        this.arg("display", eGLDisplay);
        this.arg("context", eGLContext);
        this.end();
        boolean bl = this.mEgl10.eglDestroyContext(eGLDisplay, eGLContext);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    @Override
    public boolean eglDestroySurface(EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
        this.begin("eglDestroySurface");
        this.arg("display", eGLDisplay);
        this.arg("surface", eGLSurface);
        this.end();
        boolean bl = this.mEgl10.eglDestroySurface(eGLDisplay, eGLSurface);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    @Override
    public boolean eglGetConfigAttrib(EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int[] nArray) {
        this.begin("eglGetConfigAttrib");
        this.arg("display", eGLDisplay);
        this.arg("config", eGLConfig);
        this.arg("attribute", n);
        this.end();
        boolean bl = this.mEgl10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, nArray);
        this.arg("value", nArray);
        this.returns(bl);
        this.checkError();
        return false;
    }

    @Override
    public boolean eglGetConfigs(EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray, int n, int[] nArray) {
        this.begin("eglGetConfigs");
        this.arg("display", eGLDisplay);
        this.arg("config_size", n);
        this.end();
        boolean bl = this.mEgl10.eglGetConfigs(eGLDisplay, eGLConfigArray, n, nArray);
        this.arg("configs", eGLConfigArray);
        this.arg("num_config", nArray);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    @Override
    public EGLContext eglGetCurrentContext() {
        this.begin("eglGetCurrentContext");
        this.end();
        EGLContext eGLContext = this.mEgl10.eglGetCurrentContext();
        this.returns(eGLContext);
        this.checkError();
        return eGLContext;
    }

    @Override
    public EGLDisplay eglGetCurrentDisplay() {
        this.begin("eglGetCurrentDisplay");
        this.end();
        EGLDisplay eGLDisplay = this.mEgl10.eglGetCurrentDisplay();
        this.returns(eGLDisplay);
        this.checkError();
        return eGLDisplay;
    }

    @Override
    public EGLSurface eglGetCurrentSurface(int n) {
        this.begin("eglGetCurrentSurface");
        this.arg("readdraw", n);
        this.end();
        EGLSurface eGLSurface = this.mEgl10.eglGetCurrentSurface(n);
        this.returns(eGLSurface);
        this.checkError();
        return eGLSurface;
    }

    @Override
    public EGLDisplay eglGetDisplay(Object object) {
        this.begin("eglGetDisplay");
        this.arg("native_display", object);
        this.end();
        EGLDisplay eGLDisplay = this.mEgl10.eglGetDisplay(object);
        this.returns(eGLDisplay);
        this.checkError();
        return eGLDisplay;
    }

    @Override
    public int eglGetError() {
        this.begin("eglGetError");
        this.end();
        int n = this.mEgl10.eglGetError();
        this.returns(EGLLogWrapper.getErrorString(n));
        return n;
    }

    @Override
    public boolean eglInitialize(EGLDisplay eGLDisplay, int[] nArray) {
        this.begin("eglInitialize");
        this.arg("display", eGLDisplay);
        this.end();
        boolean bl = this.mEgl10.eglInitialize(eGLDisplay, nArray);
        this.returns(bl);
        this.arg("major_minor", nArray);
        this.checkError();
        return bl;
    }

    @Override
    public boolean eglMakeCurrent(EGLDisplay eGLDisplay, EGLSurface eGLSurface, EGLSurface eGLSurface2, EGLContext eGLContext) {
        this.begin("eglMakeCurrent");
        this.arg("display", eGLDisplay);
        this.arg("draw", eGLSurface);
        this.arg("read", eGLSurface2);
        this.arg("context", eGLContext);
        this.end();
        boolean bl = this.mEgl10.eglMakeCurrent(eGLDisplay, eGLSurface, eGLSurface2, eGLContext);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    @Override
    public boolean eglQueryContext(EGLDisplay eGLDisplay, EGLContext eGLContext, int n, int[] nArray) {
        this.begin("eglQueryContext");
        this.arg("display", eGLDisplay);
        this.arg("context", eGLContext);
        this.arg("attribute", n);
        this.end();
        boolean bl = this.mEgl10.eglQueryContext(eGLDisplay, eGLContext, n, nArray);
        this.returns(nArray[0]);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    @Override
    public String eglQueryString(EGLDisplay eGLDisplay, int n) {
        this.begin("eglQueryString");
        this.arg("display", eGLDisplay);
        this.arg("name", n);
        this.end();
        String string2 = this.mEgl10.eglQueryString(eGLDisplay, n);
        this.returns(string2);
        this.checkError();
        return string2;
    }

    @Override
    public boolean eglQuerySurface(EGLDisplay eGLDisplay, EGLSurface eGLSurface, int n, int[] nArray) {
        this.begin("eglQuerySurface");
        this.arg("display", eGLDisplay);
        this.arg("surface", eGLSurface);
        this.arg("attribute", n);
        this.end();
        boolean bl = this.mEgl10.eglQuerySurface(eGLDisplay, eGLSurface, n, nArray);
        this.returns(nArray[0]);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    @Override
    public boolean eglSwapBuffers(EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
        this.begin("eglInitialize");
        this.arg("display", eGLDisplay);
        this.arg("surface", eGLSurface);
        this.end();
        boolean bl = this.mEgl10.eglSwapBuffers(eGLDisplay, eGLSurface);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    @Override
    public boolean eglTerminate(EGLDisplay eGLDisplay) {
        this.begin("eglTerminate");
        this.arg("display", eGLDisplay);
        this.end();
        boolean bl = this.mEgl10.eglTerminate(eGLDisplay);
        this.returns(bl);
        this.checkError();
        return bl;
    }

    @Override
    public boolean eglWaitGL() {
        this.begin("eglWaitGL");
        this.end();
        boolean bl = this.mEgl10.eglWaitGL();
        this.returns(bl);
        this.checkError();
        return bl;
    }

    @Override
    public boolean eglWaitNative(int n, Object object) {
        this.begin("eglWaitNative");
        this.arg("engine", n);
        this.arg("bindTarget", object);
        this.end();
        boolean bl = this.mEgl10.eglWaitNative(n, object);
        this.returns(bl);
        this.checkError();
        return bl;
    }
}

