/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.Material;
import android.opengl.MaterialIndices;
import android.opengl.Object3D;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.microedition.khronos.opengles.GL10;

public class Group {
    private List<MaterialIndices> materialIndices = new ArrayList<MaterialIndices>();
    private String name;
    private Object3D parent;

    public Group(Object3D object3D) {
        this.parent = object3D;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(GL10 gL10) {
        gL10.glDisableClientState(32886);
        gL10.glVertexPointer(3, 5132, 0, this.parent.getVertexBuffer());
        gL10.glEnableClientState(32884);
        gL10.glNormalPointer(5132, 0, this.parent.getNormalBuffer());
        gL10.glEnableClientState(32885);
        if (this.parent.hasTexcoords()) {
            gL10.glTexCoordPointer(2, 5132, 0, this.parent.getTexcoordBuffer());
            gL10.glEnableClientState(32888);
            gL10.glEnable(3553);
        } else {
            gL10.glDisable(3553);
        }
        Iterator<MaterialIndices> iterator = this.materialIndices.iterator();
        while (iterator.hasNext()) {
            MaterialIndices materialIndices = iterator.next();
            ShortBuffer shortBuffer = materialIndices.getIndexBuffer();
            Material material = materialIndices.getMaterial();
            material.setMaterialParameters(gL10);
            if (this.parent.hasTexcoords() && material.getMap_Kd().length() > 0) {
                this.parent.getTexture(material.getMap_Kd()).setTextureParameters(gL10);
            }
            gL10.glDrawElements(4, shortBuffer.capacity(), 5123, shortBuffer);
        }
        return;
    }

    public String getName() {
        return this.name;
    }

    public int getNumTriangles() {
        int n = 0;
        Iterator<MaterialIndices> iterator = this.materialIndices.iterator();
        while (iterator.hasNext()) {
            n += iterator.next().getIndexBuffer().capacity() / 3;
        }
        return n;
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        dataInputStream.readInt();
        this.name = dataInputStream.readUTF();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            dataInputStream.readInt();
            String string2 = dataInputStream.readUTF();
            Material material = this.parent.getMaterial(string2);
            int n2 = dataInputStream.readInt();
            byte[] byArray = new byte[n2 * 2];
            dataInputStream.readFully(byArray);
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                int n3 = 0;
                for (int j = 0; j < n2; ++j) {
                    byte by = byArray[n3];
                    byArray[n3] = byArray[n3 + 1];
                    byArray[n3 + 1] = by;
                    n3 += 2;
                }
            }
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 * 2);
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.put(byArray);
            byteBuffer.position(0);
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            this.materialIndices.add(new MaterialIndices(material, shortBuffer));
        }
    }

    public String toString() {
        return "Group[name=" + this.name + "]";
    }
}

