/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.Object3D;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.khronos.opengles.GL10;

public class Material {
    private static float[] black = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private float d;
    private int illum;
    private float[] ka = new float[4];
    private float[] kd = new float[4];
    private float[] ks = new float[4];
    private String map_kd;
    private String name;
    private float ns;
    private Object3D parent;

    public Material(Object3D object3D) {
        this.parent = object3D;
    }

    public String getMap_Kd() {
        return this.map_kd;
    }

    public String getName() {
        return this.name;
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        dataInputStream.readInt();
        this.name = dataInputStream.readUTF();
        dataInputStream.readInt();
        this.map_kd = dataInputStream.readUTF();
        if (this.parent.hasTexcoords() && this.map_kd.length() > 0) {
            this.parent.loadTexture(this.map_kd);
        }
        this.ka[0] = dataInputStream.readFloat();
        this.ka[1] = dataInputStream.readFloat();
        this.ka[2] = dataInputStream.readFloat();
        this.ka[3] = dataInputStream.readFloat();
        this.kd[0] = dataInputStream.readFloat();
        this.kd[1] = dataInputStream.readFloat();
        this.kd[2] = dataInputStream.readFloat();
        this.kd[3] = dataInputStream.readFloat();
        this.ks[0] = dataInputStream.readFloat();
        this.ks[1] = dataInputStream.readFloat();
        this.ks[2] = dataInputStream.readFloat();
        this.ks[3] = dataInputStream.readFloat();
        this.ns = dataInputStream.readFloat();
        this.illum = dataInputStream.readInt();
        this.d = dataInputStream.readFloat();
    }

    public void setMaterialParameters(GL10 gL10) {
        gL10.glMaterialfv(1032, 4608, this.kd, 0);
        gL10.glMaterialfv(1032, 4609, this.kd, 0);
        gL10.glMaterialfv(1032, 4610, this.ks, 0);
        gL10.glMaterialf(1032, 5633, Math.min(Math.max(this.ns, 0.0f), 128.0f));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append("Material[name=\"").append(this.name).append("\",").append("ka={").append(this.ka[0]).append(",").append(this.ka[1]).append(",").append(this.ka[2]).append("},").append("kd={").append(this.kd[0]).append(",").append(this.kd[1]).append(",").append(this.kd[2]).append("},").append("ks={").append(this.ks[0]).append(",").append(this.ks[1]).append(",").append(this.ks[2]).append("},").append("ns=").append(this.ns).append(",").append("map_kd=\"");
        if (this.map_kd == null) {
            string2 = "";
            return stringBuilder.append(string2).append("\",").append("illum=").append(this.illum).append(",").append("d=").append(this.d).append("]").toString();
        }
        string2 = this.map_kd;
        return stringBuilder.append(string2).append("\",").append("illum=").append(this.illum).append(",").append("d=").append(this.d).append("]").toString();
    }
}

