/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.opengl.Group;
import android.opengl.Material;
import android.opengl.Texture;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.microedition.khronos.opengles.GL10;

public abstract class Object3D {
    private float mBoundsMaxX;
    private float mBoundsMaxY;
    private float mBoundsMaxZ;
    private float mBoundsMinX = Float.MAX_VALUE;
    private float mBoundsMinY;
    private float mBoundsMinZ;
    private Map<String, Group> mGroups;
    private boolean mHasTexcoords = false;
    private Map<String, Material> mMaterials;
    private IntBuffer mNormalBuffer;
    private IntBuffer mTexcoordBuffer;
    private Map<String, Texture> mTextures;
    private IntBuffer mVertexBuffer;

    public Object3D() {
        this.mBoundsMaxX = Float.MIN_VALUE;
        this.mBoundsMinY = Float.MAX_VALUE;
        this.mBoundsMaxY = Float.MIN_VALUE;
        this.mBoundsMinZ = Float.MAX_VALUE;
        this.mBoundsMaxZ = Float.MIN_VALUE;
        this.reset();
    }

    private void reset() {
        this.mTexcoordBuffer = null;
        this.mNormalBuffer = null;
        this.mVertexBuffer = null;
        this.mGroups = new HashMap<String, Group>();
        this.mMaterials = new HashMap<String, Material>();
        this.mTextures = new HashMap<String, Texture>();
    }

    private static void verifyByte(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = 0xFF & dataInputStream.read();
        if (n2 != n) {
            throw new RuntimeException("Bad byte: " + n2 + " (expected " + n + ")");
        }
    }

    public void draw(GL10 gL10) {
        Iterator<Group> iterator = this.mGroups.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().draw(gL10);
        }
    }

    public float getBoundsMaxX() {
        return this.mBoundsMaxX;
    }

    public float getBoundsMaxY() {
        return this.mBoundsMaxY;
    }

    public float getBoundsMaxZ() {
        return this.mBoundsMaxZ;
    }

    public float getBoundsMinX() {
        return this.mBoundsMinX;
    }

    public float getBoundsMinY() {
        return this.mBoundsMinY;
    }

    public float getBoundsMinZ() {
        return this.mBoundsMinZ;
    }

    public Material getMaterial(String string2) {
        return this.mMaterials.get(string2);
    }

    public IntBuffer getNormalBuffer() {
        return this.mNormalBuffer;
    }

    public int getNumTriangles() {
        int n = 0;
        Iterator<Group> iterator = this.mGroups.values().iterator();
        while (iterator.hasNext()) {
            n += iterator.next().getNumTriangles();
        }
        return n;
    }

    public IntBuffer getTexcoordBuffer() {
        return this.mTexcoordBuffer;
    }

    public Texture getTexture(String string2) {
        return this.mTextures.get(string2);
    }

    public IntBuffer getVertexBuffer() {
        return this.mVertexBuffer;
    }

    public boolean hasTexcoords() {
        return this.mHasTexcoords;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void load(String string2) throws IOException {
        int n;
        this.reset();
        DataInputStream dataInputStream = new DataInputStream(this.readFile(string2));
        Object3D.verifyByte(dataInputStream, 231);
        Object3D.verifyByte(dataInputStream, 108);
        Object3D.verifyByte(dataInputStream, 101);
        Object3D.verifyByte(dataInputStream, 115);
        int n2 = dataInputStream.readInt();
        this.mBoundsMinX = dataInputStream.readFloat();
        this.mBoundsMaxX = dataInputStream.readFloat();
        this.mBoundsMinY = dataInputStream.readFloat();
        this.mBoundsMaxY = dataInputStream.readFloat();
        this.mBoundsMinZ = dataInputStream.readFloat();
        this.mBoundsMaxZ = dataInputStream.readFloat();
        boolean bl = dataInputStream.readInt() == 1;
        this.mHasTexcoords = bl;
        int n3 = this.mHasTexcoords ? 8 : 6;
        int cfr_ignored_0 = n2 * n3;
        int n4 = n2 * 4;
        int n5 = this.mHasTexcoords ? 8 : 6;
        int n6 = n4 * n5;
        byte[] byArray = new byte[n6];
        for (int i = 0; i < n6; i += dataInputStream.read(byArray, i, n)) {
            n = n6 - i;
        }
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n6; i += 4) {
                byte by = byArray[i];
                byte by2 = byArray[i + 1];
                byte by3 = byArray[i + 2];
                byArray[i] = byArray[i + 3];
                byArray[i + 1] = by3;
                byArray[i + 2] = by2;
                byArray[i + 3] = by;
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n6);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.put(byArray);
        byteBuffer.position(0);
        byteBuffer.limit(n2 * 12);
        this.mVertexBuffer = byteBuffer.slice().asIntBuffer();
        this.mVertexBuffer.position(0);
        if (this.mHasTexcoords) {
            byteBuffer.position(byteBuffer.limit());
            byteBuffer.limit(byteBuffer.position() + n2 * 8);
            this.mTexcoordBuffer = byteBuffer.slice().asIntBuffer();
            this.mTexcoordBuffer.position(0);
        }
        byteBuffer.position(byteBuffer.limit());
        byteBuffer.limit(byteBuffer.position() + n2 * 12);
        this.mNormalBuffer = byteBuffer.slice().asIntBuffer();
        this.mNormalBuffer.position(0);
        int n7 = dataInputStream.readInt();
        for (int i = 0; i < n7; ++i) {
            Material material = new Material(this);
            material.load(dataInputStream);
            this.mMaterials.put(material.getName(), material);
        }
        int n8 = dataInputStream.readInt();
        int n9 = 0;
        while (n9 < n8) {
            Group group = new Group(this);
            group.load(dataInputStream);
            this.mGroups.put(group.getName(), group);
            ++n9;
        }
        return;
    }

    public void loadTexture(String string2) throws IOException {
        Texture texture = new Texture(this.readFile(string2 + ".raw"));
        this.mTextures.put(string2, texture);
    }

    public abstract InputStream readFile(String var1) throws IOException;
}

