/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.microedition.khronos.opengles.GL10;

public class Texture {
    private int bpp;
    private ByteBuffer data;
    private int height;
    private int name = -1;
    private int width;

    public Texture(InputStream inputStream) throws IOException {
        this.width = this.readInt16(inputStream);
        this.height = this.readInt16(inputStream);
        this.bpp = 2;
        int n = this.width * this.height;
        int n2 = n * this.bpp;
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; i += inputStream.read(byArray, i, n2 - i)) {
        }
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n; ++i) {
                int n3 = i * 2;
                int n4 = n3 + 1;
                byte by = byArray[n3];
                byArray[n3] = byArray[n4];
                byArray[n4] = by;
            }
        }
        this.data = ByteBuffer.allocateDirect(byArray.length);
        this.data.order(ByteOrder.nativeOrder());
        this.data.put(byArray);
        this.data.position(0);
    }

    private int loadTexture(GL10 gL10, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Buffer buffer) {
        int[] nArray = new int[1];
        gL10.glGenTextures(1, nArray, 0);
        gL10.glEnable(3553);
        gL10.glClientActiveTexture(n);
        gL10.glBindTexture(3553, nArray[0]);
        gL10.glTexParameterf(3553, 10241, n2);
        gL10.glTexParameterf(3553, 10240, n3);
        gL10.glTexParameterf(3553, 10242, n4);
        gL10.glTexParameterf(3553, 10243, n5);
        gL10.glTexEnvf(8960, 8704, n6);
        gL10.glTexImage2D(3553, 0, 6407, n7, n8, 0, 6407, n9, buffer);
        return nArray[0];
    }

    private int readInt16(InputStream inputStream) throws IOException {
        return inputStream.read() | inputStream.read() << 8;
    }

    public void setTextureParameters(GL10 gL10) {
        if (this.name < 0) {
            this.name = this.loadTexture(gL10, 33984, 9728, 9728, 10497, 10497, 8448, this.width, this.height, 33635, this.data);
        }
        gL10.glBindTexture(3553, this.name);
    }
}

