/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.pm.ApplicationInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.Printer;
import android.util.SparseArray;
import android.util.TimeUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BatteryStats
implements Parcelable {
    private static final String APK_DATA = "apk";
    public static final int AUDIO_TURNED_ON = 7;
    private static final String BATTERY_DATA = "bt";
    private static final String BATTERY_LEVEL_DATA = "lv";
    private static final int BATTERY_STATS_CHECKIN_VERSION = 5;
    private static final long BYTES_PER_GB = 0x40000000L;
    private static final long BYTES_PER_KB = 1024L;
    private static final long BYTES_PER_MB = 0x100000L;
    public static final int DATA_CONNECTION_1xRTT = 7;
    public static final int DATA_CONNECTION_CDMA = 4;
    private static final String DATA_CONNECTION_COUNT_DATA = "dcc";
    public static final int DATA_CONNECTION_EDGE = 2;
    public static final int DATA_CONNECTION_EVDO_0 = 5;
    public static final int DATA_CONNECTION_EVDO_A = 6;
    public static final int DATA_CONNECTION_EVDO_B = 12;
    public static final int DATA_CONNECTION_GPRS = 1;
    public static final int DATA_CONNECTION_HSDPA = 8;
    public static final int DATA_CONNECTION_HSPA = 10;
    public static final int DATA_CONNECTION_HSUPA = 9;
    public static final int DATA_CONNECTION_IDEN = 11;
    static final String[] DATA_CONNECTION_NAMES;
    public static final int DATA_CONNECTION_NONE = 0;
    public static final int DATA_CONNECTION_OTHER = 13;
    private static final String DATA_CONNECTION_TIME_DATA = "dct";
    public static final int DATA_CONNECTION_UMTS = 3;
    public static final int FULL_WIFI_LOCK = 5;
    public static final BitDescription[] HISTORY_STATE_DESCRIPTIONS;
    private static final String KERNEL_WAKELOCK_DATA = "kwl";
    private static final boolean LOCAL_LOGV = false;
    private static final String MISC_DATA = "m";
    private static final String NETWORK_DATA = "nt";
    public static final int NUM_DATA_CONNECTION_TYPES = 14;
    public static final int NUM_SCREEN_BRIGHTNESS_BINS = 5;
    public static final int NUM_SIGNAL_STRENGTH_BINS = 5;
    private static final String PROCESS_DATA = "pr";
    public static final int SCAN_WIFI_LOCK = 6;
    public static final int SCREEN_BRIGHTNESS_BRIGHT = 4;
    public static final int SCREEN_BRIGHTNESS_DARK = 0;
    private static final String SCREEN_BRIGHTNESS_DATA = "br";
    public static final int SCREEN_BRIGHTNESS_DIM = 1;
    public static final int SCREEN_BRIGHTNESS_LIGHT = 3;
    public static final int SCREEN_BRIGHTNESS_MEDIUM = 2;
    static final String[] SCREEN_BRIGHTNESS_NAMES;
    public static final int SENSOR = 3;
    private static final String SENSOR_DATA = "sr";
    private static final String SIGNAL_SCANNING_TIME_DATA = "sst";
    private static final String SIGNAL_STRENGTH_COUNT_DATA = "sgc";
    public static final int SIGNAL_STRENGTH_GOOD = 3;
    public static final int SIGNAL_STRENGTH_GREAT = 4;
    public static final int SIGNAL_STRENGTH_MODERATE = 2;
    static final String[] SIGNAL_STRENGTH_NAMES;
    public static final int SIGNAL_STRENGTH_NONE_OR_UNKNOWN = 0;
    public static final int SIGNAL_STRENGTH_POOR = 1;
    private static final String SIGNAL_STRENGTH_TIME_DATA = "sgt";
    public static final int STATS_CURRENT = 2;
    public static final int STATS_LAST = 1;
    public static final int STATS_SINCE_CHARGED = 0;
    public static final int STATS_SINCE_UNPLUGGED = 3;
    private static final String[] STAT_NAMES;
    private static final String UID_DATA = "uid";
    private static final String USER_ACTIVITY_DATA = "ua";
    public static final int VIDEO_TURNED_ON = 8;
    private static final String WAKELOCK_DATA = "wl";
    public static final int WAKE_TYPE_FULL = 1;
    public static final int WAKE_TYPE_PARTIAL = 0;
    public static final int WAKE_TYPE_WINDOW = 2;
    private static final String WIFI_LOCK_DATA = "wfl";
    public static final int WIFI_MULTICAST_ENABLED = 7;
    public static final int WIFI_RUNNING = 4;
    private final StringBuilder mFormatBuilder = new StringBuilder(32);
    private final Formatter mFormatter = new Formatter(this.mFormatBuilder);

    static {
        STAT_NAMES = new String[]{"t", "l", "c", "u"};
        SCREEN_BRIGHTNESS_NAMES = new String[]{"dark", "dim", "medium", "light", "bright"};
        SIGNAL_STRENGTH_NAMES = new String[]{"none", "poor", "moderate", "good", "great"};
        DATA_CONNECTION_NAMES = new String[]{"none", "gprs", "edge", "umts", "cdma", "evdo_0", "evdo_A", "1xrtt", "hsdpa", "hsupa", "hspa", "iden", "evdo_b", "other"};
        BitDescription[] bitDescriptionArray = new BitDescription[]{new BitDescription(0x40000000, "plugged"), new BitDescription(0x20000000, "screen"), new BitDescription(0x10000000, "gps"), new BitDescription(0x8000000, "phone_in_call"), new BitDescription(0x4000000, "phone_scanning"), new BitDescription(0x2000000, "wifi"), new BitDescription(0x1000000, "wifi_running"), new BitDescription(0x800000, "wifi_full_lock"), new BitDescription(0x400000, "wifi_scan_lock"), new BitDescription(0x200000, "wifi_multicast"), new BitDescription(0x100000, "bluetooth"), new BitDescription(524288, "audio"), new BitDescription(262144, "video"), new BitDescription(131072, "wake_lock"), new BitDescription(65536, "sensor"), new BitDescription(15, 0, "brightness", SCREEN_BRIGHTNESS_NAMES), new BitDescription(240, 4, "signal_strength", SIGNAL_STRENGTH_NAMES), new BitDescription(3840, 8, "phone_state", new String[]{"in", "out", "emergency", "off"}), new BitDescription(61440, 12, "data_conn", DATA_CONNECTION_NAMES)};
        HISTORY_STATE_DESCRIPTIONS = bitDescriptionArray;
    }

    private static final void dumpLine(PrintWriter printWriter, int n, String string2, String string3, Object ... objectArray) {
        printWriter.print(5);
        printWriter.print(',');
        printWriter.print(n);
        printWriter.print(',');
        printWriter.print(string2);
        printWriter.print(',');
        printWriter.print(string3);
        for (Object object : objectArray) {
            printWriter.print(',');
            printWriter.print(object);
        }
        printWriter.print('\n');
    }

    private final String formatBytesLocked(long l) {
        this.mFormatBuilder.setLength(0);
        if (l < 1024L) {
            return l + "B";
        }
        if (l < 0x100000L) {
            Formatter formatter = this.mFormatter;
            Object[] objectArray = new Object[]{(double)l / 1024.0};
            formatter.format("%.2fKB", objectArray);
            return this.mFormatBuilder.toString();
        }
        if (l < 0x40000000L) {
            Formatter formatter = this.mFormatter;
            Object[] objectArray = new Object[]{(double)l / 1048576.0};
            formatter.format("%.2fMB", objectArray);
            return this.mFormatBuilder.toString();
        }
        Formatter formatter = this.mFormatter;
        Object[] objectArray = new Object[]{(double)l / 1.073741824E9};
        formatter.format("%.2fGB", objectArray);
        return this.mFormatBuilder.toString();
    }

    private final String formatRatioLocked(long l, long l2) {
        if (l2 == 0L) {
            return "---%";
        }
        float f = 100.0f * ((float)l / (float)l2);
        this.mFormatBuilder.setLength(0);
        Formatter formatter = this.mFormatter;
        Object[] objectArray = new Object[]{Float.valueOf(f)};
        formatter.format("%.1f%%", objectArray);
        return this.mFormatBuilder.toString();
    }

    private static final void formatTime(StringBuilder stringBuilder, long l) {
        long l2 = l / 100L;
        BatteryStats.formatTimeRaw(stringBuilder, l2);
        stringBuilder.append(10L * (l - 100L * l2));
        stringBuilder.append("ms ");
    }

    private static final void formatTimeMs(StringBuilder stringBuilder, long l) {
        long l2 = l / 1000L;
        BatteryStats.formatTimeRaw(stringBuilder, l2);
        stringBuilder.append(l - 1000L * l2);
        stringBuilder.append("ms ");
    }

    private static final void formatTimeRaw(StringBuilder stringBuilder, long l) {
        long l2;
        long l3;
        long l4;
        long l5;
        long l6 = l / 86400L;
        if (l6 != 0L) {
            stringBuilder.append(l6);
            stringBuilder.append("d ");
        }
        if ((l5 = (l - (l4 = 24L * (60L * (l6 * 60L)))) / 3600L) != 0L || l4 != 0L) {
            stringBuilder.append(l5);
            stringBuilder.append("h ");
        }
        if ((l3 = (l - (l2 = l4 + 60L * (l5 * 60L))) / 60L) != 0L || l2 != 0L) {
            stringBuilder.append(l3);
            stringBuilder.append("m ");
        }
        long l7 = l2 + l3 * 60L;
        if (l != 0L || l7 != 0L) {
            stringBuilder.append(l - l7);
            stringBuilder.append("s ");
        }
    }

    private static final String printWakeLock(StringBuilder stringBuilder, Timer timer, long l, String string2, int n, String string3) {
        if (timer != null) {
            long l2 = (500L + timer.getTotalTimeLocked(l, n)) / 1000L;
            int n2 = timer.getCountLocked(n);
            if (l2 != 0L) {
                stringBuilder.append(string3);
                BatteryStats.formatTimeMs(stringBuilder, l2);
                if (string2 != null) {
                    stringBuilder.append(string2);
                }
                stringBuilder.append(' ');
                stringBuilder.append('(');
                stringBuilder.append(n2);
                stringBuilder.append(" times)");
                return ", ";
            }
        }
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String printWakeLockCheckin(StringBuilder stringBuilder, Timer timer, long l, String string2, int n, String string3) {
        long l2 = 0L;
        int n2 = 0;
        if (timer != null) {
            l2 = timer.getTotalTimeLocked(l, n);
            n2 = timer.getCountLocked(n);
        }
        stringBuilder.append(string3);
        stringBuilder.append((500L + l2) / 1000L);
        stringBuilder.append(',');
        String string4 = string2 != null ? string2 + "," : "";
        stringBuilder.append(string4);
        stringBuilder.append(n2);
        return ",";
    }

    public abstract long computeBatteryRealtime(long var1, int var3);

    public abstract long computeBatteryUptime(long var1, int var3);

    public abstract long computeRealtime(long var1, int var3);

    public abstract long computeUptime(long var1, int var3);

    /*
     * Enabled aggressive block sorting
     */
    public final void dumpCheckinLocked(PrintWriter printWriter, int n, int n2) {
        Map<String, ? extends Timer> map;
        long l = 1000L * SystemClock.uptimeMillis();
        long l2 = 1000L * SystemClock.elapsedRealtime();
        long l3 = this.getBatteryUptime(l);
        long l4 = this.getBatteryRealtime(l2);
        long l5 = this.computeBatteryUptime(l, n);
        long l6 = this.computeBatteryRealtime(l2, n);
        long l7 = this.computeRealtime(l2, n);
        long l8 = this.computeUptime(l, n);
        long l9 = this.getScreenOnTime(l4, n);
        long l10 = this.getPhoneOnTime(l4, n);
        long l11 = this.getWifiOnTime(l4, n);
        long l12 = this.getGlobalWifiRunningTime(l4, n);
        long l13 = this.getBluetoothOnTime(l4, n);
        StringBuilder stringBuilder = new StringBuilder(128);
        SparseArray<? extends Uid> sparseArray = this.getUidStats();
        int n3 = sparseArray.size();
        String string2 = STAT_NAMES[n];
        Object[] objectArray = new Object[5];
        Object object = n == 0 ? Integer.valueOf(this.getStartCount()) : "N/A";
        objectArray[0] = object;
        objectArray[1] = l6 / 1000L;
        objectArray[2] = l5 / 1000L;
        objectArray[3] = l7 / 1000L;
        objectArray[4] = l8 / 1000L;
        BatteryStats.dumpLine(printWriter, 0, string2, BATTERY_DATA, objectArray);
        long l14 = 0L;
        long l15 = 0L;
        long l16 = 0L;
        long l17 = 0L;
        for (int i = 0; i < n3; ++i) {
            Uid uid = sparseArray.valueAt(i);
            l14 += uid.getTcpBytesReceived(n);
            l15 += uid.getTcpBytesSent(n);
            Map<String, ? extends Uid.Wakelock> map2 = uid.getWakelockStats();
            if (map2.size() <= 0) continue;
            Iterator<Map.Entry<String, ? extends Uid.Wakelock>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Timer timer;
                Uid.Wakelock wakelock = iterator.next().getValue();
                Timer timer2 = wakelock.getWakeTime(1);
                if (timer2 != null) {
                    l16 += timer2.getTotalTimeLocked(l4, n);
                }
                if ((timer = wakelock.getWakeTime(0)) == null) continue;
                l17 += timer.getTotalTimeLocked(l4, n);
            }
        }
        Object[] objectArray2 = new Object[]{l9 / 1000L, l10 / 1000L, l11 / 1000L, l12 / 1000L, l13 / 1000L, l14, l15, l16, l17, this.getInputEventCount(n)};
        BatteryStats.dumpLine(printWriter, 0, string2, MISC_DATA, objectArray2);
        Object[] objectArray3 = new Object[5];
        for (int i = 0; i < 5; ++i) {
            objectArray3[i] = this.getScreenBrightnessTime(i, l4, n) / 1000L;
        }
        BatteryStats.dumpLine(printWriter, 0, string2, SCREEN_BRIGHTNESS_DATA, objectArray3);
        Object[] objectArray4 = new Object[5];
        for (int i = 0; i < 5; ++i) {
            objectArray4[i] = this.getPhoneSignalStrengthTime(i, l4, n) / 1000L;
        }
        BatteryStats.dumpLine(printWriter, 0, string2, SIGNAL_STRENGTH_TIME_DATA, objectArray4);
        Object[] objectArray5 = new Object[]{this.getPhoneSignalScanningTime(l4, n) / 1000L};
        BatteryStats.dumpLine(printWriter, 0, string2, SIGNAL_SCANNING_TIME_DATA, objectArray5);
        for (int i = 0; i < 5; ++i) {
            objectArray4[i] = this.getPhoneSignalStrengthCount(i, n);
        }
        BatteryStats.dumpLine(printWriter, 0, string2, SIGNAL_STRENGTH_COUNT_DATA, objectArray4);
        Object[] objectArray6 = new Object[14];
        for (int i = 0; i < 14; ++i) {
            objectArray6[i] = this.getPhoneDataConnectionTime(i, l4, n) / 1000L;
        }
        BatteryStats.dumpLine(printWriter, 0, string2, DATA_CONNECTION_TIME_DATA, objectArray6);
        for (int i = 0; i < 14; ++i) {
            objectArray6[i] = this.getPhoneDataConnectionCount(i, n);
        }
        BatteryStats.dumpLine(printWriter, 0, string2, DATA_CONNECTION_COUNT_DATA, objectArray6);
        if (n == 3) {
            Object[] objectArray7 = new Object[]{this.getDischargeStartLevel(), this.getDischargeCurrentLevel()};
            BatteryStats.dumpLine(printWriter, 0, string2, BATTERY_LEVEL_DATA, objectArray7);
        }
        if (n2 < 0 && (map = this.getKernelWakelockStats()).size() > 0) {
            for (Map.Entry<String, ? extends Timer> entry : map.entrySet()) {
                stringBuilder.setLength(0);
                BatteryStats.printWakeLockCheckin(stringBuilder, entry.getValue(), l4, null, n, "");
                Object[] objectArray8 = new Object[]{entry.getKey(), stringBuilder.toString()};
                BatteryStats.dumpLine(printWriter, 0, string2, KERNEL_WAKELOCK_DATA, objectArray8);
            }
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = sparseArray.keyAt(n4);
            if (n2 < 0 || n5 == n2) {
                Map<String, ? extends Uid.Pkg> map3;
                Map<String, ? extends Uid.Proc> map4;
                Map<Integer, ? extends Uid.Sensor> map5;
                Map<String, ? extends Uid.Wakelock> map6;
                Uid uid = sparseArray.valueAt(n4);
                long l18 = uid.getTcpBytesReceived(n);
                long l19 = uid.getTcpBytesSent(n);
                long l20 = uid.getFullWifiLockTime(l4, n);
                long l21 = uid.getScanWifiLockTime(l4, n);
                long l22 = uid.getWifiRunningTime(l4, n);
                if (l18 > 0L || l19 > 0L) {
                    Object[] objectArray9 = new Object[]{l18, l19};
                    BatteryStats.dumpLine(printWriter, n5, string2, NETWORK_DATA, objectArray9);
                }
                if (l20 != 0L || l21 != 0L || l22 != 0L) {
                    Object[] objectArray10 = new Object[]{l20, l21, l22};
                    BatteryStats.dumpLine(printWriter, n5, string2, WIFI_LOCK_DATA, objectArray10);
                }
                if (uid.hasUserActivity()) {
                    Object[] objectArray11 = new Object[7];
                    boolean bl = false;
                    for (int i = 0; i < 7; ++i) {
                        int n6 = uid.getUserActivityCount(i, n);
                        objectArray11[i] = n6;
                        if (n6 == 0) continue;
                        bl = true;
                    }
                    if (bl) {
                        BatteryStats.dumpLine(printWriter, 0, string2, USER_ACTIVITY_DATA, objectArray11);
                    }
                }
                if ((map6 = uid.getWakelockStats()).size() > 0) {
                    for (Map.Entry<String, ? extends Uid.Wakelock> entry : map6.entrySet()) {
                        Uid.Wakelock wakelock = entry.getValue();
                        stringBuilder.setLength(0);
                        String string3 = BatteryStats.printWakeLockCheckin(stringBuilder, wakelock.getWakeTime(1), l4, "f", n, "");
                        String string4 = BatteryStats.printWakeLockCheckin(stringBuilder, wakelock.getWakeTime(0), l4, "p", n, string3);
                        BatteryStats.printWakeLockCheckin(stringBuilder, wakelock.getWakeTime(2), l4, "w", n, string4);
                        if (stringBuilder.length() <= 0) continue;
                        Object[] objectArray12 = new Object[]{entry.getKey(), stringBuilder.toString()};
                        BatteryStats.dumpLine(printWriter, n5, string2, WAKELOCK_DATA, objectArray12);
                    }
                }
                if ((map5 = uid.getSensorStats()).size() > 0) {
                    for (Map.Entry<Integer, ? extends Uid.Sensor> entry : map5.entrySet()) {
                        Uid.Sensor sensor = entry.getValue();
                        int n7 = entry.getKey();
                        Timer timer = sensor.getSensorTime();
                        if (timer == null) continue;
                        long l23 = (500L + timer.getTotalTimeLocked(l4, n)) / 1000L;
                        int n8 = timer.getCountLocked(n);
                        if (l23 == 0L) continue;
                        Object[] objectArray13 = new Object[]{n7, l23, n8};
                        BatteryStats.dumpLine(printWriter, n5, string2, SENSOR_DATA, objectArray13);
                    }
                }
                if ((map4 = uid.getProcessStats()).size() > 0) {
                    for (Map.Entry<String, ? extends Uid.Proc> entry : map4.entrySet()) {
                        Uid.Proc proc = entry.getValue();
                        long l24 = proc.getUserTime(n);
                        long l25 = proc.getSystemTime(n);
                        int n9 = proc.getStarts(n);
                        if (l24 == 0L && l25 == 0L && n9 == 0) continue;
                        Object[] objectArray14 = new Object[]{entry.getKey(), 10L * l24, 10L * l25, n9};
                        BatteryStats.dumpLine(printWriter, n5, string2, PROCESS_DATA, objectArray14);
                    }
                }
                if ((map3 = uid.getPackageStats()).size() > 0) {
                    for (Map.Entry<String, ? extends Uid.Pkg> entry : map3.entrySet()) {
                        Uid.Pkg pkg = entry.getValue();
                        int n10 = pkg.getWakeups(n);
                        for (Map.Entry<String, ? extends Uid.Pkg.Serv> entry2 : pkg.getServiceStats().entrySet()) {
                            Uid.Pkg.Serv serv = entry2.getValue();
                            long l26 = serv.getStartTime(l3, n);
                            int n11 = serv.getStarts(n);
                            int n12 = serv.getLaunches(n);
                            if (l26 == 0L && n11 == 0 && n12 == 0) continue;
                            Object[] objectArray15 = new Object[]{n10, entry.getKey(), entry2.getKey(), l26 / 1000L, n11, n12};
                            BatteryStats.dumpLine(printWriter, n5, string2, APK_DATA, objectArray15);
                        }
                    }
                }
            }
            ++n4;
        }
        return;
    }

    public void dumpCheckinLocked(PrintWriter printWriter, String[] stringArray, List<ApplicationInfo> list) {
        boolean bl = false;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!"-u".equals(stringArray[i])) continue;
            bl = true;
        }
        if (list != null) {
            int n2;
            SparseArray sparseArray = new SparseArray();
            for (int i = 0; i < (n2 = list.size()); ++i) {
                ApplicationInfo applicationInfo = list.get(i);
                ArrayList<String> arrayList = (ArrayList<String>)sparseArray.get(applicationInfo.uid);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    sparseArray.put(applicationInfo.uid, arrayList);
                }
                String string2 = applicationInfo.packageName;
                arrayList.add(string2);
            }
            SparseArray<? extends Uid> sparseArray2 = this.getUidStats();
            int n3 = sparseArray2.size();
            String[] stringArray2 = new String[2];
            for (int i = 0; i < n3; ++i) {
                int n4;
                int n5 = sparseArray2.keyAt(i);
                ArrayList arrayList = (ArrayList)sparseArray.get(n5);
                if (arrayList == null) continue;
                for (int j = 0; j < (n4 = arrayList.size()); ++j) {
                    stringArray2[0] = Integer.toString(n5);
                    stringArray2[1] = (String)arrayList.get(j);
                    BatteryStats.dumpLine(printWriter, 0, "i", UID_DATA, stringArray2);
                }
            }
        }
        if (bl) {
            this.dumpCheckinLocked(printWriter, 3, -1);
            return;
        }
        this.dumpCheckinLocked(printWriter, 0, -1);
        this.dumpCheckinLocked(printWriter, 3, -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dumpLocked(PrintWriter printWriter) {
        HistoryItem historyItem = new HistoryItem();
        if (this.startIteratingHistoryLocked()) {
            printWriter.println("Battery History:");
            long l = this.getHistoryBaseTime() + SystemClock.elapsedRealtime();
            int n = 0;
            byte by = -1;
            byte by2 = -1;
            byte by3 = -1;
            char c = '\uffffffff';
            char c2 = '\uffffffff';
            while (this.getNextHistoryLocked(historyItem)) {
                printWriter.print("  ");
                TimeUtils.formatDuration((long)(historyItem.time - l), (PrintWriter)printWriter, (int)19);
                printWriter.print(" ");
                if (historyItem.cmd == 1) {
                    printWriter.println(" START");
                } else if (historyItem.cmd == 2) {
                    printWriter.println(" *OVERFLOW*");
                } else {
                    char c3;
                    char c4;
                    byte by4;
                    byte by5;
                    if (historyItem.batteryLevel < 10) {
                        printWriter.print("00");
                    } else if (historyItem.batteryLevel < 100) {
                        printWriter.print("0");
                    }
                    printWriter.print(historyItem.batteryLevel);
                    printWriter.print(" ");
                    if (historyItem.states < 16) {
                        printWriter.print("0000000");
                    } else if (historyItem.states < 256) {
                        printWriter.print("000000");
                    } else if (historyItem.states < 4096) {
                        printWriter.print("00000");
                    } else if (historyItem.states < 65536) {
                        printWriter.print("0000");
                    } else if (historyItem.states < 0x100000) {
                        printWriter.print("000");
                    } else if (historyItem.states < 0x1000000) {
                        printWriter.print("00");
                    } else if (historyItem.states < 0x10000000) {
                        printWriter.print("0");
                    }
                    printWriter.print(Integer.toHexString(historyItem.states));
                    byte by6 = historyItem.batteryStatus;
                    if (by != by6) {
                        by = historyItem.batteryStatus;
                        printWriter.print(" status=");
                        switch (by) {
                            default: {
                                printWriter.print(by);
                                break;
                            }
                            case 1: {
                                printWriter.print("unknown");
                                break;
                            }
                            case 2: {
                                printWriter.print("charging");
                                break;
                            }
                            case 3: {
                                printWriter.print("discharging");
                                break;
                            }
                            case 4: {
                                printWriter.print("not-charging");
                                break;
                            }
                            case 5: {
                                printWriter.print("full");
                            }
                        }
                    }
                    if (by2 != (by5 = historyItem.batteryHealth)) {
                        by2 = historyItem.batteryHealth;
                        printWriter.print(" health=");
                        switch (by2) {
                            default: {
                                printWriter.print(by2);
                                break;
                            }
                            case 1: {
                                printWriter.print("unknown");
                                break;
                            }
                            case 2: {
                                printWriter.print("good");
                                break;
                            }
                            case 3: {
                                printWriter.print("overheat");
                                break;
                            }
                            case 4: {
                                printWriter.print("dead");
                                break;
                            }
                            case 5: {
                                printWriter.print("over-voltage");
                                break;
                            }
                            case 6: {
                                printWriter.print("failure");
                            }
                        }
                    }
                    if (by3 != (by4 = historyItem.batteryPlugType)) {
                        by3 = historyItem.batteryPlugType;
                        printWriter.print(" plug=");
                        switch (by3) {
                            default: {
                                printWriter.print(by3);
                                break;
                            }
                            case 0: {
                                printWriter.print("none");
                                break;
                            }
                            case 1: {
                                printWriter.print("ac");
                                break;
                            }
                            case 2: {
                                printWriter.print("usb");
                            }
                        }
                    }
                    if (c != (c4 = historyItem.batteryTemperature)) {
                        c = historyItem.batteryTemperature;
                        printWriter.print(" temp=");
                        printWriter.print((int)c);
                    }
                    if (c2 != (c3 = historyItem.batteryVoltage)) {
                        c2 = historyItem.batteryVoltage;
                        printWriter.print(" volt=");
                        printWriter.print((int)c2);
                    }
                    int n2 = historyItem.states;
                    BitDescription[] bitDescriptionArray = HISTORY_STATE_DESCRIPTIONS;
                    this.printBitDescriptions(printWriter, n, n2, bitDescriptionArray);
                    printWriter.println();
                }
                n = historyItem.states;
            }
            printWriter.println("");
        }
        SparseArray<? extends Uid> sparseArray = this.getUidStats();
        int n = sparseArray.size();
        boolean bl = false;
        long l = SystemClock.elapsedRealtime();
        new StringBuilder(64);
        for (int i = 0; i < n; ++i) {
            int n3;
            SparseArray<? extends Uid.Pid> sparseArray2 = sparseArray.valueAt(i).getPidStats();
            if (sparseArray2 == null) continue;
            for (int j = 0; j < (n3 = sparseArray2.size()); ++j) {
                Uid.Pid pid = sparseArray2.valueAt(j);
                if (!bl) {
                    printWriter.println("Per-PID Stats:");
                    bl = true;
                }
                long l2 = pid.mWakeSum;
                long l3 = pid.mWakeStart != 0L ? l - pid.mWakeStart : 0L;
                long l4 = l2 + l3;
                printWriter.print("  PID ");
                printWriter.print(sparseArray2.keyAt(j));
                printWriter.print(" wake time: ");
                TimeUtils.formatDuration((long)l4, (PrintWriter)printWriter);
                printWriter.println("");
            }
        }
        if (bl) {
            printWriter.println("");
        }
        printWriter.println("Statistics since last charge:");
        printWriter.println("  System starts: " + this.getStartCount() + ", currently on battery: " + this.getIsOnBattery());
        this.dumpLocked(printWriter, "", 0, -1);
        printWriter.println("");
        printWriter.println("Statistics since last unplugged:");
        this.dumpLocked(printWriter, "", 3, -1);
    }

    /*
     * Unable to fully structure code
     */
    public final void dumpLocked(PrintWriter var1_1, String var2_2, int var3_3, int var4_4) {
        block55: {
            block61: {
                block60: {
                    block54: {
                        var5_5 = 1000L * SystemClock.uptimeMillis();
                        var7_6 = 1000L * SystemClock.elapsedRealtime();
                        var9_7 = this.getBatteryUptime(var5_5);
                        var11_8 = this.getBatteryRealtime(var7_6);
                        var13_9 = this.computeBatteryUptime(var5_5, var3_3);
                        var15_10 = this.computeBatteryRealtime(var7_6, var3_3);
                        var17_11 = this.computeRealtime(var7_6, var3_3);
                        var19_12 = this.computeUptime(var5_5, var3_3);
                        var21_13 = new StringBuilder(128);
                        var22_14 = this.getUidStats();
                        var23_15 = var22_14.size();
                        var21_13.setLength(0);
                        var21_13.append(var2_2);
                        var21_13.append("  Time on battery: ");
                        BatteryStats.formatTimeMs(var21_13, var15_10 / 1000L);
                        var21_13.append("(");
                        var21_13.append(this.formatRatioLocked(var15_10, var17_11));
                        var21_13.append(") realtime, ");
                        BatteryStats.formatTimeMs(var21_13, var13_9 / 1000L);
                        var21_13.append("(");
                        var21_13.append(this.formatRatioLocked(var13_9, var17_11));
                        var21_13.append(") uptime");
                        var1_1.println(var21_13.toString());
                        var21_13.setLength(0);
                        var21_13.append(var2_2);
                        var21_13.append("  Total run time: ");
                        BatteryStats.formatTimeMs(var21_13, var17_11 / 1000L);
                        var21_13.append("realtime, ");
                        BatteryStats.formatTimeMs(var21_13, var19_12 / 1000L);
                        var21_13.append("uptime, ");
                        var1_1.println(var21_13.toString());
                        var36_16 = this.getScreenOnTime(var11_8, var3_3);
                        var38_17 = this.getPhoneOnTime(var11_8, var3_3);
                        var40_18 = this.getGlobalWifiRunningTime(var11_8, var3_3);
                        var42_19 = this.getWifiOnTime(var11_8, var3_3);
                        var44_20 = this.getBluetoothOnTime(var11_8, var3_3);
                        var21_13.setLength(0);
                        var21_13.append(var2_2);
                        var21_13.append("  Screen on: ");
                        BatteryStats.formatTimeMs(var21_13, var36_16 / 1000L);
                        var21_13.append("(");
                        var21_13.append(this.formatRatioLocked(var36_16, var15_10));
                        var21_13.append("), Input events: ");
                        var21_13.append(this.getInputEventCount(var3_3));
                        var21_13.append(", Active phone call: ");
                        BatteryStats.formatTimeMs(var21_13, var38_17 / 1000L);
                        var21_13.append("(");
                        var21_13.append(this.formatRatioLocked(var38_17, var15_10));
                        var21_13.append(")");
                        var1_1.println(var21_13.toString());
                        var21_13.setLength(0);
                        var21_13.append(var2_2);
                        var21_13.append("  Screen brightnesses: ");
                        var58_21 = false;
                        block0: for (var59_22 = 0; var59_22 < 5; ++var59_22) {
                            var252_23 = this.getScreenBrightnessTime(var59_22, var11_8, var3_3);
                            if (var252_23 == 0L) lbl-1000:
                            // 2 sources

                            {
                                continue block0;
                            }
                            if (var58_21) {
                                var21_13.append(", ");
                            }
                            var58_21 = true;
                            var21_13.append(BatteryStats.SCREEN_BRIGHTNESS_NAMES[var59_22]);
                            var21_13.append(" ");
                            BatteryStats.formatTimeMs(var21_13, var252_23 / 1000L);
                            var21_13.append("(");
                            var21_13.append(this.formatRatioLocked(var252_23, var36_16));
                            var21_13.append(")");
                            ** continue;
                        }
                        if (!var58_21) {
                            var21_13.append("No activity");
                        }
                        var1_1.println(var21_13.toString());
                        var60_24 = 0L;
                        var62_25 = 0L;
                        var64_26 = 0L;
                        var66_27 = 0L;
                        if (var4_4 < 0 && (var244_28 = this.getKernelWakelockStats()).size() > 0) {
                            for (Map.Entry<String, ? extends Timer> var246_30 : var244_28.entrySet()) {
                                var21_13.setLength(0);
                                var21_13.append(var2_2);
                                var21_13.append("  Kernel Wake lock ");
                                var21_13.append(var246_30.getKey());
                                if (BatteryStats.printWakeLock(var21_13, var246_30.getValue(), var11_8, null, var3_3, ": ").equals(": ")) continue;
                                var21_13.append(" realtime");
                                var1_1.println(var21_13.toString());
                            }
                        }
                        for (var68_31 = 0; var68_31 < var23_15; ++var68_31) {
                            var238_32 = var22_14.valueAt(var68_31);
                            var60_24 += var238_32.getTcpBytesReceived(var3_3);
                            var62_25 += var238_32.getTcpBytesSent(var3_3);
                            var239_33 = var238_32.getWakelockStats();
                            if (var239_33.size() <= 0) continue;
                            var240_34 = var239_33.entrySet().iterator();
                            while (var240_34.hasNext()) {
                                var241_35 = var240_34.next().getValue();
                                var242_36 = var241_35.getWakeTime(1);
                                if (var242_36 != null) {
                                    var64_26 += var242_36.getTotalTimeLocked(var11_8, var3_3);
                                }
                                if ((var243_37 = var241_35.getWakeTime(0)) == null) continue;
                                var66_27 += var243_37.getTotalTimeLocked(var11_8, var3_3);
                            }
                        }
                        var1_1.print(var2_2);
                        var1_1.print("  Total received: ");
                        var1_1.print(this.formatBytesLocked(var60_24));
                        var1_1.print(", Total sent: ");
                        var1_1.println(this.formatBytesLocked(var62_25));
                        var21_13.setLength(0);
                        var21_13.append(var2_2);
                        var21_13.append("  Total full wakelock time: ");
                        BatteryStats.formatTimeMs(var21_13, (500L + var64_26) / 1000L);
                        var21_13.append(", Total partial waklock time: ");
                        BatteryStats.formatTimeMs(var21_13, (500L + var66_27) / 1000L);
                        var1_1.println(var21_13.toString());
                        var21_13.setLength(0);
                        var21_13.append(var2_2);
                        var21_13.append("  Signal levels: ");
                        var74_38 = false;
                        block5: for (var75_39 = 0; var75_39 < 5; ++var75_39) {
                            var228_40 = this.getPhoneSignalStrengthTime(var75_39, var11_8, var3_3);
                            if (var228_40 == 0L) lbl-1000:
                            // 2 sources

                            {
                                continue block5;
                            }
                            if (var74_38) {
                                var21_13.append(", ");
                            }
                            var74_38 = true;
                            var21_13.append(BatteryStats.SIGNAL_STRENGTH_NAMES[var75_39]);
                            var21_13.append(" ");
                            BatteryStats.formatTimeMs(var21_13, var228_40 / 1000L);
                            var21_13.append("(");
                            var21_13.append(this.formatRatioLocked(var228_40, var15_10));
                            var21_13.append(") ");
                            var21_13.append(this.getPhoneSignalStrengthCount(var75_39, var3_3));
                            var21_13.append("x");
                            ** continue;
                        }
                        if (!var74_38) {
                            var21_13.append("No activity");
                        }
                        var1_1.println(var21_13.toString());
                        var21_13.setLength(0);
                        var21_13.append(var2_2);
                        var21_13.append("  Signal scanning time: ");
                        BatteryStats.formatTimeMs(var21_13, this.getPhoneSignalScanningTime(var11_8, var3_3) / 1000L);
                        var1_1.println(var21_13.toString());
                        var21_13.setLength(0);
                        var21_13.append(var2_2);
                        var21_13.append("  Radio types: ");
                        var80_41 = false;
                        block7: for (var81_42 = 0; var81_42 < 14; ++var81_42) {
                            var217_43 = this.getPhoneDataConnectionTime(var81_42, var11_8, var3_3);
                            if (var217_43 == 0L) lbl-1000:
                            // 2 sources

                            {
                                continue block7;
                            }
                            if (var80_41) {
                                var21_13.append(", ");
                            }
                            var80_41 = true;
                            var21_13.append(BatteryStats.DATA_CONNECTION_NAMES[var81_42]);
                            var21_13.append(" ");
                            BatteryStats.formatTimeMs(var21_13, var217_43 / 1000L);
                            var21_13.append("(");
                            var21_13.append(this.formatRatioLocked(var217_43, var15_10));
                            var21_13.append(") ");
                            var21_13.append(this.getPhoneDataConnectionCount(var81_42, var3_3));
                            var21_13.append("x");
                            ** continue;
                        }
                        if (!var80_41) {
                            var21_13.append("No activity");
                        }
                        var1_1.println(var21_13.toString());
                        var21_13.setLength(0);
                        var21_13.append(var2_2);
                        var21_13.append("  Radio data uptime when unplugged: ");
                        var21_13.append(this.getRadioDataUptime() / 1000L);
                        var21_13.append(" ms");
                        var1_1.println(var21_13.toString());
                        var21_13.setLength(0);
                        var21_13.append(var2_2);
                        var21_13.append("  Wifi on: ");
                        BatteryStats.formatTimeMs(var21_13, var42_19 / 1000L);
                        var21_13.append("(");
                        var21_13.append(this.formatRatioLocked(var42_19, var15_10));
                        var21_13.append("), Wifi running: ");
                        BatteryStats.formatTimeMs(var21_13, var40_18 / 1000L);
                        var21_13.append("(");
                        var21_13.append(this.formatRatioLocked(var40_18, var15_10));
                        var21_13.append("), Bluetooth on: ");
                        BatteryStats.formatTimeMs(var21_13, var44_20 / 1000L);
                        var21_13.append("(");
                        var21_13.append(this.formatRatioLocked(var44_20, var15_10));
                        var21_13.append(")");
                        var1_1.println(var21_13.toString());
                        var1_1.println(" ");
                        if (var3_3 == 3) {
                            if (this.getIsOnBattery()) {
                                var1_1.print(var2_2);
                                var1_1.println("  Device is currently unplugged");
                                var1_1.print(var2_2);
                                var1_1.print("    Discharge cycle start level: ");
                                var1_1.println(this.getDischargeStartLevel());
                                var1_1.print(var2_2);
                                var1_1.print("    Discharge cycle current level: ");
                                var1_1.println(this.getDischargeCurrentLevel());
lbl278:
                                // 2 sources

                                while (true) {
                                    var1_1.println(" ");
lbl280:
                                    // 2 sources

                                    while (true) {
                                        block11: for (var97_44 = 0; var97_44 < var23_15; ++var97_44) {
                                            var98_84 = var22_14.keyAt(var97_44);
                                            if (var4_4 >= 0 && var98_84 != var4_4 && var98_84 != 1000) lbl-1000:
                                            // 3 sources

                                            {
                                                continue block11;
                                            }
                                            break block54;
                                        }
                                        break block55;
                                        break;
                                    }
                                    break;
                                }
                            }
                            var1_1.print(var2_2);
                            var1_1.println("  Device is currently plugged into power");
                            var1_1.print(var2_2);
                            var1_1.print("    Last discharge cycle start level: ");
                            var1_1.println(this.getDischargeStartLevel());
                            var1_1.print(var2_2);
                            var1_1.print("    Last discharge cycle end level: ");
                            var1_1.println(this.getDischargeCurrentLevel());
                            ** continue;
                        }
                        var1_1.print(var2_2);
                        var1_1.println("  Device battery use since last full charge");
                        var1_1.print(var2_2);
                        var1_1.print("    Amount discharged (lower bound): ");
                        var1_1.println(this.getLowDischargeAmountSinceCharge());
                        var1_1.print(var2_2);
                        var1_1.print("    Amount discharged (upper bound): ");
                        var1_1.println(this.getHighDischargeAmountSinceCharge());
                        var1_1.println(" ");
                        ** while (true)
                    }
                    var99_85 = var22_14.valueAt(var97_44);
                    var1_1.println(var2_2 + "  #" + var98_84 + ":");
                    var100_86 = var99_85.getTcpBytesReceived(var3_3);
                    var102_87 = var99_85.getTcpBytesSent(var3_3);
                    var104_88 = var99_85.getFullWifiLockTime(var11_8, var3_3);
                    var106_89 = var99_85.getScanWifiLockTime(var11_8, var3_3);
                    var108_90 = var99_85.getWifiRunningTime(var11_8, var3_3);
                    if (var100_86 != 0L || var102_87 != 0L) {
                        var1_1.print(var2_2);
                        var1_1.print("    Network: ");
                        var1_1.print(this.formatBytesLocked(var100_86));
                        var1_1.print(" received, ");
                        var1_1.print(this.formatBytesLocked(var102_87));
                        var1_1.println(" sent");
                    }
                    if (var99_85.hasUserActivity()) {
                        var208_81 = false;
                        block13: for (var209_82 = 0; var209_82 < 5; ++var209_82) {
                            var210_83 = var99_85.getUserActivityCount(var209_82, var3_3);
                            if (var210_83 == 0) continue;
                            if (!var208_81) {
                                var21_13.setLength(0);
                                var21_13.append("    User activity: ");
                                var208_81 = true;
lbl332:
                                // 2 sources

                                while (true) {
                                    var21_13.append(var210_83);
                                    var21_13.append(" ");
                                    var21_13.append(Uid.USER_ACTIVITY_TYPES[var209_82]);
                                    continue block13;
                                    break;
                                }
                            }
                            var21_13.append(", ");
                            ** continue;
                        }
                        if (var208_81) {
                            var1_1.println(var21_13.toString());
                        }
                    }
                    if (var104_88 != 0L || var106_89 != 0L || var108_90 != 0L) {
                        var21_13.setLength(0);
                        var21_13.append(var2_2);
                        var21_13.append("    Wifi Running: ");
                        BatteryStats.formatTimeMs(var21_13, var108_90 / 1000L);
                        var21_13.append("(");
                        var21_13.append(this.formatRatioLocked(var108_90, var15_10));
                        var21_13.append(")\n");
                        var21_13.append(var2_2);
                        var21_13.append("    Full Wifi Lock: ");
                        BatteryStats.formatTimeMs(var21_13, var104_88 / 1000L);
                        var21_13.append("(");
                        var21_13.append(this.formatRatioLocked(var104_88, var15_10));
                        var21_13.append(")\n");
                        var21_13.append(var2_2);
                        var21_13.append("    Scan Wifi Lock: ");
                        BatteryStats.formatTimeMs(var21_13, var106_89 / 1000L);
                        var21_13.append("(");
                        var21_13.append(this.formatRatioLocked(var106_89, var15_10));
                        var21_13.append(")");
                        var1_1.println(var21_13.toString());
                    }
                    var125_91 = var99_85.getWakelockStats();
                    var126_92 = var125_91.size();
                    var127_93 = false;
                    if (var126_92 > 0) {
                        for (Map.Entry<String, ? extends Uid.Wakelock> var200_77 : var125_91.entrySet()) {
                            var201_78 = var200_77.getValue();
                            var21_13.setLength(0);
                            var21_13.append(var2_2);
                            var21_13.append("    Wake lock ");
                            var21_13.append(var200_77.getKey());
                            var205_79 = BatteryStats.printWakeLock(var21_13, var201_78.getWakeTime(1), var11_8, "full", var3_3, ": ");
                            var206_80 = BatteryStats.printWakeLock(var21_13, var201_78.getWakeTime(0), var11_8, "partial", var3_3, var205_79);
                            if (BatteryStats.printWakeLock(var21_13, var201_78.getWakeTime(2), var11_8, "window", var3_3, var206_80).equals(": ")) continue;
                            var21_13.append(" realtime");
                            var1_1.println(var21_13.toString());
                            var127_93 = true;
                        }
                    }
                    if ((var128_45 = var99_85.getSensorStats()).size() <= 0) break block60;
                    block16: for (Map.Entry<Integer, ? extends Uid.Sensor> var181_70 : var128_45.entrySet()) {
                        block56: {
                            block57: {
                                var182_71 = var181_70.getValue();
                                var181_70.getKey().intValue();
                                var21_13.setLength(0);
                                var21_13.append(var2_2);
                                var21_13.append("    Sensor ");
                                var186_72 = var182_71.getHandle();
                                if (var186_72 == -10000) {
                                    var21_13.append("GPS");
lbl416:
                                    // 2 sources

                                    while (true) {
                                        var21_13.append(": ");
                                        var189_73 = var182_71.getSensorTime();
                                        if (var189_73 == null) break block56;
                                        var191_74 = (500L + var189_73.getTotalTimeLocked(var11_8, var3_3)) / 1000L;
                                        var193_75 = var189_73.getCountLocked(var3_3);
                                        if (var191_74 != 0L) {
                                            BatteryStats.formatTimeMs(var21_13, var191_74);
                                            var21_13.append("realtime (");
                                            var21_13.append(var193_75);
                                            var21_13.append(" times)");
lbl431:
                                            // 3 sources

                                            while (true) {
                                                var1_1.println(var21_13.toString());
                                                var127_93 = true;
                                                continue block16;
                                                break;
                                            }
                                        }
                                        break block57;
                                        break;
                                    }
                                }
                                var21_13.append(var186_72);
                                ** continue;
                            }
                            var21_13.append("(not used)");
                            ** GOTO lbl431
                        }
                        var21_13.append("(not used)");
                        ** continue;
                    }
                }
                if ((var129_46 = var99_85.getProcessStats()).size() <= 0) break block61;
                for (Map.Entry<String, ? extends Uid.Proc> var157_61 : var129_46.entrySet()) {
                    block59: {
                        block62: {
                            block58: {
                                var158_62 = var157_61.getValue();
                                var159_63 = var158_62.getUserTime(var3_3);
                                var161_64 = var158_62.getSystemTime(var3_3);
                                var163_65 = var158_62.getStarts(var3_3);
                                if (var3_3 == 0) {
                                    var164_66 = var158_62.countExcessivePowers();
lbl456:
                                    // 2 sources

                                    while (var159_63 != 0L || var161_64 != 0L || var163_65 != 0 || var164_66 != 0) {
                                        var21_13.setLength(0);
                                        var21_13.append(var2_2);
                                        var21_13.append("    Proc ");
                                        var21_13.append(var157_61.getKey());
                                        var21_13.append(":\n");
                                        var21_13.append(var2_2);
                                        var21_13.append("      CPU: ");
                                        BatteryStats.formatTime(var21_13, var159_63);
                                        var21_13.append("usr + ");
                                        BatteryStats.formatTime(var21_13, var161_64);
                                        var21_13.append("krn");
                                        if (var163_65 != 0) {
                                            var21_13.append("\n");
                                            var21_13.append(var2_2);
                                            var21_13.append("      ");
                                            var21_13.append(var163_65);
                                            var21_13.append(" proc starts");
                                        }
                                        var1_1.println(var21_13.toString());
                                        block21: for (var173_67 = 0; var173_67 < var164_66; ++var173_67) {
                                            var174_68 = var158_62.getExcessivePower(var173_67);
                                            if (var174_68 == null) continue;
                                            var1_1.print(var2_2);
                                            var1_1.print("      * Killed for ");
                                            if (var174_68.type == 1) {
                                                var1_1.print("wake lock");
lbl495:
                                                // 3 sources

                                                while (true) {
                                                    var1_1.print(" use: ");
                                                    TimeUtils.formatDuration((long)var174_68.usedTime, (PrintWriter)var1_1);
                                                    var1_1.print(" over ");
                                                    TimeUtils.formatDuration((long)var174_68.overTime, (PrintWriter)var1_1);
                                                    var1_1.print(" (");
                                                    var1_1.print(100L * var174_68.usedTime / var174_68.overTime);
                                                    var1_1.println("%)");
                                                    continue block21;
                                                    break;
                                                }
                                            }
                                            break block58;
                                        }
                                        break block59;
                                    }
                                    continue;
                                }
                                var164_66 = 0;
                                ** GOTO lbl456
                            }
                            if (var174_68.type != 2) break block62;
                            var1_1.print("cpu");
                            ** GOTO lbl495
                        }
                        var1_1.print("unknown");
                        ** continue;
                    }
                    var127_93 = true;
                }
            }
            if ((var130_47 = var99_85.getPackageStats()).size() > 0) {
                for (Map.Entry<String, ? extends Uid.Pkg> var132_49 : var130_47.entrySet()) {
                    var1_1.print(var2_2);
                    var1_1.print("    Apk ");
                    var1_1.print(var132_49.getKey());
                    var1_1.println(":");
                    var133_50 = var132_49.getValue();
                    var134_51 = var133_50.getWakeups(var3_3);
                    var135_52 = false;
                    if (var134_51 != 0) {
                        var1_1.print(var2_2);
                        var1_1.print("      ");
                        var1_1.print(var134_51);
                        var1_1.println(" wakeup alarms");
                        var135_52 = true;
                    }
                    if ((var136_53 = var133_50.getServiceStats()).size() > 0) {
                        for (Map.Entry<String, ? extends Uid.Pkg.Serv> var138_55 : var136_53.entrySet()) {
                            var139_56 = var138_55.getValue();
                            var140_57 = var139_56.getStartTime(var9_7, var3_3);
                            var142_58 = var139_56.getStarts(var3_3);
                            var143_59 = var139_56.getLaunches(var3_3);
                            if (var140_57 == 0L && var142_58 == 0 && var143_59 == 0) continue;
                            var21_13.setLength(0);
                            var21_13.append(var2_2);
                            var21_13.append("      Service ");
                            var21_13.append(var138_55.getKey());
                            var21_13.append(":\n");
                            var21_13.append(var2_2);
                            var21_13.append("        Created for: ");
                            BatteryStats.formatTimeMs(var21_13, var140_57 / 1000L);
                            var21_13.append(" uptime\n");
                            var21_13.append(var2_2);
                            var21_13.append("        Starts: ");
                            var21_13.append(var142_58);
                            var21_13.append(", launches: ");
                            var21_13.append(var143_59);
                            var1_1.println(var21_13.toString());
                            var135_52 = true;
                        }
                    }
                    if (!var135_52) {
                        var1_1.print(var2_2);
                        var1_1.println("      (nothing executed)");
                    }
                    var127_93 = true;
                }
            }
            if (var127_93) ** GOTO lbl-1000
            var1_1.print(var2_2);
            var1_1.println("    (nothing executed)");
            ** while (true)
        }
    }

    public abstract long getBatteryRealtime(long var1);

    public abstract long getBatteryUptime(long var1);

    public abstract long getBluetoothOnTime(long var1, int var3);

    public abstract int getCpuSpeedSteps();

    public abstract int getDischargeCurrentLevel();

    public abstract int getDischargeStartLevel();

    public abstract long getGlobalWifiRunningTime(long var1, int var3);

    public abstract int getHighDischargeAmountSinceCharge();

    public abstract HistoryItem getHistory();

    public abstract long getHistoryBaseTime();

    public abstract int getInputEventCount(int var1);

    public abstract boolean getIsOnBattery();

    public abstract Map<String, ? extends Timer> getKernelWakelockStats();

    public abstract int getLowDischargeAmountSinceCharge();

    public abstract boolean getNextHistoryLocked(HistoryItem var1);

    public abstract int getPhoneDataConnectionCount(int var1, int var2);

    public abstract long getPhoneDataConnectionTime(int var1, long var2, int var4);

    public abstract long getPhoneOnTime(long var1, int var3);

    public abstract long getPhoneSignalScanningTime(long var1, int var3);

    public abstract int getPhoneSignalStrengthCount(int var1, int var2);

    public abstract long getPhoneSignalStrengthTime(int var1, long var2, int var4);

    public abstract long getRadioDataUptime();

    public long getRadioDataUptimeMs() {
        return this.getRadioDataUptime() / 1000L;
    }

    public abstract long getScreenBrightnessTime(int var1, long var2, int var4);

    public abstract long getScreenOnTime(long var1, int var3);

    public abstract int getStartCount();

    public abstract SparseArray<? extends Uid> getUidStats();

    public abstract long getWifiOnTime(long var1, int var3);

    /*
     * Enabled aggressive block sorting
     */
    void printBitDescriptions(PrintWriter printWriter, int n, int n2, BitDescription[] bitDescriptionArray) {
        int n3 = n ^ n2;
        if (n3 != 0) {
            for (int i = 0; i < bitDescriptionArray.length; ++i) {
                BitDescription bitDescription = bitDescriptionArray[i];
                if ((n3 & bitDescription.mask) == 0) continue;
                if (bitDescription.shift < 0) {
                    String string2 = (n2 & bitDescription.mask) != 0 ? " +" : " -";
                    printWriter.print(string2);
                    printWriter.print(bitDescription.name);
                    continue;
                }
                printWriter.print(" ");
                printWriter.print(bitDescription.name);
                printWriter.print("=");
                int n4 = (n2 & bitDescription.mask) >> bitDescription.shift;
                if (bitDescription.values != null && n4 >= 0 && n4 < bitDescription.values.length) {
                    printWriter.print(bitDescription.values[n4]);
                    continue;
                }
                printWriter.print(n4);
            }
        }
    }

    public abstract boolean startIteratingHistoryLocked();

    public static final class BitDescription {
        public final int mask;
        public final String name;
        public final int shift;
        public final String[] values;

        public BitDescription(int n, int n2, String string2, String[] stringArray) {
            this.mask = n;
            this.shift = n2;
            this.name = string2;
            this.values = stringArray;
        }

        public BitDescription(int n, String string2) {
            this.mask = n;
            this.shift = -1;
            this.name = string2;
            this.values = null;
        }
    }

    public static abstract class Counter {
        public abstract int getCountLocked(int var1);

        public abstract void logState(Printer var1, String var2);
    }

    public static final class HistoryItem
    implements Parcelable {
        public static final byte CMD_OVERFLOW = 2;
        public static final byte CMD_START = 1;
        public static final byte CMD_UPDATE = 0;
        public static final int MOST_INTERESTING_STATES = 0x78000000;
        public static final int STATE_AUDIO_ON_FLAG = 524288;
        public static final int STATE_BATTERY_PLUGGED_FLAG = 0x40000000;
        public static final int STATE_BLUETOOTH_ON_FLAG = 0x100000;
        public static final int STATE_BRIGHTNESS_MASK = 15;
        public static final int STATE_BRIGHTNESS_SHIFT = 0;
        public static final int STATE_DATA_CONNECTION_MASK = 61440;
        public static final int STATE_DATA_CONNECTION_SHIFT = 12;
        public static final int STATE_GPS_ON_FLAG = 0x10000000;
        public static final int STATE_PHONE_IN_CALL_FLAG = 0x8000000;
        public static final int STATE_PHONE_SCANNING_FLAG = 0x4000000;
        public static final int STATE_PHONE_STATE_MASK = 3840;
        public static final int STATE_PHONE_STATE_SHIFT = 8;
        public static final int STATE_SCREEN_ON_FLAG = 0x20000000;
        public static final int STATE_SENSOR_ON_FLAG = 65536;
        public static final int STATE_SIGNAL_STRENGTH_MASK = 240;
        public static final int STATE_SIGNAL_STRENGTH_SHIFT = 4;
        public static final int STATE_VIDEO_ON_FLAG = 262144;
        public static final int STATE_WAKE_LOCK_FLAG = 131072;
        public static final int STATE_WIFI_FULL_LOCK_FLAG = 0x800000;
        public static final int STATE_WIFI_MULTICAST_ON_FLAG = 0x200000;
        public static final int STATE_WIFI_ON_FLAG = 0x2000000;
        public static final int STATE_WIFI_RUNNING_FLAG = 0x1000000;
        public static final int STATE_WIFI_SCAN_LOCK_FLAG = 0x400000;
        public byte batteryHealth;
        public byte batteryLevel;
        public byte batteryPlugType;
        public byte batteryStatus;
        public char batteryTemperature;
        public char batteryVoltage;
        public byte cmd;
        public HistoryItem next;
        public int states;
        public long time;

        public HistoryItem() {
        }

        public HistoryItem(long l, Parcel parcel) {
            this.time = l;
            int n = parcel.readInt();
            this.cmd = (byte)(n & 0xFF);
            this.batteryLevel = (byte)(0xFF & n >> 8);
            this.batteryStatus = (byte)(0xF & n >> 16);
            this.batteryHealth = (byte)(0xF & n >> 20);
            this.batteryPlugType = (byte)(0xF & n >> 24);
            int n2 = parcel.readInt();
            this.batteryTemperature = (char)(n2 & 0xFFFF);
            this.batteryVoltage = (char)(0xFFFF & n2 >> 16);
            this.states = parcel.readInt();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public boolean same(HistoryItem historyItem) {
            return this.batteryLevel == historyItem.batteryLevel && this.batteryStatus == historyItem.batteryStatus && this.batteryHealth == historyItem.batteryHealth && this.batteryPlugType == historyItem.batteryPlugType && this.batteryTemperature == historyItem.batteryTemperature && this.batteryVoltage == historyItem.batteryVoltage && this.states == historyItem.states;
        }

        public void setTo(long l, byte by, HistoryItem historyItem) {
            this.time = l;
            this.cmd = by;
            this.batteryLevel = historyItem.batteryLevel;
            this.batteryStatus = historyItem.batteryStatus;
            this.batteryHealth = historyItem.batteryHealth;
            this.batteryPlugType = historyItem.batteryPlugType;
            this.batteryTemperature = historyItem.batteryTemperature;
            this.batteryVoltage = historyItem.batteryVoltage;
            this.states = historyItem.states;
        }

        public void setTo(HistoryItem historyItem) {
            this.time = historyItem.time;
            this.cmd = historyItem.cmd;
            this.batteryLevel = historyItem.batteryLevel;
            this.batteryStatus = historyItem.batteryStatus;
            this.batteryHealth = historyItem.batteryHealth;
            this.batteryPlugType = historyItem.batteryPlugType;
            this.batteryTemperature = historyItem.batteryTemperature;
            this.batteryVoltage = historyItem.batteryVoltage;
            this.states = historyItem.states;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeLong(this.time);
            parcel.writeInt(0xFF & this.cmd | 0xFF00 & this.batteryLevel << 8 | 0xF0000 & this.batteryStatus << 16 | 0xF00000 & this.batteryHealth << 20 | 0xF000000 & this.batteryPlugType << 24);
            parcel.writeInt(0xFFFF & this.batteryTemperature | 0xFFFF0000 & this.batteryVoltage << 16);
            parcel.writeInt(this.states);
        }
    }

    public static abstract class Timer {
        public abstract int getCountLocked(int var1);

        public abstract long getTotalTimeLocked(long var1, int var3);

        public abstract void logState(Printer var1, String var2);
    }

    public static abstract class Uid {
        public static final int NUM_USER_ACTIVITY_TYPES = 7;
        static final String[] USER_ACTIVITY_TYPES = new String[]{"other", "cheek", "touch", "long_touch", "touch_up", "button", "unknown"};

        public abstract long getAudioTurnedOnTime(long var1, int var3);

        public abstract long getFullWifiLockTime(long var1, int var3);

        public abstract Map<String, ? extends Pkg> getPackageStats();

        public abstract SparseArray<? extends Pid> getPidStats();

        public abstract Map<String, ? extends Proc> getProcessStats();

        public abstract long getScanWifiLockTime(long var1, int var3);

        public abstract Map<Integer, ? extends Sensor> getSensorStats();

        public abstract long getTcpBytesReceived(int var1);

        public abstract long getTcpBytesSent(int var1);

        public abstract int getUid();

        public abstract int getUserActivityCount(int var1, int var2);

        public abstract long getVideoTurnedOnTime(long var1, int var3);

        public abstract Map<String, ? extends Wakelock> getWakelockStats();

        public abstract long getWifiMulticastTime(long var1, int var3);

        public abstract long getWifiRunningTime(long var1, int var3);

        public abstract boolean hasUserActivity();

        public abstract void noteAudioTurnedOffLocked();

        public abstract void noteAudioTurnedOnLocked();

        public abstract void noteFullWifiLockAcquiredLocked();

        public abstract void noteFullWifiLockReleasedLocked();

        public abstract void noteScanWifiLockAcquiredLocked();

        public abstract void noteScanWifiLockReleasedLocked();

        public abstract void noteUserActivityLocked(int var1);

        public abstract void noteVideoTurnedOffLocked();

        public abstract void noteVideoTurnedOnLocked();

        public abstract void noteWifiMulticastDisabledLocked();

        public abstract void noteWifiMulticastEnabledLocked();

        public abstract void noteWifiRunningLocked();

        public abstract void noteWifiStoppedLocked();

        public class Pid {
            public long mWakeStart;
            public long mWakeSum;
        }

        public static abstract class Pkg {
            public abstract Map<String, ? extends Serv> getServiceStats();

            public abstract int getWakeups(int var1);

            public abstract class Serv {
                public abstract int getLaunches(int var1);

                public abstract long getStartTime(long var1, int var3);

                public abstract int getStarts(int var1);
            }
        }

        public static abstract class Proc {
            public abstract int countExcessivePowers();

            public abstract ExcessivePower getExcessivePower(int var1);

            public abstract long getForegroundTime(int var1);

            public abstract int getStarts(int var1);

            public abstract long getSystemTime(int var1);

            public abstract long getTimeAtCpuSpeedStep(int var1, int var2);

            public abstract long getUserTime(int var1);

            public static class ExcessivePower {
                public static final int TYPE_CPU = 2;
                public static final int TYPE_WAKE = 1;
                public long overTime;
                public int type;
                public long usedTime;
            }
        }

        public static abstract class Sensor {
            public static final int GPS = -10000;

            public abstract int getHandle();

            public abstract Timer getSensorTime();
        }

        public static abstract class Wakelock {
            public abstract Timer getWakeTime(int var1);
        }
    }
}

