/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.util.Log;
import java.util.HashMap;

public final class LatencyTimer {
    final String TAG;
    final int mSampleSize;
    final int mScaleFactor;
    volatile HashMap<String, long[]> store = new HashMap();

    public LatencyTimer(int n, int n2) {
        this.TAG = "LatencyTimer";
        if (n2 == 0) {
            n2 = 1;
        }
        this.mScaleFactor = n2;
        this.mSampleSize = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long[] getArray(String string2) {
        long[] lArray = this.store.get(string2);
        if (lArray != null) {
            return lArray;
        }
        HashMap<String, long[]> hashMap = this.store;
        synchronized (hashMap) {
            long[] lArray2 = this.store.get(string2);
            if (lArray2 == null) {
                lArray2 = new long[1 + this.mSampleSize];
                this.store.put(string2, lArray2);
                lArray2[this.mSampleSize] = 0L;
            }
            return lArray2;
        }
    }

    public void sample(String string2, long l) {
        long[] lArray = this.getArray(string2);
        int n = this.mSampleSize;
        long l2 = lArray[n];
        lArray[n] = 1L + l2;
        lArray[(int)l2] = l;
        if (lArray[this.mSampleSize] == (long)this.mSampleSize) {
            long l3 = 0L;
            int n2 = lArray.length;
            for (int i = 0; i < n2; ++i) {
                l3 += lArray[i] / (long)this.mScaleFactor;
            }
            lArray[this.mSampleSize] = 0L;
            Log.i("LatencyTimer", string2 + " average = " + l3 / (long)this.mSampleSize);
        }
    }
}

