/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.IServiceManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManagerNative;
import android.util.Log;
import com.android.internal.os.BinderInternal;
import java.util.HashMap;
import java.util.Map;

public final class ServiceManager {
    private static final String TAG = "ServiceManager";
    private static HashMap<String, IBinder> sCache = new HashMap();
    private static IServiceManager sServiceManager;

    public static void addService(String string2, IBinder iBinder) {
        try {
            ServiceManager.getIServiceManager().addService(string2, iBinder);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "error in addService", remoteException);
            return;
        }
    }

    public static IBinder checkService(String string2) {
        block3: {
            try {
                IBinder iBinder = sCache.get(string2);
                if (iBinder == null) break block3;
                return iBinder;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "error in checkService", remoteException);
                return null;
            }
        }
        IBinder iBinder = ServiceManager.getIServiceManager().checkService(string2);
        return iBinder;
    }

    private static IServiceManager getIServiceManager() {
        if (sServiceManager != null) {
            return sServiceManager;
        }
        sServiceManager = ServiceManagerNative.asInterface(BinderInternal.getContextObject());
        return sServiceManager;
    }

    public static IBinder getService(String string2) {
        block3: {
            try {
                IBinder iBinder = sCache.get(string2);
                if (iBinder == null) break block3;
                return iBinder;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "error in getService", remoteException);
                return null;
            }
        }
        IBinder iBinder = ServiceManager.getIServiceManager().getService(string2);
        return iBinder;
    }

    public static void initServiceCache(Map<String, IBinder> map) {
        if (sCache.size() != 0 && Process.supportsProcesses()) {
            throw new IllegalStateException("setServiceCache may only be called once");
        }
        sCache.putAll(map);
    }

    public static String[] listServices() throws RemoteException {
        try {
            String[] stringArray = ServiceManager.getIServiceManager().listServices();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "error in listServices", remoteException);
            return null;
        }
    }
}

