/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IPermissionController;
import android.os.IServiceManager;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ServiceManagerProxy;

public abstract class ServiceManagerNative
extends Binder
implements IServiceManager {
    public ServiceManagerNative() {
        this.attachInterface(this, "android.os.IServiceManager");
    }

    public static IServiceManager asInterface(IBinder iBinder) {
        if (iBinder == null) {
            return null;
        }
        IServiceManager iServiceManager = (IServiceManager)iBinder.queryLocalInterface("android.os.IServiceManager");
        if (iServiceManager != null) {
            return iServiceManager;
        }
        return new ServiceManagerProxy(iBinder);
    }

    @Override
    public IBinder asBinder() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) {
        switch (n) {
            default: {
                return false;
            }
            case 1: {
                parcel.enforceInterface("android.os.IServiceManager");
                parcel2.writeStrongBinder(this.getService(parcel.readString()));
                return true;
            }
            case 2: {
                parcel.enforceInterface("android.os.IServiceManager");
                parcel2.writeStrongBinder(this.checkService(parcel.readString()));
                return true;
            }
            case 3: {
                parcel.enforceInterface("android.os.IServiceManager");
                this.addService(parcel.readString(), parcel.readStrongBinder());
                return true;
            }
            case 4: {
                parcel.enforceInterface("android.os.IServiceManager");
                parcel2.writeStringArray(this.listServices());
                return true;
            }
            case 6: 
        }
        try {
            parcel.enforceInterface("android.os.IServiceManager");
            this.setPermissionController(IPermissionController.Stub.asInterface(parcel.readStrongBinder()));
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }
}

