/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import java.util.ArrayList;
import java.util.HashMap;

public abstract class UEventObserver {
    private static final String TAG = UEventObserver.class.getSimpleName();
    private static UEventThread sThread;
    private static boolean sThreadStarted;

    static {
        sThreadStarted = false;
    }

    private static final void ensureThreadStarted() {
        synchronized (UEventObserver.class) {
            if (!sThreadStarted) {
                sThread = new UEventThread();
                sThread.start();
                sThreadStarted = true;
            }
            return;
        }
    }

    private static native void native_setup();

    private static native int next_event(byte[] var0);

    protected void finalize() throws Throwable {
        try {
            this.stopObserving();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public abstract void onUEvent(UEvent var1);

    public final void startObserving(String string2) {
        synchronized (this) {
            UEventObserver.ensureThreadStarted();
            sThread.addObserver(string2, this);
            return;
        }
    }

    public final void stopObserving() {
        synchronized (this) {
            sThread.removeObserver(this);
            return;
        }
    }

    public static class UEvent {
        public HashMap<String, String> mMap = new HashMap();

        public UEvent(String string2) {
            int n = 0;
            int n2 = string2.length();
            while (true) {
                int n3;
                int n4;
                block6: {
                    block5: {
                        if (n >= n2) break block5;
                        n4 = string2.indexOf(61, n);
                        n3 = string2.indexOf(0, n);
                        if (n3 >= 0) break block6;
                    }
                    return;
                }
                if (n4 > n && n4 < n3) {
                    this.mMap.put(string2.substring(n, n4), string2.substring(n4 + 1, n3));
                }
                n = n3 + 1;
            }
        }

        public String get(String string2) {
            return this.mMap.get(string2);
        }

        public String get(String string2, String string3) {
            String string4 = this.mMap.get(string2);
            if (string4 == null) {
                return string3;
            }
            return string4;
        }

        public String toString() {
            return this.mMap.toString();
        }
    }

    private static class UEventThread
    extends Thread {
        private ArrayList<Object> mObservers = new ArrayList();

        UEventThread() {
            super("UEventObserver");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void addObserver(String string2, UEventObserver uEventObserver) {
            ArrayList<Object> arrayList = this.mObservers;
            synchronized (arrayList) {
                this.mObservers.add(string2);
                this.mObservers.add(uEventObserver);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void removeObserver(UEventObserver uEventObserver) {
            ArrayList<Object> arrayList = this.mObservers;
            synchronized (arrayList) {
                boolean bl = true;
                block2: while (bl) {
                    int n = 0;
                    while (true) {
                        int n2 = this.mObservers.size();
                        bl = false;
                        if (n >= n2) continue block2;
                        if (this.mObservers.get(n + 1) == uEventObserver) {
                            this.mObservers.remove(n + 1);
                            this.mObservers.remove(n);
                            bl = true;
                            continue block2;
                        }
                        n += 2;
                    }
                    break;
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            UEventObserver.native_setup();
            byte[] byArray = new byte[1024];
            block2: while (true) {
                int n;
                if ((n = UEventObserver.next_event(byArray)) <= 0) {
                    continue;
                }
                String string2 = new String(byArray, 0, n);
                ArrayList<Object> arrayList = this.mObservers;
                synchronized (arrayList) {
                    int n2 = 0;
                    while (true) {
                        if (n2 < this.mObservers.size()) {
                            if (string2.indexOf((String)this.mObservers.get(n2)) != -1) {
                                ((UEventObserver)this.mObservers.get(n2 + 1)).onUEvent(new UEvent(string2));
                            }
                        } else {
                            continue block2;
                        }
                        n2 += 2;
                    }
                }
                break;
            }
        }
    }
}

