/*
 * Decompiled with CFR 0.152.
 */
package android.pim;

import android.content.ContentUris;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.provider.ContactsContract;
import android.util.Log;
import android.widget.ImageView;
import com.android.internal.telephony.CallerInfo;
import com.android.internal.telephony.Connection;
import java.io.InputStream;

public class ContactsAsyncHelper
extends Handler {
    private static final boolean DBG = false;
    private static final int DEFAULT_TOKEN = -1;
    private static final int EVENT_LOAD_IMAGE = 1;
    private static final String LOG_TAG = "ContactsAsyncHelper";
    private static ContactsAsyncHelper sInstance = new ContactsAsyncHelper();
    private static Handler sThreadHandler;

    private ContactsAsyncHelper() {
        HandlerThread handlerThread = new HandlerThread("ContactsAsyncWorker");
        handlerThread.start();
        sThreadHandler = new WorkerHandler(handlerThread.getLooper());
    }

    public static final void updateImageViewWithContactPhotoAsync(Context context, ImageView imageView, Uri uri, int n) {
        ContactsAsyncHelper.updateImageViewWithContactPhotoAsync(null, -1, null, null, context, imageView, uri, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void updateImageViewWithContactPhotoAsync(CallerInfo callerInfo, int n, OnImageLoadCompleteListener onImageLoadCompleteListener, Object object, Context context, ImageView imageView, Uri uri, int n2) {
        if (uri == null) {
            imageView.setVisibility(0);
            imageView.setImageResource(n2);
            return;
        }
        WorkerArgs workerArgs = new WorkerArgs();
        workerArgs.cookie = object;
        workerArgs.context = context;
        workerArgs.view = imageView;
        workerArgs.uri = uri;
        workerArgs.defaultResource = n2;
        workerArgs.listener = onImageLoadCompleteListener;
        workerArgs.info = callerInfo;
        Message message = sThreadHandler.obtainMessage(n);
        message.arg1 = 1;
        message.obj = workerArgs;
        if (n2 != -1) {
            imageView.setVisibility(0);
            imageView.setImageResource(n2);
        } else {
            imageView.setVisibility(4);
        }
        sThreadHandler.sendMessage(message);
    }

    public static final void updateImageViewWithContactPhotoAsync(CallerInfo callerInfo, Context context, ImageView imageView, Uri uri, int n) {
        ContactsAsyncHelper.updateImageViewWithContactPhotoAsync(callerInfo, -1, null, null, context, imageView, uri, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleMessage(Message message) {
        WorkerArgs workerArgs = (WorkerArgs)message.obj;
        switch (message.arg1) {
            default: {
                return;
            }
            case 1: {
                boolean bl;
                if (workerArgs.result != null) {
                    workerArgs.view.setVisibility(0);
                    workerArgs.view.setImageDrawable((Drawable)workerArgs.result);
                    if (workerArgs.info != null) {
                        workerArgs.info.cachedPhoto = (Drawable)workerArgs.result;
                    }
                    bl = true;
                } else {
                    int n = workerArgs.defaultResource;
                    bl = false;
                    if (n != -1) {
                        workerArgs.view.setVisibility(0);
                        workerArgs.view.setImageResource(workerArgs.defaultResource);
                        bl = false;
                    }
                }
                if (workerArgs.info != null) {
                    workerArgs.info.isCachedPhotoCurrent = true;
                }
                if (workerArgs.listener == null) return;
                workerArgs.listener.onImageLoadComplete(message.what, workerArgs.cookie, workerArgs.view, bl);
                return;
            }
        }
    }

    public static class ImageTracker {
        public static final int DISPLAY_DEFAULT = -2;
        public static final int DISPLAY_IMAGE = -1;
        public static final int DISPLAY_UNDEFINED;
        private int displayMode = 0;
        private CallerInfo mCurrentCallerInfo = null;

        public int getPhotoState() {
            return this.displayMode;
        }

        public Uri getPhotoUri() {
            if (this.mCurrentCallerInfo != null) {
                return ContentUris.withAppendedId(ContactsContract.Contacts.CONTENT_URI, this.mCurrentCallerInfo.person_id);
            }
            return null;
        }

        public boolean isDifferentImageRequest(CallerInfo callerInfo) {
            return this.mCurrentCallerInfo != callerInfo;
        }

        public boolean isDifferentImageRequest(Connection connection) {
            if (connection == null) {
                return this.mCurrentCallerInfo != null;
            }
            Object object = connection.getUserData();
            boolean bl = true;
            if (object instanceof CallerInfo) {
                bl = this.isDifferentImageRequest((CallerInfo)object);
            }
            return bl;
        }

        public void setPhotoRequest(CallerInfo callerInfo) {
            this.mCurrentCallerInfo = callerInfo;
        }

        public void setPhotoState(int n) {
            this.displayMode = n;
        }
    }

    public static interface OnImageLoadCompleteListener {
        public void onImageLoadComplete(int var1, Object var2, ImageView var3, boolean var4);
    }

    private static final class WorkerArgs {
        public Context context;
        public Object cookie;
        public int defaultResource;
        public CallerInfo info;
        public OnImageLoadCompleteListener listener;
        public Object result;
        public Uri uri;
        public ImageView view;

        private WorkerArgs() {
        }
    }

    private class WorkerHandler
    extends Handler {
        public WorkerHandler(Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            WorkerArgs workerArgs = (WorkerArgs)message.obj;
            switch (message.arg1) {
                default: {
                    break;
                }
                case 1: {
                    InputStream inputStream;
                    try {
                        InputStream inputStream2;
                        inputStream = inputStream2 = ContactsContract.Contacts.openContactPhotoInputStream(workerArgs.context.getContentResolver(), workerArgs.uri);
                    }
                    catch (Exception exception) {
                        Log.e(ContactsAsyncHelper.LOG_TAG, "Error opening photo input stream", exception);
                        inputStream = null;
                    }
                    workerArgs.result = inputStream != null ? Drawable.createFromStream(inputStream, workerArgs.uri.toString()) : null;
                }
            }
            Message message2 = ContactsAsyncHelper.this.obtainMessage(message.what);
            message2.arg1 = message.arg1;
            message2.obj = message.obj;
            message2.sendToTarget();
        }
    }
}

