/*
 * Decompiled with CFR 0.152.
 */
package android.pim;

import android.text.TextUtils;
import android.text.format.Time;

public class EventRecurrence {
    public static final int DAILY = 4;
    public static final int FR = 0x200000;
    public static final int HOURLY = 3;
    public static final int MINUTELY = 2;
    public static final int MO = 131072;
    public static final int MONTHLY = 6;
    public static final int SA = 0x400000;
    public static final int SECONDLY = 1;
    public static final int SU = 65536;
    public static final int TH = 0x100000;
    public static final int TU = 262144;
    public static final int WE = 524288;
    public static final int WEEKLY = 5;
    public static final int YEARLY = 7;
    public int[] byday;
    public int bydayCount;
    public int[] bydayNum;
    public int[] byhour;
    public int byhourCount;
    public int[] byminute;
    public int byminuteCount;
    public int[] bymonth;
    public int bymonthCount;
    public int[] bymonthday;
    public int bymonthdayCount;
    public int[] bysecond;
    public int bysecondCount;
    public int[] bysetpos;
    public int bysetposCount;
    public int[] byweekno;
    public int byweeknoCount;
    public int[] byyearday;
    public int byyeardayCount;
    public int count;
    public int freq;
    public int interval;
    public Time startDate;
    public String until;
    public int wkst = 131072;

    private void appendByDay(StringBuilder stringBuilder, int n) {
        int n2 = this.bydayNum[n];
        if (n2 != 0) {
            stringBuilder.append(n2);
        }
        stringBuilder.append(EventRecurrence.day2String(this.byday[n]));
    }

    private static void appendNumbers(StringBuilder stringBuilder, String string2, int n, int[] nArray) {
        if (n > 0) {
            stringBuilder.append(string2);
            int n2 = n - 1;
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append(nArray[i]);
                stringBuilder.append(",");
            }
            stringBuilder.append(nArray[n2]);
        }
    }

    public static int calendarDay2Day(int n) {
        switch (n) {
            default: {
                throw new RuntimeException("bad day of week: " + n);
            }
            case 1: {
                return 65536;
            }
            case 2: {
                return 131072;
            }
            case 3: {
                return 262144;
            }
            case 4: {
                return 524288;
            }
            case 5: {
                return 0x100000;
            }
            case 6: {
                return 0x200000;
            }
            case 7: 
        }
        return 0x400000;
    }

    public static int day2CalendarDay(int n) {
        switch (n) {
            default: {
                throw new RuntimeException("bad day of week: " + n);
            }
            case 65536: {
                return 1;
            }
            case 131072: {
                return 2;
            }
            case 262144: {
                return 3;
            }
            case 524288: {
                return 4;
            }
            case 0x100000: {
                return 5;
            }
            case 0x200000: {
                return 6;
            }
            case 0x400000: 
        }
        return 7;
    }

    private static String day2String(int n) {
        switch (n) {
            default: {
                throw new IllegalArgumentException("bad day argument: " + n);
            }
            case 65536: {
                return "SU";
            }
            case 131072: {
                return "MO";
            }
            case 262144: {
                return "TU";
            }
            case 524288: {
                return "WE";
            }
            case 0x100000: {
                return "TH";
            }
            case 0x200000: {
                return "FR";
            }
            case 0x400000: 
        }
        return "SA";
    }

    public static int day2TimeDay(int n) {
        switch (n) {
            default: {
                throw new RuntimeException("bad day of week: " + n);
            }
            case 65536: {
                return 0;
            }
            case 131072: {
                return 1;
            }
            case 262144: {
                return 2;
            }
            case 524288: {
                return 3;
            }
            case 0x100000: {
                return 4;
            }
            case 0x200000: {
                return 5;
            }
            case 0x400000: 
        }
        return 6;
    }

    public static int timeDay2Day(int n) {
        switch (n) {
            default: {
                throw new RuntimeException("bad day of week: " + n);
            }
            case 0: {
                return 65536;
            }
            case 1: {
                return 131072;
            }
            case 2: {
                return 262144;
            }
            case 3: {
                return 524288;
            }
            case 4: {
                return 0x100000;
            }
            case 5: {
                return 0x200000;
            }
            case 6: 
        }
        return 0x400000;
    }

    public native void parse(String var1);

    public boolean repeatsMonthlyOnDayCount() {
        if (this.freq != 6) {
            return false;
        }
        return this.bydayCount == 1 && this.bymonthdayCount == 0;
    }

    public boolean repeatsOnEveryWeekDay() {
        if (this.freq != 5) {
            return false;
        }
        int n = this.bydayCount;
        if (n != 5) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.byday[i];
            if (n2 != 65536 && n2 != 0x400000) continue;
            return false;
        }
        return true;
    }

    public void setStartDate(Time time) {
        this.startDate = time;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FREQ=");
        switch (this.freq) {
            case 1: {
                stringBuilder.append("SECONDLY");
                break;
            }
            case 2: {
                stringBuilder.append("MINUTELY");
                break;
            }
            case 3: {
                stringBuilder.append("HOURLY");
                break;
            }
            case 4: {
                stringBuilder.append("DAILY");
                break;
            }
            case 5: {
                stringBuilder.append("WEEKLY");
                break;
            }
            case 6: {
                stringBuilder.append("MONTHLY");
                break;
            }
            case 7: {
                stringBuilder.append("YEARLY");
            }
        }
        if (!TextUtils.isEmpty(this.until)) {
            stringBuilder.append(";UNTIL=");
            stringBuilder.append(this.until);
        }
        if (this.count != 0) {
            stringBuilder.append(";COUNT=");
            stringBuilder.append(this.count);
        }
        if (this.interval != 0) {
            stringBuilder.append(";INTERVAL=");
            stringBuilder.append(this.interval);
        }
        if (this.wkst != 0) {
            stringBuilder.append(";WKST=");
            stringBuilder.append(EventRecurrence.day2String(this.wkst));
        }
        EventRecurrence.appendNumbers(stringBuilder, ";BYSECOND=", this.bysecondCount, this.bysecond);
        EventRecurrence.appendNumbers(stringBuilder, ";BYMINUTE=", this.byminuteCount, this.byminute);
        EventRecurrence.appendNumbers(stringBuilder, ";BYSECOND=", this.byhourCount, this.byhour);
        int n = this.bydayCount;
        if (n > 0) {
            stringBuilder.append(";BYDAY=");
            int n2 = n - 1;
            for (int i = 0; i < n2; ++i) {
                this.appendByDay(stringBuilder, i);
                stringBuilder.append(",");
            }
            this.appendByDay(stringBuilder, n2);
        }
        EventRecurrence.appendNumbers(stringBuilder, ";BYMONTHDAY=", this.bymonthdayCount, this.bymonthday);
        EventRecurrence.appendNumbers(stringBuilder, ";BYYEARDAY=", this.byyeardayCount, this.byyearday);
        EventRecurrence.appendNumbers(stringBuilder, ";BYWEEKNO=", this.byweeknoCount, this.byweekno);
        EventRecurrence.appendNumbers(stringBuilder, ";BYMONTH=", this.bymonthCount, this.bymonth);
        EventRecurrence.appendNumbers(stringBuilder, ";BYSETPOS=", this.bysetposCount, this.bysetpos);
        return stringBuilder.toString();
    }

    public static class InvalidFormatException
    extends RuntimeException {
        InvalidFormatException(String string2) {
            super(string2);
        }
    }
}

