/*
 * Decompiled with CFR 0.152.
 */
package android.pim;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ICalendar {
    private static final String TAG = "Sync";

    private ICalendar() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Parameter extractParameter(ParserState parserState) throws FormatException {
        String string2 = parserState.line;
        int n = string2.length();
        Parameter parameter = null;
        int n2 = -1;
        int n3 = -1;
        while (true) {
            if (parserState.index >= n) {
                throw new FormatException("Expected ':' before end of line in " + string2);
            }
            char c = string2.charAt(parserState.index);
            if (c == ':') {
                if (parameter != null) {
                    if (n3 == -1) {
                        throw new FormatException("Expected '=' within parameter in " + string2);
                    }
                    parameter.value = string2.substring(n3 + 1, parserState.index);
                }
                return parameter;
            }
            if (c == ';') {
                if (parameter != null) {
                    if (n3 == -1) {
                        throw new FormatException("Expected '=' within parameter in " + string2);
                    }
                    parameter.value = string2.substring(n3 + 1, parserState.index);
                    return parameter;
                }
                parameter = new Parameter();
                n2 = parserState.index;
            } else if (c == '=') {
                n3 = parserState.index;
                if (parameter == null || n2 == -1) {
                    throw new FormatException("Expected ';' before '=' in " + string2);
                }
                parameter.name = string2.substring(n2 + 1, n3);
            }
            parserState.index = 1 + parserState.index;
        }
    }

    private static String extractValue(ParserState parserState) throws FormatException {
        String string2 = parserState.line;
        if (parserState.index >= string2.length() || string2.charAt(parserState.index) != ':') {
            throw new FormatException("Expected ':' before end of line in " + string2);
        }
        String string3 = string2.substring(1 + parserState.index);
        parserState.index = string2.length() - 1;
        return string3;
    }

    private static String normalizeText(String string2) {
        return string2.replaceAll("\r\n", "\n").replaceAll("\r", "\n").replaceAll("\n ", "");
    }

    public static Component parseCalendar(String string2) throws FormatException {
        Component component = ICalendar.parseComponent(null, string2);
        if (component == null || !"VCALENDAR".equals(component.getName())) {
            throw new FormatException("Expected VCALENDAR");
        }
        return component;
    }

    public static Component parseComponent(Component component, String string2) throws FormatException {
        return ICalendar.parseComponentImpl(component, ICalendar.normalizeText(string2));
    }

    public static Component parseComponent(String string2) throws FormatException {
        return ICalendar.parseComponent(null, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Component parseComponentImpl(Component component, String string2) throws FormatException {
        Component component2 = component;
        ParserState parserState = new ParserState();
        parserState.index = 0;
        String[] stringArray = string2.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray[n2];
            try {
                Component component3;
                component2 = component3 = ICalendar.parseLine(string3, parserState, component2);
                if (component == null) {
                    component = component2;
                }
            }
            catch (FormatException formatException) {}
            ++n2;
        }
        return component;
    }

    public static Component parseEvent(String string2) throws FormatException {
        Component component = ICalendar.parseComponent(null, string2);
        if (component == null || !"VEVENT".equals(component.getName())) {
            throw new FormatException("Expected VEVENT");
        }
        return component;
    }

    private static Component parseLine(String string2, ParserState parserState, Component component) throws FormatException {
        String string3;
        parserState.line = string2;
        int n = parserState.line.length();
        char c = '\u0000';
        parserState.index = 0;
        while (true) {
            if (parserState.index >= n || (c = string2.charAt(parserState.index)) == ';' || c == ':') {
                string3 = string2.substring(0, parserState.index);
                if (component != null || "BEGIN".equals(string3)) break;
                throw new FormatException("Expected BEGIN");
            }
            parserState.index = 1 + parserState.index;
        }
        if ("BEGIN".equals(string3)) {
            Component component2 = new Component(ICalendar.extractValue(parserState), component);
            if (component != null) {
                component.addChild(component2);
            }
            return component2;
        }
        if ("END".equals(string3)) {
            String string4 = ICalendar.extractValue(parserState);
            if (component == null || !string4.equals(component.getName())) {
                throw new FormatException("Unexpected END " + string4);
            }
            return component.getParent();
        }
        Property property = new Property(string3);
        if (c == ';') {
            Parameter parameter;
            while ((parameter = ICalendar.extractParameter(parserState)) != null) {
                property.addParameter(parameter);
            }
        }
        property.setValue(ICalendar.extractValue(parserState));
        component.addProperty(property);
        return component;
    }

    public static class Component {
        private static final String BEGIN = "BEGIN";
        private static final String END = "END";
        private static final String NEWLINE = "\n";
        public static final String VALARM = "VALARM";
        public static final String VCALENDAR = "VCALENDAR";
        public static final String VEVENT = "VEVENT";
        public static final String VFREEBUSY = "VFREEBUSY";
        public static final String VJOURNAL = "VJOURNAL";
        public static final String VTIMEZONE = "VTIMEZONE";
        public static final String VTODO = "VTODO";
        private LinkedList<Component> mChildren = null;
        private final String mName;
        private final Component mParent;
        private final LinkedHashMap<String, ArrayList<Property>> mPropsMap = new LinkedHashMap();

        public Component(String string2, Component component) {
            this.mName = string2;
            this.mParent = component;
        }

        public void addChild(Component component) {
            this.getOrCreateChildren().add(component);
        }

        public void addProperty(Property property) {
            String string2 = property.getName();
            ArrayList<Property> arrayList = this.mPropsMap.get(string2);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.mPropsMap.put(string2, arrayList);
            }
            arrayList.add(property);
        }

        public List<Component> getComponents() {
            return this.mChildren;
        }

        public Property getFirstProperty(String string2) {
            List list = this.mPropsMap.get(string2);
            if (list == null || list.size() == 0) {
                return null;
            }
            return (Property)list.get(0);
        }

        public String getName() {
            return this.mName;
        }

        protected LinkedList<Component> getOrCreateChildren() {
            if (this.mChildren == null) {
                this.mChildren = new LinkedList();
            }
            return this.mChildren;
        }

        public Component getParent() {
            return this.mParent;
        }

        public List<Property> getProperties(String string2) {
            return this.mPropsMap.get(string2);
        }

        public Set<String> getPropertyNames() {
            return this.mPropsMap.keySet();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder);
            stringBuilder.append(NEWLINE);
            return stringBuilder.toString();
        }

        public void toString(StringBuilder stringBuilder) {
            stringBuilder.append(BEGIN);
            stringBuilder.append(":");
            stringBuilder.append(this.mName);
            stringBuilder.append(NEWLINE);
            Iterator<String> iterator = this.getPropertyNames().iterator();
            while (iterator.hasNext()) {
                Iterator<Property> iterator2 = this.getProperties(iterator.next()).iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().toString(stringBuilder);
                    stringBuilder.append(NEWLINE);
                }
            }
            if (this.mChildren != null) {
                Iterator iterator3 = this.mChildren.iterator();
                while (iterator3.hasNext()) {
                    ((Component)iterator3.next()).toString(stringBuilder);
                    stringBuilder.append(NEWLINE);
                }
            }
            stringBuilder.append(END);
            stringBuilder.append(":");
            stringBuilder.append(this.mName);
        }
    }

    public static class FormatException
    extends Exception {
        public FormatException() {
        }

        public FormatException(String string2) {
            super(string2);
        }

        public FormatException(String string2, Throwable throwable) {
            super(string2, throwable);
        }
    }

    public static class Parameter {
        public String name;
        public String value;

        public Parameter() {
        }

        public Parameter(String string2, String string3) {
            this.name = string2;
            this.value = string3;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder);
            return stringBuilder.toString();
        }

        public void toString(StringBuilder stringBuilder) {
            stringBuilder.append(this.name);
            stringBuilder.append("=");
            stringBuilder.append(this.value);
        }
    }

    private static final class ParserState {
        public int index;
        public String line;

        private ParserState() {
        }
    }

    public static class Property {
        public static final String DTEND = "DTEND";
        public static final String DTSTART = "DTSTART";
        public static final String DURATION = "DURATION";
        public static final String EXDATE = "EXDATE";
        public static final String EXRULE = "EXRULE";
        public static final String RDATE = "RDATE";
        public static final String RRULE = "RRULE";
        private final String mName;
        private LinkedHashMap<String, ArrayList<Parameter>> mParamsMap = new LinkedHashMap();
        private String mValue;

        public Property(String string2) {
            this.mName = string2;
        }

        public Property(String string2, String string3) {
            this.mName = string2;
            this.mValue = string3;
        }

        public void addParameter(Parameter parameter) {
            ArrayList<Parameter> arrayList = this.mParamsMap.get(parameter.name);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.mParamsMap.put(parameter.name, arrayList);
            }
            arrayList.add(parameter);
        }

        public Parameter getFirstParameter(String string2) {
            ArrayList<Parameter> arrayList = this.mParamsMap.get(string2);
            if (arrayList == null || arrayList.size() == 0) {
                return null;
            }
            return arrayList.get(0);
        }

        public String getName() {
            return this.mName;
        }

        public Set<String> getParameterNames() {
            return this.mParamsMap.keySet();
        }

        public List<Parameter> getParameters(String string2) {
            return this.mParamsMap.get(string2);
        }

        public String getValue() {
            return this.mValue;
        }

        public void setValue(String string2) {
            this.mValue = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder);
            return stringBuilder.toString();
        }

        public void toString(StringBuilder stringBuilder) {
            stringBuilder.append(this.mName);
            Iterator<String> iterator = this.getParameterNames().iterator();
            while (iterator.hasNext()) {
                for (Parameter parameter : this.getParameters(iterator.next())) {
                    stringBuilder.append(";");
                    parameter.toString(stringBuilder);
                }
            }
            stringBuilder.append(":");
            stringBuilder.append(this.mValue);
        }
    }
}

