/*
 * Decompiled with CFR 0.152.
 */
package android.pim;

import android.content.ContentValues;
import android.database.Cursor;
import android.pim.EventRecurrence;
import android.pim.ICalendar;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.Log;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class RecurrenceSet {
    private static final String FOLDING_SEPARATOR = "\n ";
    private static final Pattern FOLD_RE;
    private static final Pattern IGNORABLE_ICAL_WHITESPACE_RE;
    private static final String RULE_SEPARATOR = "\n";
    private static final String TAG = "CalendarProvider";
    public long[] exdates = null;
    public EventRecurrence[] exrules = null;
    public long[] rdates = null;
    public EventRecurrence[] rrules = null;

    static {
        IGNORABLE_ICAL_WHITESPACE_RE = Pattern.compile("(?:\\r\\n?|\\n)[ \t]");
        FOLD_RE = Pattern.compile(".{75}");
    }

    public RecurrenceSet(ContentValues contentValues) throws EventRecurrence.InvalidFormatException {
        this.init(contentValues.getAsString("rrule"), contentValues.getAsString("rdate"), contentValues.getAsString("exrule"), contentValues.getAsString("exdate"));
    }

    public RecurrenceSet(Cursor cursor) throws EventRecurrence.InvalidFormatException {
        int n = cursor.getColumnIndex("rrule");
        int n2 = cursor.getColumnIndex("rdate");
        int n3 = cursor.getColumnIndex("exrule");
        int n4 = cursor.getColumnIndex("exdate");
        this.init(cursor.getString(n), cursor.getString(n2), cursor.getString(n3), cursor.getString(n4));
    }

    public RecurrenceSet(String string2, String string3, String string4, String string5) throws EventRecurrence.InvalidFormatException {
        this.init(string2, string3, string4, string5);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void addPropertiesForRuleStr(ICalendar.Component component, String string2, String string3) {
        if (!TextUtils.isEmpty(string3)) {
            for (String string4 : RecurrenceSet.getRuleStrings(string3)) {
                ICalendar.Property property = new ICalendar.Property(string2);
                property.setValue(string4);
                component.addProperty(property);
            }
        }
    }

    private static void addPropertyForDateStr(ICalendar.Component component, String string2, String string3) {
        if (TextUtils.isEmpty(string3)) {
            return;
        }
        ICalendar.Property property = new ICalendar.Property(string2);
        int n = string3.indexOf(";");
        String string4 = null;
        if (n != -1) {
            string4 = string3.substring(0, n);
            string3 = string3.substring(n + 1);
        }
        if (!TextUtils.isEmpty(string4)) {
            property.addParameter(new ICalendar.Parameter("TZID", string4));
        }
        property.setValue(string3);
        component.addProperty(property);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String computeDuration(Time time, ICalendar.Component component) {
        ICalendar.Property property = component.getFirstProperty("DURATION");
        if (property != null) {
            return property.getValue();
        }
        ICalendar.Property property2 = component.getFirstProperty("DTEND");
        if (property2 == null) {
            return "+P0S";
        }
        ICalendar.Parameter parameter = property2.getFirstParameter("TZID");
        String string2 = parameter == null ? time.timezone : parameter.value;
        Time time2 = new Time(string2);
        time2.parse(property2.getValue());
        long l = (time2.toMillis(false) - time.toMillis(false)) / 1000L;
        if (time.allDay && l % 86400L == 0L) {
            return "P" + l / 86400L + "D";
        }
        return "P" + l + "S";
    }

    private static String extractDates(ICalendar.Property property) {
        if (property == null) {
            return null;
        }
        ICalendar.Parameter parameter = property.getFirstParameter("TZID");
        if (parameter != null) {
            return parameter.value + ";" + property.getValue();
        }
        return property.getValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String flattenProperties(ICalendar.Component component, String string2) {
        List<ICalendar.Property> list = component.getProperties(string2);
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0).getValue();
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        Iterator<ICalendar.Property> iterator = component.getProperties(string2).iterator();
        while (iterator.hasNext()) {
            ICalendar.Property property = iterator.next();
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(RULE_SEPARATOR);
            }
            stringBuilder.append(property.getValue());
        }
        return stringBuilder.toString();
    }

    public static String fold(String string2) {
        return FOLD_RE.matcher(string2).replaceAll("$0\r\n ");
    }

    private static String[] getRuleStrings(String string2) {
        if (string2 == null) {
            return new String[0];
        }
        String[] stringArray = RecurrenceSet.unfold(string2).split(RULE_SEPARATOR);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = RecurrenceSet.fold(stringArray[i]);
        }
        return stringArray;
    }

    private void init(String string2, String string3, String string4, String string5) throws EventRecurrence.InvalidFormatException {
        if (!TextUtils.isEmpty(string2) || !TextUtils.isEmpty(string3)) {
            if (!TextUtils.isEmpty(string2)) {
                String[] stringArray = string2.split(RULE_SEPARATOR);
                this.rrules = new EventRecurrence[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    EventRecurrence eventRecurrence = new EventRecurrence();
                    eventRecurrence.parse(stringArray[i]);
                    this.rrules[i] = eventRecurrence;
                }
            }
            if (!TextUtils.isEmpty(string3)) {
                this.rdates = RecurrenceSet.parseRecurrenceDates(string3);
            }
            if (!TextUtils.isEmpty(string4)) {
                String[] stringArray = string4.split(RULE_SEPARATOR);
                this.exrules = new EventRecurrence[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    EventRecurrence eventRecurrence = new EventRecurrence();
                    eventRecurrence.parse(string4);
                    this.exrules[i] = eventRecurrence;
                }
            }
            if (!TextUtils.isEmpty(string5)) {
                this.exdates = RecurrenceSet.parseRecurrenceDates(string5);
            }
        }
    }

    public static long[] parseRecurrenceDates(String string2) {
        String string3 = "UTC";
        int n = string2.indexOf(";");
        if (n != -1) {
            string3 = string2.substring(0, n);
            string2 = string2.substring(n + 1);
        }
        Time time = new Time(string3);
        String[] stringArray = string2.split(",");
        int n2 = stringArray.length;
        long[] lArray = new long[n2];
        for (int i = 0; i < n2; ++i) {
            time.parse(stringArray[i]);
            lArray[i] = time.toMillis(false);
            time.timezone = string3;
        }
        return lArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean populateComponent(ContentValues contentValues, ICalendar.Component component) {
        Time time;
        long l = -1L;
        if (contentValues.containsKey("dtstart")) {
            l = contentValues.getAsLong("dtstart");
        }
        String string2 = contentValues.getAsString("duration");
        String string3 = contentValues.getAsString("eventTimezone");
        String string4 = contentValues.getAsString("rrule");
        String string5 = contentValues.getAsString("rdate");
        String string6 = contentValues.getAsString("exrule");
        String string7 = contentValues.getAsString("exdate");
        Integer n = contentValues.getAsInteger("allDay");
        boolean bl = n != null ? n == 1 : false;
        if (l == -1L || TextUtils.isEmpty(string2) || TextUtils.isEmpty(string4) && TextUtils.isEmpty(string5)) {
            return false;
        }
        ICalendar.Property property = new ICalendar.Property("DTSTART");
        if (!TextUtils.isEmpty(string3)) {
            if (!bl) {
                property.addParameter(new ICalendar.Parameter("TZID", string3));
            }
            time = new Time(string3);
        } else {
            time = new Time("UTC");
        }
        time.set(l);
        if (bl) {
            property.addParameter(new ICalendar.Parameter("VALUE", "DATE"));
            time.allDay = true;
            time.hour = 0;
            time.minute = 0;
            time.second = 0;
        }
        property.setValue(time.format2445());
        component.addProperty(property);
        ICalendar.Property property2 = new ICalendar.Property("DURATION");
        property2.setValue(string2);
        component.addProperty(property2);
        RecurrenceSet.addPropertiesForRuleStr(component, "RRULE", string4);
        RecurrenceSet.addPropertyForDateStr(component, "RDATE", string5);
        RecurrenceSet.addPropertiesForRuleStr(component, "EXRULE", string6);
        RecurrenceSet.addPropertyForDateStr(component, "EXDATE", string7);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean populateComponent(Cursor cursor, ICalendar.Component component) {
        Time time;
        int n = cursor.getColumnIndex("dtstart");
        int n2 = cursor.getColumnIndex("duration");
        int n3 = cursor.getColumnIndex("eventTimezone");
        int n4 = cursor.getColumnIndex("rrule");
        int n5 = cursor.getColumnIndex("rdate");
        int n6 = cursor.getColumnIndex("exrule");
        int n7 = cursor.getColumnIndex("exdate");
        int n8 = cursor.getColumnIndex("allDay");
        long l = -1L;
        if (!cursor.isNull(n)) {
            l = cursor.getLong(n);
        }
        String string2 = cursor.getString(n2);
        String string3 = cursor.getString(n3);
        String string4 = cursor.getString(n4);
        String string5 = cursor.getString(n5);
        String string6 = cursor.getString(n6);
        String string7 = cursor.getString(n7);
        boolean bl = cursor.getInt(n8) == 1;
        if (l == -1L || TextUtils.isEmpty(string2) || TextUtils.isEmpty(string4) && TextUtils.isEmpty(string5)) {
            return false;
        }
        ICalendar.Property property = new ICalendar.Property("DTSTART");
        if (!TextUtils.isEmpty(string3)) {
            if (!bl) {
                property.addParameter(new ICalendar.Parameter("TZID", string3));
            }
            time = new Time(string3);
        } else {
            time = new Time("UTC");
        }
        time.set(l);
        if (bl) {
            property.addParameter(new ICalendar.Parameter("VALUE", "DATE"));
            time.allDay = true;
            time.hour = 0;
            time.minute = 0;
            time.second = 0;
        }
        property.setValue(time.format2445());
        component.addProperty(property);
        ICalendar.Property property2 = new ICalendar.Property("DURATION");
        property2.setValue(string2);
        component.addProperty(property2);
        RecurrenceSet.addPropertiesForRuleStr(component, "RRULE", string4);
        RecurrenceSet.addPropertyForDateStr(component, "RDATE", string5);
        RecurrenceSet.addPropertiesForRuleStr(component, "EXRULE", string6);
        RecurrenceSet.addPropertyForDateStr(component, "EXDATE", string7);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean populateContentValues(ICalendar.Component component, ContentValues contentValues) {
        ICalendar.Property property = component.getFirstProperty("DTSTART");
        String string2 = property.getValue();
        ICalendar.Parameter parameter = property.getFirstParameter("TZID");
        String string3 = parameter == null ? null : parameter.value;
        String string4 = parameter == null ? "UTC" : string3;
        Time time = new Time(string4);
        boolean bl = time.parse(string2);
        boolean bl2 = time.allDay;
        String string5 = bl || bl2 ? "UTC" : string3;
        String string6 = RecurrenceSet.computeDuration(time, component);
        String string7 = RecurrenceSet.flattenProperties(component, "RRULE");
        String string8 = RecurrenceSet.extractDates(component.getFirstProperty("RDATE"));
        String string9 = RecurrenceSet.flattenProperties(component, "EXRULE");
        String string10 = RecurrenceSet.extractDates(component.getFirstProperty("EXDATE"));
        if (TextUtils.isEmpty(string2) || TextUtils.isEmpty(string6) || TextUtils.isEmpty(string7) && TextUtils.isEmpty(string8)) {
            Log.d(TAG, "Recurrence missing DTSTART, DTEND/DURATION, or RRULE/RDATE: " + component.toString());
            return false;
        }
        if (bl2) {
            time.timezone = "UTC";
        }
        long l = time.toMillis(false);
        contentValues.put("dtstart", l);
        if (l == -1L) {
            Log.d(TAG, "DTSTART is out of range: " + component.toString());
            return false;
        }
        contentValues.put("rrule", string7);
        contentValues.put("rdate", string8);
        contentValues.put("exrule", string9);
        contentValues.put("exdate", string10);
        contentValues.put("eventTimezone", string5);
        contentValues.put("duration", string6);
        int n = bl2 ? 1 : 0;
        contentValues.put("allDay", n);
        return true;
    }

    public static String unfold(String string2) {
        return IGNORABLE_ICAL_WHITESPACE_RE.matcher(string2).replaceAll("");
    }

    public boolean hasRecurrence() {
        return this.rrules != null || this.rdates != null;
    }
}

