/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.content.ContentValues;
import android.pim.vcard.VCardConfig;
import android.pim.vcard.VCardUtils;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Base64;
import android.util.CharsetUtils;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VCardBuilder {
    public static final int DEFAULT_EMAIL_TYPE = 3;
    public static final int DEFAULT_PHONE_TYPE = 1;
    public static final int DEFAULT_POSTAL_TYPE = 1;
    private static final String LOG_TAG = "VCardBuilder";
    private static final String SHIFT_JIS = "SHIFT_JIS";
    private static final String VCARD_DATA_PUBLIC = "PUBLIC";
    private static final String VCARD_DATA_SEPARATOR = ":";
    private static final String VCARD_DATA_VCARD = "VCARD";
    private static final String VCARD_END_OF_LINE = "\r\n";
    private static final String VCARD_ITEM_SEPARATOR = ";";
    private static final String VCARD_PARAM_ENCODING_BASE64_AS_B = "ENCODING=B";
    private static final String VCARD_PARAM_ENCODING_BASE64_V21 = "ENCODING=BASE64";
    private static final String VCARD_PARAM_ENCODING_QP = "ENCODING=QUOTED-PRINTABLE";
    private static final String VCARD_PARAM_EQUAL = "=";
    private static final String VCARD_PARAM_SEPARATOR = ";";
    private static final String VCARD_WS = " ";
    private static final Set<String> sAllowedAndroidPropertySet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("vnd.android.cursor.item/nickname", "vnd.android.cursor.item/contact_event", "vnd.android.cursor.item/relation")));
    private static final Map<Integer, Integer> sPostalTypePriorityMap = new HashMap<Integer, Integer>();
    private final boolean mAppendTypeParamName;
    private StringBuilder mBuilder;
    private final String mCharset;
    private boolean mEndAppended;
    private final boolean mIsDoCoMo;
    private final boolean mIsJapaneseMobilePhone;
    private final boolean mIsV30OrV40;
    private final boolean mNeedsToConvertPhoneticString;
    private final boolean mOnlyOneNoteFieldIsAvailable;
    private final boolean mRefrainsQPToNameProperties;
    private final boolean mShouldAppendCharsetParam;
    private final boolean mShouldUseQuotedPrintable;
    private final boolean mUsesAndroidProperty;
    private final boolean mUsesDefactProperty;
    private final String mVCardCharsetParameter;
    private final int mVCardType;

    static {
        sPostalTypePriorityMap.put(1, 0);
        sPostalTypePriorityMap.put(2, 1);
        sPostalTypePriorityMap.put(3, 2);
        sPostalTypePriorityMap.put(0, 3);
    }

    public VCardBuilder(int n) {
        this(n, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VCardBuilder(int n, String string2) {
        block18: {
            block15: {
                block17: {
                    String string3;
                    block16: {
                        this.mVCardType = n;
                        if (VCardConfig.isVersion40(n)) {
                            Log.w(LOG_TAG, "Should not use vCard 4.0 when building vCard. It is not officially published yet.");
                        }
                        boolean bl = VCardConfig.isVersion30(n) || VCardConfig.isVersion40(n);
                        this.mIsV30OrV40 = bl;
                        this.mShouldUseQuotedPrintable = VCardConfig.shouldUseQuotedPrintable(n);
                        this.mIsDoCoMo = VCardConfig.isDoCoMo(n);
                        this.mIsJapaneseMobilePhone = VCardConfig.needsToConvertPhoneticString(n);
                        this.mOnlyOneNoteFieldIsAvailable = VCardConfig.onlyOneNoteFieldIsAvailable(n);
                        this.mUsesAndroidProperty = VCardConfig.usesAndroidSpecificProperty(n);
                        this.mUsesDefactProperty = VCardConfig.usesDefactProperty(n);
                        this.mRefrainsQPToNameProperties = VCardConfig.shouldRefrainQPToNameProperties(n);
                        this.mAppendTypeParamName = VCardConfig.appendTypeParamName(n);
                        this.mNeedsToConvertPhoneticString = VCardConfig.needsToConvertPhoneticString(n);
                        boolean bl2 = !VCardConfig.isVersion30(n) || !"UTF-8".equalsIgnoreCase(string2);
                        this.mShouldAppendCharsetParam = bl2;
                        if (!VCardConfig.isDoCoMo(n)) break block15;
                        if (SHIFT_JIS.equalsIgnoreCase(string2)) break block16;
                        Log.w(LOG_TAG, "The charset \"" + string2 + "\" is used while " + SHIFT_JIS + " is needed to be used.");
                        if (TextUtils.isEmpty(string2)) {
                            this.mCharset = SHIFT_JIS;
                            break block17;
                        } else {
                            try {
                                String string4;
                                string2 = string4 = CharsetUtils.charsetForVendor(string2).name();
                            }
                            catch (UnsupportedCharsetException unsupportedCharsetException) {
                                Log.i(LOG_TAG, "Career-specific \"" + string2 + "\" was not found (as usual). " + "Use it as is.");
                            }
                            this.mCharset = string2;
                        }
                        break block17;
                    }
                    if (this.mIsDoCoMo) {
                        try {
                            String string5;
                            string3 = string5 = CharsetUtils.charsetForVendor(SHIFT_JIS, "docomo").name();
                        }
                        catch (UnsupportedCharsetException unsupportedCharsetException) {
                            Log.e(LOG_TAG, "DoCoMo-specific SHIFT_JIS was not found. Use SHIFT_JIS as is.");
                            string3 = SHIFT_JIS;
                        }
                    } else {
                        try {
                            String string6;
                            string3 = string6 = CharsetUtils.charsetForVendor(SHIFT_JIS).name();
                        }
                        catch (UnsupportedCharsetException unsupportedCharsetException) {
                            Log.e(LOG_TAG, "Career-specific SHIFT_JIS was not found. Use SHIFT_JIS as is.");
                            string3 = SHIFT_JIS;
                        }
                    }
                    this.mCharset = string3;
                }
                this.mVCardCharsetParameter = "CHARSET=SHIFT_JIS";
                break block18;
            }
            if (TextUtils.isEmpty(string2)) {
                Log.i(LOG_TAG, "Use the charset \"UTF-8\" for export.");
                this.mCharset = "UTF-8";
                this.mVCardCharsetParameter = "CHARSET=UTF-8";
            } else {
                try {
                    String string7;
                    string2 = string7 = CharsetUtils.charsetForVendor(string2).name();
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    Log.i(LOG_TAG, "Career-specific \"" + string2 + "\" was not found (as usual). " + "Use it as is.");
                }
                this.mCharset = string2;
                this.mVCardCharsetParameter = "CHARSET=" + string2;
            }
        }
        this.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    private VCardBuilder appendNamePropertiesV40(List<ContentValues> list) {
        if (this.mIsDoCoMo || this.mNeedsToConvertPhoneticString) {
            Log.w(LOG_TAG, "Invalid flag is used in vCard 4.0 construction. Ignored.");
        }
        if (list == null || list.isEmpty()) {
            this.appendLine("FN", "");
            return this;
        }
        ContentValues contentValues = this.getPrimaryContentValue(list);
        String string2 = contentValues.getAsString("data3");
        String string3 = contentValues.getAsString("data5");
        String string4 = contentValues.getAsString("data2");
        String string5 = contentValues.getAsString("data4");
        String string6 = contentValues.getAsString("data6");
        String string7 = contentValues.getAsString("data1");
        if (TextUtils.isEmpty(string2) && TextUtils.isEmpty(string4) && TextUtils.isEmpty(string3) && TextUtils.isEmpty(string5) && TextUtils.isEmpty(string6)) {
            if (TextUtils.isEmpty(string7)) {
                this.appendLine("FN", "");
                return this;
            }
            string2 = string7;
        }
        String string8 = contentValues.getAsString("data9");
        String string9 = contentValues.getAsString("data8");
        String string10 = contentValues.getAsString("data7");
        String string11 = this.escapeCharacters(string2);
        String string12 = this.escapeCharacters(string4);
        String string13 = this.escapeCharacters(string3);
        String string14 = this.escapeCharacters(string5);
        String string15 = this.escapeCharacters(string6);
        this.mBuilder.append("N");
        if (!(TextUtils.isEmpty(string8) && TextUtils.isEmpty(string9) && TextUtils.isEmpty(string10))) {
            this.mBuilder.append(";");
            String string16 = this.escapeCharacters(string8) + ';' + this.escapeCharacters(string10) + ';' + this.escapeCharacters(string9);
            this.mBuilder.append("SORT-AS=").append(VCardUtils.toStringAsV40ParamValue(string16));
        }
        this.mBuilder.append(VCARD_DATA_SEPARATOR);
        this.mBuilder.append(string11);
        this.mBuilder.append(";");
        this.mBuilder.append(string12);
        this.mBuilder.append(";");
        this.mBuilder.append(string13);
        this.mBuilder.append(";");
        this.mBuilder.append(string14);
        this.mBuilder.append(";");
        this.mBuilder.append(string15);
        this.mBuilder.append(VCARD_END_OF_LINE);
        if (TextUtils.isEmpty(string7)) {
            Log.w(LOG_TAG, "DISPLAY_NAME is empty.");
            this.appendLine("FN", this.escapeCharacters(VCardUtils.constructNameFromElements(VCardConfig.getNameOrderType(this.mVCardType), string2, string3, string4, string5, string6)));
        } else {
            String string17 = this.escapeCharacters(string7);
            this.mBuilder.append("FN");
            this.mBuilder.append(VCARD_DATA_SEPARATOR);
            this.mBuilder.append(string17);
            this.mBuilder.append(VCARD_END_OF_LINE);
        }
        this.appendPhoneticNameFields(contentValues);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void appendPhoneticNameFields(ContentValues contentValues) {
        String string2;
        String string3;
        String string4;
        String string5 = contentValues.getAsString("data9");
        String string6 = contentValues.getAsString("data8");
        String string7 = contentValues.getAsString("data7");
        if (this.mNeedsToConvertPhoneticString) {
            string4 = VCardUtils.toHalfWidthString(string5);
            string3 = VCardUtils.toHalfWidthString(string6);
            string2 = VCardUtils.toHalfWidthString(string7);
        } else {
            string4 = string5;
            string3 = string6;
            string2 = string7;
        }
        if (TextUtils.isEmpty(string4) && TextUtils.isEmpty(string3) && TextUtils.isEmpty(string2)) {
            if (!this.mIsDoCoMo) return;
            this.mBuilder.append("SOUND");
            this.mBuilder.append(";");
            this.mBuilder.append("X-IRMC-N");
            this.mBuilder.append(VCARD_DATA_SEPARATOR);
            this.mBuilder.append(";");
            this.mBuilder.append(";");
            this.mBuilder.append(";");
            this.mBuilder.append(";");
            this.mBuilder.append(VCARD_END_OF_LINE);
            return;
        }
        if (!VCardConfig.isVersion40(this.mVCardType)) {
            if (VCardConfig.isVersion30(this.mVCardType)) {
                String string8 = VCardUtils.constructNameFromElements(this.mVCardType, string4, string3, string2);
                this.mBuilder.append("SORT-STRING");
                if (VCardConfig.isVersion30(this.mVCardType) && this.shouldAppendCharsetParam(string8)) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(this.mVCardCharsetParameter);
                }
                this.mBuilder.append(VCARD_DATA_SEPARATOR);
                this.mBuilder.append(this.escapeCharacters(string8));
                this.mBuilder.append(VCARD_END_OF_LINE);
            } else if (this.mIsJapaneseMobilePhone) {
                String string9;
                String string10;
                String string11;
                this.mBuilder.append("SOUND");
                this.mBuilder.append(";");
                this.mBuilder.append("X-IRMC-N");
                boolean bl = !this.mRefrainsQPToNameProperties && (!VCardUtils.containsOnlyNonCrLfPrintableAscii(string4) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(string3) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(string2));
                if (bl) {
                    string11 = this.encodeQuotedPrintable(string4);
                    string10 = this.encodeQuotedPrintable(string3);
                    string9 = this.encodeQuotedPrintable(string2);
                } else {
                    string11 = this.escapeCharacters(string4);
                    string10 = this.escapeCharacters(string3);
                    string9 = this.escapeCharacters(string2);
                }
                if (this.shouldAppendCharsetParam(string11, string10, string9)) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(this.mVCardCharsetParameter);
                }
                this.mBuilder.append(VCARD_DATA_SEPARATOR);
                boolean bl2 = true;
                if (!TextUtils.isEmpty(string11)) {
                    this.mBuilder.append(string11);
                    bl2 = false;
                }
                if (!TextUtils.isEmpty(string10)) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        this.mBuilder.append(' ');
                    }
                    this.mBuilder.append(string10);
                }
                if (!TextUtils.isEmpty(string9)) {
                    if (!bl2) {
                        this.mBuilder.append(' ');
                    }
                    this.mBuilder.append(string9);
                }
                this.mBuilder.append(";");
                this.mBuilder.append(";");
                this.mBuilder.append(";");
                this.mBuilder.append(";");
                this.mBuilder.append(VCARD_END_OF_LINE);
            }
        }
        Log.d("@@@", "hoge");
        if (!this.mUsesDefactProperty) return;
        if (!TextUtils.isEmpty(string2)) {
            boolean bl = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(string2);
            String string12 = bl ? this.encodeQuotedPrintable(string2) : this.escapeCharacters(string2);
            this.mBuilder.append("X-PHONETIC-FIRST-NAME");
            if (this.shouldAppendCharsetParam(string2)) {
                this.mBuilder.append(";");
                this.mBuilder.append(this.mVCardCharsetParameter);
            }
            if (bl) {
                this.mBuilder.append(";");
                this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
            }
            this.mBuilder.append(VCARD_DATA_SEPARATOR);
            this.mBuilder.append(string12);
            this.mBuilder.append(VCARD_END_OF_LINE);
        }
        if (!TextUtils.isEmpty(string3)) {
            boolean bl = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(string3);
            String string13 = bl ? this.encodeQuotedPrintable(string3) : this.escapeCharacters(string3);
            this.mBuilder.append("X-PHONETIC-MIDDLE-NAME");
            if (this.shouldAppendCharsetParam(string3)) {
                this.mBuilder.append(";");
                this.mBuilder.append(this.mVCardCharsetParameter);
            }
            if (bl) {
                this.mBuilder.append(";");
                this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
            }
            this.mBuilder.append(VCARD_DATA_SEPARATOR);
            this.mBuilder.append(string13);
            this.mBuilder.append(VCARD_END_OF_LINE);
        }
        if (TextUtils.isEmpty(string4)) return;
        boolean bl = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(string4);
        String string14 = bl ? this.encodeQuotedPrintable(string4) : this.escapeCharacters(string4);
        this.mBuilder.append("X-PHONETIC-LAST-NAME");
        if (this.shouldAppendCharsetParam(string4)) {
            this.mBuilder.append(";");
            this.mBuilder.append(this.mVCardCharsetParameter);
        }
        if (bl) {
            this.mBuilder.append(";");
            this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
        }
        this.mBuilder.append(VCARD_DATA_SEPARATOR);
        this.mBuilder.append(string14);
        this.mBuilder.append(VCARD_END_OF_LINE);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void appendPostalsForDoCoMo(List<ContentValues> list) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        ContentValues contentValues = null;
        for (ContentValues contentValues2 : list) {
            Integer n3;
            Integer n4;
            int n5;
            if (contentValues2 == null || (n5 = (n4 = sPostalTypePriorityMap.get(n3 = contentValues2.getAsInteger("data2"))) != null ? n4 : Integer.MAX_VALUE) >= n) continue;
            n = n5;
            n2 = n3;
            contentValues = contentValues2;
            if (n5 != 0) continue;
        }
        if (contentValues == null) {
            Log.w(LOG_TAG, "Should not come here. Must have at least one postal data.");
            return;
        }
        this.appendPostalLine(n2, contentValues.getAsString("data3"), contentValues, false, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void appendPostalsForGeneric(List<ContentValues> list) {
        Iterator<ContentValues> iterator = list.iterator();
        while (iterator.hasNext()) {
            ContentValues contentValues = iterator.next();
            if (contentValues == null) continue;
            Integer n = contentValues.getAsInteger("data2");
            int n2 = n != null ? n : 1;
            String string2 = contentValues.getAsString("data3");
            Integer n3 = contentValues.getAsInteger("is_primary");
            boolean bl = n3 != null ? n3 > 0 : false;
            this.appendPostalLine(n2, string2, contentValues, bl, false);
        }
        return;
    }

    private void appendTypeParameter(String string2) {
        this.appendTypeParameter(this.mBuilder, string2);
    }

    private void appendTypeParameter(StringBuilder stringBuilder, String string2) {
        if (VCardConfig.isVersion40(this.mVCardType) || (VCardConfig.isVersion30(this.mVCardType) || this.mAppendTypeParamName) && !this.mIsDoCoMo) {
            stringBuilder.append("TYPE").append(VCARD_PARAM_EQUAL);
        }
        stringBuilder.append(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void appendTypeParameters(List<String> list) {
        boolean bl = true;
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (VCardConfig.isVersion30(this.mVCardType)) {
                String string3 = VCardUtils.toStringAsV30ParamValue(string2);
                if (TextUtils.isEmpty(string3)) continue;
                if (bl) {
                    bl = false;
                } else {
                    this.mBuilder.append(";");
                }
                this.appendTypeParameter(string3);
                continue;
            }
            if (!VCardUtils.isV21Word(string2)) continue;
            if (bl) {
                bl = false;
            } else {
                this.mBuilder.append(";");
            }
            this.appendTypeParameter(string2);
        }
        return;
    }

    private void appendUncommonPhoneType(StringBuilder stringBuilder, Integer n) {
        if (this.mIsDoCoMo) {
            stringBuilder.append("VOICE");
            return;
        }
        String string2 = VCardUtils.getPhoneTypeString(n);
        if (string2 != null) {
            this.appendTypeParameter(string2);
            return;
        }
        Log.e(LOG_TAG, "Unknown or unsupported (by vCard) Phone type: " + n);
    }

    private boolean containsNonEmptyName(ContentValues contentValues) {
        String string2 = contentValues.getAsString("data3");
        String string3 = contentValues.getAsString("data5");
        String string4 = contentValues.getAsString("data2");
        String string5 = contentValues.getAsString("data4");
        String string6 = contentValues.getAsString("data6");
        String string7 = contentValues.getAsString("data9");
        String string8 = contentValues.getAsString("data8");
        String string9 = contentValues.getAsString("data7");
        String string10 = contentValues.getAsString("data1");
        return !TextUtils.isEmpty(string2) || !TextUtils.isEmpty(string3) || !TextUtils.isEmpty(string4) || !TextUtils.isEmpty(string5) || !TextUtils.isEmpty(string6) || !TextUtils.isEmpty(string7) || !TextUtils.isEmpty(string8) || !TextUtils.isEmpty(string9) || !TextUtils.isEmpty(string10);
    }

    private String encodeQuotedPrintable(String string2) {
        byte[] byArray;
        if (TextUtils.isEmpty(string2)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        try {
            byte[] byArray2;
            byArray = byArray2 = string2.getBytes(this.mCharset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e(LOG_TAG, "Charset " + this.mCharset + " cannot be used. " + "Try default charset");
            byArray = string2.getBytes();
            n = 0;
            n2 = 0;
        }
        while (n < byArray.length) {
            Object[] objectArray = new Object[]{byArray[n]};
            stringBuilder.append(String.format("=%02X", objectArray));
            ++n;
            if ((n2 += 3) < 67) continue;
            stringBuilder.append("=\r\n");
            n2 = 0;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String escapeCharacters(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            switch (c) {
                default: {
                    stringBuilder.append(c);
                    break;
                }
                case ';': {
                    stringBuilder.append('\\');
                    stringBuilder.append(';');
                    break;
                }
                case '\r': {
                    if (n2 + 1 < n && string2.charAt(n2) == '\n') break;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    break;
                }
                case '\\': {
                    if (this.mIsV30OrV40) {
                        stringBuilder.append("\\\\");
                        break;
                    }
                }
                case '<': 
                case '>': {
                    if (this.mIsDoCoMo) {
                        stringBuilder.append('\\');
                        stringBuilder.append(c);
                        break;
                    }
                    stringBuilder.append(c);
                    break;
                }
                case ',': {
                    if (this.mIsV30OrV40) {
                        stringBuilder.append("\\,");
                        break;
                    }
                    stringBuilder.append(c);
                }
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private ContentValues getPrimaryContentValue(List<ContentValues> list) {
        ContentValues contentValues = null;
        ContentValues contentValues2 = null;
        Iterator<ContentValues> iterator = list.iterator();
        while (true) {
            ContentValues contentValues3;
            block7: {
                block6: {
                    if (!iterator.hasNext()) break block6;
                    contentValues3 = iterator.next();
                    if (contentValues3 == null) continue;
                    Integer n = contentValues3.getAsInteger("is_super_primary");
                    if (n == null || n <= 0) break block7;
                    contentValues = contentValues3;
                }
                if (contentValues == null) {
                    if (contentValues2 == null) break;
                    contentValues = contentValues2;
                }
                return contentValues;
            }
            if (contentValues != null) continue;
            Integer n = contentValues3.getAsInteger("is_primary");
            if (n != null && n > 0 && this.containsNonEmptyName(contentValues3)) {
                contentValues = contentValues3;
                continue;
            }
            if (contentValues2 != null || !this.containsNonEmptyName(contentValues3)) continue;
            contentValues2 = contentValues3;
        }
        Log.e(LOG_TAG, "All ContentValues given from database is empty.");
        return new ContentValues();
    }

    private boolean shouldAppendCharsetParam(String ... stringArray) {
        if (!this.mShouldAppendCharsetParam) {
            return false;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (VCardUtils.containsOnlyPrintableAscii(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<String> splitAndTrimPhoneNumbers(String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (Character.isDigit(c) || c == '+') {
                stringBuilder.append(c);
                continue;
            }
            if (c != ';' && c != '\n' || stringBuilder.length() <= 0) continue;
            arrayList.add(stringBuilder.toString());
            stringBuilder = new StringBuilder();
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private PostalStruct tryConstructPostalStruct(ContentValues contentValues) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8 = contentValues.getAsString("data5");
        String[] stringArray = new String[]{string8, string7 = contentValues.getAsString("data6"), string6 = contentValues.getAsString("data4"), string5 = contentValues.getAsString("data7"), string4 = contentValues.getAsString("data8"), string3 = contentValues.getAsString("data9"), string2 = contentValues.getAsString("data10")};
        if (!VCardUtils.areAllEmpty(stringArray)) {
            String string9;
            String string10;
            String string11;
            String string12;
            String string13;
            String string14;
            boolean bl = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(stringArray);
            boolean bl2 = !VCardUtils.containsOnlyPrintableAscii(stringArray);
            String string15 = TextUtils.isEmpty(string5) ? (TextUtils.isEmpty(string7) ? "" : string7) : (TextUtils.isEmpty(string7) ? string5 : string5 + VCARD_WS + string7);
            if (bl) {
                string14 = this.encodeQuotedPrintable(string8);
                string13 = this.encodeQuotedPrintable(string6);
                string12 = this.encodeQuotedPrintable(string15);
                string11 = this.encodeQuotedPrintable(string4);
                string10 = this.encodeQuotedPrintable(string3);
                string9 = this.encodeQuotedPrintable(string2);
            } else {
                string14 = this.escapeCharacters(string8);
                string13 = this.escapeCharacters(string6);
                string12 = this.escapeCharacters(string15);
                string11 = this.escapeCharacters(string4);
                string10 = this.escapeCharacters(string3);
                string9 = this.escapeCharacters(string2);
                this.escapeCharacters(string7);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string14);
            stringBuilder.append(";");
            stringBuilder.append(";");
            stringBuilder.append(string13);
            stringBuilder.append(";");
            stringBuilder.append(string12);
            stringBuilder.append(";");
            stringBuilder.append(string11);
            stringBuilder.append(";");
            stringBuilder.append(string10);
            stringBuilder.append(";");
            stringBuilder.append(string9);
            String string16 = stringBuilder.toString();
            return new PostalStruct(bl, bl2, string16);
        }
        String string17 = contentValues.getAsString("data1");
        if (TextUtils.isEmpty(string17)) {
            return null;
        }
        boolean bl = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(string17);
        boolean bl3 = !VCardUtils.containsOnlyPrintableAscii(string17);
        String string18 = bl ? this.encodeQuotedPrintable(string17) : this.escapeCharacters(string17);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(";");
        stringBuilder.append(string18);
        stringBuilder.append(";");
        stringBuilder.append(";");
        stringBuilder.append(";");
        stringBuilder.append(";");
        stringBuilder.append(";");
        String string19 = stringBuilder.toString();
        return new PostalStruct(bl, bl3, string19);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendAndroidSpecificProperty(String string2, ContentValues contentValues) {
        if (!sAllowedAndroidPropertySet.contains(string2)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i <= 15; ++i) {
            String string3 = contentValues.getAsString("data" + i);
            if (string3 == null) {
                string3 = "";
            }
            arrayList.add(string3);
        }
        boolean bl = this.mShouldAppendCharsetParam && !VCardUtils.containsOnlyNonCrLfPrintableAscii(arrayList);
        boolean bl2 = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(arrayList);
        this.mBuilder.append("X-ANDROID-CUSTOM");
        if (bl) {
            this.mBuilder.append(";");
            this.mBuilder.append(this.mVCardCharsetParameter);
        }
        if (bl2) {
            this.mBuilder.append(";");
            this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
        }
        this.mBuilder.append(VCARD_DATA_SEPARATOR);
        this.mBuilder.append(string2);
        Iterator iterator = arrayList.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.mBuilder.append(VCARD_END_OF_LINE);
                return;
            }
            String string4 = (String)iterator.next();
            String string5 = bl2 ? this.encodeQuotedPrintable(string4) : this.escapeCharacters(string4);
            this.mBuilder.append(";");
            this.mBuilder.append(string5);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendEmailLine(int n, String string2, String string3, boolean bl) {
        String string4;
        switch (n) {
            default: {
                Log.e(LOG_TAG, "Unknown Email type: " + n);
                string4 = null;
                break;
            }
            case 0: {
                if (VCardUtils.isMobilePhoneLabel(string2)) {
                    string4 = "CELL";
                    break;
                }
                if (!TextUtils.isEmpty(string2) && VCardUtils.containsOnlyAlphaDigitHyphen(string2)) {
                    string4 = "X-" + string2;
                    break;
                }
                string4 = null;
                break;
            }
            case 1: {
                string4 = "HOME";
                break;
            }
            case 2: {
                string4 = "WORK";
                break;
            }
            case 3: {
                string4 = null;
                break;
            }
            case 4: {
                string4 = "CELL";
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add("PREF");
        }
        if (!TextUtils.isEmpty(string4)) {
            arrayList.add(string4);
        }
        this.appendLineWithCharsetAndQPDetection("EMAIL", arrayList, string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardBuilder appendEmails(List<ContentValues> list) {
        boolean bl = false;
        if (list != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (ContentValues contentValues : list) {
                String string2 = contentValues.getAsString("data1");
                if (string2 != null) {
                    string2 = string2.trim();
                }
                if (TextUtils.isEmpty(string2)) continue;
                Integer n = contentValues.getAsInteger("data2");
                int n2 = n != null ? n : 3;
                String string3 = contentValues.getAsString("data3");
                Integer n3 = contentValues.getAsInteger("is_primary");
                boolean bl2 = n3 != null ? n3 > 0 : false;
                bl = true;
                if (hashSet.contains(string2)) continue;
                hashSet.add(string2);
                this.appendEmailLine(n2, string3, string2, bl2);
            }
        }
        if (!bl && this.mIsDoCoMo) {
            this.appendEmailLine(1, "", "", false);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardBuilder appendEvents(List<ContentValues> list) {
        if (list == null) return this;
        String string2 = null;
        String string3 = null;
        for (ContentValues contentValues : list) {
            if (contentValues == null) continue;
            Integer n = contentValues.getAsInteger("data2");
            int n2 = n != null ? n : 2;
            if (n2 == 3) {
                String string4 = contentValues.getAsString("data1");
                if (string4 == null) continue;
                Integer n3 = contentValues.getAsInteger("is_super_primary");
                boolean bl = n3 != null ? n3 > 0 : false;
                if (bl) {
                    string2 = string4;
                    break;
                }
                Integer n4 = contentValues.getAsInteger("is_primary");
                boolean bl2 = n4 != null ? n4 > 0 : false;
                if (bl2) {
                    string2 = string4;
                    continue;
                }
                if (string3 != null) continue;
                string3 = string4;
                continue;
            }
            if (!this.mUsesAndroidProperty) continue;
            this.appendAndroidSpecificProperty("vnd.android.cursor.item/contact_event", contentValues);
        }
        if (string2 != null) {
            this.appendLineWithCharsetAndQPDetection("BDAY", string2.trim());
            return this;
        } else {
            if (string3 == null) return this;
            this.appendLineWithCharsetAndQPDetection("BDAY", string3.trim());
            return this;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardBuilder appendIms(List<ContentValues> list) {
        if (list != null) {
            for (ContentValues contentValues : list) {
                Integer n;
                String string2;
                String string3;
                Integer n2 = contentValues.getAsInteger("data5");
                if (n2 == null || (string3 = VCardUtils.getPropertyNameForIm(n2)) == null) continue;
                String string4 = contentValues.getAsString("data1");
                if (string4 != null) {
                    string4 = string4.trim();
                }
                if (TextUtils.isEmpty(string4)) continue;
                Integer n3 = contentValues.getAsInteger("data2");
                int n4 = n3 != null ? n3 : 3;
                switch (n4) {
                    default: {
                        string2 = null;
                        break;
                    }
                    case 1: {
                        string2 = "HOME";
                        break;
                    }
                    case 2: {
                        string2 = "WORK";
                        break;
                    }
                    case 0: {
                        String string5 = contentValues.getAsString("data3");
                        string2 = string5 != null ? "X-" + string5 : null;
                    }
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                if (!TextUtils.isEmpty(string2)) {
                    arrayList.add(string2);
                }
                boolean bl = (n = contentValues.getAsInteger("is_primary")) != null ? n > 0 : false;
                if (bl) {
                    arrayList.add("PREF");
                }
                this.appendLineWithCharsetAndQPDetection(string3, arrayList, string4);
            }
        }
        return this;
    }

    public void appendLine(String string2, String string3) {
        this.appendLine(string2, string3, false, false);
    }

    public void appendLine(String string2, String string3, boolean bl, boolean bl2) {
        this.appendLine(string2, null, string3, bl, bl2);
    }

    public void appendLine(String string2, List<String> list) {
        this.appendLine(string2, list, false, false);
    }

    public void appendLine(String string2, List<String> list, String string3) {
        this.appendLine(string2, list, string3, false, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendLine(String string2, List<String> list, String string3, boolean bl, boolean bl2) {
        String string4;
        this.mBuilder.append(string2);
        if (list != null && list.size() > 0) {
            this.mBuilder.append(";");
            this.appendTypeParameters(list);
        }
        if (bl) {
            this.mBuilder.append(";");
            this.mBuilder.append(this.mVCardCharsetParameter);
        }
        if (bl2) {
            this.mBuilder.append(";");
            this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
            string4 = this.encodeQuotedPrintable(string3);
        } else {
            string4 = this.escapeCharacters(string3);
        }
        this.mBuilder.append(VCARD_DATA_SEPARATOR);
        this.mBuilder.append(string4);
        this.mBuilder.append(VCARD_END_OF_LINE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendLine(String string2, List<String> list, List<String> list2, boolean bl, boolean bl2) {
        this.mBuilder.append(string2);
        if (list != null && list.size() > 0) {
            this.mBuilder.append(";");
            this.appendTypeParameters(list);
        }
        if (bl) {
            this.mBuilder.append(";");
            this.mBuilder.append(this.mVCardCharsetParameter);
        }
        if (bl2) {
            this.mBuilder.append(";");
            this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
        }
        this.mBuilder.append(VCARD_DATA_SEPARATOR);
        boolean bl3 = true;
        Iterator<String> iterator = list2.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.mBuilder.append(VCARD_END_OF_LINE);
                return;
            }
            String string3 = iterator.next();
            String string4 = bl2 ? this.encodeQuotedPrintable(string3) : this.escapeCharacters(string3);
            if (bl3) {
                bl3 = false;
            } else {
                this.mBuilder.append(";");
            }
            this.mBuilder.append(string4);
        }
    }

    public void appendLine(String string2, List<String> list, boolean bl, boolean bl2) {
        this.appendLine(string2, null, list, bl, bl2);
    }

    public void appendLineWithCharsetAndQPDetection(String string2, String string3) {
        this.appendLineWithCharsetAndQPDetection(string2, null, string3);
    }

    public void appendLineWithCharsetAndQPDetection(String string2, List<String> list) {
        this.appendLineWithCharsetAndQPDetection(string2, null, list);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendLineWithCharsetAndQPDetection(String string2, List<String> list, String string3) {
        boolean bl = !VCardUtils.containsOnlyPrintableAscii(string3);
        boolean bl2 = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(string3);
        this.appendLine(string2, list, string3, bl, bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendLineWithCharsetAndQPDetection(String string2, List<String> list, List<String> list2) {
        boolean bl = this.mShouldAppendCharsetParam && !VCardUtils.containsOnlyNonCrLfPrintableAscii(list2);
        boolean bl2 = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(list2);
        this.appendLine(string2, list, list2, bl, bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardBuilder appendNameProperties(List<ContentValues> list) {
        if (VCardConfig.isVersion40(this.mVCardType)) {
            return this.appendNamePropertiesV40(list);
        }
        if (list == null || list.isEmpty()) {
            if (VCardConfig.isVersion30(this.mVCardType)) {
                this.appendLine("N", "");
                this.appendLine("FN", "");
                return this;
            }
            if (!this.mIsDoCoMo) return this;
            this.appendLine("N", "");
            return this;
        }
        ContentValues contentValues = this.getPrimaryContentValue(list);
        String string2 = contentValues.getAsString("data3");
        String string3 = contentValues.getAsString("data5");
        String string4 = contentValues.getAsString("data2");
        String string5 = contentValues.getAsString("data4");
        String string6 = contentValues.getAsString("data6");
        String string7 = contentValues.getAsString("data1");
        if (!TextUtils.isEmpty(string2) || !TextUtils.isEmpty(string4)) {
            String string8;
            String string9;
            String string10;
            String string11;
            String string12;
            boolean bl = this.shouldAppendCharsetParam(string2, string4, string3, string5, string6);
            boolean bl2 = !this.mRefrainsQPToNameProperties && (!VCardUtils.containsOnlyNonCrLfPrintableAscii(string2) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(string4) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(string3) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(string5) || !VCardUtils.containsOnlyNonCrLfPrintableAscii(string6));
            String string13 = !TextUtils.isEmpty(string7) ? string7 : VCardUtils.constructNameFromElements(VCardConfig.getNameOrderType(this.mVCardType), string2, string3, string4, string5, string6);
            boolean bl3 = this.shouldAppendCharsetParam(string13);
            boolean bl4 = !this.mRefrainsQPToNameProperties && !VCardUtils.containsOnlyNonCrLfPrintableAscii(string13);
            if (bl2) {
                string12 = this.encodeQuotedPrintable(string2);
                string11 = this.encodeQuotedPrintable(string4);
                string10 = this.encodeQuotedPrintable(string3);
                string9 = this.encodeQuotedPrintable(string5);
                string8 = this.encodeQuotedPrintable(string6);
            } else {
                string12 = this.escapeCharacters(string2);
                string11 = this.escapeCharacters(string4);
                string10 = this.escapeCharacters(string3);
                string9 = this.escapeCharacters(string5);
                string8 = this.escapeCharacters(string6);
            }
            String string14 = bl4 ? this.encodeQuotedPrintable(string13) : this.escapeCharacters(string13);
            this.mBuilder.append("N");
            if (this.mIsDoCoMo) {
                if (bl) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(this.mVCardCharsetParameter);
                }
                if (bl2) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
                }
                this.mBuilder.append(VCARD_DATA_SEPARATOR);
                this.mBuilder.append(string13);
                this.mBuilder.append(";");
                this.mBuilder.append(";");
                this.mBuilder.append(";");
                this.mBuilder.append(";");
            } else {
                if (bl) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(this.mVCardCharsetParameter);
                }
                if (bl2) {
                    this.mBuilder.append(";");
                    this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
                }
                this.mBuilder.append(VCARD_DATA_SEPARATOR);
                this.mBuilder.append(string12);
                this.mBuilder.append(";");
                this.mBuilder.append(string11);
                this.mBuilder.append(";");
                this.mBuilder.append(string10);
                this.mBuilder.append(";");
                this.mBuilder.append(string9);
                this.mBuilder.append(";");
                this.mBuilder.append(string8);
            }
            this.mBuilder.append(VCARD_END_OF_LINE);
            this.mBuilder.append("FN");
            if (bl3) {
                this.mBuilder.append(";");
                this.mBuilder.append(this.mVCardCharsetParameter);
            }
            if (bl4) {
                this.mBuilder.append(";");
                this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
            }
            this.mBuilder.append(VCARD_DATA_SEPARATOR);
            this.mBuilder.append(string14);
            this.mBuilder.append(VCARD_END_OF_LINE);
        } else if (!TextUtils.isEmpty(string7)) {
            boolean bl = !this.mRefrainsQPToNameProperties && !VCardUtils.containsOnlyNonCrLfPrintableAscii(string7);
            String string15 = bl ? this.encodeQuotedPrintable(string7) : this.escapeCharacters(string7);
            this.mBuilder.append("N");
            if (this.shouldAppendCharsetParam(string7)) {
                this.mBuilder.append(";");
                this.mBuilder.append(this.mVCardCharsetParameter);
            }
            if (bl) {
                this.mBuilder.append(";");
                this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
            }
            this.mBuilder.append(VCARD_DATA_SEPARATOR);
            this.mBuilder.append(string15);
            this.mBuilder.append(";");
            this.mBuilder.append(";");
            this.mBuilder.append(";");
            this.mBuilder.append(";");
            this.mBuilder.append(VCARD_END_OF_LINE);
            this.mBuilder.append("FN");
            if (this.shouldAppendCharsetParam(string7)) {
                this.mBuilder.append(";");
                this.mBuilder.append(this.mVCardCharsetParameter);
            }
            this.mBuilder.append(VCARD_DATA_SEPARATOR);
            this.mBuilder.append(string15);
            this.mBuilder.append(VCARD_END_OF_LINE);
        } else if (VCardConfig.isVersion30(this.mVCardType)) {
            this.appendLine("N", "");
            this.appendLine("FN", "");
        } else if (this.mIsDoCoMo) {
            this.appendLine("N", "");
        }
        this.appendPhoneticNameFields(contentValues);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardBuilder appendNickNames(List<ContentValues> list) {
        block8: {
            boolean bl;
            block7: {
                block6: {
                    if (!this.mIsV30OrV40) break block6;
                    bl = false;
                    break block7;
                }
                if (!this.mUsesAndroidProperty) break block8;
                bl = true;
            }
            if (list != null) {
                for (ContentValues contentValues : list) {
                    String string2 = contentValues.getAsString("data1");
                    if (TextUtils.isEmpty(string2)) continue;
                    if (bl) {
                        this.appendAndroidSpecificProperty("vnd.android.cursor.item/nickname", contentValues);
                        continue;
                    }
                    this.appendLineWithCharsetAndQPDetection("NICKNAME", string2);
                }
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public VCardBuilder appendNotes(List<ContentValues> list) {
        if (list == null) return this;
        if (this.mOnlyOneNoteFieldIsAvailable) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            Iterator<ContentValues> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().getAsString("data1");
                if (string2 == null) {
                    string2 = "";
                }
                if (string2.length() <= 0) continue;
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string2);
            }
            String string3 = stringBuilder.toString();
            boolean bl2 = !VCardUtils.containsOnlyPrintableAscii(string3);
            boolean bl3 = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(string3);
            this.appendLine("NOTE", string3, bl2, bl3);
            return this;
        }
        Iterator<ContentValues> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string4 = iterator.next().getAsString("data1");
            if (TextUtils.isEmpty(string4)) continue;
            boolean bl = !VCardUtils.containsOnlyPrintableAscii(string4);
            boolean bl4 = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(string4);
            this.appendLine("NOTE", string4, bl, bl4);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardBuilder appendOrganizations(List<ContentValues> list) {
        if (list != null) {
            for (ContentValues contentValues : list) {
                String string2;
                String string3;
                String string4 = contentValues.getAsString("data1");
                if (string4 != null) {
                    string4 = string4.trim();
                }
                if ((string3 = contentValues.getAsString("data5")) != null) {
                    string3 = string3.trim();
                }
                if ((string2 = contentValues.getAsString("data4")) != null) {
                    string2 = string2.trim();
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (!TextUtils.isEmpty(string4)) {
                    stringBuilder.append(string4);
                }
                if (!TextUtils.isEmpty(string3)) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(';');
                    }
                    stringBuilder.append(string3);
                }
                String string5 = stringBuilder.toString();
                boolean bl = !VCardUtils.containsOnlyPrintableAscii(string5);
                boolean bl2 = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(string5);
                this.appendLine("ORG", string5, bl, bl2);
                if (TextUtils.isEmpty(string2)) continue;
                boolean bl3 = !VCardUtils.containsOnlyPrintableAscii(string2);
                boolean bl4 = this.mShouldUseQuotedPrintable && !VCardUtils.containsOnlyNonCrLfPrintableAscii(string2);
                this.appendLine("TITLE", string2, bl3, bl4);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardBuilder appendPhones(List<ContentValues> list) {
        boolean bl = false;
        if (list != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (ContentValues contentValues : list) {
                Integer n = contentValues.getAsInteger("data2");
                String string2 = contentValues.getAsString("data3");
                Integer n2 = contentValues.getAsInteger("is_primary");
                boolean bl2 = n2 != null ? n2 > 0 : false;
                String string3 = contentValues.getAsString("data1");
                if (string3 != null) {
                    string3 = string3.trim();
                }
                if (TextUtils.isEmpty(string3)) continue;
                int n3 = n != null ? n : 1;
                if (n3 == 6 || VCardConfig.refrainPhoneNumberFormatting(this.mVCardType)) {
                    bl = true;
                    if (hashSet.contains(string3)) continue;
                    hashSet.add(string3);
                    this.appendTelLine(n3, string2, string3, bl2);
                    continue;
                }
                List<String> list2 = this.splitAndTrimPhoneNumbers(string3);
                if (list2.isEmpty()) continue;
                bl = true;
                for (String string4 : list2) {
                    if (hashSet.contains(string4)) continue;
                    String string5 = PhoneNumberUtils.formatNumber((String)string4, (int)VCardUtils.getPhoneNumberFormat(this.mVCardType));
                    hashSet.add(string4);
                    this.appendTelLine(n3, string2, string5, bl2);
                }
            }
        }
        if (!bl && this.mIsDoCoMo) {
            this.appendTelLine(1, "", "", false);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendPhotoLine(String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PHOTO");
        stringBuilder.append(";");
        if (this.mIsV30OrV40) {
            stringBuilder.append(VCARD_PARAM_ENCODING_BASE64_AS_B);
        } else {
            stringBuilder.append(VCARD_PARAM_ENCODING_BASE64_V21);
        }
        stringBuilder.append(";");
        this.appendTypeParameter(stringBuilder, string3);
        stringBuilder.append(VCARD_DATA_SEPARATOR);
        stringBuilder.append(string2);
        String string4 = stringBuilder.toString();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n = 0;
        int n2 = string4.length();
        int n3 = 75 - VCARD_END_OF_LINE.length();
        int n4 = n3 - VCARD_WS.length();
        int n5 = n3;
        int n6 = 0;
        while (true) {
            if (n6 >= n2) {
                this.mBuilder.append(stringBuilder2.toString());
                this.mBuilder.append(VCARD_END_OF_LINE);
                this.mBuilder.append(VCARD_END_OF_LINE);
                return;
            }
            stringBuilder2.append(string4.charAt(n6));
            if (++n > n5) {
                stringBuilder2.append(VCARD_END_OF_LINE);
                stringBuilder2.append(VCARD_WS);
                n5 = n4;
                n = 0;
            }
            ++n6;
        }
    }

    public VCardBuilder appendPhotos(List<ContentValues> list) {
        if (list != null) {
            for (ContentValues contentValues : list) {
                byte[] byArray;
                if (contentValues == null || (byArray = contentValues.getAsByteArray("data15")) == null) continue;
                String string2 = VCardUtils.guessImageType(byArray);
                if (string2 == null) {
                    Log.d(LOG_TAG, "Unknown photo type. Ignored.");
                    continue;
                }
                String string3 = new String(Base64.encode(byArray, 2));
                if (TextUtils.isEmpty(string3)) continue;
                this.appendPhotoLine(string3, string2);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendPostalLine(int n, String string2, ContentValues contentValues, boolean bl, boolean bl2) {
        block11: {
            String string3;
            boolean bl3;
            boolean bl4;
            block12: {
                PostalStruct postalStruct;
                block10: {
                    postalStruct = this.tryConstructPostalStruct(contentValues);
                    if (postalStruct != null) break block10;
                    if (!bl2) break block11;
                    bl4 = false;
                    bl3 = false;
                    string3 = "";
                    break block12;
                }
                bl4 = postalStruct.reallyUseQuotedPrintable;
                bl3 = postalStruct.appendCharset;
                string3 = postalStruct.addressData;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bl) {
                arrayList.add("PREF");
            }
            switch (n) {
                default: {
                    Log.e(LOG_TAG, "Unknown StructuredPostal type: " + n);
                    break;
                }
                case 1: {
                    arrayList.add("HOME");
                    break;
                }
                case 2: {
                    arrayList.add("WORK");
                }
                case 3: {
                    break;
                }
                case 0: {
                    if (TextUtils.isEmpty(string2) || !VCardUtils.containsOnlyAlphaDigitHyphen(string2)) break;
                    arrayList.add("X-" + string2);
                }
            }
            this.mBuilder.append("ADR");
            if (!arrayList.isEmpty()) {
                this.mBuilder.append(";");
                this.appendTypeParameters(arrayList);
            }
            if (bl3) {
                this.mBuilder.append(";");
                this.mBuilder.append(this.mVCardCharsetParameter);
            }
            if (bl4) {
                this.mBuilder.append(";");
                this.mBuilder.append(VCARD_PARAM_ENCODING_QP);
            }
            this.mBuilder.append(VCARD_DATA_SEPARATOR);
            this.mBuilder.append(string3);
            this.mBuilder.append(VCARD_END_OF_LINE);
        }
    }

    public VCardBuilder appendPostals(List<ContentValues> list) {
        if (list == null || list.isEmpty()) {
            if (this.mIsDoCoMo) {
                this.mBuilder.append("ADR");
                this.mBuilder.append(";");
                this.mBuilder.append("HOME");
                this.mBuilder.append(VCARD_DATA_SEPARATOR);
                this.mBuilder.append(VCARD_END_OF_LINE);
            }
            return this;
        }
        if (this.mIsDoCoMo) {
            this.appendPostalsForDoCoMo(list);
            return this;
        }
        this.appendPostalsForGeneric(list);
        return this;
    }

    public VCardBuilder appendRelation(List<ContentValues> list) {
        if (this.mUsesAndroidProperty && list != null) {
            for (ContentValues contentValues : list) {
                if (contentValues == null) continue;
                this.appendAndroidSpecificProperty("vnd.android.cursor.item/relation", contentValues);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void appendTelLine(Integer n, String string2, String string3, boolean bl) {
        this.mBuilder.append("TEL");
        this.mBuilder.append(";");
        int n2 = n == null ? 7 : n;
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n2) {
            case 1: {
                arrayList.addAll(Arrays.asList("HOME"));
                break;
            }
            case 3: {
                arrayList.addAll(Arrays.asList("WORK"));
                break;
            }
            case 5: {
                arrayList.addAll(Arrays.asList("HOME", "FAX"));
                break;
            }
            case 4: {
                arrayList.addAll(Arrays.asList("WORK", "FAX"));
                break;
            }
            case 2: {
                arrayList.add("CELL");
                break;
            }
            case 6: {
                if (this.mIsDoCoMo) {
                    arrayList.add("VOICE");
                    break;
                }
                arrayList.add("PAGER");
                break;
            }
            case 7: {
                arrayList.add("VOICE");
                break;
            }
            case 9: {
                arrayList.add("CAR");
                break;
            }
            case 10: {
                arrayList.add("WORK");
                bl = true;
                break;
            }
            case 11: {
                arrayList.add("ISDN");
                break;
            }
            case 12: {
                bl = true;
                break;
            }
            case 13: {
                arrayList.add("FAX");
                break;
            }
            case 15: {
                arrayList.add("TLX");
                break;
            }
            case 17: {
                arrayList.addAll(Arrays.asList("WORK", "CELL"));
                break;
            }
            case 18: {
                arrayList.add("WORK");
                if (this.mIsDoCoMo) {
                    arrayList.add("VOICE");
                    break;
                }
                arrayList.add("PAGER");
                break;
            }
            case 20: {
                arrayList.add("MSG");
                break;
            }
            case 0: {
                if (TextUtils.isEmpty(string2)) {
                    arrayList.add("VOICE");
                    break;
                }
                if (VCardUtils.isMobilePhoneLabel(string2)) {
                    arrayList.add("CELL");
                    break;
                }
                if (this.mIsV30OrV40) {
                    arrayList.add(string2);
                    break;
                }
                String string4 = string2.toUpperCase();
                if (VCardUtils.isValidInV21ButUnknownToContactsPhoteType(string4)) {
                    arrayList.add(string4);
                    break;
                }
                if (!VCardUtils.containsOnlyAlphaDigitHyphen(string2)) break;
                arrayList.add("X-" + string2);
            }
        }
        if (bl) {
            arrayList.add("PREF");
        }
        if (arrayList.isEmpty()) {
            this.appendUncommonPhoneType(this.mBuilder, n2);
        } else {
            this.appendTypeParameters(arrayList);
        }
        this.mBuilder.append(VCARD_DATA_SEPARATOR);
        this.mBuilder.append(string3);
        this.mBuilder.append(VCARD_END_OF_LINE);
    }

    public VCardBuilder appendWebsites(List<ContentValues> list) {
        if (list != null) {
            Iterator<ContentValues> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().getAsString("data1");
                if (string2 != null) {
                    string2 = string2.trim();
                }
                if (TextUtils.isEmpty(string2)) continue;
                this.appendLineWithCharsetAndQPDetection("URL", string2);
            }
        }
        return this;
    }

    public void clear() {
        this.mBuilder = new StringBuilder();
        this.mEndAppended = false;
        this.appendLine("BEGIN", VCARD_DATA_VCARD);
        if (VCardConfig.isVersion40(this.mVCardType)) {
            this.appendLine("VERSION", "4.0");
            return;
        }
        if (VCardConfig.isVersion30(this.mVCardType)) {
            this.appendLine("VERSION", "3.0");
            return;
        }
        if (!VCardConfig.isVersion21(this.mVCardType)) {
            Log.w(LOG_TAG, "Unknown vCard version detected.");
        }
        this.appendLine("VERSION", "2.1");
    }

    public String toString() {
        if (!this.mEndAppended) {
            if (this.mIsDoCoMo) {
                this.appendLine("X-CLASS", VCARD_DATA_PUBLIC);
                this.appendLine("X-REDUCTION", "");
                this.appendLine("X-NO", "");
                this.appendLine("X-DCM-HMN-MODE", "");
            }
            this.appendLine("END", VCARD_DATA_VCARD);
            this.mEndAppended = true;
        }
        return this.mBuilder.toString();
    }

    private static class PostalStruct {
        final String addressData;
        final boolean appendCharset;
        final boolean reallyUseQuotedPrintable;

        public PostalStruct(boolean bl, boolean bl2, String string2) {
            this.reallyUseQuotedPrintable = bl;
            this.appendCharset = bl2;
            this.addressData = string2;
        }
    }
}

