/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.pim.vcard.VCardBuilder;
import android.pim.vcard.VCardConfig;
import android.pim.vcard.exception.VCardException;
import android.provider.ContactsContract;
import android.text.TextUtils;
import android.util.CharsetUtils;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VCardComposer {
    public static final Uri CONTACTS_TEST_CONTENT_URI;
    public static final String FAILURE_REASON_FAILED_TO_GET_DATABASE_INFO = "Failed to get database information";
    public static final String FAILURE_REASON_NOT_INITIALIZED = "The vCard composer object is not correctly initialized";
    public static final String FAILURE_REASON_NO_ENTRY = "There's no exportable in the database";
    public static final String FAILURE_REASON_UNSUPPORTED_URI = "The Uri vCard composer received is not supported by the composer.";
    private static final String LOG_TAG = "VCardComposer";
    public static final String NO_ERROR = "No error";
    private static final String SHIFT_JIS = "SHIFT_JIS";
    private static final String UTF_8 = "UTF-8";
    public static final String VCARD_TEST_AUTHORITY = "com.android.unit_tests.vcard";
    public static final Uri VCARD_TEST_AUTHORITY_URI;
    public static final String VCARD_TYPE_STRING_DOCOMO = "docomo";
    private static final String[] sContactsProjection;
    private static final Map<Integer, String> sImMap;
    private final boolean mCareHandlerErrors;
    private final String mCharset;
    private final ContentResolver mContentResolver;
    private final Context mContext;
    private Cursor mCursor;
    private String mErrorReason;
    private final List<OneEntryHandler> mHandlerList;
    private int mIdColumn;
    private final boolean mIsDoCoMo;
    private boolean mTerminateIsCalled;
    private final int mVCardType;

    static {
        VCARD_TEST_AUTHORITY_URI = Uri.parse("content://com.android.unit_tests.vcard");
        CONTACTS_TEST_CONTENT_URI = Uri.withAppendedPath(VCARD_TEST_AUTHORITY_URI, "contacts");
        sImMap = new HashMap<Integer, String>();
        sImMap.put(0, "X-AIM");
        sImMap.put(1, "X-MSN");
        sImMap.put(2, "X-YAHOO");
        sImMap.put(6, "X-ICQ");
        sImMap.put(7, "X-JABBER");
        sImMap.put(3, "X-SKYPE-USERNAME");
        sContactsProjection = new String[]{"_id"};
    }

    public VCardComposer(Context context) {
        this(context, VCardConfig.VCARD_TYPE_DEFAULT, null, true);
    }

    public VCardComposer(Context context, int n) {
        this(context, n, null, true);
    }

    public VCardComposer(Context context, int n, String string2) {
        this(context, n, string2, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VCardComposer(Context context, int n, String string2, boolean bl) {
        block17: {
            block15: {
                block16: {
                    String string3;
                    this.mErrorReason = NO_ERROR;
                    this.mContext = context;
                    this.mVCardType = n;
                    this.mCareHandlerErrors = bl;
                    this.mContentResolver = context.getContentResolver();
                    this.mIsDoCoMo = VCardConfig.isDoCoMo(n);
                    this.mHandlerList = new ArrayList<OneEntryHandler>();
                    if (TextUtils.isEmpty(string2)) {
                        string2 = UTF_8;
                    }
                    boolean bl2 = !VCardConfig.isVersion30(n) || !UTF_8.equalsIgnoreCase(string2);
                    if (!this.mIsDoCoMo && !bl2) break block15;
                    if (!SHIFT_JIS.equalsIgnoreCase(string2)) break block16;
                    if (this.mIsDoCoMo) {
                        try {
                            String string4;
                            string3 = string4 = CharsetUtils.charsetForVendor(SHIFT_JIS, VCARD_TYPE_STRING_DOCOMO).name();
                        }
                        catch (UnsupportedCharsetException unsupportedCharsetException) {
                            Log.e(LOG_TAG, "DoCoMo-specific SHIFT_JIS was not found. Use SHIFT_JIS as is.");
                            string3 = SHIFT_JIS;
                        }
                    } else {
                        try {
                            String string5;
                            string3 = string5 = CharsetUtils.charsetForVendor(SHIFT_JIS).name();
                        }
                        catch (UnsupportedCharsetException unsupportedCharsetException) {
                            Log.e(LOG_TAG, "Career-specific SHIFT_JIS was not found. Use SHIFT_JIS as is.");
                            string3 = SHIFT_JIS;
                        }
                    }
                    this.mCharset = string3;
                    break block17;
                }
                Log.w(LOG_TAG, "The charset \"" + string2 + "\" is used while " + SHIFT_JIS + " is needed to be used.");
                if (TextUtils.isEmpty(string2)) {
                    this.mCharset = SHIFT_JIS;
                    break block17;
                } else {
                    try {
                        String string6;
                        string2 = string6 = CharsetUtils.charsetForVendor(string2).name();
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {
                        Log.i(LOG_TAG, "Career-specific \"" + string2 + "\" was not found (as usual). " + "Use it as is.");
                    }
                    this.mCharset = string2;
                }
                break block17;
            }
            if (TextUtils.isEmpty(string2)) {
                this.mCharset = UTF_8;
            } else {
                try {
                    String string7;
                    string2 = string7 = CharsetUtils.charsetForVendor(string2).name();
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    Log.i(LOG_TAG, "Career-specific \"" + string2 + "\" was not found (as usual). " + "Use it as is.");
                }
                this.mCharset = string2;
            }
        }
        Log.d(LOG_TAG, "Use the charset \"" + this.mCharset + "\"");
    }

    public VCardComposer(Context context, int n, boolean bl) {
        this(context, n, null, bl);
    }

    static /* synthetic */ String access$102(VCardComposer vCardComposer, String string2) {
        vCardComposer.mErrorReason = string2;
        return string2;
    }

    /*
     * Exception decompiling
     */
    private String createOneEntryInternal(String var1_1, Method var2_2) throws VCardException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [7 : 186->216)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addHandler(OneEntryHandler oneEntryHandler) {
        if (oneEntryHandler != null) {
            this.mHandlerList.add(oneEntryHandler);
        }
    }

    public String buildVCard(Map<String, List<ContentValues>> map) {
        if (map == null) {
            Log.e(LOG_TAG, "The given map is null. Ignore and return empty String");
            return "";
        }
        VCardBuilder vCardBuilder = new VCardBuilder(this.mVCardType, this.mCharset);
        vCardBuilder.appendNameProperties(map.get("vnd.android.cursor.item/name")).appendNickNames(map.get("vnd.android.cursor.item/nickname")).appendPhones(map.get("vnd.android.cursor.item/phone_v2")).appendEmails(map.get("vnd.android.cursor.item/email_v2")).appendPostals(map.get("vnd.android.cursor.item/postal-address_v2")).appendOrganizations(map.get("vnd.android.cursor.item/organization")).appendWebsites(map.get("vnd.android.cursor.item/website"));
        if ((0x800000 & this.mVCardType) == 0) {
            vCardBuilder.appendPhotos(map.get("vnd.android.cursor.item/photo"));
        }
        vCardBuilder.appendNotes(map.get("vnd.android.cursor.item/note")).appendEvents(map.get("vnd.android.cursor.item/contact_event")).appendIms(map.get("vnd.android.cursor.item/im")).appendRelation(map.get("vnd.android.cursor.item/relation"));
        return vCardBuilder.toString();
    }

    public boolean createOneEntry() {
        return this.createOneEntry(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createOneEntry(Method method) {
        String string2;
        block12: {
            block13: {
                if (this.mCursor == null || this.mCursor.isAfterLast()) {
                    this.mErrorReason = FAILURE_REASON_NOT_INITIALIZED;
                    return false;
                }
                try {
                    if (this.mIdColumn >= 0) {
                        string2 = this.createOneEntryInternal(this.mCursor.getString(this.mIdColumn), method);
                        if (!this.mCareHandlerErrors) break block12;
                        new ArrayList(this.mHandlerList.size());
                        break block13;
                    }
                    Log.e(LOG_TAG, "Incorrect mIdColumn: " + this.mIdColumn);
                    return true;
                }
                catch (VCardException vCardException) {
                    Log.e(LOG_TAG, "VCardException has been thrown: " + vCardException.getMessage());
                    return false;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e(LOG_TAG, "OutOfMemoryError occured. Ignore the entry.");
                    System.gc();
                    return true;
                }
            }
            Iterator<OneEntryHandler> iterator = this.mHandlerList.iterator();
            do {
                if (!iterator.hasNext()) return true;
            } while (iterator.next().onEntryCreated(string2));
            return false;
            finally {
                this.mCursor.moveToNext();
            }
        }
        Iterator<OneEntryHandler> iterator = this.mHandlerList.iterator();
        while (iterator.hasNext()) {
            iterator.next().onEntryCreated(string2);
        }
        return true;
    }

    public void finalize() {
        if (!this.mTerminateIsCalled) {
            Log.w(LOG_TAG, "terminate() is not called yet. We call it in finalize() step.");
            this.terminate();
        }
    }

    public int getCount() {
        if (this.mCursor == null) {
            Log.w(LOG_TAG, "This object is not ready yet.");
            return 0;
        }
        return this.mCursor.getCount();
    }

    public String getErrorReason() {
        return this.mErrorReason;
    }

    public boolean init() {
        return this.init(null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean init(Uri uri, String string2, String[] stringArray, String string3) {
        if (uri == null) {
            return false;
        }
        if (this.mCareHandlerErrors) {
            ArrayList arrayList = new ArrayList(this.mHandlerList.size());
            Iterator<OneEntryHandler> iterator = this.mHandlerList.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().onInit(this.mContext)) continue;
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    ((OneEntryHandler)iterator2.next()).onTerminate();
                }
                return false;
            }
        } else {
            Iterator<OneEntryHandler> iterator = this.mHandlerList.iterator();
            while (iterator.hasNext()) {
                iterator.next().onInit(this.mContext);
            }
        }
        if (ContactsContract.Contacts.CONTENT_URI.equals(uri) || CONTACTS_TEST_CONTENT_URI.equals(uri)) {
            String[] stringArray2 = sContactsProjection;
            this.mCursor = this.mContentResolver.query(uri, stringArray2, string2, stringArray, string3);
            if (this.mCursor == null) {
                this.mErrorReason = FAILURE_REASON_FAILED_TO_GET_DATABASE_INFO;
                return false;
            }
        } else {
            this.mErrorReason = FAILURE_REASON_UNSUPPORTED_URI;
            return false;
        }
        if (this.getCount() == 0 || !this.mCursor.moveToFirst()) {
            try {
                this.mCursor.close();
                return false;
            }
            catch (SQLiteException sQLiteException) {
                Log.e(LOG_TAG, "SQLiteException on Cursor#close(): " + sQLiteException.getMessage());
                return false;
            }
            finally {
                this.mCursor = null;
                this.mErrorReason = FAILURE_REASON_NO_ENTRY;
                return false;
            }
        }
        this.mIdColumn = this.mCursor.getColumnIndex("_id");
        return true;
    }

    public boolean init(String string2, String[] stringArray) {
        return this.init(ContactsContract.Contacts.CONTENT_URI, string2, stringArray, null);
    }

    public boolean isAfterLast() {
        if (this.mCursor == null) {
            Log.w(LOG_TAG, "This object is not ready yet.");
            return false;
        }
        return this.mCursor.isAfterLast();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void terminate() {
        Iterator<OneEntryHandler> iterator = this.mHandlerList.iterator();
        while (iterator.hasNext()) {
            iterator.next().onTerminate();
        }
        if (this.mCursor != null) {
            try {
                this.mCursor.close();
            }
            catch (SQLiteException sQLiteException) {
                Log.e(LOG_TAG, "SQLiteException on Cursor#close(): " + sQLiteException.getMessage());
            }
            this.mCursor = null;
        }
        this.mTerminateIsCalled = true;
    }

    public final class HandlerForOutputStream
    implements OneEntryHandler {
        private static final String LOG_TAG = "VCardComposer.HandlerForOutputStream";
        private boolean mOnTerminateIsCalled = false;
        private final OutputStream mOutputStream;
        private Writer mWriter;

        public HandlerForOutputStream(OutputStream outputStream) {
            this.mOutputStream = outputStream;
        }

        public void closeOutputStream() {
            try {
                this.mWriter.close();
                return;
            }
            catch (IOException iOException) {
                Log.w(LOG_TAG, "IOException is thrown during close(). Ignoring.");
                return;
            }
        }

        public void finalize() {
            if (!this.mOnTerminateIsCalled) {
                this.onTerminate();
            }
        }

        @Override
        public boolean onEntryCreated(String string2) {
            try {
                this.mWriter.write(string2);
                return true;
            }
            catch (IOException iOException) {
                Log.e(LOG_TAG, "IOException occurred during exportOneContactData: " + iOException.getMessage());
                VCardComposer.access$102(VCardComposer.this, "IOException occurred: " + iOException.getMessage());
                return false;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean onInit(Context context) {
            try {
                this.mWriter = new BufferedWriter(new OutputStreamWriter(this.mOutputStream, VCardComposer.this.mCharset));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.e(LOG_TAG, "Unsupported charset: " + VCardComposer.this.mCharset);
                VCardComposer.access$102(VCardComposer.this, "Encoding is not supported (usually this does not happen!): " + VCardComposer.this.mCharset);
                return false;
            }
            if (!VCardComposer.this.mIsDoCoMo) return true;
            try {
                this.mWriter.write(VCardComposer.this.createOneEntryInternal("-1", null));
            }
            catch (VCardException vCardException) {
                Log.e(LOG_TAG, "VCardException has been thrown during on Init(): " + vCardException.getMessage());
                return false;
            }
            catch (IOException iOException) {
                Log.e(LOG_TAG, "IOException occurred during exportOneContactData: " + iOException.getMessage());
                VCardComposer.access$102(VCardComposer.this, "IOException occurred: " + iOException.getMessage());
                return false;
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onTerminate() {
            this.mOnTerminateIsCalled = true;
            if (this.mWriter == null) return;
            try {
                this.mWriter.flush();
                if (this.mOutputStream == null || !(this.mOutputStream instanceof FileOutputStream)) return;
                ((FileOutputStream)this.mOutputStream).getFD().sync();
            }
            catch (IOException iOException) {
                Log.d(LOG_TAG, "IOException during closing the output stream: " + iOException.getMessage());
                return;
            }
            finally {
                this.closeOutputStream();
            }
            return;
        }
    }

    public static interface OneEntryHandler {
        public boolean onEntryCreated(String var1);

        public boolean onInit(Context var1);

        public void onTerminate();
    }
}

