/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.accounts.Account;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import android.pim.vcard.VCardConfig;
import android.pim.vcard.VCardUtils;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.util.Log;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VCardEntry {
    private static final String ACCOUNT_TYPE_GOOGLE = "com.google";
    private static final int DEFAULT_ORGANIZATION_TYPE = 1;
    private static final String GOOGLE_MY_CONTACTS_GROUP = "System Group: My Contacts";
    private static final String LOG_TAG = "VCardEntry";
    private static final List<String> sEmptyList;
    private static final Map<String, Integer> sImMap;
    private final Account mAccount;
    private List<List<String>> mAndroidCustomPropertyList;
    private String mAnniversary;
    private String mBirthday;
    private String mDisplayName;
    private List<EmailData> mEmailList;
    private String mFamilyName;
    private String mFormattedName;
    private String mGivenName;
    private List<ImData> mImList;
    private String mMiddleName;
    private List<String> mNickNameList;
    private List<String> mNoteList;
    private List<OrganizationData> mOrganizationList;
    private List<PhoneData> mPhoneList;
    private String mPhoneticFamilyName;
    private String mPhoneticFullName;
    private String mPhoneticGivenName;
    private String mPhoneticMiddleName;
    private List<PhotoData> mPhotoList;
    private List<PostalData> mPostalList;
    private String mPrefix;
    private String mSuffix;
    private final int mVCardType;
    private List<String> mWebsiteList;

    static {
        sImMap = new HashMap<String, Integer>();
        sImMap.put("X-AIM", 0);
        sImMap.put("X-MSN", 1);
        sImMap.put("X-YAHOO", 2);
        sImMap.put("X-ICQ", 6);
        sImMap.put("X-JABBER", 7);
        sImMap.put("X-SKYPE-USERNAME", 3);
        sImMap.put("X-GOOGLE-TALK", 5);
        sImMap.put("X-GOOGLE TALK", 5);
        sEmptyList = Collections.unmodifiableList(new ArrayList(0));
    }

    public VCardEntry() {
        this(-1073741824);
    }

    public VCardEntry(int n) {
        this(n, null);
    }

    public VCardEntry(int n, Account account) {
        this.mVCardType = n;
        this.mAccount = account;
    }

    private void addEmail(int n, String string2, String string3, boolean bl) {
        if (this.mEmailList == null) {
            this.mEmailList = new ArrayList<EmailData>();
        }
        this.mEmailList.add(new EmailData(n, string2, string3, bl));
    }

    private void addIm(int n, String string2, int n2, String string3, boolean bl) {
        if (this.mImList == null) {
            this.mImList = new ArrayList<ImData>();
        }
        this.mImList.add(new ImData(n, string2, n2, string3, bl));
    }

    private void addNewOrganization(int n, String string2, String string3, String string4, String string5, boolean bl) {
        if (this.mOrganizationList == null) {
            this.mOrganizationList = new ArrayList<OrganizationData>();
        }
        this.mOrganizationList.add(new OrganizationData(n, string2, string3, string4, string5, bl));
    }

    private void addNickName(String string2) {
        if (this.mNickNameList == null) {
            this.mNickNameList = new ArrayList<String>();
        }
        this.mNickNameList.add(string2);
    }

    private void addNote(String string2) {
        if (this.mNoteList == null) {
            this.mNoteList = new ArrayList<String>(1);
        }
        this.mNoteList.add(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addPhone(int n, String string2, String string3, boolean bl) {
        String string4;
        if (this.mPhoneList == null) {
            this.mPhoneList = new ArrayList<PhoneData>();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = string2.trim();
        if (n == 6 || VCardConfig.refrainPhoneNumberFormatting(this.mVCardType)) {
            string4 = string5;
        } else {
            int n2 = string5.length();
            for (int i = 0; i < n2; ++i) {
                char c = string5.charAt(i);
                if (('0' > c || c > '9') && (i != 0 || c != '+')) continue;
                stringBuilder.append(c);
            }
            int n3 = VCardUtils.getPhoneNumberFormat(this.mVCardType);
            string4 = PhoneNumberUtils.formatNumber((String)stringBuilder.toString(), (int)n3);
        }
        PhoneData phoneData = new PhoneData(n, string4, string3, bl);
        this.mPhoneList.add(phoneData);
    }

    private void addPhotoBytes(String string2, byte[] byArray, boolean bl) {
        if (this.mPhotoList == null) {
            this.mPhotoList = new ArrayList<PhotoData>(1);
        }
        PhotoData photoData = new PhotoData(0, null, byArray, bl);
        this.mPhotoList.add(photoData);
    }

    private void addPostal(int n, List<String> list, String string2, boolean bl) {
        if (this.mPostalList == null) {
            this.mPostalList = new ArrayList<PostalData>(0);
        }
        this.mPostalList.add(new PostalData(n, list, string2, bl));
    }

    public static VCardEntry buildFromResolver(ContentResolver contentResolver) {
        return VCardEntry.buildFromResolver(contentResolver, ContactsContract.Contacts.CONTENT_URI);
    }

    public static VCardEntry buildFromResolver(ContentResolver contentResolver, Uri uri) {
        return null;
    }

    private String buildSinglePhoneticNameFromSortAsParam(Map<String, Collection<String>> map) {
        Collection<String> collection = map.get("SORT-AS");
        if (collection != null && collection.size() != 0) {
            if (collection.size() > 1) {
                Log.w(LOG_TAG, "Incorrect multiple SORT_AS parameters detected: " + Arrays.toString(collection.toArray()));
            }
            List<String> list = VCardUtils.constructListFromValue(collection.iterator().next(), this.mVCardType);
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
            }
            return stringBuilder.toString();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void constructDisplayName() {
        if (!TextUtils.isEmpty(this.mFormattedName)) {
            this.mDisplayName = this.mFormattedName;
        } else if (!TextUtils.isEmpty(this.mFamilyName) || !TextUtils.isEmpty(this.mGivenName)) {
            this.mDisplayName = VCardUtils.constructNameFromElements(this.mVCardType, this.mFamilyName, this.mMiddleName, this.mGivenName, this.mPrefix, this.mSuffix);
        } else if (!TextUtils.isEmpty(this.mPhoneticFamilyName) || !TextUtils.isEmpty(this.mPhoneticGivenName)) {
            this.mDisplayName = VCardUtils.constructNameFromElements(this.mVCardType, this.mPhoneticFamilyName, this.mPhoneticMiddleName, this.mPhoneticGivenName);
        } else if (this.mEmailList != null && this.mEmailList.size() > 0) {
            this.mDisplayName = this.mEmailList.get((int)0).data;
        } else if (this.mPhoneList != null && this.mPhoneList.size() > 0) {
            this.mDisplayName = this.mPhoneList.get((int)0).data;
        } else if (this.mPostalList != null && this.mPostalList.size() > 0) {
            this.mDisplayName = this.mPostalList.get(0).getFormattedAddress(this.mVCardType);
        } else if (this.mOrganizationList != null && this.mOrganizationList.size() > 0) {
            this.mDisplayName = this.mOrganizationList.get(0).getFormattedString();
        }
        if (this.mDisplayName == null) {
            this.mDisplayName = "";
        }
    }

    private void handleAndroidCustomProperty(List<String> list) {
        if (this.mAndroidCustomPropertyList == null) {
            this.mAndroidCustomPropertyList = new ArrayList<List<String>>();
        }
        this.mAndroidCustomPropertyList.add(list);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleNProperty(List<String> list, Map<String, Collection<String>> map) {
        block8: {
            int n;
            this.tryHandleSortAsName(map);
            if (list == null || (n = list.size()) < 1) {
                return;
            }
            if (n > 5) {
                n = 5;
            }
            switch (n) {
                default: {
                    break block8;
                }
                case 5: {
                    this.mSuffix = list.get(4);
                }
                case 4: {
                    this.mPrefix = list.get(3);
                }
                case 3: {
                    this.mMiddleName = list.get(2);
                    break;
                }
                case 2: 
            }
            this.mGivenName = list.get(1);
        }
        this.mFamilyName = list.get(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleOrgValue(int n, List<String> list, Map<String, Collection<String>> map, boolean bl) {
        OrganizationData organizationData;
        String string2;
        String string3;
        String string4;
        block10: {
            StringBuilder stringBuilder;
            string4 = this.buildSinglePhoneticNameFromSortAsParam(map);
            if (list == null) {
                list = sEmptyList;
            }
            int n2 = list.size();
            switch (n2) {
                default: {
                    string3 = list.get(0);
                    stringBuilder = new StringBuilder();
                    for (int i = 1; i < n2; ++i) {
                        if (i > 1) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(list.get(i));
                    }
                    break;
                }
                case 0: {
                    string3 = "";
                    string2 = null;
                    break block10;
                }
                case 1: {
                    string3 = list.get(0);
                    string2 = null;
                    break block10;
                }
            }
            string2 = stringBuilder.toString();
        }
        if (this.mOrganizationList == null) {
            this.addNewOrganization(n, string3, string2, null, string4, bl);
            return;
        }
        Iterator<OrganizationData> iterator = this.mOrganizationList.iterator();
        do {
            if (!iterator.hasNext()) {
                this.addNewOrganization(n, string3, string2, null, string4, bl);
                return;
            }
            organizationData = iterator.next();
        } while (organizationData.companyName != null || organizationData.departmentName != null);
        organizationData.companyName = string3;
        organizationData.departmentName = string2;
        organizationData.isPrimary = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handlePhoneticNameFromSound(List<String> list) {
        block13: {
            int n;
            block10: {
                int n2;
                String[] stringArray;
                if (!(TextUtils.isEmpty(this.mPhoneticFamilyName) && TextUtils.isEmpty(this.mPhoneticMiddleName) && TextUtils.isEmpty(this.mPhoneticGivenName) && list != null && (n = list.size()) >= 1)) {
                    return;
                }
                if (n > 3) {
                    n = 3;
                }
                if (list.get(0).length() <= 0) break block10;
                boolean bl = true;
                int n3 = 1;
                while (true) {
                    block12: {
                        block11: {
                            if (n3 >= n) break block11;
                            if (list.get(n3).length() <= 0) break block12;
                            bl = false;
                        }
                        if (bl) {
                            stringArray = list.get(0).split(" ");
                            n2 = stringArray.length;
                            if (n2 != 3) break;
                            this.mPhoneticFamilyName = stringArray[0];
                            this.mPhoneticMiddleName = stringArray[1];
                            this.mPhoneticGivenName = stringArray[2];
                            return;
                        }
                        break block10;
                    }
                    ++n3;
                }
                if (n2 == 2) {
                    this.mPhoneticFamilyName = stringArray[0];
                    this.mPhoneticGivenName = stringArray[1];
                    return;
                }
                this.mPhoneticFullName = list.get(0);
                return;
            }
            switch (n) {
                default: {
                    break block13;
                }
                case 3: {
                    this.mPhoneticMiddleName = list.get(2);
                    break;
                }
                case 2: 
            }
            this.mPhoneticGivenName = list.get(1);
        }
        this.mPhoneticFamilyName = list.get(0);
    }

    private void handleTitleValue(String string2) {
        if (this.mOrganizationList == null) {
            this.addNewOrganization(1, null, null, string2, null, false);
            return;
        }
        for (OrganizationData organizationData : this.mOrganizationList) {
            if (organizationData.titleName != null) continue;
            organizationData.titleName = string2;
            return;
        }
        this.addNewOrganization(1, null, null, string2, null, false);
    }

    private String listToString(List<String> list) {
        int n = list.size();
        if (n > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (n - 1 >= 0) continue;
                stringBuilder.append(";");
            }
            return stringBuilder.toString();
        }
        if (n == 1) {
            return list.get(0);
        }
        return "";
    }

    private boolean nameFieldsAreEmpty() {
        return TextUtils.isEmpty(this.mFamilyName) && TextUtils.isEmpty(this.mMiddleName) && TextUtils.isEmpty(this.mGivenName) && TextUtils.isEmpty(this.mPrefix) && TextUtils.isEmpty(this.mSuffix) && TextUtils.isEmpty(this.mFormattedName) && TextUtils.isEmpty(this.mPhoneticFamilyName) && TextUtils.isEmpty(this.mPhoneticMiddleName) && TextUtils.isEmpty(this.mPhoneticGivenName) && TextUtils.isEmpty(this.mPhoneticFullName);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void tryHandleSortAsName(Map<String, Collection<String>> map) {
        List<String> list;
        block7: {
            int n;
            Collection<String> collection;
            if (VCardConfig.isVersion30(this.mVCardType) && (!TextUtils.isEmpty(this.mPhoneticFamilyName) || !TextUtils.isEmpty(this.mPhoneticMiddleName) || !TextUtils.isEmpty(this.mPhoneticGivenName)) || (collection = map.get("SORT-AS")) == null || collection.size() == 0) {
                return;
            }
            if (collection.size() > 1) {
                Log.w(LOG_TAG, "Incorrect multiple SORT_AS parameters detected: " + Arrays.toString(collection.toArray()));
            }
            if ((n = (list = VCardUtils.constructListFromValue(collection.iterator().next(), this.mVCardType)).size()) > 3) {
                n = 3;
            }
            switch (n) {
                default: {
                    break block7;
                }
                case 3: {
                    this.mPhoneticMiddleName = list.get(2);
                    break;
                }
                case 2: 
            }
            this.mPhoneticGivenName = list.get(1);
        }
        this.mPhoneticFamilyName = list.get(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addProperty(Property property) {
        boolean bl;
        int n;
        int n2;
        String string2;
        block57: {
            Iterator iterator;
            block58: {
                String string3;
                boolean bl2;
                byte[] byArray;
                block54: {
                    Iterator iterator2;
                    block55: {
                        String string4;
                        boolean bl3;
                        int n3;
                        block51: {
                            Iterator iterator3;
                            block52: {
                                boolean bl4;
                                String string5;
                                int n4;
                                List list;
                                block48: {
                                    Iterator iterator4;
                                    block49: {
                                        String string6;
                                        block56: {
                                            Map map;
                                            block53: {
                                                block50: {
                                                    block47: {
                                                        string6 = property.mPropertyName;
                                                        map = property.mParameterMap;
                                                        list = property.mPropertyValueList;
                                                        byArray = property.mPropertyBytes;
                                                        if (list.size() == 0) return;
                                                        string2 = this.listToString(list).trim();
                                                        if (string6.equals("VERSION")) return;
                                                        if (string6.equals("FN")) {
                                                            this.mFormattedName = string2;
                                                            return;
                                                        }
                                                        if (string6.equals("NAME") && this.mFormattedName == null) {
                                                            this.mFormattedName = string2;
                                                            return;
                                                        }
                                                        if (string6.equals("N")) {
                                                            this.handleNProperty(list, map);
                                                            return;
                                                        }
                                                        if (string6.equals("SORT-STRING")) {
                                                            this.mPhoneticFullName = string2;
                                                            return;
                                                        }
                                                        if (string6.equals("NICKNAME") || string6.equals("X-NICKNAME")) {
                                                            this.addNickName(string2);
                                                            return;
                                                        }
                                                        if (string6.equals("SOUND")) {
                                                            Collection collection = (Collection)map.get("TYPE");
                                                            if (collection == null || !collection.contains("X-IRMC-N")) return;
                                                            this.handlePhoneticNameFromSound(VCardUtils.constructListFromValue(string2, this.mVCardType));
                                                            return;
                                                        }
                                                        if (!string6.equals("ADR")) break block47;
                                                        boolean bl5 = true;
                                                        Iterator iterator5 = list.iterator();
                                                        while (iterator5.hasNext()) {
                                                            if (((String)iterator5.next()).length() <= 0) continue;
                                                            bl5 = false;
                                                            break;
                                                        }
                                                        if (bl5) return;
                                                        n4 = -1;
                                                        string5 = "";
                                                        Collection collection = (Collection)map.get("TYPE");
                                                        bl4 = false;
                                                        if (collection == null) break block48;
                                                        iterator4 = collection.iterator();
                                                        break block49;
                                                    }
                                                    if (!string6.equals("EMAIL")) break block50;
                                                    n3 = -1;
                                                    Collection collection = (Collection)map.get("TYPE");
                                                    bl3 = false;
                                                    string4 = null;
                                                    if (collection == null) break block51;
                                                    iterator3 = collection.iterator();
                                                    break block52;
                                                }
                                                if (string6.equals("ORG")) {
                                                    Collection collection = (Collection)map.get("TYPE");
                                                    boolean bl6 = false;
                                                    if (collection != null) {
                                                        Iterator iterator6 = collection.iterator();
                                                        while (iterator6.hasNext()) {
                                                            if (!((String)iterator6.next()).equals("PREF")) continue;
                                                            bl6 = true;
                                                        }
                                                    }
                                                    this.handleOrgValue(1, list, map, bl6);
                                                    return;
                                                }
                                                if (string6.equals("TITLE")) {
                                                    this.handleTitleValue(string2);
                                                    return;
                                                }
                                                if (string6.equals("ROLE")) return;
                                                if (!string6.equals("PHOTO") && !string6.equals("LOGO")) break block53;
                                                Collection collection = (Collection)map.get("VALUE");
                                                if (collection != null && collection.contains("URL")) return;
                                                Collection collection2 = (Collection)map.get("TYPE");
                                                bl2 = false;
                                                string3 = null;
                                                if (collection2 == null) break block54;
                                                iterator2 = collection2.iterator();
                                                break block55;
                                            }
                                            if (string6.equals("TEL")) {
                                                String string7;
                                                int n5;
                                                Collection collection = (Collection)map.get("TYPE");
                                                Object object = VCardUtils.getPhoneTypeFromStrings(collection, string2);
                                                if (object instanceof Integer) {
                                                    n5 = (Integer)object;
                                                    string7 = null;
                                                } else {
                                                    string7 = object.toString();
                                                    n5 = 0;
                                                }
                                                boolean bl7 = collection != null && collection.contains("PREF");
                                                this.addPhone(n5, string2, string7, bl7);
                                                return;
                                            }
                                            if (string6.equals("X-SKYPE-PSTNNUMBER")) {
                                                Collection collection = (Collection)map.get("TYPE");
                                                boolean bl8 = collection != null && collection.contains("PREF");
                                                this.addPhone(7, string2, null, bl8);
                                                return;
                                            }
                                            if (!sImMap.containsKey(string6)) break block56;
                                            n2 = sImMap.get(string6);
                                            n = -1;
                                            Collection collection = (Collection)map.get("TYPE");
                                            bl = false;
                                            if (collection == null) break block57;
                                            iterator = collection.iterator();
                                            break block58;
                                        }
                                        if (string6.equals("NOTE")) {
                                            this.addNote(string2);
                                            return;
                                        }
                                        if (string6.equals("URL")) {
                                            if (this.mWebsiteList == null) {
                                                this.mWebsiteList = new ArrayList<String>(1);
                                            }
                                            this.mWebsiteList.add(string2);
                                            return;
                                        }
                                        if (string6.equals("BDAY")) {
                                            this.mBirthday = string2;
                                            return;
                                        }
                                        if (string6.equals("ANNIVERSARY")) {
                                            this.mAnniversary = string2;
                                            return;
                                        }
                                        if (string6.equals("X-PHONETIC-FIRST-NAME")) {
                                            this.mPhoneticGivenName = string2;
                                            return;
                                        }
                                        if (string6.equals("X-PHONETIC-MIDDLE-NAME")) {
                                            this.mPhoneticMiddleName = string2;
                                            return;
                                        }
                                        if (string6.equals("X-PHONETIC-LAST-NAME")) {
                                            this.mPhoneticFamilyName = string2;
                                            return;
                                        }
                                        if (!string6.equals("X-ANDROID-CUSTOM")) {
                                            return;
                                        }
                                        this.handleAndroidCustomProperty(VCardUtils.constructListFromValue(string2, this.mVCardType));
                                        return;
                                    }
                                    while (iterator4.hasNext()) {
                                        String string8 = ((String)iterator4.next()).toUpperCase();
                                        if (string8.equals("PREF")) {
                                            bl4 = true;
                                            continue;
                                        }
                                        if (string8.equals("HOME")) {
                                            n4 = 1;
                                            string5 = "";
                                            continue;
                                        }
                                        if (string8.equals("WORK") || string8.equalsIgnoreCase("COMPANY")) {
                                            n4 = 2;
                                            string5 = "";
                                            continue;
                                        }
                                        if (string8.equals("PARCEL") || string8.equals("DOM") || string8.equals("INTL")) continue;
                                        if (string8.startsWith("X-") && n4 < 0) {
                                            string8 = string8.substring(2);
                                        }
                                        string5 = string8;
                                        n4 = 0;
                                    }
                                }
                                if (n4 < 0) {
                                    n4 = 1;
                                }
                                this.addPostal(n4, list, string5, bl4);
                                return;
                            }
                            while (iterator3.hasNext()) {
                                String string9 = ((String)iterator3.next()).toUpperCase();
                                if (string9.equals("PREF")) {
                                    bl3 = true;
                                    continue;
                                }
                                if (string9.equals("HOME")) {
                                    n3 = 1;
                                    continue;
                                }
                                if (string9.equals("WORK")) {
                                    n3 = 2;
                                    continue;
                                }
                                if (string9.equals("CELL")) {
                                    n3 = 4;
                                    continue;
                                }
                                if (string9.startsWith("X-") && n3 < 0) {
                                    string9 = string9.substring(2);
                                }
                                string4 = string9;
                                n3 = 0;
                            }
                        }
                        if (n3 < 0) {
                            n3 = 3;
                        }
                        this.addEmail(n3, string2, string4, bl3);
                        return;
                    }
                    while (iterator2.hasNext()) {
                        String string10 = (String)iterator2.next();
                        if ("PREF".equals(string10)) {
                            bl2 = true;
                            continue;
                        }
                        if (string3 != null) continue;
                        string3 = string10;
                    }
                }
                this.addPhotoBytes(string3, byArray, bl2);
                return;
            }
            while (iterator.hasNext()) {
                String string11 = (String)iterator.next();
                if (string11.equals("PREF")) {
                    bl = true;
                    continue;
                }
                if (n >= 0) continue;
                if (string11.equalsIgnoreCase("HOME")) {
                    n = 1;
                    continue;
                }
                if (!string11.equalsIgnoreCase("WORK")) continue;
                n = 2;
            }
        }
        if (n < 0) {
            n = 1;
        }
        this.addIm(n2, null, n, string2, bl);
    }

    public void consolidateFields() {
        this.constructDisplayName();
        if (this.mPhoneticFullName != null) {
            this.mPhoneticFullName = this.mPhoneticFullName.trim();
        }
    }

    public String getBirthday() {
        return this.mBirthday;
    }

    public String getDisplayName() {
        if (this.mDisplayName == null) {
            this.constructDisplayName();
        }
        return this.mDisplayName;
    }

    public final List<EmailData> getEmailList() {
        return this.mEmailList;
    }

    public String getFamilyName() {
        return this.mFamilyName;
    }

    public String getFullName() {
        return this.mFormattedName;
    }

    public String getGivenName() {
        return this.mGivenName;
    }

    public final List<ImData> getImList() {
        return this.mImList;
    }

    public String getMiddleName() {
        return this.mMiddleName;
    }

    public final List<String> getNickNameList() {
        return this.mNickNameList;
    }

    public final List<String> getNotes() {
        return this.mNoteList;
    }

    public final List<OrganizationData> getOrganizationList() {
        return this.mOrganizationList;
    }

    public final List<PhoneData> getPhoneList() {
        return this.mPhoneList;
    }

    public String getPhoneticFamilyName() {
        return this.mPhoneticFamilyName;
    }

    public String getPhoneticFullName() {
        return this.mPhoneticFullName;
    }

    public String getPhoneticGivenName() {
        return this.mPhoneticGivenName;
    }

    public String getPhoneticMiddleName() {
        return this.mPhoneticMiddleName;
    }

    public final List<PhotoData> getPhotoList() {
        return this.mPhotoList;
    }

    public final List<PostalData> getPostalList() {
        return this.mPostalList;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public String getSuffix() {
        return this.mSuffix;
    }

    public final List<String> getWebsiteList() {
        return this.mWebsiteList;
    }

    public boolean isIgnorable() {
        return this.getDisplayName().length() == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Uri pushIntoContentResolver(ContentResolver contentResolver) {
        String string2;
        ContentProviderOperation.Builder builder;
        ArrayList<ContentProviderOperation> arrayList;
        block54: {
            block53: {
                arrayList = new ArrayList<ContentProviderOperation>();
                builder = ContentProviderOperation.newInsert(ContactsContract.RawContacts.CONTENT_URI);
                if (this.mAccount == null) break block53;
                builder.withValue("account_name", this.mAccount.name);
                builder.withValue("account_type", this.mAccount.type);
                boolean bl = ACCOUNT_TYPE_GOOGLE.equals(this.mAccount.type);
                string2 = null;
                if (bl) {
                    Cursor cursor = contentResolver.query(ContactsContract.Groups.CONTENT_URI, new String[]{"sourceid"}, "title=?", new String[]{GOOGLE_MY_CONTACTS_GROUP}, null);
                    string2 = null;
                    if (cursor != null) {
                        try {
                            boolean bl2 = cursor.moveToFirst();
                            string2 = null;
                            if (bl2) {
                                String string3;
                                string2 = string3 = cursor.getString(0);
                            }
                        }
                        catch (Throwable throwable) {
                            if (cursor == null) throw throwable;
                            cursor.close();
                            throw throwable;
                        }
                    }
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                break block54;
            }
            builder.withValue("account_name", null);
            builder.withValue("account_type", null);
            string2 = null;
        }
        arrayList.add(builder.build());
        if (!this.nameFieldsAreEmpty()) {
            builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
            builder.withValueBackReference("raw_contact_id", 0);
            builder.withValue("mimetype", "vnd.android.cursor.item/name");
            builder.withValue("data2", this.mGivenName);
            builder.withValue("data3", this.mFamilyName);
            builder.withValue("data5", this.mMiddleName);
            builder.withValue("data4", this.mPrefix);
            builder.withValue("data6", this.mSuffix);
            if (!(TextUtils.isEmpty(this.mPhoneticGivenName) && TextUtils.isEmpty(this.mPhoneticFamilyName) && TextUtils.isEmpty(this.mPhoneticMiddleName))) {
                builder.withValue("data7", this.mPhoneticGivenName);
                builder.withValue("data9", this.mPhoneticFamilyName);
                builder.withValue("data8", this.mPhoneticMiddleName);
            } else if (!TextUtils.isEmpty(this.mPhoneticFullName)) {
                builder.withValue("data7", this.mPhoneticFullName);
            }
            builder.withValue("data1", this.getDisplayName());
            arrayList.add(builder.build());
        }
        if (this.mNickNameList != null && this.mNickNameList.size() > 0) {
            for (String string4 : this.mNickNameList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/nickname");
                builder.withValue("data2", 1);
                builder.withValue("data1", string4);
                arrayList.add(builder.build());
            }
        }
        if (this.mPhoneList != null) {
            for (PhoneData phoneData : this.mPhoneList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/phone_v2");
                builder.withValue("data2", phoneData.type);
                if (phoneData.type == 0) {
                    builder.withValue("data3", phoneData.label);
                }
                builder.withValue("data1", phoneData.data);
                if (phoneData.isPrimary) {
                    builder.withValue("is_primary", 1);
                }
                arrayList.add(builder.build());
            }
        }
        if (this.mOrganizationList != null) {
            for (OrganizationData organizationData : this.mOrganizationList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/organization");
                builder.withValue("data2", organizationData.type);
                if (organizationData.companyName != null) {
                    builder.withValue("data1", organizationData.companyName);
                }
                if (organizationData.departmentName != null) {
                    builder.withValue("data5", organizationData.departmentName);
                }
                if (organizationData.titleName != null) {
                    builder.withValue("data4", organizationData.titleName);
                }
                if (organizationData.phoneticName != null) {
                    builder.withValue("data8", organizationData.phoneticName);
                }
                if (organizationData.isPrimary) {
                    builder.withValue("is_primary", 1);
                }
                arrayList.add(builder.build());
            }
        }
        if (this.mEmailList != null) {
            for (EmailData emailData : this.mEmailList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/email_v2");
                builder.withValue("data2", emailData.type);
                if (emailData.type == 0) {
                    builder.withValue("data3", emailData.label);
                }
                builder.withValue("data1", emailData.data);
                if (emailData.isPrimary) {
                    builder.withValue("is_primary", 1);
                }
                arrayList.add(builder.build());
            }
        }
        if (this.mPostalList != null) {
            for (PostalData postalData : this.mPostalList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                VCardUtils.insertStructuredPostalDataUsingContactsStruct(this.mVCardType, builder, postalData);
                arrayList.add(builder.build());
            }
        }
        if (this.mImList != null) {
            for (ImData imData : this.mImList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/im");
                builder.withValue("data2", imData.type);
                builder.withValue("data5", imData.protocol);
                builder.withValue("data1", imData.data);
                if (imData.protocol == -1) {
                    builder.withValue("data6", imData.customProtocol);
                }
                if (imData.isPrimary) {
                    builder.withValue("is_primary", 1);
                }
                arrayList.add(builder.build());
            }
        }
        if (this.mNoteList != null) {
            for (String string5 : this.mNoteList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/note");
                builder.withValue("data1", string5);
                arrayList.add(builder.build());
            }
        }
        if (this.mPhotoList != null) {
            for (PhotoData photoData : this.mPhotoList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/photo");
                builder.withValue("data15", photoData.photoBytes);
                if (photoData.isPrimary) {
                    builder.withValue("is_primary", 1);
                }
                arrayList.add(builder.build());
            }
        }
        if (this.mWebsiteList != null) {
            for (String string6 : this.mWebsiteList) {
                builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                builder.withValueBackReference("raw_contact_id", 0);
                builder.withValue("mimetype", "vnd.android.cursor.item/website");
                builder.withValue("data1", string6);
                builder.withValue("data2", 1);
                arrayList.add(builder.build());
            }
        }
        if (!TextUtils.isEmpty(this.mBirthday)) {
            builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
            builder.withValueBackReference("raw_contact_id", 0);
            builder.withValue("mimetype", "vnd.android.cursor.item/contact_event");
            builder.withValue("data1", this.mBirthday);
            builder.withValue("data2", 3);
            arrayList.add(builder.build());
        }
        if (!TextUtils.isEmpty(this.mAnniversary)) {
            builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
            builder.withValueBackReference("raw_contact_id", 0);
            builder.withValue("mimetype", "vnd.android.cursor.item/contact_event");
            builder.withValue("data1", this.mAnniversary);
            builder.withValue("data2", 1);
            arrayList.add(builder.build());
        }
        if (this.mAndroidCustomPropertyList != null) {
            for (List<String> list : this.mAndroidCustomPropertyList) {
                int n = list.size();
                if (n < 2 || TextUtils.isEmpty(list.get(0))) continue;
                if (n > 16) {
                    list = list.subList(0, 17);
                }
                int n2 = 0;
                for (String string7 : list) {
                    if (n2 == 0) {
                        builder = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
                        builder.withValueBackReference("raw_contact_id", 0);
                        builder.withValue("mimetype", string7);
                    } else if (!TextUtils.isEmpty(string7)) {
                        builder.withValue("data" + n2, string7);
                    }
                    ++n2;
                }
                arrayList.add(builder.build());
            }
        }
        if (string2 != null) {
            ContentProviderOperation.Builder builder2 = ContentProviderOperation.newInsert(ContactsContract.Data.CONTENT_URI);
            builder2.withValueBackReference("raw_contact_id", 0);
            builder2.withValue("mimetype", "vnd.android.cursor.item/group_membership");
            builder2.withValue("group_sourceid", string2);
            arrayList.add(builder2.build());
        }
        try {
            ContentProviderResult[] contentProviderResultArray = contentResolver.applyBatch("com.android.contacts", arrayList);
            if (contentProviderResultArray == null) return null;
            if (contentProviderResultArray.length == 0) return null;
            if (contentProviderResultArray[0] != null) return contentProviderResultArray[0].uri;
            return null;
        }
        catch (RemoteException remoteException) {
            Object[] objectArray = new Object[]{remoteException.toString(), remoteException.getMessage()};
            Log.e(LOG_TAG, String.format("%s: %s", objectArray));
            return null;
        }
        catch (OperationApplicationException operationApplicationException) {
            Object[] objectArray = new Object[]{operationApplicationException.toString(), operationApplicationException.getMessage()};
            Log.e(LOG_TAG, String.format("%s: %s", objectArray));
            return null;
        }
    }

    public static class EmailData {
        public final String data;
        public boolean isPrimary;
        public final String label;
        public final int type;

        public EmailData(int n, String string2, String string3, boolean bl) {
            this.type = n;
            this.data = string2;
            this.label = string3;
            this.isPrimary = bl;
        }

        public boolean equals(Object object) {
            if (!(object instanceof EmailData)) {
                return false;
            }
            EmailData emailData = (EmailData)object;
            return this.type == emailData.type && this.data.equals(emailData.data) && this.label.equals(emailData.label) && this.isPrimary == emailData.isPrimary;
        }

        public String toString() {
            Object[] objectArray = new Object[]{this.type, this.data, this.label, this.isPrimary};
            return String.format("type: %d, data: %s, label: %s, isPrimary: %s", objectArray);
        }
    }

    public static class ImData {
        public final String customProtocol;
        public final String data;
        public final boolean isPrimary;
        public final int protocol;
        public final int type;

        public ImData(int n, String string2, int n2, String string3, boolean bl) {
            this.protocol = n;
            this.customProtocol = string2;
            this.type = n2;
            this.data = string3;
            this.isPrimary = bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            if (!(object instanceof ImData)) {
                return false;
            }
            ImData imData = (ImData)object;
            return this.type == imData.type && this.protocol == imData.protocol && (this.customProtocol != null ? this.customProtocol.equals(imData.customProtocol) : imData.customProtocol == null) && (this.data != null ? this.data.equals(imData.data) : imData.data == null) && this.isPrimary == imData.isPrimary;
        }

        public String toString() {
            Object[] objectArray = new Object[]{this.type, this.protocol, this.customProtocol, this.data, this.isPrimary};
            return String.format("type: %d, protocol: %d, custom_protcol: %s, data: %s, isPrimary: %s", objectArray);
        }
    }

    public static class OrganizationData {
        public String companyName;
        public String departmentName;
        public boolean isPrimary;
        public final String phoneticName;
        public String titleName;
        public final int type;

        public OrganizationData(int n, String string2, String string3, String string4, String string5, boolean bl) {
            this.type = n;
            this.companyName = string2;
            this.departmentName = string3;
            this.titleName = string4;
            this.phoneticName = string5;
            this.isPrimary = bl;
        }

        public boolean equals(Object object) {
            if (!(object instanceof OrganizationData)) {
                return false;
            }
            OrganizationData organizationData = (OrganizationData)object;
            return this.type == organizationData.type && TextUtils.equals(this.companyName, organizationData.companyName) && TextUtils.equals(this.departmentName, organizationData.departmentName) && TextUtils.equals(this.titleName, organizationData.titleName) && this.isPrimary == organizationData.isPrimary;
        }

        public String getFormattedString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (!TextUtils.isEmpty(this.companyName)) {
                stringBuilder.append(this.companyName);
            }
            if (!TextUtils.isEmpty(this.departmentName)) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.departmentName);
            }
            if (!TextUtils.isEmpty(this.titleName)) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.titleName);
            }
            return stringBuilder.toString();
        }

        public String toString() {
            Object[] objectArray = new Object[]{this.type, this.companyName, this.departmentName, this.titleName, this.isPrimary};
            return String.format("type: %d, company: %s, department: %s, title: %s, isPrimary: %s", objectArray);
        }
    }

    public static class PhoneData {
        public final String data;
        public boolean isPrimary;
        public final String label;
        public final int type;

        public PhoneData(int n, String string2, String string3, boolean bl) {
            this.type = n;
            this.data = string2;
            this.label = string3;
            this.isPrimary = bl;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PhoneData)) {
                return false;
            }
            PhoneData phoneData = (PhoneData)object;
            return this.type == phoneData.type && this.data.equals(phoneData.data) && this.label.equals(phoneData.label) && this.isPrimary == phoneData.isPrimary;
        }

        public String toString() {
            Object[] objectArray = new Object[]{this.type, this.data, this.label, this.isPrimary};
            return String.format("type: %d, data: %s, label: %s, isPrimary: %s", objectArray);
        }
    }

    public static class PhotoData {
        public static final String FORMAT_FLASH = "SWF";
        public final String formatName;
        public final boolean isPrimary;
        public final byte[] photoBytes;
        public final int type;

        public PhotoData(int n, String string2, byte[] byArray, boolean bl) {
            this.type = n;
            this.formatName = string2;
            this.photoBytes = byArray;
            this.isPrimary = bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            if (!(object instanceof PhotoData)) {
                return false;
            }
            PhotoData photoData = (PhotoData)object;
            return this.type == photoData.type && (this.formatName == null ? photoData.formatName == null : this.formatName.equals(photoData.formatName)) && Arrays.equals(this.photoBytes, photoData.photoBytes) && this.isPrimary == photoData.isPrimary;
        }

        public String toString() {
            Object[] objectArray = new Object[]{this.type, this.formatName, this.photoBytes.length, this.isPrimary};
            return String.format("type: %d, format: %s: size: %d, isPrimary: %s", objectArray);
        }
    }

    public static class PostalData {
        public static final int ADDR_MAX_DATA_SIZE = 7;
        public final String country;
        private final String[] dataArray;
        public final String extendedAddress;
        public boolean isPrimary;
        public final String label;
        public final String localty;
        public final String pobox;
        public final String postalCode;
        public final String region;
        public final String street;
        public final int type;

        /*
         * Enabled aggressive block sorting
         */
        public PostalData(int n, List<String> list, String string2, boolean bl) {
            int n2;
            block4: {
                this.type = n;
                this.dataArray = new String[7];
                int n3 = list.size();
                if (n3 > 7) {
                    n3 = 7;
                }
                int n4 = 0;
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    this.dataArray[n4] = string3 = iterator.next();
                    if (++n4 < n3) continue;
                    n2 = n4;
                    break block4;
                }
                n2 = n4;
            }
            while (true) {
                if (n2 >= 7) {
                    this.pobox = this.dataArray[0];
                    this.extendedAddress = this.dataArray[1];
                    this.street = this.dataArray[2];
                    this.localty = this.dataArray[3];
                    this.region = this.dataArray[4];
                    this.postalCode = this.dataArray[5];
                    this.country = this.dataArray[6];
                    this.label = string2;
                    this.isPrimary = bl;
                    return;
                }
                String[] stringArray = this.dataArray;
                int n5 = n2 + 1;
                stringArray[n2] = null;
                n2 = n5;
            }
        }

        public boolean equals(Object object) {
            if (!(object instanceof PostalData)) {
                return false;
            }
            PostalData postalData = (PostalData)object;
            return Arrays.equals(this.dataArray, postalData.dataArray) && this.type == postalData.type && (this.type != 0 || this.label == postalData.label) && this.isPrimary == postalData.isPrimary;
        }

        /*
         * Enabled aggressive block sorting
         */
        public String getFormattedAddress(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            if (VCardConfig.isJapaneseDevice(n)) {
                for (int i = 6; i >= 0; --i) {
                    String string2 = this.dataArray[i];
                    if (TextUtils.isEmpty(string2)) continue;
                    if (!bl) {
                        stringBuilder.append(' ');
                    } else {
                        bl = false;
                    }
                    stringBuilder.append(string2);
                }
                return stringBuilder.toString().trim();
            }
            for (int i = 0; i < 7; ++i) {
                String string3 = this.dataArray[i];
                if (TextUtils.isEmpty(string3)) continue;
                if (!bl) {
                    stringBuilder.append(' ');
                } else {
                    bl = false;
                }
                stringBuilder.append(string3);
            }
            return stringBuilder.toString().trim();
        }

        public String toString() {
            Object[] objectArray = new Object[]{this.type, this.label, this.isPrimary};
            return String.format("type: %d, label: %s, isPrimary: %s", objectArray);
        }
    }

    static class Property {
        private Map<String, Collection<String>> mParameterMap = new HashMap<String, Collection<String>>();
        private byte[] mPropertyBytes;
        private String mPropertyName;
        private List<String> mPropertyValueList = new ArrayList<String>();

        Property() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void addParameter(String string2, String string3) {
            AbstractCollection abstractCollection;
            if (!this.mParameterMap.containsKey(string2)) {
                abstractCollection = string2.equals("TYPE") ? new HashSet<String>() : new ArrayList<String>();
                this.mParameterMap.put(string2, abstractCollection);
            } else {
                abstractCollection = this.mParameterMap.get(string2);
            }
            abstractCollection.add((String)string3);
        }

        public void addToPropertyValueList(String string2) {
            this.mPropertyValueList.add(string2);
        }

        public void clear() {
            this.mPropertyName = null;
            this.mParameterMap.clear();
            this.mPropertyValueList.clear();
            this.mPropertyBytes = null;
        }

        public final Collection<String> getParameters(String string2) {
            return this.mParameterMap.get(string2);
        }

        public final List<String> getPropertyValueList() {
            return this.mPropertyValueList;
        }

        public void setPropertyBytes(byte[] byArray) {
            this.mPropertyBytes = byArray;
        }

        public void setPropertyName(String string2) {
            this.mPropertyName = string2;
        }
    }
}

