/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.content.ContentResolver;
import android.net.Uri;
import android.pim.vcard.VCardConfig;
import android.pim.vcard.VCardEntry;
import android.pim.vcard.VCardEntryHandler;
import android.util.Log;
import java.util.ArrayList;

public class VCardEntryCommitter
implements VCardEntryHandler {
    public static String LOG_TAG = "VCardEntryComitter";
    private final ContentResolver mContentResolver;
    private ArrayList<Uri> mCreatedUris = new ArrayList();
    private long mTimeToCommit;

    public VCardEntryCommitter(ContentResolver contentResolver) {
        this.mContentResolver = contentResolver;
    }

    public ArrayList<Uri> getCreatedUris() {
        return this.mCreatedUris;
    }

    @Override
    public void onEnd() {
        if (VCardConfig.showPerformanceLog()) {
            String string2 = LOG_TAG;
            Object[] objectArray = new Object[]{this.mTimeToCommit};
            Log.d(string2, String.format("time to commit entries: %d ms", objectArray));
        }
    }

    @Override
    public void onEntryCreated(VCardEntry vCardEntry) {
        long l = System.currentTimeMillis();
        this.mCreatedUris.add(vCardEntry.pushIntoContentResolver(this.mContentResolver));
        this.mTimeToCommit += System.currentTimeMillis() - l;
    }

    @Override
    public void onStart() {
    }
}

