/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.accounts.Account;
import android.pim.vcard.VCardEntry;
import android.pim.vcard.VCardEntryHandler;
import android.pim.vcard.VCardInterpreter;
import android.pim.vcard.VCardUtils;
import android.text.TextUtils;
import android.util.Base64;
import android.util.CharsetUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class VCardEntryConstructor
implements VCardInterpreter {
    private static String LOG_TAG = "VCardEntryConstructor";
    private final Account mAccount;
    private VCardEntry.Property mCurrentProperty = new VCardEntry.Property();
    private VCardEntry mCurrentVCardEntry;
    private final List<VCardEntryHandler> mEntryHandlers = new ArrayList<VCardEntryHandler>();
    private String mParamType;
    private final String mSourceCharset;
    private final boolean mStrictLineBreaking;
    private long mTimePushIntoContentResolver;
    private final int mVCardType;

    public VCardEntryConstructor() {
        this(-1073741824, null);
    }

    public VCardEntryConstructor(int n) {
        this(n, null, null, false);
    }

    public VCardEntryConstructor(int n, Account account) {
        this(n, account, null, false);
    }

    public VCardEntryConstructor(int n, Account account, String string2) {
        this(n, account, string2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public VCardEntryConstructor(int n, Account account, String string2, boolean bl) {
        this.mSourceCharset = string2 != null ? string2 : "ISO-8859-1";
        this.mStrictLineBreaking = bl;
        this.mVCardType = n;
        this.mAccount = account;
    }

    private String handleOneValue(String string2, String string3, String string4, String string5) {
        if (TextUtils.isEmpty(string2)) {
            return "";
        }
        if (string5 != null) {
            if (string5.equals("BASE64") || string5.equals("B")) {
                this.mCurrentProperty.setPropertyBytes(Base64.decode(string2.getBytes(), 0));
                return string2;
            }
            if (string5.equals("QUOTED-PRINTABLE")) {
                return VCardUtils.parseQuotedPrintable(string2, this.mStrictLineBreaking, string3, string4);
            }
            Log.w(LOG_TAG, "Unknown encoding. Fall back to default.");
        }
        return VCardUtils.convertStringCharset(string2, string3, string4);
    }

    public void addEntryHandler(VCardEntryHandler vCardEntryHandler) {
        this.mEntryHandlers.add(vCardEntryHandler);
    }

    public void clear() {
        this.mCurrentVCardEntry = null;
        this.mCurrentProperty = new VCardEntry.Property();
    }

    @Override
    public void end() {
        Iterator<VCardEntryHandler> iterator = this.mEntryHandlers.iterator();
        while (iterator.hasNext()) {
            iterator.next().onEnd();
        }
    }

    @Override
    public void endEntry() {
        this.mCurrentVCardEntry.consolidateFields();
        Iterator<VCardEntryHandler> iterator = this.mEntryHandlers.iterator();
        while (iterator.hasNext()) {
            iterator.next().onEntryCreated(this.mCurrentVCardEntry);
        }
        this.mCurrentVCardEntry = null;
    }

    @Override
    public void endProperty() {
        this.mCurrentVCardEntry.addProperty(this.mCurrentProperty);
    }

    @Override
    public void propertyGroup(String string2) {
    }

    @Override
    public void propertyName(String string2) {
        this.mCurrentProperty.setPropertyName(string2);
    }

    @Override
    public void propertyParamType(String string2) {
        if (this.mParamType != null) {
            Log.e(LOG_TAG, "propertyParamType() is called more than once before propertyParamValue() is called");
        }
        this.mParamType = string2;
    }

    @Override
    public void propertyParamValue(String string2) {
        if (this.mParamType == null) {
            this.mParamType = "TYPE";
        }
        if (!VCardUtils.containsOnlyAlphaDigitHyphen(string2)) {
            string2 = VCardUtils.convertStringCharset(string2, this.mSourceCharset, "UTF-8");
        }
        this.mCurrentProperty.addParameter(this.mParamType, string2);
        this.mParamType = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void propertyValues(List<String> list) {
        if (list != null && !list.isEmpty()) {
            Collection<String> collection = this.mCurrentProperty.getParameters("CHARSET");
            Collection<String> collection2 = this.mCurrentProperty.getParameters("ENCODING");
            String string2 = collection2 != null ? collection2.iterator().next() : null;
            String string3 = collection != null ? collection.iterator().next() : null;
            String string4 = CharsetUtils.nameForDefaultVendor(string3);
            if (TextUtils.isEmpty(string4)) {
                string4 = "UTF-8";
            }
            for (String string5 : list) {
                this.mCurrentProperty.addToPropertyValueList(this.handleOneValue(string5, this.mSourceCharset, string4, string2));
            }
        }
    }

    public void showPerformanceInfo() {
        Log.d(LOG_TAG, "time for insert ContactStruct to database: " + this.mTimePushIntoContentResolver + " ms");
    }

    @Override
    public void start() {
        Iterator<VCardEntryHandler> iterator = this.mEntryHandlers.iterator();
        while (iterator.hasNext()) {
            iterator.next().onStart();
        }
    }

    @Override
    public void startEntry() {
        if (this.mCurrentVCardEntry != null) {
            Log.e(LOG_TAG, "Nested VCard code is not supported now.");
        }
        this.mCurrentVCardEntry = new VCardEntry(this.mVCardType, this.mAccount);
    }

    @Override
    public void startProperty() {
        this.mCurrentProperty.clear();
    }
}

