/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.pim.vcard.VCardConfig;
import android.pim.vcard.VCardInterpreter;
import android.pim.vcard.VCardParser_V21;
import android.pim.vcard.VCardUtils;
import android.pim.vcard.exception.VCardAgentNotSupportedException;
import android.pim.vcard.exception.VCardException;
import android.pim.vcard.exception.VCardInvalidCommentLineException;
import android.pim.vcard.exception.VCardInvalidLineException;
import android.pim.vcard.exception.VCardNestedException;
import android.pim.vcard.exception.VCardVersionException;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class VCardParserImpl_V21 {
    private static final String DEFAULT_ENCODING = "8BIT";
    private static final String LOG_TAG = "VCardParserImpl_V21";
    private static final int STATE_GROUP_OR_PROPERTY_NAME = 0;
    private static final int STATE_PARAMS = 1;
    private static final int STATE_PARAMS_IN_DQUOTE = 2;
    protected boolean mCanceled;
    protected String mCurrentEncoding;
    protected final String mIntermediateCharset;
    protected VCardInterpreter mInterpreter;
    private int mNestCount;
    private String mPreviousLine;
    protected CustomBufferedReader mReader;
    private long mTimeEndProperty;
    private long mTimeHandleBase64;
    private long mTimeHandleMiscPropertyValue;
    private long mTimeHandleQuotedPrintable;
    private long mTimeParseAdrOrgN;
    private long mTimeParseItems;
    private long mTimeParseLineAndHandleGroup;
    private long mTimeParsePropertyValues;
    private long mTimeReadEndRecord;
    private long mTimeReadStartRecord;
    private long mTimeStartProperty;
    private long mTimeTotal;
    protected final Set<String> mUnknownTypeSet = new HashSet<String>();
    protected final Set<String> mUnknownValueSet = new HashSet<String>();

    public VCardParserImpl_V21() {
        this(VCardConfig.VCARD_TYPE_DEFAULT);
    }

    public VCardParserImpl_V21(int n) {
        if ((0x1000000 & n) != 0) {
            this.mNestCount = 1;
        }
        this.mIntermediateCharset = "ISO-8859-1";
    }

    private String getQuotedPrintable(String string2) throws IOException, VCardException {
        if (string2.trim().endsWith("=")) {
            String string3;
            int n = string2.length() - 1;
            while (string2.charAt(n) != '=') {
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2.substring(0, n + 1));
            stringBuilder.append("\r\n");
            while (true) {
                if ((string3 = this.getLine()) == null) {
                    throw new VCardException("File ended during parsing a Quoted-Printable String");
                }
                if (!string3.trim().endsWith("=")) break;
                int n2 = string3.length() - 1;
                while (string3.charAt(n2) != '=') {
                }
                stringBuilder.append(string3.substring(0, n2 + 1));
                stringBuilder.append("\r\n");
            }
            stringBuilder.append(string3);
            return stringBuilder.toString();
        }
        return string2;
    }

    private boolean isAsciiLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private boolean parseOneVCard(boolean bl) throws IOException, VCardException {
        boolean bl2 = false;
        if (bl) {
            int n = this.mNestCount;
            bl2 = false;
            if (n > 0) {
                for (int i = 0; i < this.mNestCount; ++i) {
                    if (!this.readBeginVCard(bl2)) {
                        return false;
                    }
                    bl2 = true;
                }
            }
        }
        if (!this.readBeginVCard(bl2)) {
            return false;
        }
        long l = System.currentTimeMillis();
        this.mInterpreter.startEntry();
        this.mTimeReadStartRecord += System.currentTimeMillis() - l;
        long l2 = System.currentTimeMillis();
        this.parseItems();
        this.mTimeParseItems += System.currentTimeMillis() - l2;
        this.readEndVCard(true, false);
        long l3 = System.currentTimeMillis();
        this.mInterpreter.endEntry();
        this.mTimeReadEndRecord += System.currentTimeMillis() - l3;
        return true;
    }

    private void showPerformanceInfo() {
        Log.d(LOG_TAG, "Total parsing time:  " + this.mTimeTotal + " ms");
        Log.d(LOG_TAG, "Total readLine time: " + this.mReader.getTotalmillisecond() + " ms");
        Log.d(LOG_TAG, "Time for handling the beggining of the record: " + this.mTimeReadStartRecord + " ms");
        Log.d(LOG_TAG, "Time for handling the end of the record: " + this.mTimeReadEndRecord + " ms");
        Log.d(LOG_TAG, "Time for parsing line, and handling group: " + this.mTimeParseLineAndHandleGroup + " ms");
        Log.d(LOG_TAG, "Time for parsing ADR, ORG, and N fields:" + this.mTimeParseAdrOrgN + " ms");
        Log.d(LOG_TAG, "Time for parsing property values: " + this.mTimeParsePropertyValues + " ms");
        Log.d(LOG_TAG, "Time for handling normal property values: " + this.mTimeHandleMiscPropertyValue + " ms");
        Log.d(LOG_TAG, "Time for handling Quoted-Printable: " + this.mTimeHandleQuotedPrintable + " ms");
        Log.d(LOG_TAG, "Time for handling Base64: " + this.mTimeHandleBase64 + " ms");
    }

    static String unescapeCharacter(char c) {
        if (c == '\\' || c == ';' || c == ':' || c == ',') {
            return String.valueOf(c);
        }
        return null;
    }

    public final void cancel() {
        this.mCanceled = true;
    }

    protected Set<String> getAvailableEncodingSet() {
        return VCardParser_V21.sAvailableEncoding;
    }

    protected String getBase64(String string2) throws IOException, VCardException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        while (true) {
            String string3;
            if ((string3 = this.getLine()) == null) {
                throw new VCardException("File ended during parsing BASE64 binary");
            }
            if (string3.length() == 0) {
                return stringBuilder.toString();
            }
            stringBuilder.append(string3);
        }
    }

    protected String getDefaultEncoding() {
        return DEFAULT_ENCODING;
    }

    protected Set<String> getKnownPropertyNameSet() {
        return VCardParser_V21.sKnownPropertyNameSet;
    }

    protected Set<String> getKnownTypeSet() {
        return VCardParser_V21.sKnownTypeSet;
    }

    protected Set<String> getKnownValueSet() {
        return VCardParser_V21.sKnownValueSet;
    }

    protected String getLine() throws IOException {
        return this.mReader.readLine();
    }

    protected String getNonEmptyLine() throws IOException, VCardException {
        String string2;
        do {
            if ((string2 = this.getLine()) != null) continue;
            throw new VCardException("Reached end of buffer.");
        } while (string2.trim().length() <= 0);
        return string2;
    }

    protected int getVersion() {
        return 0;
    }

    protected String getVersionString() {
        return "2.1";
    }

    protected void handleAgent(String string2) throws VCardException {
        if (!string2.toUpperCase().contains("BEGIN:VCARD")) {
            return;
        }
        throw new VCardAgentNotSupportedException("AGENT Property is not supported now.");
    }

    protected void handleAnyParam(String string2, String string3) {
        this.mInterpreter.propertyParamType(string2);
        this.mInterpreter.propertyParamValue(string3);
    }

    protected void handleCharset(String string2) {
        this.mInterpreter.propertyParamType("CHARSET");
        this.mInterpreter.propertyParamValue(string2);
    }

    protected void handleEncoding(String string2) throws VCardException {
        if (this.getAvailableEncodingSet().contains(string2) || string2.startsWith("X-")) {
            this.mInterpreter.propertyParamType("ENCODING");
            this.mInterpreter.propertyParamValue(string2);
            this.mCurrentEncoding = string2;
            return;
        }
        throw new VCardException("Unknown encoding \"" + string2 + "\"");
    }

    protected void handleLanguage(String string2) throws VCardException {
        String[] stringArray = string2.split("-");
        if (stringArray.length != 2) {
            throw new VCardException("Invalid Language: \"" + string2 + "\"");
        }
        String string3 = stringArray[0];
        int n = string3.length();
        for (int i = 0; i < n; ++i) {
            if (this.isAsciiLetter(string3.charAt(i))) continue;
            throw new VCardException("Invalid Language: \"" + string2 + "\"");
        }
        String string4 = stringArray[1];
        int n2 = string4.length();
        for (int i = 0; i < n2; ++i) {
            if (this.isAsciiLetter(string4.charAt(i))) continue;
            throw new VCardException("Invalid Language: \"" + string2 + "\"");
        }
        this.mInterpreter.propertyParamType("LANGUAGE");
        this.mInterpreter.propertyParamValue(string2);
    }

    protected void handleMultiplePropertyValue(String string2, String string3) throws IOException, VCardException {
        if (this.mCurrentEncoding.equalsIgnoreCase("QUOTED-PRINTABLE")) {
            string3 = this.getQuotedPrintable(string3);
        }
        this.mInterpreter.propertyValues(VCardUtils.constructListFromValue(string3, this.getVersion()));
    }

    protected void handleParamWithoutName(String string2) throws VCardException {
        this.handleType(string2);
    }

    protected void handleParams(String string2) throws VCardException {
        String[] stringArray = string2.split("=", 2);
        if (stringArray.length == 2) {
            String string3 = stringArray[0].trim().toUpperCase();
            String string4 = stringArray[1].trim();
            if (string3.equals("TYPE")) {
                this.handleType(string4);
                return;
            }
            if (string3.equals("VALUE")) {
                this.handleValue(string4);
                return;
            }
            if (string3.equals("ENCODING")) {
                this.handleEncoding(string4);
                return;
            }
            if (string3.equals("CHARSET")) {
                this.handleCharset(string4);
                return;
            }
            if (string3.equals("LANGUAGE")) {
                this.handleLanguage(string4);
                return;
            }
            if (string3.startsWith("X-")) {
                this.handleAnyParam(string3, string4);
                return;
            }
            throw new VCardException("Unknown type \"" + string3 + "\"");
        }
        this.handleParamWithoutName(stringArray[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePropertyValue(String string2, String string3) throws IOException, VCardException {
        String string4 = this.mCurrentEncoding.toUpperCase();
        if (string4.equals("QUOTED-PRINTABLE")) {
            long l = System.currentTimeMillis();
            String string5 = this.getQuotedPrintable(string3);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string5);
            this.mInterpreter.propertyValues(arrayList);
            this.mTimeHandleQuotedPrintable += System.currentTimeMillis() - l;
            return;
        }
        if (string4.equals("BASE64") || string4.equals("B")) {
            long l = System.currentTimeMillis();
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(this.getBase64(string3));
                this.mInterpreter.propertyValues(arrayList);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.e(LOG_TAG, "OutOfMemoryError happened during parsing BASE64 data!");
                this.mInterpreter.propertyValues(null);
            }
            this.mTimeHandleBase64 += System.currentTimeMillis() - l;
            return;
        }
        if (!(string4.equals("7BIT") || string4.equals(DEFAULT_ENCODING) || string4.startsWith("X-"))) {
            Object[] objectArray = new Object[]{this.mCurrentEncoding, this.getVersionString()};
            Log.w(LOG_TAG, String.format("The encoding \"%s\" is unsupported by vCard %s", objectArray));
        }
        if (this.getVersion() == 0) {
            String string6;
            StringBuilder stringBuilder = null;
            while (!TextUtils.isEmpty(string6 = this.peekLine()) && string6.charAt(0) == ' ' && !"END:VCARD".contains(string6.toUpperCase())) {
                this.getLine();
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(string3);
                }
                stringBuilder.append(string6.substring(1));
            }
            if (stringBuilder != null) {
                string3 = stringBuilder.toString();
            }
        }
        long l = System.currentTimeMillis();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.maybeUnescapeText(string3));
        this.mInterpreter.propertyValues(arrayList);
        this.mTimeHandleMiscPropertyValue += System.currentTimeMillis() - l;
    }

    protected void handleType(String string2) {
        if (!(this.getKnownTypeSet().contains(string2.toUpperCase()) || string2.startsWith("X-") || this.mUnknownTypeSet.contains(string2))) {
            this.mUnknownTypeSet.add(string2);
            Object[] objectArray = new Object[]{this.getVersion(), string2};
            Log.w(LOG_TAG, String.format("TYPE unsupported by %s: ", objectArray));
        }
        this.mInterpreter.propertyParamType("TYPE");
        this.mInterpreter.propertyParamValue(string2);
    }

    protected void handleValue(String string2) {
        if (!(this.getKnownValueSet().contains(string2.toUpperCase()) || string2.startsWith("X-") || this.mUnknownValueSet.contains(string2))) {
            this.mUnknownValueSet.add(string2);
            Object[] objectArray = new Object[]{this.getVersion(), string2};
            Log.w(LOG_TAG, String.format("The value unsupported by TYPE of %s: ", objectArray));
        }
        this.mInterpreter.propertyParamType("VALUE");
        this.mInterpreter.propertyParamValue(string2);
    }

    protected boolean isValidPropertyName(String string2) {
        if (!(this.getKnownPropertyNameSet().contains(string2.toUpperCase()) || string2.startsWith("X-") || this.mUnknownTypeSet.contains(string2))) {
            this.mUnknownTypeSet.add(string2);
            Log.w(LOG_TAG, "Property name unsupported by vCard 2.1: " + string2);
        }
        return true;
    }

    protected String maybeUnescapeCharacter(char c) {
        return VCardParserImpl_V21.unescapeCharacter(c);
    }

    protected String maybeUnescapeText(String string2) {
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parse(InputStream inputStream, VCardInterpreter vCardInterpreter) throws IOException, VCardException {
        if (inputStream == null) {
            throw new NullPointerException("InputStream must not be null.");
        }
        this.mReader = new CustomBufferedReader(new InputStreamReader(inputStream, this.mIntermediateCharset));
        VCardInterpreter vCardInterpreter2 = vCardInterpreter != null ? vCardInterpreter : new EmptyInterpreter();
        this.mInterpreter = vCardInterpreter2;
        long l = System.currentTimeMillis();
        if (this.mInterpreter != null) {
            this.mInterpreter.start();
        }
        this.parseVCardFile();
        if (this.mInterpreter != null) {
            this.mInterpreter.end();
        }
        this.mTimeTotal += System.currentTimeMillis() - l;
        if (VCardConfig.showPerformanceLog()) {
            this.showPerformanceInfo();
        }
    }

    protected boolean parseItem() throws IOException, VCardException {
        this.mCurrentEncoding = DEFAULT_ENCODING;
        String string2 = this.getNonEmptyLine();
        long l = System.currentTimeMillis();
        String[] stringArray = this.separateLineAndHandleGroup(string2);
        if (stringArray == null) {
            return true;
        }
        if (stringArray.length != 2) {
            throw new VCardInvalidLineException("Invalid line \"" + string2 + "\"");
        }
        String string3 = stringArray[0].toUpperCase();
        String string4 = stringArray[1];
        this.mTimeParseLineAndHandleGroup += System.currentTimeMillis() - l;
        if (string3.equals("ADR") || string3.equals("ORG") || string3.equals("N")) {
            long l2 = System.currentTimeMillis();
            this.handleMultiplePropertyValue(string3, string4);
            this.mTimeParseAdrOrgN += System.currentTimeMillis() - l2;
            return false;
        }
        if (string3.equals("AGENT")) {
            this.handleAgent(string4);
            return false;
        }
        if (this.isValidPropertyName(string3)) {
            if (string3.equals("BEGIN")) {
                if (string4.equals("VCARD")) {
                    throw new VCardNestedException("This vCard has nested vCard data in it.");
                }
                throw new VCardException("Unknown BEGIN type: " + string4);
            }
            if (string3.equals("VERSION") && !string4.equals(this.getVersionString())) {
                throw new VCardVersionException("Incompatible version: " + string4 + " != " + this.getVersionString());
            }
            long l3 = System.currentTimeMillis();
            this.handlePropertyValue(string3, string4);
            this.mTimeParsePropertyValues += System.currentTimeMillis() - l3;
            return false;
        }
        throw new VCardException("Unknown property name: \"" + string3 + "\"");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseItems() throws IOException, VCardException {
        long l = System.currentTimeMillis();
        this.mInterpreter.startProperty();
        this.mTimeStartProperty += System.currentTimeMillis() - l;
        boolean bl = this.parseItem();
        if (!bl) {
            long l2 = System.currentTimeMillis();
            this.mInterpreter.endProperty();
            this.mTimeEndProperty += System.currentTimeMillis() - l2;
        }
        while (!bl) {
            long l3 = System.currentTimeMillis();
            this.mInterpreter.startProperty();
            this.mTimeStartProperty += System.currentTimeMillis() - l3;
            try {
                boolean bl2;
                bl = bl2 = this.parseItem();
            }
            catch (VCardInvalidCommentLineException vCardInvalidCommentLineException) {
                Log.e(LOG_TAG, "Invalid line which looks like some comment was found. Ignored.");
                bl = false;
            }
            if (bl) continue;
            long l4 = System.currentTimeMillis();
            this.mInterpreter.endProperty();
            this.mTimeEndProperty += System.currentTimeMillis() - l4;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void parseVCardFile() throws IOException, VCardException {
        boolean bl = true;
        while (!this.mCanceled && this.parseOneVCard(bl)) {
            bl = false;
        }
        if (this.mNestCount > 0) {
            boolean bl2 = true;
            for (int i = 0; i < this.mNestCount; ++i) {
                this.readEndVCard(bl2, true);
                bl2 = false;
            }
        }
    }

    protected String peekLine() throws IOException {
        return this.mReader.peekLine();
    }

    protected boolean readBeginVCard(boolean bl) throws IOException, VCardException {
        while (true) {
            String string2;
            if ((string2 = this.getLine()) == null) {
                return false;
            }
            if (string2.trim().length() <= 0) continue;
            String[] stringArray = string2.split(":", 2);
            if (stringArray.length == 2 && stringArray[0].trim().equalsIgnoreCase("BEGIN") && stringArray[1].trim().equalsIgnoreCase("VCARD")) {
                return true;
            }
            if (!bl) {
                if (this.mNestCount > 0) {
                    this.mPreviousLine = string2;
                    return false;
                }
                throw new VCardException("Expected String \"BEGIN:VCARD\" did not come (Instead, \"" + string2 + "\" came)");
            }
            if (!bl) break;
        }
        throw new VCardException("Reached where must not be reached.");
    }

    /*
     * Unable to fully structure code
     */
    protected void readEndVCard(boolean var1_1, boolean var2_2) throws IOException, VCardException {
        do {
            block5: {
                block4: {
                    if (!var1_1) break block4;
                    var3_3 = this.mPreviousLine;
lbl4:
                    // 2 sources

                    while ((var4_4 = var3_3.split(":", 2)).length == 2 && var4_4[0].trim().equalsIgnoreCase("END") && var4_4[1].trim().equalsIgnoreCase("VCARD")) {
                        return;
                    }
                    break block5;
                }
                do {
                    if ((var3_3 = this.getLine()) != null) continue;
                    throw new VCardException("Expected END:VCARD was not found.");
                } while (var3_3.trim().length() <= 0);
                ** GOTO lbl4
            }
            if (!var2_2) {
                throw new VCardException("END:VCARD != \"" + this.mPreviousLine + "\"");
            }
            var1_1 = false;
        } while (var2_2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String[] separateLineAndHandleGroup(String string2) throws VCardException {
        String[] stringArray = new String[2];
        int n = string2.length();
        if (n > 0 && string2.charAt(0) == '#') {
            throw new VCardInvalidCommentLineException();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            char c = string2.charAt(n4);
            switch (n2) {
                case 0: {
                    if (c == ':') {
                        String string3 = string2.substring(n3, n4);
                        if (string3.equalsIgnoreCase("END")) {
                            this.mPreviousLine = string2;
                            return null;
                        }
                        this.mInterpreter.propertyName(string3);
                        stringArray[0] = string3;
                        if (n4 < n - 1) {
                            stringArray[1] = string2.substring(n4 + 1);
                            return stringArray;
                        }
                        stringArray[1] = "";
                        return stringArray;
                    }
                    if (c == '.') {
                        String string4 = string2.substring(n3, n4);
                        if (string4.length() == 0) {
                            Log.w(LOG_TAG, "Empty group found. Ignoring.");
                        } else {
                            this.mInterpreter.propertyGroup(string4);
                        }
                        n3 = n4 + 1;
                        break;
                    }
                    if (c != ';') break;
                    String string5 = string2.substring(n3, n4);
                    if (string5.equalsIgnoreCase("END")) {
                        this.mPreviousLine = string2;
                        return null;
                    }
                    this.mInterpreter.propertyName(string5);
                    stringArray[0] = string5;
                    n3 = n4 + 1;
                    n2 = 1;
                    break;
                }
                case 1: {
                    if (c == '\"') {
                        if ("2.1".equalsIgnoreCase(this.getVersionString())) {
                            Log.w(LOG_TAG, "Double-quoted params found in vCard 2.1. Silently allow it");
                        }
                        n2 = 2;
                        break;
                    }
                    if (c == ';') {
                        this.handleParams(string2.substring(n3, n4));
                        n3 = n4 + 1;
                        break;
                    }
                    if (c != ':') break;
                    this.handleParams(string2.substring(n3, n4));
                    if (n4 < n - 1) {
                        stringArray[1] = string2.substring(n4 + 1);
                        return stringArray;
                    }
                    stringArray[1] = "";
                    return stringArray;
                }
                case 2: {
                    if (c != '\"') break;
                    if ("2.1".equalsIgnoreCase(this.getVersionString())) {
                        Log.w(LOG_TAG, "Double-quoted params found in vCard 2.1. Silently allow it");
                    }
                    n2 = 1;
                    break;
                }
            }
            ++n4;
        }
        throw new VCardInvalidLineException("Invalid line: \"" + string2 + "\"");
    }

    protected static final class CustomBufferedReader
    extends BufferedReader {
        private String mNextLine;
        private boolean mNextLineIsValid;
        private long mTime;

        public CustomBufferedReader(Reader reader) {
            super(reader);
        }

        public long getTotalmillisecond() {
            return this.mTime;
        }

        public String peekLine() throws IOException {
            if (!this.mNextLineIsValid) {
                long l = System.currentTimeMillis();
                String string2 = super.readLine();
                long l2 = System.currentTimeMillis();
                this.mTime += l2 - l;
                this.mNextLine = string2;
                this.mNextLineIsValid = true;
            }
            return this.mNextLine;
        }

        @Override
        public String readLine() throws IOException {
            if (this.mNextLineIsValid) {
                String string2 = this.mNextLine;
                this.mNextLine = null;
                this.mNextLineIsValid = false;
                return string2;
            }
            long l = System.currentTimeMillis();
            String string3 = super.readLine();
            long l2 = System.currentTimeMillis();
            this.mTime += l2 - l;
            return string3;
        }
    }

    private static final class EmptyInterpreter
    implements VCardInterpreter {
        private EmptyInterpreter() {
        }

        @Override
        public void end() {
        }

        @Override
        public void endEntry() {
        }

        @Override
        public void endProperty() {
        }

        @Override
        public void propertyGroup(String string2) {
        }

        @Override
        public void propertyName(String string2) {
        }

        @Override
        public void propertyParamType(String string2) {
        }

        @Override
        public void propertyParamValue(String string2) {
        }

        @Override
        public void propertyValues(List<String> list) {
        }

        @Override
        public void start() {
        }

        @Override
        public void startEntry() {
        }

        @Override
        public void startProperty() {
        }
    }
}

