/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.pim.vcard.VCardParserImpl_V21;
import android.pim.vcard.VCardParser_V30;
import android.pim.vcard.exception.VCardException;
import android.util.Log;
import java.io.IOException;
import java.util.Set;

class VCardParserImpl_V30
extends VCardParserImpl_V21 {
    private static final String LOG_TAG = "VCardParserImpl_V30";
    private boolean mEmittedAgentWarning = false;
    private String mPreviousLine;

    public VCardParserImpl_V30() {
    }

    public VCardParserImpl_V30(int n) {
        super(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void splitAndPutParamValue(String string2) {
        StringBuilder stringBuilder = null;
        boolean bl = false;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '\"') {
                if (bl) {
                    this.mInterpreter.propertyParamValue(stringBuilder.toString());
                    stringBuilder = null;
                    bl = false;
                    continue;
                }
                if (stringBuilder != null) {
                    if (stringBuilder.length() > 0) {
                        Log.w(LOG_TAG, "Unexpected Dquote inside property.");
                    } else {
                        this.mInterpreter.propertyParamValue(stringBuilder.toString());
                    }
                }
                bl = true;
                continue;
            }
            if (c == ',' && !bl) {
                if (stringBuilder == null) {
                    Log.w(LOG_TAG, "Comma is used before actual string comes. (" + string2 + ")");
                    continue;
                }
                this.mInterpreter.propertyParamValue(stringBuilder.toString());
                stringBuilder = null;
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(c);
        }
        if (bl) {
            Log.d(LOG_TAG, "Dangling Dquote.");
        }
        if (stringBuilder != null) {
            if (stringBuilder.length() != 0) {
                this.mInterpreter.propertyParamValue(stringBuilder.toString());
                return;
            }
            Log.w(LOG_TAG, "Unintended behavior. We must not see empty StringBuilder at the end of parameter value parsing.");
        }
    }

    public static String unescapeCharacter(char c) {
        if (c == 'n' || c == 'N') {
            return "\n";
        }
        return String.valueOf(c);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String unescapeText(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c == '\\' && n2 < n - 1) {
                char c2;
                if ((c2 = string2.charAt(++n2)) == 'n' || c2 == 'N') {
                    stringBuilder.append("\n");
                } else {
                    stringBuilder.append(c2);
                }
            } else {
                stringBuilder.append(c);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String getBase64(String string2) throws IOException, VCardException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        while (true) {
            String string3;
            if ((string3 = this.getLine()) == null) {
                throw new VCardException("File ended during parsing BASE64 binary");
            }
            if (string3.length() == 0) {
                return stringBuilder.toString();
            }
            if (!string3.startsWith(" ") && !string3.startsWith("\t")) {
                this.mPreviousLine = string3;
                return stringBuilder.toString();
            }
            stringBuilder.append(string3);
        }
    }

    @Override
    protected Set<String> getKnownPropertyNameSet() {
        return VCardParser_V30.sKnownPropertyNameSet;
    }

    @Override
    protected String getLine() throws IOException {
        if (this.mPreviousLine != null) {
            String string2 = this.mPreviousLine;
            this.mPreviousLine = null;
            return string2;
        }
        return this.mReader.readLine();
    }

    @Override
    protected String getNonEmptyLine() throws IOException, VCardException {
        String string2;
        block9: {
            StringBuilder stringBuilder = null;
            while (true) {
                if ((string2 = this.mReader.readLine()) == null) {
                    if (stringBuilder != null) {
                        return stringBuilder.toString();
                    }
                    if (this.mPreviousLine != null) {
                        String string3 = this.mPreviousLine;
                        this.mPreviousLine = null;
                        return string3;
                    }
                    throw new VCardException("Reached end of buffer.");
                }
                if (string2.length() == 0) {
                    if (stringBuilder != null) {
                        return stringBuilder.toString();
                    }
                    if (this.mPreviousLine == null) continue;
                    String string4 = this.mPreviousLine;
                    this.mPreviousLine = null;
                    return string4;
                }
                if (string2.charAt(0) == ' ' || string2.charAt(0) == '\t') {
                    if (stringBuilder != null) {
                        stringBuilder.append(string2.substring(1));
                        continue;
                    }
                    if (this.mPreviousLine != null) {
                        stringBuilder = new StringBuilder();
                        stringBuilder.append(this.mPreviousLine);
                        this.mPreviousLine = null;
                        stringBuilder.append(string2.substring(1));
                        continue;
                    }
                    throw new VCardException("Space exists at the beginning of the line");
                }
                if (this.mPreviousLine != null) break block9;
                this.mPreviousLine = string2;
                if (stringBuilder != null) break;
            }
            return stringBuilder.toString();
        }
        String string5 = this.mPreviousLine;
        this.mPreviousLine = string2;
        return string5;
    }

    @Override
    protected int getVersion() {
        return 1;
    }

    @Override
    protected String getVersionString() {
        return "3.0";
    }

    @Override
    protected void handleAgent(String string2) {
        if (!this.mEmittedAgentWarning) {
            Log.w(LOG_TAG, "AGENT in vCard 3.0 is not supported yet. Ignore it");
            this.mEmittedAgentWarning = true;
        }
    }

    @Override
    protected void handleAnyParam(String string2, String string3) {
        this.mInterpreter.propertyParamType(string2);
        this.splitAndPutParamValue(string3);
    }

    @Override
    protected void handleParamWithoutName(String string2) {
        this.handleType(string2);
    }

    @Override
    protected void handleParams(String string2) throws VCardException {
        try {
            super.handleParams(string2);
            return;
        }
        catch (VCardException vCardException) {
            String[] stringArray = string2.split("=", 2);
            if (stringArray.length == 2) {
                this.handleAnyParam(stringArray[0], stringArray[1]);
                return;
            }
            throw new VCardException("Unknown params value: " + string2);
        }
    }

    @Override
    protected void handleType(String string2) {
        this.mInterpreter.propertyParamType("TYPE");
        this.splitAndPutParamValue(string2);
    }

    @Override
    protected String maybeUnescapeCharacter(char c) {
        return VCardParserImpl_V30.unescapeCharacter(c);
    }

    @Override
    protected String maybeUnescapeText(String string2) {
        return VCardParserImpl_V30.unescapeText(string2);
    }

    @Override
    protected boolean readBeginVCard(boolean bl) throws IOException, VCardException {
        return super.readBeginVCard(bl);
    }

    @Override
    protected void readEndVCard(boolean bl, boolean bl2) throws IOException, VCardException {
        super.readEndVCard(bl, bl2);
    }
}

