/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.pim.vcard.VCardInterpreter;
import android.text.TextUtils;
import android.util.Log;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VCardSourceDetector
implements VCardInterpreter {
    private static Set<String> APPLE_SIGNS = new HashSet<String>(Arrays.asList("X-PHONETIC-FIRST-NAME", "X-PHONETIC-MIDDLE-NAME", "X-PHONETIC-LAST-NAME", "X-ABADR", "X-ABUID"));
    private static Set<String> FOMA_SIGNS;
    private static Set<String> JAPANESE_MOBILE_PHONE_SIGNS;
    private static final String LOG_TAG = "VCardSourceDetector";
    private static final int PARSE_TYPE_APPLE = 1;
    private static final int PARSE_TYPE_DOCOMO_TORELATE_NEST = 3;
    private static final int PARSE_TYPE_MOBILE_PHONE_JP = 2;
    public static final int PARSE_TYPE_UNKNOWN = 0;
    private static final int PARSE_TYPE_WINDOWS_MOBILE_V65_JP = 4;
    private static String TYPE_FOMA_CHARSET_SIGN;
    private static Set<String> WINDOWS_MOBILE_PHONE_SIGNS;
    private boolean mNeedToParseCharset;
    private boolean mNeedToParseVersion = false;
    private int mParseType = 0;
    private String mSpecifiedCharset;
    private int mVersion = -1;

    static {
        JAPANESE_MOBILE_PHONE_SIGNS = new HashSet<String>(Arrays.asList("X-GNO", "X-GN", "X-REDUCTION"));
        WINDOWS_MOBILE_PHONE_SIGNS = new HashSet<String>(Arrays.asList("X-MICROSOFT-ASST_TEL", "X-MICROSOFT-ASSISTANT", "X-MICROSOFT-OFFICELOC"));
        FOMA_SIGNS = new HashSet<String>(Arrays.asList("X-SD-VERN", "X-SD-FORMAT_VER", "X-SD-CATEGORIES", "X-SD-CLASS", "X-SD-DCREATED", "X-SD-DESCRIPTION"));
        TYPE_FOMA_CHARSET_SIGN = "X-SD-CHAR_CODE";
    }

    @Override
    public void end() {
    }

    @Override
    public void endEntry() {
    }

    @Override
    public void endProperty() {
    }

    public String getEstimatedCharset() {
        if (TextUtils.isEmpty(this.mSpecifiedCharset)) {
            return this.mSpecifiedCharset;
        }
        switch (this.mParseType) {
            default: {
                return null;
            }
            case 2: 
            case 3: 
            case 4: {
                return "SHIFT_JIS";
            }
            case 1: 
        }
        return "UTF-8";
    }

    public int getEstimatedType() {
        switch (this.mParseType) {
            default: {
                if (this.mVersion != 0) break;
                return -1073741824;
            }
            case 3: {
                return 956301320;
            }
            case 2: {
                return 0x18000008;
            }
        }
        if (this.mVersion == 1) {
            return -1073741823;
        }
        if (this.mVersion == 2) {
            return -1073741822;
        }
        return 0;
    }

    @Override
    public void propertyGroup(String string2) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void propertyName(String string2) {
        if (string2.equalsIgnoreCase("VERSION")) {
            this.mNeedToParseVersion = true;
            return;
        } else {
            if (string2.equalsIgnoreCase(TYPE_FOMA_CHARSET_SIGN)) {
                this.mParseType = 3;
                this.mNeedToParseCharset = true;
                return;
            }
            if (this.mParseType != 0) return;
            if (WINDOWS_MOBILE_PHONE_SIGNS.contains(string2)) {
                this.mParseType = 4;
                return;
            }
            if (FOMA_SIGNS.contains(string2)) {
                this.mParseType = 3;
                return;
            }
            if (JAPANESE_MOBILE_PHONE_SIGNS.contains(string2)) {
                this.mParseType = 2;
                return;
            }
            if (!APPLE_SIGNS.contains(string2)) return;
            this.mParseType = 1;
            return;
        }
    }

    @Override
    public void propertyParamType(String string2) {
    }

    @Override
    public void propertyParamValue(String string2) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void propertyValues(List<String> list) {
        if (this.mNeedToParseVersion && list.size() > 0) {
            String string2 = list.get(0);
            if (string2.equals("2.1")) {
                this.mVersion = 0;
                return;
            } else {
                if (string2.equals("3.0")) {
                    this.mVersion = 1;
                    return;
                }
                if (string2.equals("4.0")) {
                    this.mVersion = 2;
                    return;
                }
                Log.w(LOG_TAG, "Invalid version string: " + string2);
                return;
            }
        }
        if (!this.mNeedToParseCharset || list.size() <= 0) return;
        this.mSpecifiedCharset = list.get(0);
    }

    @Override
    public void start() {
    }

    @Override
    public void startEntry() {
    }

    @Override
    public void startProperty() {
        this.mNeedToParseCharset = false;
        this.mNeedToParseVersion = false;
    }
}

