/*
 * Decompiled with CFR 0.152.
 */
package android.pim.vcard;

import android.content.ContentProviderOperation;
import android.pim.vcard.JapaneseUtils;
import android.pim.vcard.VCardConfig;
import android.pim.vcard.VCardEntry;
import android.pim.vcard.VCardParser;
import android.pim.vcard.VCardParserImpl_V21;
import android.pim.vcard.VCardParserImpl_V30;
import android.pim.vcard.VCardParserImpl_V40;
import android.pim.vcard.VCardParser_V21;
import android.pim.vcard.VCardParser_V30;
import android.pim.vcard.VCardParser_V40;
import android.pim.vcard.exception.VCardException;
import android.text.TextUtils;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.QuotedPrintableCodec;

public class VCardUtils {
    private static final String LOG_TAG = "VCardUtils";
    private static final int[] sEscapeIndicatorsV30;
    private static final int[] sEscapeIndicatorsV40;
    private static final Map<Integer, String> sKnownImPropNameMap_ItoS;
    private static final Map<String, Integer> sKnownPhoneTypeMap_StoI;
    private static final Map<Integer, String> sKnownPhoneTypesMap_ItoS;
    private static final Set<String> sMobilePhoneLabelSet;
    private static final Set<String> sPhoneTypesUnknownToContactsSet;
    private static final Set<Character> sUnAcceptableAsciiInV21WordSet;

    static {
        sKnownPhoneTypesMap_ItoS = new HashMap<Integer, String>();
        sKnownPhoneTypeMap_StoI = new HashMap<String, Integer>();
        sKnownPhoneTypesMap_ItoS.put(9, "CAR");
        sKnownPhoneTypeMap_StoI.put("CAR", 9);
        sKnownPhoneTypesMap_ItoS.put(6, "PAGER");
        sKnownPhoneTypeMap_StoI.put("PAGER", 6);
        sKnownPhoneTypesMap_ItoS.put(11, "ISDN");
        sKnownPhoneTypeMap_StoI.put("ISDN", 11);
        sKnownPhoneTypeMap_StoI.put("HOME", 1);
        sKnownPhoneTypeMap_StoI.put("WORK", 3);
        sKnownPhoneTypeMap_StoI.put("CELL", 2);
        sKnownPhoneTypeMap_StoI.put("OTHER", 7);
        sKnownPhoneTypeMap_StoI.put("CALLBACK", 8);
        sKnownPhoneTypeMap_StoI.put("COMPANY-MAIN", 10);
        sKnownPhoneTypeMap_StoI.put("RADIO", 14);
        sKnownPhoneTypeMap_StoI.put("TTY-TDD", 16);
        sKnownPhoneTypeMap_StoI.put("ASSISTANT", 19);
        sPhoneTypesUnknownToContactsSet = new HashSet<String>();
        sPhoneTypesUnknownToContactsSet.add("MODEM");
        sPhoneTypesUnknownToContactsSet.add("MSG");
        sPhoneTypesUnknownToContactsSet.add("BBS");
        sPhoneTypesUnknownToContactsSet.add("VIDEO");
        sKnownImPropNameMap_ItoS = new HashMap<Integer, String>();
        sKnownImPropNameMap_ItoS.put(0, "X-AIM");
        sKnownImPropNameMap_ItoS.put(1, "X-MSN");
        sKnownImPropNameMap_ItoS.put(2, "X-YAHOO");
        sKnownImPropNameMap_ItoS.put(3, "X-SKYPE-USERNAME");
        sKnownImPropNameMap_ItoS.put(5, "X-GOOGLE-TALK");
        sKnownImPropNameMap_ItoS.put(6, "X-ICQ");
        sKnownImPropNameMap_ItoS.put(7, "X-JABBER");
        sKnownImPropNameMap_ItoS.put(4, "X-QQ");
        sKnownImPropNameMap_ItoS.put(8, "X-NETMEETING");
        sMobilePhoneLabelSet = new HashSet<String>(Arrays.asList("MOBILE", "\u643a\u5e2f\u96fb\u8a71", "\u643a\u5e2f", "\u30b1\u30a4\u30bf\u30a4", "\uff79\uff72\uff80\uff72"));
        Character[] characterArray = new Character[]{Character.valueOf('['), Character.valueOf(']'), Character.valueOf('='), Character.valueOf(':'), Character.valueOf('.'), Character.valueOf(','), Character.valueOf(' ')};
        sUnAcceptableAsciiInV21WordSet = new HashSet<Character>(Arrays.asList(characterArray));
        sEscapeIndicatorsV30 = new int[]{58, 59, 44, 32};
        sEscapeIndicatorsV40 = new int[]{59, 58};
    }

    private VCardUtils() {
    }

    public static boolean areAllEmpty(String ... stringArray) {
        if (stringArray == null) {
            return true;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (TextUtils.isEmpty(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<String> constructListFromValue(String string2, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string2.length();
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                arrayList.add(stringBuilder.toString());
                return arrayList;
            }
            char c = string2.charAt(n3);
            if (c == '\\' && n3 < n2 - 1) {
                String string3;
                char c2 = string2.charAt(n3 + 1);
                if (VCardConfig.isVersion40(n)) {
                    string3 = VCardParserImpl_V40.unescapeCharacter(c2);
                } else if (VCardConfig.isVersion30(n)) {
                    string3 = VCardParserImpl_V30.unescapeCharacter(c2);
                } else {
                    if (!VCardConfig.isVersion21(n)) {
                        Log.w(LOG_TAG, "Unknown vCard type");
                    }
                    string3 = VCardParserImpl_V21.unescapeCharacter(c2);
                }
                if (string3 != null) {
                    stringBuilder.append(string3);
                    ++n3;
                } else {
                    stringBuilder.append(c);
                }
            } else if (c == ';') {
                arrayList.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
            } else {
                stringBuilder.append(c);
            }
            ++n3;
        }
    }

    public static String constructNameFromElements(int n, String string2, String string3, String string4) {
        return VCardUtils.constructNameFromElements(n, string2, string3, string4, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String constructNameFromElements(int n, String string2, String string3, String string4, String string5, String string6) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = VCardUtils.sortNameElements(n, string2, string3, string4);
        boolean bl = true;
        if (!TextUtils.isEmpty(string5)) {
            bl = false;
            stringBuilder.append(string5);
        }
        for (String string7 : stringArray) {
            if (TextUtils.isEmpty(string7)) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string7);
        }
        if (!TextUtils.isEmpty(string6)) {
            if (!bl) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string6);
        }
        return stringBuilder.toString();
    }

    public static boolean containsOnlyAlphaDigitHyphen(Collection<String> collection) {
        if (collection == null) {
            return true;
        }
        for (String string2 : collection) {
            if (TextUtils.isEmpty(string2)) continue;
            int n = string2.length();
            int n2 = 0;
            while (n2 < n) {
                int n3 = string2.codePointAt(n2);
                if (!(97 <= n3 && n3 < 123 || 65 <= n3 && n3 < 91 || 48 <= n3 && n3 < 58 || n3 == 45)) {
                    return false;
                }
                n2 = string2.offsetByCodePoints(n2, 1);
            }
        }
        return true;
    }

    public static boolean containsOnlyAlphaDigitHyphen(String ... stringArray) {
        if (stringArray == null) {
            return true;
        }
        return VCardUtils.containsOnlyAlphaDigitHyphen(Arrays.asList(stringArray));
    }

    public static boolean containsOnlyNonCrLfPrintableAscii(Collection<String> collection) {
        if (collection == null) {
            return true;
        }
        for (String string2 : collection) {
            if (TextUtils.isEmpty(string2)) continue;
            int n = string2.length();
            int n2 = 0;
            while (n2 < n) {
                int n3 = string2.codePointAt(n2);
                if (32 > n3 || n3 > 126) {
                    return false;
                }
                n2 = string2.offsetByCodePoints(n2, 1);
            }
        }
        return true;
    }

    public static boolean containsOnlyNonCrLfPrintableAscii(String ... stringArray) {
        if (stringArray == null) {
            return true;
        }
        return VCardUtils.containsOnlyNonCrLfPrintableAscii(Arrays.asList(stringArray));
    }

    public static boolean containsOnlyPrintableAscii(Collection<String> collection) {
        if (collection == null) {
            return true;
        }
        for (String string2 : collection) {
            if (TextUtils.isEmpty(string2) || TextUtils.isPrintableAsciiOnly((CharSequence)string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsOnlyPrintableAscii(String ... stringArray) {
        if (stringArray == null) {
            return true;
        }
        return VCardUtils.containsOnlyPrintableAscii(Arrays.asList(stringArray));
    }

    public static boolean containsOnlyWhiteSpaces(Collection<String> collection) {
        if (collection == null) {
            return true;
        }
        for (String string2 : collection) {
            if (TextUtils.isEmpty(string2)) continue;
            int n = string2.length();
            int n2 = 0;
            while (n2 < n) {
                if (!Character.isWhitespace(string2.codePointAt(n2))) {
                    return false;
                }
                n2 = string2.offsetByCodePoints(n2, 1);
            }
        }
        return true;
    }

    public static boolean containsOnlyWhiteSpaces(String ... stringArray) {
        if (stringArray == null) {
            return true;
        }
        return VCardUtils.containsOnlyWhiteSpaces(Arrays.asList(stringArray));
    }

    public static final String convertStringCharset(String string2, String string3, String string4) {
        if (string3.equalsIgnoreCase(string4)) {
            return string2;
        }
        ByteBuffer byteBuffer = Charset.forName(string3).encode(string2);
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        try {
            String string5 = new String(byArray, string4);
            return string5;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e(LOG_TAG, "Failed to encode: charset=" + string4);
            return null;
        }
    }

    public static final VCardParser getAppropriateParser(int n) throws VCardException {
        if (VCardConfig.isVersion21(n)) {
            return new VCardParser_V21();
        }
        if (VCardConfig.isVersion30(n)) {
            return new VCardParser_V30();
        }
        if (VCardConfig.isVersion40(n)) {
            return new VCardParser_V40();
        }
        throw new VCardException("Version is not specified");
    }

    public static int getPhoneNumberFormat(int n) {
        if (VCardConfig.isJapaneseDevice(n)) {
            return 2;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object getPhoneTypeFromStrings(Collection<String> collection, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        int n = -1;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = null;
        if (collection != null) {
            for (String string4 : collection) {
                if (string4 == null) continue;
                String string5 = string4.toUpperCase();
                if (string5.equals("PREF")) {
                    bl = true;
                    continue;
                }
                if (string5.equals("FAX")) {
                    bl2 = true;
                    continue;
                }
                if (string5.startsWith("X-") && n < 0) {
                    string5 = string5.substring(2);
                }
                if (string5.length() == 0) continue;
                Integer n2 = sKnownPhoneTypeMap_StoI.get(string5);
                if (n2 != null) {
                    int n3 = n2;
                    int n4 = string2.indexOf("@");
                    if ((n3 != 6 || n4 <= 0 || n4 >= string2.length() - 1) && n >= 0 && n != 0) continue;
                    n = n2;
                    continue;
                }
                if (n >= 0) continue;
                string3 = string5;
                n = 0;
            }
        }
        if (n < 0) {
            n = bl ? 12 : 1;
        }
        if (bl2) {
            if (n == 1) {
                n = 5;
            } else if (n == 3) {
                n = 4;
            } else if (n == 7) {
                n = 13;
            }
        }
        if (n == 0) {
            return string3;
        }
        return n;
    }

    public static String getPhoneTypeString(Integer n) {
        return sKnownPhoneTypesMap_ItoS.get(n);
    }

    public static String getPropertyNameForIm(int n) {
        return sKnownImPropNameMap_ItoS.get(n);
    }

    public static String guessImageType(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length >= 3 && byArray[0] == 71 && byArray[1] == 73 && byArray[2] == 70) {
            return "GIF";
        }
        if (byArray.length >= 4 && byArray[0] == -119 && byArray[1] == 80 && byArray[2] == 78 && byArray[3] == 71) {
            return "PNG";
        }
        if (byArray.length >= 2 && byArray[0] == -1 && byArray[1] == -40) {
            return "JPEG";
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void insertStructuredPostalDataUsingContactsStruct(int n, ContentProviderOperation.Builder builder, VCardEntry.PostalData postalData) {
        builder.withValueBackReference("raw_contact_id", 0);
        builder.withValue("mimetype", "vnd.android.cursor.item/postal-address_v2");
        builder.withValue("data2", postalData.type);
        if (postalData.type == 0) {
            builder.withValue("data3", postalData.label);
        }
        String string2 = TextUtils.isEmpty(postalData.street) ? (TextUtils.isEmpty(postalData.extendedAddress) ? null : postalData.extendedAddress) : (TextUtils.isEmpty(postalData.extendedAddress) ? postalData.street : postalData.street + " " + postalData.extendedAddress);
        builder.withValue("data5", postalData.pobox);
        builder.withValue("data4", string2);
        builder.withValue("data7", postalData.localty);
        builder.withValue("data8", postalData.region);
        builder.withValue("data9", postalData.postalCode);
        builder.withValue("data10", postalData.country);
        builder.withValue("data1", postalData.getFormattedAddress(n));
        if (postalData.isPrimary) {
            builder.withValue("is_primary", 1);
        }
    }

    public static boolean isMobilePhoneLabel(String string2) {
        return "_AUTO_CELL".equals(string2) || sMobilePhoneLabelSet.contains(string2);
    }

    public static boolean isV21Word(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return true;
        }
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string2.codePointAt(n2);
            if (32 > n3 || n3 > 126 || sUnAcceptableAsciiInV21WordSet.contains(Character.valueOf((char)n3))) {
                return false;
            }
            n2 = string2.offsetByCodePoints(n2, 1);
        }
        return true;
    }

    public static boolean isValidInV21ButUnknownToContactsPhoteType(String string2) {
        return sPhoneTypesUnknownToContactsSet.contains(string2);
    }

    /*
     * Unable to fully structure code
     */
    public static String parseQuotedPrintable(String var0, boolean var1_1, String var2_2, String var3_3) {
        block20: {
            var4_4 = new StringBuilder();
            var5_5 = var0.length();
            var6_6 = 0;
            block6: while (var6_6 < var5_5) {
                var39_7 = var0.charAt(var6_6);
                if (var39_7 == '=' && var6_6 < var5_5 - 1 && ((var42_9 = var0.charAt(var6_6 + 1)) == ' ' || var42_9 == '\t')) {
                    var4_4.append(var42_9);
                    var41_8 = var6_6 + 1;
lbl10:
                    // 2 sources

                    while (true) {
                        var6_6 = var41_8 + 1;
                        continue block6;
                        break;
                    }
                }
                var4_4.append(var39_7);
                var41_8 = var6_6;
                ** continue;
            }
            var7_10 = var4_4.toString();
            if (var1_1) {
                var13_11 = var7_10.split("\r\n");
lbl20:
                // 2 sources

                while (true) {
                    var14_19 = new StringBuilder();
                    for (String var31_23 : var13_11) {
                        if (var31_23.endsWith("=")) {
                            var31_23 = var31_23.substring(0, var31_23.length() - 1);
                        }
                        var14_19.append(var31_23);
                    }
                    break block20;
                    break;
                }
            }
            var8_14 = new StringBuilder();
            var9_15 = var7_10.length();
            var10_16 = new ArrayList<String>();
            var11_17 = 0;
            block10: while (var11_17 < var9_15) {
                block22: {
                    block21: {
                        var34_12 = var7_10.charAt(var11_17);
                        if (var34_12 == '\n') {
                            var10_16.add(var8_14.toString());
                            var8_14 = new StringBuilder();
                            var36_13 = var11_17;
lbl40:
                            // 3 sources

                            while (true) {
                                var11_17 = var36_13 + 1;
                                continue block10;
                                break;
                            }
                        }
                        if (var34_12 != '\r') break block21;
                        var10_16.add(var8_14.toString());
                        var8_14 = new StringBuilder();
                        if (var11_17 >= var9_15 - 1 || var7_10.charAt(var11_17 + 1) != '\n') break block22;
                        var36_13 = var11_17 + 1;
                        ** GOTO lbl40
                    }
                    var8_14.append(var34_12);
                }
                var36_13 = var11_17;
                ** continue;
            }
            var12_18 = var8_14.toString();
            if (var12_18.length() > 0) {
                var10_16.add(var12_18);
            }
            var13_11 = var10_16.toArray(new String[0]);
            ** while (true)
        }
        var18_24 = var14_19.toString();
        if (TextUtils.isEmpty(var18_24)) {
            Log.w("VCardUtils", "Given raw string is empty.");
        }
        try {
            var21_26 = var29_25 = var18_24.getBytes(var2_2);
        }
        catch (UnsupportedEncodingException var19_30) {
            Log.w("VCardUtils", "Failed to decode: " + var2_2);
            var21_26 = var18_24.getBytes();
            ** continue;
        }
lbl69:
        // 2 sources

        while (true) {
            var24_28 = var28_27 = QuotedPrintableCodec.decodeQuotedPrintable((byte[])var21_26);
lbl72:
            // 2 sources

            while (true) {
                var25_29 = new String(var24_28, var3_3);
                return var25_29;
                break;
            }
            break;
        }
        catch (DecoderException var22_31) {
            Log.e("VCardUtils", "DecoderException is thrown.");
            var24_28 = var21_26;
            ** continue;
        }
        catch (UnsupportedEncodingException var26_32) {
            Log.e("VCardUtils", "Failed to encode: charset=" + var3_3);
            return new String(var24_28);
        }
    }

    public static String[] sortNameElements(int n, String string2, String string3, String string4) {
        String[] stringArray = new String[3];
        switch (VCardConfig.getNameOrderType(n)) {
            default: {
                stringArray[0] = string4;
                stringArray[1] = string3;
                stringArray[2] = string2;
                return stringArray;
            }
            case 8: {
                if (VCardUtils.containsOnlyPrintableAscii(string2) && VCardUtils.containsOnlyPrintableAscii(string4)) {
                    stringArray[0] = string4;
                    stringArray[1] = string3;
                    stringArray[2] = string2;
                    return stringArray;
                }
                stringArray[0] = string2;
                stringArray[1] = string3;
                stringArray[2] = string4;
                return stringArray;
            }
            case 4: 
        }
        stringArray[0] = string3;
        stringArray[1] = string4;
        stringArray[2] = string2;
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String toHalfWidthString(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            String string3 = JapaneseUtils.tryGetHalfWidthText(c);
            if (string3 != null) {
                stringBuilder.append(string3);
            } else {
                stringBuilder.append(c);
            }
            n2 = string2.offsetByCodePoints(n2, 1);
        }
        return stringBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static String toStringAsParamValue(String var0, int[] var1_1) {
        block7: {
            if (TextUtils.isEmpty(var0)) {
                var0 = "";
            }
            var2_2 = new StringBuilder();
            var3_3 = var0.length();
            var4_4 = 0;
            var5_5 = false;
            block0: while (var4_4 < var3_3) {
                var7_6 = var0.codePointAt(var4_4);
                if (var7_6 < 32) break block7;
                if (var7_6 == 34) {
                    var8_7 = var5_5;
lbl12:
                    // 3 sources

                    while (true) {
                        var4_4 = var0.offsetByCodePoints(var4_4, 1);
                        var5_5 = var8_7;
                        continue block0;
                        break;
                    }
                }
                var2_2.appendCodePoint(var7_6);
                var10_8 = var1_1.length;
                for (var11_9 = 0; var11_9 < var10_8; ++var11_9) {
                    if (var7_6 != var1_1[var11_9]) continue;
                    var8_7 = true;
                    ** GOTO lbl12
                }
                break block7;
            }
            var6_10 = var2_2.toString();
            if (var6_10.isEmpty() || VCardUtils.containsOnlyWhiteSpaces(new String[]{var6_10})) {
                var6_10 = "";
lbl27:
                // 2 sources

                return var6_10;
            }
            ** while (!var5_5)
lbl30:
            // 1 sources

            return '\"' + var6_10 + '\"';
        }
        var8_7 = var5_5;
        ** while (true)
    }

    public static String toStringAsV30ParamValue(String string2) {
        return VCardUtils.toStringAsParamValue(string2, sEscapeIndicatorsV30);
    }

    public static String toStringAsV40ParamValue(String string2) {
        return VCardUtils.toStringAsParamValue(string2, sEscapeIndicatorsV40);
    }
}

