/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.Dialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.preference.SeekBarPreference;
import android.provider.Settings;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.SeekBar;
import com.android.internal.R;

public class VolumePreference
extends SeekBarPreference
implements PreferenceManager.OnActivityStopListener,
View.OnKeyListener {
    private static final String TAG = "VolumePreference";
    private SeekBarVolumizer mSeekBarVolumizer;
    private int mStreamType;

    public VolumePreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.VolumePreference, 0, 0);
        this.mStreamType = typedArray.getInt(0, 0);
        typedArray.recycle();
    }

    private void cleanup() {
        this.getPreferenceManager().unregisterOnActivityStopListener(this);
        if (this.mSeekBarVolumizer != null) {
            Dialog dialog = this.getDialog();
            if (dialog != null && dialog.isShowing()) {
                View view = dialog.getWindow().getDecorView().findViewById(16908822);
                if (view != null) {
                    view.setOnKeyListener(null);
                }
                this.mSeekBarVolumizer.revertVolume();
            }
            this.mSeekBarVolumizer.stop();
            this.mSeekBarVolumizer = null;
        }
    }

    @Override
    public void onActivityStop() {
        this.cleanup();
    }

    @Override
    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
        SeekBar seekBar = (SeekBar)view.findViewById(16908822);
        this.mSeekBarVolumizer = new SeekBarVolumizer(this.getContext(), seekBar, this.mStreamType);
        this.getPreferenceManager().registerOnActivityStopListener(this);
        view.setOnKeyListener(this);
        view.setFocusableInTouchMode(true);
        view.requestFocus();
    }

    @Override
    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        if (!bl && this.mSeekBarVolumizer != null) {
            this.mSeekBarVolumizer.revertVolume();
        }
        this.cleanup();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onKey(View view, int n, KeyEvent keyEvent) {
        if (this.mSeekBarVolumizer == null) {
            return true;
        }
        boolean bl = keyEvent.getAction() == 0;
        switch (n) {
            default: {
                return false;
            }
            case 25: {
                if (bl) {
                    this.mSeekBarVolumizer.changeVolumeBy(-1);
                }
                return true;
            }
            case 24: 
        }
        if (bl) {
            this.mSeekBarVolumizer.changeVolumeBy(1);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable == null || !parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        } else {
            SavedState savedState = (SavedState)parcelable;
            super.onRestoreInstanceState(savedState.getSuperState());
            if (this.mSeekBarVolumizer == null) return;
            this.mSeekBarVolumizer.onRestoreInstanceState(savedState.getVolumeStore());
            return;
        }
    }

    protected void onSampleStarting(SeekBarVolumizer seekBarVolumizer) {
        if (this.mSeekBarVolumizer != null && seekBarVolumizer != this.mSeekBarVolumizer) {
            this.mSeekBarVolumizer.stopSample();
        }
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        if (this.mSeekBarVolumizer != null) {
            this.mSeekBarVolumizer.onSaveInstanceState(savedState.getVolumeStore());
        }
        return savedState;
    }

    public void setStreamType(int n) {
        this.mStreamType = n;
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        VolumeStore mVolumeStore = new VolumeStore();

        public SavedState(Parcel parcel) {
            super(parcel);
            this.mVolumeStore.volume = parcel.readInt();
            this.mVolumeStore.originalVolume = parcel.readInt();
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        VolumeStore getVolumeStore() {
            return this.mVolumeStore;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.mVolumeStore.volume);
            parcel.writeInt(this.mVolumeStore.originalVolume);
        }
    }

    public class SeekBarVolumizer
    implements SeekBar.OnSeekBarChangeListener,
    Runnable {
        private AudioManager mAudioManager;
        private Context mContext;
        private Handler mHandler = new Handler();
        private int mLastProgress = -1;
        private int mOriginalStreamVolume;
        private Ringtone mRingtone;
        private SeekBar mSeekBar;
        private int mStreamType;
        private ContentObserver mVolumeObserver = new ContentObserver(this.mHandler){

            @Override
            public void onChange(boolean bl) {
                int n;
                super.onChange(bl);
                if (SeekBarVolumizer.this.mSeekBar != null && (n = Settings.System.getInt(SeekBarVolumizer.this.mContext.getContentResolver(), Settings.System.VOLUME_SETTINGS[SeekBarVolumizer.this.mStreamType], -1)) >= 0) {
                    SeekBarVolumizer.this.mSeekBar.setProgress(n);
                }
            }
        };

        public SeekBarVolumizer(Context context, SeekBar seekBar, int n) {
            this.mContext = context;
            this.mAudioManager = (AudioManager)context.getSystemService("audio");
            this.mStreamType = n;
            this.mSeekBar = seekBar;
            this.initSeekBar(seekBar);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void initSeekBar(SeekBar seekBar) {
            seekBar.setMax(this.mAudioManager.getStreamMaxVolume(this.mStreamType));
            this.mOriginalStreamVolume = this.mAudioManager.getStreamVolume(this.mStreamType);
            seekBar.setProgress(this.mOriginalStreamVolume);
            seekBar.setOnSeekBarChangeListener(this);
            this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor(Settings.System.VOLUME_SETTINGS[this.mStreamType]), false, this.mVolumeObserver);
            Uri uri = this.mStreamType == 2 ? Settings.System.DEFAULT_RINGTONE_URI : (this.mStreamType == 5 ? Settings.System.DEFAULT_NOTIFICATION_URI : Settings.System.DEFAULT_ALARM_ALERT_URI);
            this.mRingtone = RingtoneManager.getRingtone(this.mContext, uri);
            if (this.mRingtone != null) {
                this.mRingtone.setStreamType(this.mStreamType);
            }
        }

        private void sample() {
            VolumePreference.this.onSampleStarting(this);
            this.mRingtone.play();
        }

        public void changeVolumeBy(int n) {
            this.mSeekBar.incrementProgressBy(n);
            if (this.mRingtone != null && !this.mRingtone.isPlaying()) {
                this.sample();
            }
            this.postSetVolume(this.mSeekBar.getProgress());
        }

        public SeekBar getSeekBar() {
            return this.mSeekBar;
        }

        @Override
        public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
            if (!bl) {
                return;
            }
            this.postSetVolume(n);
        }

        public void onRestoreInstanceState(VolumeStore volumeStore) {
            if (volumeStore.volume != -1) {
                this.mOriginalStreamVolume = volumeStore.originalVolume;
                this.mLastProgress = volumeStore.volume;
                this.postSetVolume(this.mLastProgress);
            }
        }

        public void onSaveInstanceState(VolumeStore volumeStore) {
            if (this.mLastProgress >= 0) {
                volumeStore.volume = this.mLastProgress;
                volumeStore.originalVolume = this.mOriginalStreamVolume;
            }
        }

        @Override
        public void onStartTrackingTouch(SeekBar seekBar) {
        }

        @Override
        public void onStopTrackingTouch(SeekBar seekBar) {
            if (this.mRingtone != null && !this.mRingtone.isPlaying()) {
                this.sample();
            }
        }

        void postSetVolume(int n) {
            this.mLastProgress = n;
            this.mHandler.removeCallbacks(this);
            this.mHandler.post(this);
        }

        public void revertVolume() {
            this.mAudioManager.setStreamVolume(this.mStreamType, this.mOriginalStreamVolume, 0);
        }

        @Override
        public void run() {
            this.mAudioManager.setStreamVolume(this.mStreamType, this.mLastProgress, 0);
        }

        public void stop() {
            this.stopSample();
            this.mContext.getContentResolver().unregisterContentObserver(this.mVolumeObserver);
            this.mSeekBar.setOnSeekBarChangeListener(null);
        }

        public void stopSample() {
            if (this.mRingtone != null) {
                this.mRingtone.stop();
            }
        }
    }

    public static class VolumeStore {
        public int originalVolume = -1;
        public int volume = -1;
    }
}

