/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.renderscript.BaseObj;
import android.renderscript.Dimension;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.Type;

public class Allocation
extends BaseObj {
    private static BitmapFactory.Options mBitmapOptions = new BitmapFactory.Options();
    Bitmap mBitmap;
    Type mType;

    static {
        Allocation.mBitmapOptions.inScaled = false;
    }

    Allocation(int n, RenderScript renderScript, Type type) {
        super(renderScript);
        this.mID = n;
        this.mType = type;
    }

    public static Allocation createBitmapRef(RenderScript renderScript, Bitmap bitmap) throws IllegalArgumentException {
        renderScript.validate();
        Type type = Allocation.typeFromBitmap(renderScript, bitmap);
        int n = renderScript.nAllocationCreateBitmapRef(type.getID(), bitmap);
        if (n == 0) {
            throw new IllegalStateException("Load failed.");
        }
        Allocation allocation = new Allocation(n, renderScript, type);
        allocation.mBitmap = bitmap;
        return allocation;
    }

    public static Allocation createFromBitmap(RenderScript renderScript, Bitmap bitmap, Element element, boolean bl) throws IllegalArgumentException {
        renderScript.validate();
        Type type = Allocation.typeFromBitmap(renderScript, bitmap);
        int n = renderScript.nAllocationCreateFromBitmap(element.mID, bl, bitmap);
        if (n == 0) {
            throw new IllegalStateException("Load failed.");
        }
        return new Allocation(n, renderScript, type);
    }

    static Allocation createFromBitmapBoxed(RenderScript renderScript, Bitmap bitmap, Element element, boolean bl) throws IllegalArgumentException {
        renderScript.validate();
        int n = renderScript.nAllocationCreateFromBitmapBoxed(element.mID, bl, bitmap);
        if (n == 0) {
            throw new IllegalStateException("Load failed.");
        }
        return new Allocation(n, renderScript, null);
    }

    /*
     * Exception decompiling
     */
    public static Allocation createFromBitmapResource(RenderScript var0, Resources var1_1, int var2_2, Element var3_3, boolean var4_4) throws IllegalArgumentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5, 6 : 78->91)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Allocation createFromBitmapResourceBoxed(RenderScript renderScript, Resources resources, int n, Element element, boolean bl) throws IllegalArgumentException {
        Allocation.mBitmapOptions.inPreferredConfig = null;
        if (element == renderScript.mElement_RGBA_8888) {
            Allocation.mBitmapOptions.inPreferredConfig = Bitmap.Config.ARGB_8888;
            return Allocation.createFromBitmapBoxed(renderScript, BitmapFactory.decodeResource(resources, n, mBitmapOptions), element, bl);
        }
        if (element == renderScript.mElement_RGB_888) {
            Allocation.mBitmapOptions.inPreferredConfig = Bitmap.Config.ARGB_8888;
            return Allocation.createFromBitmapBoxed(renderScript, BitmapFactory.decodeResource(resources, n, mBitmapOptions), element, bl);
        }
        if (element == renderScript.mElement_RGBA_4444) {
            Allocation.mBitmapOptions.inPreferredConfig = Bitmap.Config.ARGB_4444;
            return Allocation.createFromBitmapBoxed(renderScript, BitmapFactory.decodeResource(resources, n, mBitmapOptions), element, bl);
        }
        if (element != renderScript.mElement_RGB_565) return Allocation.createFromBitmapBoxed(renderScript, BitmapFactory.decodeResource(resources, n, mBitmapOptions), element, bl);
        Allocation.mBitmapOptions.inPreferredConfig = Bitmap.Config.RGB_565;
        return Allocation.createFromBitmapBoxed(renderScript, BitmapFactory.decodeResource(resources, n, mBitmapOptions), element, bl);
    }

    public static Allocation createSized(RenderScript renderScript, Element element, int n) throws IllegalArgumentException {
        renderScript.validate();
        Type.Builder builder = new Type.Builder(renderScript, element);
        builder.add(Dimension.X, n);
        Type type = builder.create();
        int n2 = renderScript.nAllocationCreateTyped(type.mID);
        if (n2 == 0) {
            throw new IllegalStateException("Bad element.");
        }
        return new Allocation(n2, renderScript, type);
    }

    public static Allocation createTyped(RenderScript renderScript, Type type) throws IllegalArgumentException {
        renderScript.validate();
        if (type.mID == 0) {
            throw new IllegalStateException("Bad Type");
        }
        return new Allocation(renderScript.nAllocationCreateTyped(type.mID), renderScript, type);
    }

    private void data1DChecks(int n, int n2, int n3, int n4) {
        this.mRS.validate();
        if (n < 0 || n2 < 1 || n + n2 > this.mType.getElementCount()) {
            throw new IllegalArgumentException("Offset or Count out of bounds.");
        }
        if (n3 < n4) {
            throw new IllegalArgumentException("Array too small for allocation type.");
        }
    }

    private static Element elementFromBitmap(RenderScript renderScript, Bitmap bitmap) {
        Bitmap.Config config = bitmap.getConfig();
        if (config == Bitmap.Config.ALPHA_8) {
            return Element.A_8(renderScript);
        }
        if (config == Bitmap.Config.ARGB_4444) {
            return Element.RGBA_4444(renderScript);
        }
        if (config == Bitmap.Config.ARGB_8888) {
            return Element.RGBA_8888(renderScript);
        }
        if (config == Bitmap.Config.RGB_565) {
            return Element.RGB_565(renderScript);
        }
        throw new IllegalStateException("Bad bitmap type.");
    }

    private static Type typeFromBitmap(RenderScript renderScript, Bitmap bitmap) {
        Type.Builder builder = new Type.Builder(renderScript, Allocation.elementFromBitmap(renderScript, bitmap));
        builder.add(Dimension.X, bitmap.getWidth());
        builder.add(Dimension.Y, bitmap.getHeight());
        return builder.create();
    }

    public Adapter1D createAdapter1D() {
        this.mRS.validate();
        int n = this.mRS.nAdapter1DCreate();
        if (n == 0) {
            throw new IllegalStateException("allocation failed.");
        }
        this.mRS.nAdapter1DBindAllocation(n, this.mID);
        return new Adapter1D(n, this.mRS);
    }

    public Adapter2D createAdapter2D() {
        this.mRS.validate();
        int n = this.mRS.nAdapter2DCreate();
        if (n == 0) {
            throw new IllegalStateException("allocation failed.");
        }
        this.mRS.nAdapter2DBindAllocation(n, this.mID);
        return new Adapter2D(n, this.mRS);
    }

    public void data(Object object) {
        this.mRS.validate();
        this.mRS.nAllocationSubDataFromObject(this.mID, this.mType, 0, object);
    }

    public void data(byte[] byArray) {
        this.mRS.validate();
        this.subData1D(0, this.mType.getElementCount(), byArray);
    }

    public void data(float[] fArray) {
        this.mRS.validate();
        this.subData1D(0, this.mType.getElementCount(), fArray);
    }

    public void data(int[] nArray) {
        this.mRS.validate();
        this.subData1D(0, this.mType.getElementCount(), nArray);
    }

    public void data(short[] sArray) {
        this.mRS.validate();
        this.subData1D(0, this.mType.getElementCount(), sArray);
    }

    public Type getType() {
        return this.mType;
    }

    public void read(Object object) {
        this.mRS.validate();
        this.mRS.nAllocationSubReadFromObject(this.mID, this.mType, 0, object);
    }

    public void readData(float[] fArray) {
        this.mRS.validate();
        this.mRS.nAllocationRead(this.mID, fArray);
    }

    public void readData(int[] nArray) {
        this.mRS.validate();
        this.mRS.nAllocationRead(this.mID, nArray);
    }

    public void subData(int n, Object object) {
        this.mRS.validate();
        this.mRS.nAllocationSubDataFromObject(this.mID, this.mType, n, object);
    }

    public void subData1D(int n, int n2, byte[] byArray) {
        int n3 = n2 * this.mType.mElement.getSizeBytes();
        this.data1DChecks(n, n2, byArray.length, n3);
        this.mRS.nAllocationSubData1D(this.mID, n, n2, byArray, n3);
    }

    public void subData1D(int n, int n2, float[] fArray) {
        int n3 = n2 * this.mType.mElement.getSizeBytes();
        this.data1DChecks(n, n2, 4 * fArray.length, n3);
        this.mRS.nAllocationSubData1D(this.mID, n, n2, fArray, n3);
    }

    public void subData1D(int n, int n2, int[] nArray) {
        int n3 = n2 * this.mType.mElement.getSizeBytes();
        this.data1DChecks(n, n2, 4 * nArray.length, n3);
        this.mRS.nAllocationSubData1D(this.mID, n, n2, nArray, n3);
    }

    public void subData1D(int n, int n2, short[] sArray) {
        int n3 = n2 * this.mType.mElement.getSizeBytes();
        this.data1DChecks(n, n2, 2 * sArray.length, n3);
        this.mRS.nAllocationSubData1D(this.mID, n, n2, sArray, n3);
    }

    public void subData2D(int n, int n2, int n3, int n4, float[] fArray) {
        this.mRS.validate();
        this.mRS.nAllocationSubData2D(this.mID, n, n2, n3, n4, fArray, 4 * fArray.length);
    }

    public void subData2D(int n, int n2, int n3, int n4, int[] nArray) {
        this.mRS.validate();
        this.mRS.nAllocationSubData2D(this.mID, n, n2, n3, n4, nArray, 4 * nArray.length);
    }

    public void uploadToBufferObject() {
        this.mRS.validate();
        this.mRS.nAllocationUploadToBufferObject(this.mID);
    }

    public void uploadToTexture(int n) {
        this.mRS.validate();
        this.mRS.nAllocationUploadToTexture(this.mID, false, n);
    }

    public void uploadToTexture(boolean bl, int n) {
        this.mRS.validate();
        this.mRS.nAllocationUploadToTexture(this.mID, bl, n);
    }

    public class Adapter1D
    extends BaseObj {
        Adapter1D(int n, RenderScript renderScript) {
            super(renderScript);
            this.mID = n;
        }

        public void data(float[] fArray) {
            this.mRS.validate();
            this.mRS.nAdapter1DData(this.mID, fArray);
        }

        public void data(int[] nArray) {
            this.mRS.validate();
            this.mRS.nAdapter1DData(this.mID, nArray);
        }

        public void setConstraint(Dimension dimension, int n) {
            this.mRS.validate();
            this.mRS.nAdapter1DSetConstraint(this.mID, dimension.mID, n);
        }

        public void subData(int n, int n2, float[] fArray) {
            this.mRS.validate();
            this.mRS.nAdapter1DSubData(this.mID, n, n2, fArray);
        }

        public void subData(int n, int n2, int[] nArray) {
            this.mRS.validate();
            this.mRS.nAdapter1DSubData(this.mID, n, n2, nArray);
        }
    }

    public class Adapter2D
    extends BaseObj {
        Adapter2D(int n, RenderScript renderScript) {
            super(renderScript);
            this.mID = n;
        }

        public void data(float[] fArray) {
            this.mRS.validate();
            this.mRS.nAdapter2DData(this.mID, fArray);
        }

        public void data(int[] nArray) {
            this.mRS.validate();
            this.mRS.nAdapter2DData(this.mID, nArray);
        }

        public void setConstraint(Dimension dimension, int n) {
            this.mRS.validate();
            this.mRS.nAdapter2DSetConstraint(this.mID, dimension.mID, n);
        }

        public void subData(int n, int n2, int n3, int n4, float[] fArray) {
            this.mRS.validate();
            this.mRS.nAdapter2DSubData(this.mID, n, n2, n3, n4, fArray);
        }

        public void subData(int n, int n2, int n3, int n4, int[] nArray) {
            this.mRS.validate();
            this.mRS.nAdapter2DSubData(this.mID, n, n2, n3, n4, nArray);
        }
    }
}

