/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RenderScript;
import java.lang.reflect.Field;

public class Element
extends BaseObj {
    String[] mElementNames;
    Element[] mElements;
    DataKind mKind;
    boolean mNormalized;
    int mSize;
    DataType mType;
    int mVectorSize;

    Element(RenderScript renderScript, DataType dataType, DataKind dataKind, boolean bl, int n) {
        super(renderScript);
        this.mSize = n * dataType.mSize;
        this.mType = dataType;
        this.mKind = dataKind;
        this.mNormalized = bl;
        this.mVectorSize = n;
        this.mID = renderScript.nElementCreate(dataType.mID, dataKind.mID, bl, n);
    }

    Element(RenderScript renderScript, Element[] elementArray, String[] stringArray) {
        super(renderScript);
        this.mSize = 0;
        this.mElements = elementArray;
        this.mElementNames = stringArray;
        int[] nArray = new int[this.mElements.length];
        for (int i = 0; i < this.mElements.length; ++i) {
            this.mSize += this.mElements[i].mSize;
            nArray[i] = this.mElements[i].mID;
        }
        this.mID = renderScript.nElementCreate2(nArray, this.mElementNames);
    }

    public static Element ATTRIB_COLOR_F32_4(RenderScript renderScript) {
        if (renderScript.mElement_COLOR_F32_4 == null) {
            renderScript.mElement_COLOR_F32_4 = Element.createAttrib(renderScript, DataType.FLOAT_32, DataKind.COLOR, 4);
        }
        return renderScript.mElement_COLOR_F32_4;
    }

    public static Element ATTRIB_COLOR_U8_4(RenderScript renderScript) {
        if (renderScript.mElement_COLOR_U8_4 == null) {
            renderScript.mElement_COLOR_U8_4 = Element.createAttrib(renderScript, DataType.UNSIGNED_8, DataKind.COLOR, 4);
        }
        return renderScript.mElement_COLOR_U8_4;
    }

    public static Element ATTRIB_NORMAL_3(RenderScript renderScript) {
        if (renderScript.mElement_NORMAL_3 == null) {
            renderScript.mElement_NORMAL_3 = Element.createAttrib(renderScript, DataType.FLOAT_32, DataKind.NORMAL, 3);
        }
        return renderScript.mElement_NORMAL_3;
    }

    public static Element ATTRIB_POSITION_2(RenderScript renderScript) {
        if (renderScript.mElement_POSITION_2 == null) {
            renderScript.mElement_POSITION_2 = Element.createAttrib(renderScript, DataType.FLOAT_32, DataKind.POSITION, 2);
        }
        return renderScript.mElement_POSITION_2;
    }

    public static Element ATTRIB_POSITION_3(RenderScript renderScript) {
        if (renderScript.mElement_POSITION_3 == null) {
            renderScript.mElement_POSITION_3 = Element.createAttrib(renderScript, DataType.FLOAT_32, DataKind.POSITION, 3);
        }
        return renderScript.mElement_POSITION_3;
    }

    public static Element ATTRIB_TEXTURE_2(RenderScript renderScript) {
        if (renderScript.mElement_TEXTURE_2 == null) {
            renderScript.mElement_TEXTURE_2 = Element.createAttrib(renderScript, DataType.FLOAT_32, DataKind.TEXTURE, 2);
        }
        return renderScript.mElement_TEXTURE_2;
    }

    public static Element A_8(RenderScript renderScript) {
        if (renderScript.mElement_A_8 == null) {
            renderScript.mElement_A_8 = Element.createPixel(renderScript, DataType.UNSIGNED_8, DataKind.PIXEL_A);
        }
        return renderScript.mElement_A_8;
    }

    public static Element INDEX_16(RenderScript renderScript) {
        if (renderScript.mElement_INDEX_16 == null) {
            renderScript.mElement_INDEX_16 = Element.createIndex(renderScript);
        }
        return renderScript.mElement_INDEX_16;
    }

    public static Element RGBA_4444(RenderScript renderScript) {
        if (renderScript.mElement_RGBA_4444 == null) {
            renderScript.mElement_RGBA_4444 = Element.createPixel(renderScript, DataType.UNSIGNED_4_4_4_4, DataKind.PIXEL_RGBA);
        }
        return renderScript.mElement_RGBA_4444;
    }

    public static Element RGBA_5551(RenderScript renderScript) {
        if (renderScript.mElement_RGBA_5551 == null) {
            renderScript.mElement_RGBA_5551 = Element.createPixel(renderScript, DataType.UNSIGNED_5_5_5_1, DataKind.PIXEL_RGBA);
        }
        return renderScript.mElement_RGBA_5551;
    }

    public static Element RGBA_8888(RenderScript renderScript) {
        if (renderScript.mElement_RGBA_8888 == null) {
            renderScript.mElement_RGBA_8888 = Element.createPixel(renderScript, DataType.UNSIGNED_8, DataKind.PIXEL_RGBA);
        }
        return renderScript.mElement_RGBA_8888;
    }

    public static Element RGB_565(RenderScript renderScript) {
        if (renderScript.mElement_RGB_565 == null) {
            renderScript.mElement_RGB_565 = Element.createPixel(renderScript, DataType.UNSIGNED_5_6_5, DataKind.PIXEL_RGB);
        }
        return renderScript.mElement_RGB_565;
    }

    public static Element RGB_888(RenderScript renderScript) {
        if (renderScript.mElement_RGB_888 == null) {
            renderScript.mElement_RGB_888 = Element.createPixel(renderScript, DataType.UNSIGNED_8, DataKind.PIXEL_RGB);
        }
        return renderScript.mElement_RGB_888;
    }

    public static Element USER_F32(RenderScript renderScript) {
        if (renderScript.mElement_USER_F32 == null) {
            renderScript.mElement_USER_F32 = Element.createUser(renderScript, DataType.FLOAT_32);
        }
        return renderScript.mElement_USER_F32;
    }

    public static Element USER_I32(RenderScript renderScript) {
        if (renderScript.mElement_USER_I32 == null) {
            renderScript.mElement_USER_I32 = Element.createUser(renderScript, DataType.SIGNED_32);
        }
        return renderScript.mElement_USER_I32;
    }

    public static Element USER_I8(RenderScript renderScript) {
        if (renderScript.mElement_USER_I8 == null) {
            renderScript.mElement_USER_I8 = Element.createUser(renderScript, DataType.SIGNED_8);
        }
        return renderScript.mElement_USER_I8;
    }

    public static Element USER_U32(RenderScript renderScript) {
        if (renderScript.mElement_USER_U32 == null) {
            renderScript.mElement_USER_U32 = Element.createUser(renderScript, DataType.UNSIGNED_32);
        }
        return renderScript.mElement_USER_U32;
    }

    public static Element USER_U8(RenderScript renderScript) {
        if (renderScript.mElement_USER_U8 == null) {
            renderScript.mElement_USER_U8 = Element.createUser(renderScript, DataType.UNSIGNED_8);
        }
        return renderScript.mElement_USER_U8;
    }

    public static Element createAttrib(RenderScript renderScript, DataType dataType, DataKind dataKind, int n) {
        if (dataType != DataType.FLOAT_32 && dataType != DataType.UNSIGNED_8 && dataType != DataType.UNSIGNED_16 && dataType != DataType.UNSIGNED_32 && dataType != DataType.SIGNED_8 && dataType != DataType.SIGNED_16 && dataType != DataType.SIGNED_32) {
            throw new IllegalArgumentException("Unsupported DataType");
        }
        if (dataKind != DataKind.COLOR && dataKind != DataKind.POSITION && dataKind != DataKind.TEXTURE && dataKind != DataKind.NORMAL && dataKind != DataKind.POINT_SIZE && dataKind != DataKind.USER) {
            throw new IllegalArgumentException("Unsupported DataKind");
        }
        if (dataKind == DataKind.COLOR && (dataType != DataType.FLOAT_32 && dataType != DataType.UNSIGNED_8 || n < 3 || n > 4)) {
            throw new IllegalArgumentException("Bad combo");
        }
        if (dataKind == DataKind.POSITION && (n < 1 || n > 4)) {
            throw new IllegalArgumentException("Bad combo");
        }
        if (dataKind == DataKind.TEXTURE && (dataType != DataType.FLOAT_32 || n < 1 || n > 4)) {
            throw new IllegalArgumentException("Bad combo");
        }
        if (dataKind == DataKind.NORMAL && (dataType != DataType.FLOAT_32 || n != 3)) {
            throw new IllegalArgumentException("Bad combo");
        }
        if (dataKind == DataKind.POINT_SIZE && (dataType != DataType.FLOAT_32 || n != 1)) {
            throw new IllegalArgumentException("Bad combo");
        }
        DataKind dataKind2 = DataKind.COLOR;
        boolean bl = false;
        if (dataKind == dataKind2) {
            DataType dataType2 = DataType.UNSIGNED_8;
            bl = false;
            if (dataType == dataType2) {
                bl = true;
            }
        }
        return new Element(renderScript, dataType, dataKind, bl, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Element createFromClass(RenderScript renderScript, Class clazz) {
        renderScript.validate();
        Field[] fieldArray = clazz.getFields();
        Builder builder = new Builder(renderScript);
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Class<?> clazz2 = field.getType();
            if (clazz2 == Integer.TYPE) {
                builder.add(Element.createUser(renderScript, DataType.SIGNED_32), field.getName());
            } else if (clazz2 == Short.TYPE) {
                builder.add(Element.createUser(renderScript, DataType.SIGNED_16), field.getName());
            } else if (clazz2 == Byte.TYPE) {
                builder.add(Element.createUser(renderScript, DataType.SIGNED_8), field.getName());
            } else {
                if (clazz2 != Float.TYPE) {
                    throw new IllegalArgumentException("Unkown field type");
                }
                builder.add(Element.createUser(renderScript, DataType.FLOAT_32), field.getName());
            }
            ++n2;
        }
        return builder.create();
    }

    public static Element createIndex(RenderScript renderScript) {
        return new Element(renderScript, DataType.UNSIGNED_16, DataKind.INDEX, false, 1);
    }

    public static Element createPixel(RenderScript renderScript, DataType dataType, DataKind dataKind) {
        if (dataKind != DataKind.PIXEL_L && dataKind != DataKind.PIXEL_A && dataKind != DataKind.PIXEL_LA && dataKind != DataKind.PIXEL_RGB && dataKind != DataKind.PIXEL_RGBA) {
            throw new IllegalArgumentException("Unsupported DataKind");
        }
        if (dataType != DataType.UNSIGNED_8 && dataType != DataType.UNSIGNED_5_6_5 && dataType != DataType.UNSIGNED_4_4_4_4 && dataType != DataType.UNSIGNED_5_5_5_1) {
            throw new IllegalArgumentException("Unsupported DataType");
        }
        if (dataType == DataType.UNSIGNED_5_6_5 && dataKind != DataKind.PIXEL_RGB) {
            throw new IllegalArgumentException("Bad kind and type combo");
        }
        if (dataType == DataType.UNSIGNED_5_5_5_1 && dataKind != DataKind.PIXEL_RGBA) {
            throw new IllegalArgumentException("Bad kind and type combo");
        }
        if (dataType == DataType.UNSIGNED_4_4_4_4 && dataKind != DataKind.PIXEL_RGBA) {
            throw new IllegalArgumentException("Bad kind and type combo");
        }
        int n = 1;
        if (dataKind == DataKind.PIXEL_LA) {
            n = 2;
        }
        if (dataKind == DataKind.PIXEL_RGB) {
            n = 3;
        }
        if (dataKind == DataKind.PIXEL_RGBA) {
            n = 4;
        }
        return new Element(renderScript, dataType, dataKind, true, n);
    }

    public static Element createUser(RenderScript renderScript, DataType dataType) {
        return new Element(renderScript, dataType, DataKind.USER, false, 1);
    }

    public static Element createVector(RenderScript renderScript, DataType dataType, int n) {
        if (n < 2 || n > 4) {
            throw new IllegalArgumentException("Bad size");
        }
        return new Element(renderScript, dataType, DataKind.USER, false, n);
    }

    static void initPredefined(RenderScript renderScript) {
        renderScript.nInitElements(renderScript.nElementCreate(DataType.UNSIGNED_8.mID, DataKind.PIXEL_A.mID, true, 1), renderScript.nElementCreate(DataType.UNSIGNED_4_4_4_4.mID, DataKind.PIXEL_RGBA.mID, true, 4), renderScript.nElementCreate(DataType.UNSIGNED_8.mID, DataKind.PIXEL_RGBA.mID, true, 4), renderScript.nElementCreate(DataType.UNSIGNED_5_6_5.mID, DataKind.PIXEL_RGB.mID, true, 3));
    }

    @Override
    public void destroy() throws IllegalStateException {
        super.destroy();
    }

    int getSizeBytes() {
        return this.mSize;
    }

    public static class Builder {
        int mCount;
        String[] mElementNames;
        Element[] mElements;
        RenderScript mRS;

        public Builder(RenderScript renderScript) {
            this.mRS = renderScript;
            this.mCount = 0;
            this.mElements = new Element[8];
            this.mElementNames = new String[8];
        }

        public void add(Element element, String string2) {
            if (this.mCount == this.mElements.length) {
                Element[] elementArray = new Element[8 + this.mCount];
                String[] stringArray = new String[8 + this.mCount];
                System.arraycopy(this.mElements, 0, elementArray, 0, this.mCount);
                System.arraycopy(this.mElementNames, 0, stringArray, 0, this.mCount);
                this.mElements = elementArray;
                this.mElementNames = stringArray;
            }
            this.mElements[this.mCount] = element;
            this.mElementNames[this.mCount] = string2;
            this.mCount = 1 + this.mCount;
        }

        public Element create() {
            this.mRS.validate();
            Element[] elementArray = new Element[this.mCount];
            String[] stringArray = new String[this.mCount];
            System.arraycopy(this.mElements, 0, elementArray, 0, this.mCount);
            System.arraycopy(this.mElementNames, 0, stringArray, 0, this.mCount);
            return new Element(this.mRS, elementArray, stringArray);
        }
    }

    public static final class DataKind
    extends Enum<DataKind> {
        private static final /* synthetic */ DataKind[] $VALUES;
        public static final /* enum */ DataKind COLOR;
        public static final /* enum */ DataKind INDEX;
        public static final /* enum */ DataKind NORMAL;
        public static final /* enum */ DataKind PIXEL_A;
        public static final /* enum */ DataKind PIXEL_L;
        public static final /* enum */ DataKind PIXEL_LA;
        public static final /* enum */ DataKind PIXEL_RGB;
        public static final /* enum */ DataKind PIXEL_RGBA;
        public static final /* enum */ DataKind POINT_SIZE;
        public static final /* enum */ DataKind POSITION;
        public static final /* enum */ DataKind TEXTURE;
        public static final /* enum */ DataKind USER;
        int mID;

        static {
            USER = new DataKind(0);
            COLOR = new DataKind(1);
            POSITION = new DataKind(2);
            TEXTURE = new DataKind(3);
            NORMAL = new DataKind(4);
            INDEX = new DataKind(5);
            POINT_SIZE = new DataKind(6);
            PIXEL_L = new DataKind(7);
            PIXEL_A = new DataKind(8);
            PIXEL_LA = new DataKind(9);
            PIXEL_RGB = new DataKind(10);
            PIXEL_RGBA = new DataKind(11);
            DataKind[] dataKindArray = new DataKind[]{USER, COLOR, POSITION, TEXTURE, NORMAL, INDEX, POINT_SIZE, PIXEL_L, PIXEL_A, PIXEL_LA, PIXEL_RGB, PIXEL_RGBA};
            $VALUES = dataKindArray;
        }

        private DataKind(int n2) {
            this.mID = n2;
        }

        public static DataKind valueOf(String string2) {
            return Enum.valueOf(DataKind.class, string2);
        }

        public static DataKind[] values() {
            return (DataKind[])$VALUES.clone();
        }
    }

    public static final class DataType
    extends Enum<DataType> {
        private static final /* synthetic */ DataType[] $VALUES;
        public static final /* enum */ DataType FLOAT_32 = new DataType(2, 4);
        public static final /* enum */ DataType RS_ALLOCATION;
        public static final /* enum */ DataType RS_ELEMENT;
        public static final /* enum */ DataType RS_MESH;
        public static final /* enum */ DataType RS_PROGRAM_FRAGMENT;
        public static final /* enum */ DataType RS_PROGRAM_RASTER;
        public static final /* enum */ DataType RS_PROGRAM_STORE;
        public static final /* enum */ DataType RS_PROGRAM_VERTEX;
        public static final /* enum */ DataType RS_SAMPLER;
        public static final /* enum */ DataType RS_SCRIPT;
        public static final /* enum */ DataType RS_TYPE;
        public static final /* enum */ DataType SIGNED_16;
        public static final /* enum */ DataType SIGNED_32;
        public static final /* enum */ DataType SIGNED_8;
        public static final /* enum */ DataType UNSIGNED_16;
        public static final /* enum */ DataType UNSIGNED_32;
        public static final /* enum */ DataType UNSIGNED_4_4_4_4;
        public static final /* enum */ DataType UNSIGNED_5_5_5_1;
        public static final /* enum */ DataType UNSIGNED_5_6_5;
        public static final /* enum */ DataType UNSIGNED_8;
        int mID;
        int mSize;

        static {
            SIGNED_8 = new DataType(4, 1);
            SIGNED_16 = new DataType(5, 2);
            SIGNED_32 = new DataType(6, 4);
            UNSIGNED_8 = new DataType(8, 1);
            UNSIGNED_16 = new DataType(9, 2);
            UNSIGNED_32 = new DataType(10, 4);
            UNSIGNED_5_6_5 = new DataType(12, 2);
            UNSIGNED_5_5_5_1 = new DataType(13, 2);
            UNSIGNED_4_4_4_4 = new DataType(14, 2);
            RS_ELEMENT = new DataType(15, 4);
            RS_TYPE = new DataType(16, 4);
            RS_ALLOCATION = new DataType(17, 4);
            RS_SAMPLER = new DataType(18, 4);
            RS_SCRIPT = new DataType(19, 4);
            RS_MESH = new DataType(20, 4);
            RS_PROGRAM_FRAGMENT = new DataType(21, 4);
            RS_PROGRAM_VERTEX = new DataType(22, 4);
            RS_PROGRAM_RASTER = new DataType(23, 4);
            RS_PROGRAM_STORE = new DataType(24, 4);
            DataType[] dataTypeArray = new DataType[]{FLOAT_32, SIGNED_8, SIGNED_16, SIGNED_32, UNSIGNED_8, UNSIGNED_16, UNSIGNED_32, UNSIGNED_5_6_5, UNSIGNED_5_5_5_1, UNSIGNED_4_4_4_4, RS_ELEMENT, RS_TYPE, RS_ALLOCATION, RS_SAMPLER, RS_SCRIPT, RS_MESH, RS_PROGRAM_FRAGMENT, RS_PROGRAM_VERTEX, RS_PROGRAM_RASTER, RS_PROGRAM_STORE};
            $VALUES = dataTypeArray;
        }

        private DataType(int n2, int n3) {
            this.mID = n2;
            this.mSize = n3;
        }

        public static DataType valueOf(String string2) {
            return Enum.valueOf(DataType.class, string2);
        }

        public static DataType[] values() {
            return (DataType[])$VALUES.clone();
        }
    }
}

