/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

public class FieldPacker {
    private final byte[] mData;
    private int mPos = 0;

    public FieldPacker(int n) {
        this.mData = new byte[n];
    }

    void addF32(float f) {
        this.addI32(Float.floatToRawIntBits(f));
    }

    void addF64(float f) {
        this.addI64(Double.doubleToRawLongBits(f));
    }

    void addI16(short s) {
        this.align(2);
        byte[] byArray = this.mData;
        int n = this.mPos;
        this.mPos = n + 1;
        byArray[n] = (byte)(s & 0xFF);
        byte[] byArray2 = this.mData;
        int n2 = this.mPos;
        this.mPos = n2 + 1;
        byArray2[n2] = (byte)(s >> 8);
    }

    void addI32(int n) {
        this.align(4);
        byte[] byArray = this.mData;
        int n2 = this.mPos;
        this.mPos = n2 + 1;
        byArray[n2] = (byte)(n & 0xFF);
        byte[] byArray2 = this.mData;
        int n3 = this.mPos;
        this.mPos = n3 + 1;
        byArray2[n3] = (byte)(0xFF & n >> 8);
        byte[] byArray3 = this.mData;
        int n4 = this.mPos;
        this.mPos = n4 + 1;
        byArray3[n4] = (byte)(0xFF & n >> 16);
        byte[] byArray4 = this.mData;
        int n5 = this.mPos;
        this.mPos = n5 + 1;
        byArray4[n5] = (byte)(0xFF & n >> 24);
    }

    void addI64(long l) {
        this.align(8);
        byte[] byArray = this.mData;
        int n = this.mPos;
        this.mPos = n + 1;
        byArray[n] = (byte)(l & 0xFFL);
        byte[] byArray2 = this.mData;
        int n2 = this.mPos;
        this.mPos = n2 + 1;
        byArray2[n2] = (byte)(0xFFL & l >> 8);
        byte[] byArray3 = this.mData;
        int n3 = this.mPos;
        this.mPos = n3 + 1;
        byArray3[n3] = (byte)(0xFFL & l >> 16);
        byte[] byArray4 = this.mData;
        int n4 = this.mPos;
        this.mPos = n4 + 1;
        byArray4[n4] = (byte)(0xFFL & l >> 24);
        byte[] byArray5 = this.mData;
        int n5 = this.mPos;
        this.mPos = n5 + 1;
        byArray5[n5] = (byte)(0xFFL & l >> 32);
        byte[] byArray6 = this.mData;
        int n6 = this.mPos;
        this.mPos = n6 + 1;
        byArray6[n6] = (byte)(0xFFL & l >> 40);
        byte[] byArray7 = this.mData;
        int n7 = this.mPos;
        this.mPos = n7 + 1;
        byArray7[n7] = (byte)(0xFFL & l >> 48);
        byte[] byArray8 = this.mData;
        int n8 = this.mPos;
        this.mPos = n8 + 1;
        byArray8[n8] = (byte)(0xFFL & l >> 56);
    }

    void addI8(byte by) {
        byte[] byArray = this.mData;
        int n = this.mPos;
        this.mPos = n + 1;
        byArray[n] = by;
    }

    void addU16(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(2);
        byte[] byArray = this.mData;
        int n2 = this.mPos;
        this.mPos = n2 + 1;
        byArray[n2] = (byte)(n & 0xFF);
        byte[] byArray2 = this.mData;
        int n3 = this.mPos;
        this.mPos = n3 + 1;
        byArray2[n3] = (byte)(n >> 8);
    }

    void addU32(long l) {
        if (l < 0L || l > -1L) {
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(4);
        byte[] byArray = this.mData;
        int n = this.mPos;
        this.mPos = n + 1;
        byArray[n] = (byte)(l & 0xFFL);
        byte[] byArray2 = this.mData;
        int n2 = this.mPos;
        this.mPos = n2 + 1;
        byArray2[n2] = (byte)(0xFFL & l >> 8);
        byte[] byArray3 = this.mData;
        int n3 = this.mPos;
        this.mPos = n3 + 1;
        byArray3[n3] = (byte)(0xFFL & l >> 16);
        byte[] byArray4 = this.mData;
        int n4 = this.mPos;
        this.mPos = n4 + 1;
        byArray4[n4] = (byte)(0xFFL & l >> 24);
    }

    void addU64(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(8);
        byte[] byArray = this.mData;
        int n = this.mPos;
        this.mPos = n + 1;
        byArray[n] = (byte)(l & 0xFFL);
        byte[] byArray2 = this.mData;
        int n2 = this.mPos;
        this.mPos = n2 + 1;
        byArray2[n2] = (byte)(0xFFL & l >> 8);
        byte[] byArray3 = this.mData;
        int n3 = this.mPos;
        this.mPos = n3 + 1;
        byArray3[n3] = (byte)(0xFFL & l >> 16);
        byte[] byArray4 = this.mData;
        int n4 = this.mPos;
        this.mPos = n4 + 1;
        byArray4[n4] = (byte)(0xFFL & l >> 24);
        byte[] byArray5 = this.mData;
        int n5 = this.mPos;
        this.mPos = n5 + 1;
        byArray5[n5] = (byte)(0xFFL & l >> 32);
        byte[] byArray6 = this.mData;
        int n6 = this.mPos;
        this.mPos = n6 + 1;
        byArray6[n6] = (byte)(0xFFL & l >> 40);
        byte[] byArray7 = this.mData;
        int n7 = this.mPos;
        this.mPos = n7 + 1;
        byArray7[n7] = (byte)(0xFFL & l >> 48);
        byte[] byArray8 = this.mData;
        int n8 = this.mPos;
        this.mPos = n8 + 1;
        byArray8[n8] = (byte)(0xFFL & l >> 56);
    }

    void addU8(short s) {
        if (s < 0 || s > 255) {
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        byte[] byArray = this.mData;
        int n = this.mPos;
        this.mPos = n + 1;
        byArray[n] = (byte)s;
    }

    public void align(int n) {
        while ((this.mPos & n - 1) != 0) {
            byte[] byArray = this.mData;
            int n2 = this.mPos;
            this.mPos = n2 + 1;
            byArray[n2] = 0;
        }
    }

    final byte[] getData() {
        return this.mData;
    }

    void reset() {
        this.mPos = 0;
    }
}

