/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RenderScript;

public class Light
extends BaseObj {
    Light(int n, RenderScript renderScript) {
        super(renderScript);
        this.mID = n;
    }

    public void setColor(float f, float f2, float f3) {
        this.mRS.validate();
        this.mRS.nLightSetColor(this.mID, f, f2, f3);
    }

    public void setPosition(float f, float f2, float f3) {
        this.mRS.validate();
        this.mRS.nLightSetPosition(this.mID, f, f2, f3);
    }

    public static class Builder {
        boolean mIsLocal;
        boolean mIsMono;
        RenderScript mRS;

        public Builder(RenderScript renderScript) {
            this.mRS = renderScript;
            this.mIsMono = false;
            this.mIsLocal = false;
        }

        static Light internalCreate(RenderScript renderScript, Builder builder) {
            synchronized (Builder.class) {
                renderScript.nSamplerBegin();
                renderScript.nLightSetIsMono(builder.mIsMono);
                renderScript.nLightSetIsLocal(builder.mIsLocal);
                Light light = new Light(renderScript.nLightCreate(), renderScript);
                return light;
            }
        }

        public Light create() {
            this.mRS.validate();
            return Builder.internalCreate(this.mRS, this);
        }

        public void lightSetIsLocal(boolean bl) {
            this.mIsLocal = bl;
        }

        public void lightSetIsMono(boolean bl) {
            this.mIsMono = bl;
        }
    }
}

