/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.Sampler;
import android.renderscript.Type;

public class Program
extends BaseObj {
    public static final int MAX_CONSTANT = 8;
    public static final int MAX_INPUT = 8;
    public static final int MAX_OUTPUT = 8;
    public static final int MAX_TEXTURE = 8;
    Type[] mConstants;
    Element[] mInputs;
    Element[] mOutputs;
    String mShader;
    int mTextureCount;

    Program(int n, RenderScript renderScript) {
        super(renderScript);
        this.mID = n;
    }

    public void bindConstants(Allocation allocation, int n) {
        this.mRS.nProgramBindConstants(this.mID, n, allocation.mID);
    }

    public void bindSampler(Sampler sampler, int n) throws IllegalArgumentException {
        this.mRS.validate();
        if (n < 0 || n >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        this.mRS.nProgramBindSampler(this.mID, n, sampler.mID);
    }

    public void bindTexture(Allocation allocation, int n) throws IllegalArgumentException {
        this.mRS.validate();
        if (n < 0 || n >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        this.mRS.nProgramBindTexture(this.mID, n, allocation.mID);
    }

    public static class BaseProgramBuilder {
        int mConstantCount;
        Type[] mConstants;
        int mInputCount;
        Element[] mInputs;
        int mOutputCount;
        Element[] mOutputs;
        RenderScript mRS;
        String mShader;
        int mTextureCount;
        Type[] mTextures;

        protected BaseProgramBuilder(RenderScript renderScript) {
            this.mRS = renderScript;
            this.mInputs = new Element[8];
            this.mOutputs = new Element[8];
            this.mConstants = new Type[8];
            this.mInputCount = 0;
            this.mOutputCount = 0;
            this.mConstantCount = 0;
            this.mTextureCount = 0;
        }

        public int addConstant(Type type) throws IllegalStateException {
            if (this.mConstantCount >= 8) {
                throw new IllegalArgumentException("Max input count exceeded.");
            }
            this.mConstants[this.mConstantCount] = type;
            int n = this.mConstantCount;
            this.mConstantCount = n + 1;
            return n;
        }

        public void addInput(Element element) throws IllegalStateException {
            if (this.mInputCount >= 8) {
                throw new IllegalArgumentException("Max input count exceeded.");
            }
            Element[] elementArray = this.mInputs;
            int n = this.mInputCount;
            this.mInputCount = n + 1;
            elementArray[n] = element;
        }

        public void addOutput(Element element) throws IllegalStateException {
            if (this.mOutputCount >= 8) {
                throw new IllegalArgumentException("Max output count exceeded.");
            }
            Element[] elementArray = this.mOutputs;
            int n = this.mOutputCount;
            this.mOutputCount = n + 1;
            elementArray[n] = element;
        }

        protected void initProgram(Program program) {
            program.mInputs = new Element[this.mInputCount];
            System.arraycopy(this.mInputs, 0, program.mInputs, 0, this.mInputCount);
            program.mOutputs = new Element[this.mOutputCount];
            System.arraycopy(this.mOutputs, 0, program.mOutputs, 0, this.mOutputCount);
            program.mConstants = new Type[this.mConstantCount];
            System.arraycopy(this.mConstants, 0, program.mConstants, 0, this.mConstantCount);
            program.mTextureCount = this.mTextureCount;
        }

        public void setShader(String string2) {
            this.mShader = string2;
        }

        public void setTextureCount(int n) throws IllegalArgumentException {
            if (n >= 8) {
                throw new IllegalArgumentException("Max texture count exceeded.");
            }
            this.mTextureCount = n;
        }
    }
}

