/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Program;
import android.renderscript.RenderScript;

public class ProgramFragment
extends Program {
    ProgramFragment(int n, RenderScript renderScript) {
        super(n, renderScript);
    }

    public static class Builder {
        public static final int MAX_TEXTURE = 2;
        boolean mPointSpriteEnable;
        RenderScript mRS;
        Slot[] mSlots;

        public Builder(RenderScript renderScript) {
            this.mRS = renderScript;
            this.mSlots = new Slot[2];
            this.mPointSpriteEnable = false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public ProgramFragment create() {
            this.mRS.validate();
            int[] nArray = new int[5];
            if (this.mSlots[0] != null) {
                nArray[0] = this.mSlots[0].env.mID;
                nArray[1] = this.mSlots[0].format.mID;
            }
            if (this.mSlots[1] != null) {
                nArray[2] = this.mSlots[1].env.mID;
                nArray[3] = this.mSlots[1].format.mID;
            }
            int n = this.mPointSpriteEnable ? 1 : 0;
            nArray[4] = n;
            ProgramFragment programFragment = new ProgramFragment(this.mRS.nProgramFragmentCreate(nArray), this.mRS);
            programFragment.mTextureCount = 2;
            return programFragment;
        }

        public void setPointSpriteTexCoordinateReplacement(boolean bl) {
            this.mPointSpriteEnable = bl;
        }

        public void setTexture(EnvMode envMode, Format format, int n) throws IllegalArgumentException {
            if (n < 0 || n >= 2) {
                throw new IllegalArgumentException("MAX_TEXTURE exceeded.");
            }
            this.mSlots[n] = new Slot(envMode, format);
        }

        public static final class EnvMode
        extends Enum<EnvMode> {
            private static final /* synthetic */ EnvMode[] $VALUES;
            public static final /* enum */ EnvMode DECAL;
            public static final /* enum */ EnvMode MODULATE;
            public static final /* enum */ EnvMode REPLACE;
            int mID;

            static {
                REPLACE = new EnvMode(1);
                MODULATE = new EnvMode(2);
                DECAL = new EnvMode(3);
                EnvMode[] envModeArray = new EnvMode[]{REPLACE, MODULATE, DECAL};
                $VALUES = envModeArray;
            }

            private EnvMode(int n2) {
                this.mID = n2;
            }

            public static EnvMode valueOf(String string2) {
                return Enum.valueOf(EnvMode.class, string2);
            }

            public static EnvMode[] values() {
                return (EnvMode[])$VALUES.clone();
            }
        }

        public static final class Format
        extends Enum<Format> {
            private static final /* synthetic */ Format[] $VALUES;
            public static final /* enum */ Format ALPHA = new Format(1);
            public static final /* enum */ Format LUMINANCE_ALPHA = new Format(2);
            public static final /* enum */ Format RGB = new Format(3);
            public static final /* enum */ Format RGBA = new Format(4);
            int mID;

            static {
                Format[] formatArray = new Format[]{ALPHA, LUMINANCE_ALPHA, RGB, RGBA};
                $VALUES = formatArray;
            }

            private Format(int n2) {
                this.mID = n2;
            }

            public static Format valueOf(String string2) {
                return Enum.valueOf(Format.class, string2);
            }

            public static Format[] values() {
                return (Format[])$VALUES.clone();
            }
        }

        private class Slot {
            EnvMode env;
            Format format;

            Slot(EnvMode envMode, Format format) {
                this.env = envMode;
                this.format = format;
            }
        }
    }

    public static class ShaderBuilder
    extends Program.BaseProgramBuilder {
        public ShaderBuilder(RenderScript renderScript) {
            super(renderScript);
        }

        public ProgramFragment create() {
            this.mRS.validate();
            int[] nArray = new int[2 * (1 + (this.mInputCount + this.mOutputCount + this.mConstantCount))];
            int n = 0;
            for (int i = 0; i < this.mInputCount; ++i) {
                int n2 = n + 1;
                nArray[n] = 0;
                n = n2 + 1;
                nArray[n2] = this.mInputs[i].mID;
            }
            for (int i = 0; i < this.mOutputCount; ++i) {
                int n3 = n + 1;
                nArray[n] = 1;
                n = n3 + 1;
                nArray[n3] = this.mOutputs[i].mID;
            }
            for (int i = 0; i < this.mConstantCount; ++i) {
                int n4 = n + 1;
                nArray[n] = 2;
                n = n4 + 1;
                nArray[n4] = this.mConstants[i].mID;
            }
            int n5 = n + 1;
            nArray[n] = 3;
            int cfr_ignored_0 = n5 + 1;
            nArray[n5] = this.mTextureCount;
            ProgramFragment programFragment = new ProgramFragment(this.mRS.nProgramFragmentCreate2(this.mShader, nArray), this.mRS);
            this.initProgram(programFragment);
            return programFragment;
        }
    }
}

