/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RenderScript;

public class ProgramRaster
extends BaseObj {
    Element mIn;
    boolean mLineSmooth;
    float mLineWidth;
    Element mOut;
    float mPointSize;
    boolean mPointSmooth;
    boolean mPointSprite;

    ProgramRaster(int n, RenderScript renderScript) {
        super(renderScript);
        this.mID = n;
        this.mPointSize = 1.0f;
        this.mLineWidth = 1.0f;
        this.mPointSmooth = false;
        this.mLineSmooth = false;
        this.mPointSprite = false;
    }

    void internalInit() {
        Element element = this.mIn;
        int n = 0;
        if (element != null) {
            n = this.mIn.mID;
        }
        Element element2 = this.mOut;
        int n2 = 0;
        if (element2 != null) {
            n2 = this.mOut.mID;
        }
        this.mID = this.mRS.nProgramRasterCreate(n, n2, this.mPointSmooth, this.mLineSmooth, this.mPointSprite);
    }

    public void setLineWidth(float f) {
        this.mRS.validate();
        this.mLineWidth = f;
        this.mRS.nProgramRasterSetLineWidth(this.mID, f);
    }

    public void setPointSize(float f) {
        this.mRS.validate();
        this.mPointSize = f;
        this.mRS.nProgramRasterSetPointSize(this.mID, f);
    }

    public static class Builder {
        ProgramRaster mPR;
        RenderScript mRS;

        public Builder(RenderScript renderScript, Element element, Element element2) {
            this.mRS = renderScript;
            this.mPR = new ProgramRaster(0, renderScript);
        }

        static ProgramRaster internalCreate(RenderScript renderScript, Builder builder) {
            synchronized (Builder.class) {
                builder.mPR.internalInit();
                ProgramRaster programRaster = builder.mPR;
                builder.mPR = new ProgramRaster(0, builder.mRS);
                return programRaster;
            }
        }

        public ProgramRaster create() {
            this.mRS.validate();
            return Builder.internalCreate(this.mRS, this);
        }

        public void setLineSmoothEnable(boolean bl) {
            this.mPR.mLineSmooth = bl;
        }

        public void setPointSmoothEnable(boolean bl) {
            this.mPR.mPointSmooth = bl;
        }

        public void setPointSpriteEnable(boolean bl) {
            this.mPR.mPointSprite = bl;
        }
    }
}

