/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RenderScript;

public class ProgramStore
extends BaseObj {
    ProgramStore(int n, RenderScript renderScript) {
        super(renderScript);
        this.mID = n;
    }

    public static final class BlendDstFunc
    extends Enum<BlendDstFunc> {
        private static final /* synthetic */ BlendDstFunc[] $VALUES;
        public static final /* enum */ BlendDstFunc DST_ALPHA;
        public static final /* enum */ BlendDstFunc ONE;
        public static final /* enum */ BlendDstFunc ONE_MINUS_DST_ALPHA;
        public static final /* enum */ BlendDstFunc ONE_MINUS_SRC_ALPHA;
        public static final /* enum */ BlendDstFunc ONE_MINUS_SRC_COLOR;
        public static final /* enum */ BlendDstFunc SRC_ALPHA;
        public static final /* enum */ BlendDstFunc SRC_COLOR;
        public static final /* enum */ BlendDstFunc ZERO;
        int mID;

        static {
            ZERO = new BlendDstFunc(0);
            ONE = new BlendDstFunc(1);
            SRC_COLOR = new BlendDstFunc(2);
            ONE_MINUS_SRC_COLOR = new BlendDstFunc(3);
            SRC_ALPHA = new BlendDstFunc(4);
            ONE_MINUS_SRC_ALPHA = new BlendDstFunc(5);
            DST_ALPHA = new BlendDstFunc(6);
            ONE_MINUS_DST_ALPHA = new BlendDstFunc(7);
            BlendDstFunc[] blendDstFuncArray = new BlendDstFunc[]{ZERO, ONE, SRC_COLOR, ONE_MINUS_SRC_COLOR, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, DST_ALPHA, ONE_MINUS_DST_ALPHA};
            $VALUES = blendDstFuncArray;
        }

        private BlendDstFunc(int n2) {
            this.mID = n2;
        }

        public static BlendDstFunc valueOf(String string2) {
            return Enum.valueOf(BlendDstFunc.class, string2);
        }

        public static BlendDstFunc[] values() {
            return (BlendDstFunc[])$VALUES.clone();
        }
    }

    public static final class BlendSrcFunc
    extends Enum<BlendSrcFunc> {
        private static final /* synthetic */ BlendSrcFunc[] $VALUES;
        public static final /* enum */ BlendSrcFunc DST_ALPHA;
        public static final /* enum */ BlendSrcFunc DST_COLOR;
        public static final /* enum */ BlendSrcFunc ONE;
        public static final /* enum */ BlendSrcFunc ONE_MINUS_DST_ALPHA;
        public static final /* enum */ BlendSrcFunc ONE_MINUS_DST_COLOR;
        public static final /* enum */ BlendSrcFunc ONE_MINUS_SRC_ALPHA;
        public static final /* enum */ BlendSrcFunc SRC_ALPHA;
        public static final /* enum */ BlendSrcFunc SRC_ALPHA_SATURATE;
        public static final /* enum */ BlendSrcFunc ZERO;
        int mID;

        static {
            ZERO = new BlendSrcFunc(0);
            ONE = new BlendSrcFunc(1);
            DST_COLOR = new BlendSrcFunc(2);
            ONE_MINUS_DST_COLOR = new BlendSrcFunc(3);
            SRC_ALPHA = new BlendSrcFunc(4);
            ONE_MINUS_SRC_ALPHA = new BlendSrcFunc(5);
            DST_ALPHA = new BlendSrcFunc(6);
            ONE_MINUS_DST_ALPHA = new BlendSrcFunc(7);
            SRC_ALPHA_SATURATE = new BlendSrcFunc(8);
            BlendSrcFunc[] blendSrcFuncArray = new BlendSrcFunc[]{ZERO, ONE, DST_COLOR, ONE_MINUS_DST_COLOR, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, DST_ALPHA, ONE_MINUS_DST_ALPHA, SRC_ALPHA_SATURATE};
            $VALUES = blendSrcFuncArray;
        }

        private BlendSrcFunc(int n2) {
            this.mID = n2;
        }

        public static BlendSrcFunc valueOf(String string2) {
            return Enum.valueOf(BlendSrcFunc.class, string2);
        }

        public static BlendSrcFunc[] values() {
            return (BlendSrcFunc[])$VALUES.clone();
        }
    }

    public static class Builder {
        BlendDstFunc mBlendDst;
        BlendSrcFunc mBlendSrc;
        boolean mColorMaskA;
        boolean mColorMaskB;
        boolean mColorMaskG;
        boolean mColorMaskR;
        DepthFunc mDepthFunc;
        boolean mDepthMask;
        boolean mDither;
        Element mIn;
        Element mOut;
        RenderScript mRS;

        public Builder(RenderScript renderScript, Element element, Element element2) {
            this.mRS = renderScript;
            this.mIn = element;
            this.mOut = element2;
            this.mDepthFunc = DepthFunc.ALWAYS;
            this.mDepthMask = false;
            this.mColorMaskR = true;
            this.mColorMaskG = true;
            this.mColorMaskB = true;
            this.mColorMaskA = true;
            this.mBlendSrc = BlendSrcFunc.ONE;
            this.mBlendDst = BlendDstFunc.ZERO;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static ProgramStore internalCreate(RenderScript renderScript, Builder builder) {
            synchronized (Builder.class) {
                Element element = builder.mIn;
                int n = 0;
                if (element != null) {
                    n = builder.mIn.mID;
                }
                Element element2 = builder.mOut;
                int n2 = 0;
                if (element2 != null) {
                    n2 = builder.mOut.mID;
                }
                renderScript.nProgramFragmentStoreBegin(n, n2);
                renderScript.nProgramFragmentStoreDepthFunc(builder.mDepthFunc.mID);
                renderScript.nProgramFragmentStoreDepthMask(builder.mDepthMask);
                renderScript.nProgramFragmentStoreColorMask(builder.mColorMaskR, builder.mColorMaskG, builder.mColorMaskB, builder.mColorMaskA);
                renderScript.nProgramFragmentStoreBlendFunc(builder.mBlendSrc.mID, builder.mBlendDst.mID);
                renderScript.nProgramFragmentStoreDither(builder.mDither);
                return new ProgramStore(renderScript.nProgramFragmentStoreCreate(), renderScript);
            }
        }

        public ProgramStore create() {
            this.mRS.validate();
            return Builder.internalCreate(this.mRS, this);
        }

        public void setBlendFunc(BlendSrcFunc blendSrcFunc, BlendDstFunc blendDstFunc) {
            this.mBlendSrc = blendSrcFunc;
            this.mBlendDst = blendDstFunc;
        }

        public void setColorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.mColorMaskR = bl;
            this.mColorMaskG = bl2;
            this.mColorMaskB = bl3;
            this.mColorMaskA = bl4;
        }

        public void setDepthFunc(DepthFunc depthFunc) {
            this.mDepthFunc = depthFunc;
        }

        public void setDepthMask(boolean bl) {
            this.mDepthMask = bl;
        }

        public void setDitherEnable(boolean bl) {
            this.mDither = bl;
        }
    }

    public static final class DepthFunc
    extends Enum<DepthFunc> {
        private static final /* synthetic */ DepthFunc[] $VALUES;
        public static final /* enum */ DepthFunc ALWAYS = new DepthFunc(0);
        public static final /* enum */ DepthFunc EQUAL;
        public static final /* enum */ DepthFunc GEQUAL;
        public static final /* enum */ DepthFunc GREATER;
        public static final /* enum */ DepthFunc LEQUAL;
        public static final /* enum */ DepthFunc LESS;
        public static final /* enum */ DepthFunc NOTEQUAL;
        int mID;

        static {
            LESS = new DepthFunc(1);
            LEQUAL = new DepthFunc(2);
            GREATER = new DepthFunc(3);
            GEQUAL = new DepthFunc(4);
            EQUAL = new DepthFunc(5);
            NOTEQUAL = new DepthFunc(6);
            DepthFunc[] depthFuncArray = new DepthFunc[]{ALWAYS, LESS, LEQUAL, GREATER, GEQUAL, EQUAL, NOTEQUAL};
            $VALUES = depthFuncArray;
        }

        private DepthFunc(int n2) {
            this.mID = n2;
        }

        public static DepthFunc valueOf(String string2) {
            return Enum.valueOf(DepthFunc.class, string2);
        }

        public static DepthFunc[] values() {
            return (DepthFunc[])$VALUES.clone();
        }
    }
}

