/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.Matrix4f;
import android.renderscript.Program;
import android.renderscript.RenderScript;

public class ProgramVertex
extends Program {
    public static final int MAX_LIGHT = 8;

    ProgramVertex(int n, RenderScript renderScript) {
        super(n, renderScript);
    }

    public void bindAllocation(MatrixAllocation matrixAllocation) {
        this.mRS.validate();
        this.bindConstants(matrixAllocation.mAlloc, 0);
    }

    public static class Builder {
        RenderScript mRS;
        boolean mTextureMatrixEnable;

        public Builder(RenderScript renderScript, Element element, Element element2) {
            this.mRS = renderScript;
        }

        public ProgramVertex create() {
            return new ProgramVertex(this.mRS.nProgramVertexCreate(this.mTextureMatrixEnable), this.mRS);
        }

        public void setTextureMatrixEnable(boolean bl) {
            this.mTextureMatrixEnable = bl;
        }
    }

    public static class MatrixAllocation {
        static final int MODELVIEW_OFFSET = 0;
        static final int PROJECTION_OFFSET = 16;
        static final int TEXTURE_OFFSET = 32;
        public Allocation mAlloc;
        Matrix4f mModel = new Matrix4f();
        Matrix4f mProjection = new Matrix4f();
        Matrix4f mTexture = new Matrix4f();

        public MatrixAllocation(RenderScript renderScript) {
            this.mAlloc = Allocation.createSized(renderScript, Element.createUser(renderScript, Element.DataType.FLOAT_32), 48);
            this.mAlloc.subData1D(0, 16, this.mModel.mMat);
            this.mAlloc.subData1D(16, 16, this.mProjection.mMat);
            this.mAlloc.subData1D(32, 16, this.mTexture.mMat);
        }

        public void destroy() {
            this.mAlloc.destroy();
            this.mAlloc = null;
        }

        public void loadModelview(Matrix4f matrix4f) {
            this.mModel = matrix4f;
            this.mAlloc.subData1D(0, 16, matrix4f.mMat);
        }

        public void loadProjection(Matrix4f matrix4f) {
            this.mProjection = matrix4f;
            this.mAlloc.subData1D(16, 16, matrix4f.mMat);
        }

        public void loadTexture(Matrix4f matrix4f) {
            this.mTexture = matrix4f;
            this.mAlloc.subData1D(32, 16, matrix4f.mMat);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setupOrthoNormalized(int n, int n2) {
            if (n > n2) {
                float f = (float)n / (float)n2;
                this.mProjection.loadOrtho(-f, f, -1.0f, 1.0f, -1.0f, 1.0f);
            } else {
                float f = (float)n2 / (float)n;
                this.mProjection.loadOrtho(-1.0f, 1.0f, -f, f, -1.0f, 1.0f);
            }
            this.mAlloc.subData1D(16, 16, this.mProjection.mMat);
        }

        public void setupOrthoWindow(int n, int n2) {
            this.mProjection.loadOrtho(0.0f, n, n2, 0.0f, -1.0f, 1.0f);
            this.mAlloc.subData1D(16, 16, this.mProjection.mMat);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setupProjectionNormalized(int n, int n2) {
            Matrix4f matrix4f = new Matrix4f();
            Matrix4f matrix4f2 = new Matrix4f();
            if (n > n2) {
                float f = (float)n / (float)n2;
                matrix4f.loadFrustum(-f, f, -1.0f, 1.0f, 1.0f, 100.0f);
            } else {
                float f = (float)n2 / (float)n;
                matrix4f.loadFrustum(-1.0f, 1.0f, -f, f, 1.0f, 100.0f);
            }
            matrix4f2.loadRotate(180.0f, 0.0f, 1.0f, 0.0f);
            matrix4f.loadMultiply(matrix4f, matrix4f2);
            matrix4f2.loadScale(-2.0f, 2.0f, 1.0f);
            matrix4f.loadMultiply(matrix4f, matrix4f2);
            matrix4f2.loadTranslate(0.0f, 0.0f, 2.0f);
            matrix4f.loadMultiply(matrix4f, matrix4f2);
            this.mProjection = matrix4f;
            this.mAlloc.subData1D(16, 16, this.mProjection.mMat);
        }
    }

    public static class ShaderBuilder
    extends Program.BaseProgramBuilder {
        public ShaderBuilder(RenderScript renderScript) {
            super(renderScript);
        }

        public ProgramVertex create() {
            this.mRS.validate();
            int[] nArray = new int[2 * (1 + (this.mInputCount + this.mOutputCount + this.mConstantCount))];
            int n = 0;
            for (int i = 0; i < this.mInputCount; ++i) {
                int n2 = n + 1;
                nArray[n] = 0;
                n = n2 + 1;
                nArray[n2] = this.mInputs[i].mID;
            }
            for (int i = 0; i < this.mOutputCount; ++i) {
                int n3 = n + 1;
                nArray[n] = 1;
                n = n3 + 1;
                nArray[n3] = this.mOutputs[i].mID;
            }
            for (int i = 0; i < this.mConstantCount; ++i) {
                int n4 = n + 1;
                nArray[n] = 2;
                n = n4 + 1;
                nArray[n4] = this.mConstants[i].mID;
            }
            int n5 = n + 1;
            nArray[n] = 3;
            int cfr_ignored_0 = n5 + 1;
            nArray[n5] = this.mTextureCount;
            ProgramVertex programVertex = new ProgramVertex(this.mRS.nProgramVertexCreate2(this.mShader, nArray), this.mRS);
            this.initProgram(programVertex);
            return programVertex;
        }
    }
}

