/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.Context;
import android.renderscript.RenderScriptGL;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;

public class RSSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    private RenderScriptGL mRS;
    private SurfaceHolder mSurfaceHolder;

    public RSSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public RSSurfaceView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    private void init() {
        this.getHolder().addCallback(this);
    }

    public RenderScriptGL createRenderScript(boolean bl) {
        return this.createRenderScript(bl, false);
    }

    public RenderScriptGL createRenderScript(boolean bl, boolean bl2) {
        Log.v("RenderScript_jni", "createRenderScript");
        this.mRS = new RenderScriptGL(bl, bl2);
        return this.mRS;
    }

    public void createRenderScript(RenderScriptGL renderScriptGL) {
        this.mRS = renderScriptGL;
    }

    public void destroyRenderScript() {
        Log.v("RenderScript_jni", "destroyRenderScript");
        this.mRS.destroy();
        this.mRS = null;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public void onPause() {
        if (this.mRS != null) {
            this.mRS.pause();
        }
    }

    public void onResume() {
        if (this.mRS != null) {
            this.mRS.resume();
        }
    }

    public void queueEvent(Runnable runnable) {
    }

    @Override
    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        Log.v("RenderScript_jni", "surfaceChanged");
        if (this.mRS != null) {
            this.mRS.contextSetSurface(n2, n3, surfaceHolder.getSurface());
        }
    }

    @Override
    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        Log.v("RenderScript_jni", "surfaceCreated");
        this.mSurfaceHolder = surfaceHolder;
    }

    @Override
    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Log.v("RenderScript_jni", "surfaceDestroyed");
        if (this.mRS != null) {
            this.mRS.contextSetSurface(0, 0, null);
        }
    }
}

