/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.graphics.Bitmap;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.Type;
import android.util.Log;
import android.view.Surface;
import java.lang.reflect.Field;

public class RenderScript {
    protected static final boolean DEBUG = false;
    protected static final boolean LOG_ENABLED = false;
    static final String LOG_TAG = "RenderScript_jni";
    protected static boolean sInitialized = false;
    protected int mContext;
    protected int mDev;
    Element mElement_A_8;
    Element mElement_COLOR_F32_4;
    Element mElement_COLOR_U8_4;
    Element mElement_INDEX_16;
    Element mElement_NORMAL_3;
    Element mElement_POSITION_2;
    Element mElement_POSITION_3;
    Element mElement_RGBA_4444;
    Element mElement_RGBA_5551;
    Element mElement_RGBA_8888;
    Element mElement_RGB_565;
    Element mElement_RGB_888;
    Element mElement_TEXTURE_2;
    Element mElement_USER_F32;
    Element mElement_USER_I16;
    Element mElement_USER_I32;
    Element mElement_USER_I8;
    Element mElement_USER_U16;
    Element mElement_USER_U32;
    Element mElement_USER_U8;
    public RSMessage mMessageCallback = null;
    protected MessageThread mMessageThread;

    static {
        try {
            System.loadLibrary("rs_jni");
            RenderScript._nInit();
            sInitialized = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Log.d(LOG_TAG, "RenderScript JNI library not found!");
        }
    }

    protected RenderScript() {
    }

    protected static native void _nInit();

    public static RenderScript create() {
        RenderScript renderScript = new RenderScript();
        renderScript.mDev = renderScript.nDeviceCreate();
        renderScript.mContext = renderScript.nContextCreate(renderScript.mDev, 0);
        renderScript.mMessageThread = new MessageThread(renderScript);
        renderScript.mMessageThread.start();
        Element.initPredefined(renderScript);
        return renderScript;
    }

    public void contextDump(int n) {
        this.validate();
        this.nContextDump(n);
    }

    public void contextSetPriority(Priority priority) {
        this.validate();
        this.nContextSetPriority(priority.mID);
    }

    public void destroy() {
        this.validate();
        this.nContextDeinitToClient();
        this.mMessageThread.mRun = false;
        this.nContextDestroy(this.mContext);
        this.mContext = 0;
        this.nDeviceDestroy(this.mDev);
        this.mDev = 0;
    }

    boolean isAlive() {
        return this.mContext != 0;
    }

    native void nAdapter1DBindAllocation(int var1, int var2);

    native int nAdapter1DCreate();

    native void nAdapter1DData(int var1, float[] var2);

    native void nAdapter1DData(int var1, int[] var2);

    native void nAdapter1DSetConstraint(int var1, int var2, int var3);

    native void nAdapter1DSubData(int var1, int var2, int var3, float[] var4);

    native void nAdapter1DSubData(int var1, int var2, int var3, int[] var4);

    native void nAdapter2DBindAllocation(int var1, int var2);

    native int nAdapter2DCreate();

    native void nAdapter2DData(int var1, float[] var2);

    native void nAdapter2DData(int var1, int[] var2);

    native void nAdapter2DSetConstraint(int var1, int var2, int var3);

    native void nAdapter2DSubData(int var1, int var2, int var3, int var4, int var5, float[] var6);

    native void nAdapter2DSubData(int var1, int var2, int var3, int var4, int var5, int[] var6);

    native int nAllocationCreateBitmapRef(int var1, Bitmap var2);

    native int nAllocationCreateFromAssetStream(int var1, boolean var2, int var3);

    native int nAllocationCreateFromBitmap(int var1, boolean var2, Bitmap var3);

    native int nAllocationCreateFromBitmapBoxed(int var1, boolean var2, Bitmap var3);

    native int nAllocationCreateTyped(int var1);

    native void nAllocationRead(int var1, float[] var2);

    native void nAllocationRead(int var1, int[] var2);

    native void nAllocationSubData1D(int var1, int var2, int var3, byte[] var4, int var5);

    native void nAllocationSubData1D(int var1, int var2, int var3, float[] var4, int var5);

    native void nAllocationSubData1D(int var1, int var2, int var3, int[] var4, int var5);

    native void nAllocationSubData1D(int var1, int var2, int var3, short[] var4, int var5);

    native void nAllocationSubData2D(int var1, int var2, int var3, int var4, int var5, float[] var6, int var7);

    native void nAllocationSubData2D(int var1, int var2, int var3, int var4, int var5, int[] var6, int var7);

    native void nAllocationSubDataFromObject(int var1, Type var2, int var3, Object var4);

    native void nAllocationSubReadFromObject(int var1, Type var2, int var3, Object var4);

    native void nAllocationUploadToBufferObject(int var1);

    native void nAllocationUploadToTexture(int var1, boolean var2, int var3);

    native void nAnimationAdd(float var1, float[] var2);

    native void nAnimationBegin(int var1, int var2);

    native int nAnimationCreate();

    native void nAssignName(int var1, byte[] var2);

    native void nContextBindProgramFragment(int var1);

    native void nContextBindProgramFragmentStore(int var1);

    native void nContextBindProgramRaster(int var1);

    native void nContextBindProgramVertex(int var1);

    native void nContextBindRootScript(int var1);

    native void nContextBindSampler(int var1, int var2);

    native int nContextCreate(int var1, int var2);

    native int nContextCreateGL(int var1, int var2, boolean var3);

    native void nContextDeinitToClient();

    native void nContextDestroy(int var1);

    native void nContextDump(int var1);

    native int nContextGetMessage(int[] var1, boolean var2);

    native void nContextInitToClient();

    native void nContextPause();

    native void nContextResume();

    native void nContextSetPriority(int var1);

    native void nContextSetSurface(int var1, int var2, Surface var3);

    native int nDeviceCreate();

    native void nDeviceDestroy(int var1);

    native void nDeviceSetConfig(int var1, int var2, int var3);

    native int nElementCreate(int var1, int var2, boolean var3, int var4);

    native int nElementCreate2(int[] var1, String[] var2);

    native int nFileOpen(byte[] var1);

    native void nInitElements(int var1, int var2, int var3, int var4);

    native void nLightBegin();

    native int nLightCreate();

    native void nLightSetColor(int var1, float var2, float var3, float var4);

    native void nLightSetIsLocal(boolean var1);

    native void nLightSetIsMono(boolean var1);

    native void nLightSetPosition(int var1, float var2, float var3, float var4);

    native void nObjDestroy(int var1);

    native void nObjDestroyOOB(int var1);

    native void nProgramBindConstants(int var1, int var2, int var3);

    native void nProgramBindSampler(int var1, int var2, int var3);

    native void nProgramBindTexture(int var1, int var2, int var3);

    native int nProgramFragmentCreate(int[] var1);

    native int nProgramFragmentCreate2(String var1, int[] var2);

    native void nProgramFragmentStoreBegin(int var1, int var2);

    native void nProgramFragmentStoreBlendFunc(int var1, int var2);

    native void nProgramFragmentStoreColorMask(boolean var1, boolean var2, boolean var3, boolean var4);

    native int nProgramFragmentStoreCreate();

    native void nProgramFragmentStoreDepthFunc(int var1);

    native void nProgramFragmentStoreDepthMask(boolean var1);

    native void nProgramFragmentStoreDither(boolean var1);

    native int nProgramRasterCreate(int var1, int var2, boolean var3, boolean var4, boolean var5);

    native void nProgramRasterSetLineWidth(int var1, float var2);

    native void nProgramRasterSetPointSize(int var1, float var2);

    native int nProgramVertexCreate(boolean var1);

    native int nProgramVertexCreate2(String var1, int[] var2);

    native void nSamplerBegin();

    native int nSamplerCreate();

    native void nSamplerSet(int var1, int var2);

    native void nScriptBindAllocation(int var1, int var2, int var3);

    native void nScriptCAddDefineF(String var1, float var2);

    native void nScriptCAddDefineI32(String var1, int var2);

    native void nScriptCBegin();

    native int nScriptCCreate();

    native void nScriptCSetScript(byte[] var1, int var2, int var3);

    native void nScriptInvoke(int var1, int var2);

    native void nScriptSetClearColor(int var1, float var2, float var3, float var4, float var5);

    native void nScriptSetClearDepth(int var1, float var2);

    native void nScriptSetClearStencil(int var1, int var2);

    native void nScriptSetInvokable(String var1, int var2);

    native void nScriptSetRoot(boolean var1);

    native void nScriptSetTimeZone(int var1, byte[] var2);

    native void nScriptSetType(int var1, boolean var2, String var3, int var4);

    native void nSimpleMeshBindIndex(int var1, int var2);

    native void nSimpleMeshBindVertex(int var1, int var2, int var3);

    native int nSimpleMeshCreate(int var1, int var2, int[] var3, int var4);

    native void nTypeAdd(int var1, int var2);

    native void nTypeBegin(int var1);

    native int nTypeCreate();

    native void nTypeFinalDestroy(Type var1);

    native void nTypeSetupFields(Type var1, int[] var2, int[] var3, Field[] var4);

    protected int safeID(BaseObj baseObj) {
        if (baseObj != null) {
            return baseObj.mID;
        }
        return 0;
    }

    void validate() {
        if (this.mContext == 0) {
            throw new IllegalStateException("Calling RS with no Context active.");
        }
    }

    protected static class MessageThread
    extends Thread {
        RenderScript mRS;
        boolean mRun = true;

        MessageThread(RenderScript renderScript) {
            super("RSMessageThread");
            this.mRS = renderScript;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int[] nArray = new int[16];
            this.mRS.nContextInitToClient();
            while (true) {
                if (!this.mRun) {
                    Log.d(RenderScript.LOG_TAG, "MessageThread exiting.");
                    return;
                }
                int n = this.mRS.nContextGetMessage(nArray, true);
                if (n == 0) {
                    try {
                        MessageThread.sleep(1L, 0);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.mRS.mMessageCallback == null) continue;
                this.mRS.mMessageCallback.mData = nArray;
                this.mRS.mMessageCallback.mID = n;
                this.mRS.mMessageCallback.run();
            }
        }
    }

    public static final class Priority
    extends Enum<Priority> {
        private static final /* synthetic */ Priority[] $VALUES;
        public static final /* enum */ Priority LOW = new Priority(5);
        public static final /* enum */ Priority NORMAL = new Priority(-4);
        int mID;

        static {
            Priority[] priorityArray = new Priority[]{LOW, NORMAL};
            $VALUES = priorityArray;
        }

        private Priority(int n2) {
            this.mID = n2;
        }

        public static Priority valueOf(String string2) {
            return Enum.valueOf(Priority.class, string2);
        }

        public static Priority[] values() {
            return (Priority[])$VALUES.clone();
        }
    }

    public static class RSMessage
    implements Runnable {
        protected int[] mData;
        protected int mID;

        @Override
        public void run() {
        }
    }
}

