/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.ProgramFragment;
import android.renderscript.ProgramRaster;
import android.renderscript.ProgramStore;
import android.renderscript.ProgramVertex;
import android.renderscript.RenderScript;
import android.renderscript.Script;
import android.view.Surface;
import java.io.UnsupportedEncodingException;

public class RenderScriptGL
extends RenderScript {
    int mHeight = 0;
    private Surface mSurface = null;
    int mWidth = 0;

    public RenderScriptGL(boolean bl, boolean bl2) {
        this.mDev = this.nDeviceCreate();
        if (bl2) {
            this.nDeviceSetConfig(this.mDev, 0, 1);
        }
        this.mContext = this.nContextCreateGL(this.mDev, 0, bl);
        this.mMessageThread = new RenderScript.MessageThread(this);
        this.mMessageThread.start();
        Element.initPredefined(this);
    }

    public void contextBindProgramFragment(ProgramFragment programFragment) {
        this.validate();
        this.nContextBindProgramFragment(this.safeID(programFragment));
    }

    public void contextBindProgramFragmentStore(ProgramStore programStore) {
        this.validate();
        this.nContextBindProgramFragmentStore(this.safeID(programStore));
    }

    public void contextBindProgramRaster(ProgramRaster programRaster) {
        this.validate();
        this.nContextBindProgramRaster(this.safeID(programRaster));
    }

    public void contextBindProgramVertex(ProgramVertex programVertex) {
        this.validate();
        this.nContextBindProgramVertex(this.safeID(programVertex));
    }

    public void contextBindRootScript(Script script) {
        this.validate();
        this.nContextBindRootScript(this.safeID(script));
    }

    public void contextSetSurface(int n, int n2, Surface surface) {
        this.mSurface = surface;
        this.mWidth = n;
        this.mHeight = n2;
        this.validate();
        this.nContextSetSurface(n, n2, this.mSurface);
    }

    public File fileOpen(String string2) throws IllegalStateException, IllegalArgumentException {
        if (string2.length() < 1) {
            throw new IllegalArgumentException("fileOpen does not accept a zero length string.");
        }
        try {
            File file = new File(this.nFileOpen(string2.getBytes("UTF-8")));
            return file;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    void pause() {
        this.validate();
        this.nContextPause();
    }

    void resume() {
        this.validate();
        this.nContextResume();
    }

    public class File
    extends BaseObj {
        File(int n) {
            super(RenderScriptGL.this);
            this.mID = n;
        }
    }
}

