/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RenderScript;

public class Sampler
extends BaseObj {
    Sampler(int n, RenderScript renderScript) {
        super(renderScript);
        this.mID = n;
    }

    public static class Builder {
        Value mMag;
        Value mMin;
        RenderScript mRS;
        Value mWrapR;
        Value mWrapS;
        Value mWrapT;

        public Builder(RenderScript renderScript) {
            this.mRS = renderScript;
            this.mMin = Value.NEAREST;
            this.mMag = Value.NEAREST;
            this.mWrapS = Value.WRAP;
            this.mWrapT = Value.WRAP;
            this.mWrapR = Value.WRAP;
        }

        static Sampler internalCreate(RenderScript renderScript, Builder builder) {
            synchronized (Builder.class) {
                renderScript.nSamplerBegin();
                renderScript.nSamplerSet(0, builder.mMin.mID);
                renderScript.nSamplerSet(1, builder.mMag.mID);
                renderScript.nSamplerSet(2, builder.mWrapS.mID);
                renderScript.nSamplerSet(3, builder.mWrapT.mID);
                renderScript.nSamplerSet(4, builder.mWrapR.mID);
                Sampler sampler = new Sampler(renderScript.nSamplerCreate(), renderScript);
                return sampler;
            }
        }

        public Sampler create() {
            this.mRS.validate();
            return Builder.internalCreate(this.mRS, this);
        }

        public void setMag(Value value) {
            if (value == Value.NEAREST || value == Value.LINEAR) {
                this.mMag = value;
                return;
            }
            throw new IllegalArgumentException("Invalid value");
        }

        public void setMin(Value value) {
            if (value == Value.NEAREST || value == Value.LINEAR || value == Value.LINEAR_MIP_LINEAR) {
                this.mMin = value;
                return;
            }
            throw new IllegalArgumentException("Invalid value");
        }

        public void setWrapR(Value value) {
            if (value == Value.WRAP || value == Value.CLAMP) {
                this.mWrapR = value;
                return;
            }
            throw new IllegalArgumentException("Invalid value");
        }

        public void setWrapS(Value value) {
            if (value == Value.WRAP || value == Value.CLAMP) {
                this.mWrapS = value;
                return;
            }
            throw new IllegalArgumentException("Invalid value");
        }

        public void setWrapT(Value value) {
            if (value == Value.WRAP || value == Value.CLAMP) {
                this.mWrapT = value;
                return;
            }
            throw new IllegalArgumentException("Invalid value");
        }
    }

    public static final class Value
    extends Enum<Value> {
        private static final /* synthetic */ Value[] $VALUES;
        public static final /* enum */ Value CLAMP;
        public static final /* enum */ Value LINEAR;
        public static final /* enum */ Value LINEAR_MIP_LINEAR;
        public static final /* enum */ Value NEAREST;
        public static final /* enum */ Value WRAP;
        int mID;

        static {
            NEAREST = new Value(0);
            LINEAR = new Value(1);
            LINEAR_MIP_LINEAR = new Value(2);
            WRAP = new Value(3);
            CLAMP = new Value(4);
            Value[] valueArray = new Value[]{NEAREST, LINEAR, LINEAR_MIP_LINEAR, WRAP, CLAMP};
            $VALUES = valueArray;
        }

        private Value(int n2) {
            this.mID = n2;
        }

        public static Value valueOf(String string2) {
            return Enum.valueOf(Value.class, string2);
        }

        public static Value[] values() {
            return (Value[])$VALUES.clone();
        }
    }
}

