/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import java.io.UnsupportedEncodingException;

public class Script
extends BaseObj {
    public static final int MAX_SLOT = 16;
    Invokable[] mInvokables;
    boolean mIsRoot;
    Type[] mTypes;
    boolean[] mWritable;

    Script(int n, RenderScript renderScript) {
        super(renderScript);
        this.mID = n;
    }

    public void bindAllocation(Allocation allocation, int n) {
        this.mRS.validate();
        this.mRS.nScriptBindAllocation(this.mID, allocation.mID, n);
    }

    public void setClearColor(float f, float f2, float f3, float f4) {
        this.mRS.validate();
        this.mRS.nScriptSetClearColor(this.mID, f, f2, f3, f4);
    }

    public void setClearDepth(float f) {
        this.mRS.validate();
        this.mRS.nScriptSetClearDepth(this.mID, f);
    }

    public void setClearStencil(int n) {
        this.mRS.validate();
        this.mRS.nScriptSetClearStencil(this.mID, n);
    }

    public void setTimeZone(String string2) {
        this.mRS.validate();
        try {
            this.mRS.nScriptSetTimeZone(this.mID, string2.getBytes("UTF-8"));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static class Builder {
        int mInvokableCount = 0;
        Invokable[] mInvokables;
        boolean mIsRoot = false;
        String[] mNames;
        RenderScript mRS;
        Type[] mTypes;
        boolean[] mWritable;

        Builder(RenderScript renderScript) {
            this.mRS = renderScript;
            this.mTypes = new Type[16];
            this.mNames = new String[16];
            this.mWritable = new boolean[16];
            this.mInvokables = new Invokable[16];
        }

        public Invokable addInvokable(String string2) {
            Invokable invokable = new Invokable();
            invokable.mName = string2;
            invokable.mRS = this.mRS;
            invokable.mSlot = this.mInvokableCount;
            Invokable[] invokableArray = this.mInvokables;
            int n = this.mInvokableCount;
            this.mInvokableCount = n + 1;
            invokableArray[n] = invokable;
            return invokable;
        }

        public void setRoot(boolean bl) {
            this.mIsRoot = bl;
        }

        public void setType(Type type, int n) {
            this.mTypes[n] = type;
            this.mNames[n] = null;
        }

        public void setType(Type type, String string2, int n) {
            this.mTypes[n] = type;
            this.mNames[n] = string2;
        }

        public void setType(boolean bl, int n) {
            this.mWritable[n] = bl;
        }

        void transferCreate() {
            this.mRS.nScriptSetRoot(this.mIsRoot);
            for (int i = 0; i < this.mTypes.length; ++i) {
                if (this.mTypes[i] == null) continue;
                this.mRS.nScriptSetType(this.mTypes[i].mID, this.mWritable[i], this.mNames[i], i);
            }
            for (int i = 0; i < this.mInvokableCount; ++i) {
                this.mRS.nScriptSetInvokable(this.mInvokables[i].mName, i);
            }
        }

        void transferObject(Script script) {
            script.mIsRoot = this.mIsRoot;
            script.mTypes = this.mTypes;
            script.mInvokables = new Invokable[this.mInvokableCount];
            for (int i = 0; i < this.mInvokableCount; ++i) {
                script.mInvokables[i] = this.mInvokables[i];
                script.mInvokables[i].mScript = script;
            }
            script.mInvokables = null;
        }
    }

    public static class Invokable {
        String mName;
        RenderScript mRS;
        Script mScript;
        int mSlot = -1;

        Invokable() {
        }

        public void execute() {
            this.mRS.nScriptInvoke(this.mScript.mID, this.mSlot);
        }
    }
}

