/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.Resources;
import android.renderscript.RenderScript;
import android.renderscript.Script;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ScriptC
extends Script {
    private static final String TAG = "ScriptC";

    ScriptC(int n, RenderScript renderScript) {
        super(n, renderScript);
    }

    public static class Builder
    extends Script.Builder {
        HashMap<String, Float> mFloatDefines;
        HashMap<String, Integer> mIntDefines = new HashMap();
        byte[] mProgram;
        int mProgramLength;

        public Builder(RenderScript renderScript) {
            super(renderScript);
            this.mFloatDefines = new HashMap();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static ScriptC internalCreate(Builder builder) {
            synchronized (Builder.class) {
                builder.mRS.nScriptCBegin();
                builder.transferCreate();
                for (Map.Entry<String, Integer> entry : builder.mIntDefines.entrySet()) {
                    builder.mRS.nScriptCAddDefineI32(entry.getKey(), entry.getValue());
                }
                Iterator<Map.Entry<String, Float>> iterator = builder.mFloatDefines.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        builder.mRS.nScriptCSetScript(builder.mProgram, 0, builder.mProgramLength);
                        ScriptC scriptC = new ScriptC(builder.mRS.nScriptCCreate(), builder.mRS);
                        builder.transferObject(scriptC);
                        return scriptC;
                    }
                    Map.Entry<String, Float> entry = iterator.next();
                    builder.mRS.nScriptCAddDefineF(entry.getKey(), entry.getValue().floatValue());
                }
            }
        }

        public void addDefine(String string2, float f) {
            this.mFloatDefines.put(string2, Float.valueOf(f));
        }

        public void addDefine(String string2, int n) {
            this.mIntDefines.put(string2, n);
        }

        public void addDefines(Class clazz) {
            this.addDefines(clazz.getFields(), 25, null);
        }

        public void addDefines(Object object) {
            this.addDefines(object.getClass().getFields(), 1, object);
        }

        void addDefines(Field[] fieldArray, int n, Object object) {
            int n2 = fieldArray.length;
            int n3 = 0;
            while (true) {
                block8: {
                    if (n3 < n2) {
                        Field field = fieldArray[n3];
                        try {
                            if ((n & field.getModifiers()) != n) break block8;
                            Class<?> clazz = field.getType();
                            if (clazz == Integer.TYPE) {
                                this.mIntDefines.put(field.getName(), field.getInt(object));
                            } else if (clazz == Float.TYPE) {
                                this.mFloatDefines.put(field.getName(), Float.valueOf(field.getFloat(object)));
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            Log.d(ScriptC.TAG, "addDefines skipping field " + field.getName());
                        }
                    } else {
                        return;
                    }
                }
                ++n3;
            }
        }

        public ScriptC create() {
            return Builder.internalCreate(this);
        }

        /*
         * Loose catch block
         */
        public void setScript(Resources resources, int n) {
            InputStream inputStream = resources.openRawResource(n);
            this.setScript(inputStream);
            inputStream.close();
            return;
            {
                catch (IOException iOException) {
                    throw new Resources.NotFoundException();
                }
            }
            catch (Throwable throwable) {
                inputStream.close();
                throw throwable;
            }
        }

        public void setScript(InputStream inputStream) throws IOException {
            byte[] byArray = new byte[1024];
            int n = 0;
            while (true) {
                int n2;
                int n3;
                if ((n3 = byArray.length - n) == 0) {
                    byte[] byArray2 = new byte[2 * byArray.length];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                    byArray = byArray2;
                    n3 = byArray.length - n;
                }
                if ((n2 = inputStream.read(byArray, n, n3)) <= 0) {
                    this.mProgram = byArray;
                    this.mProgramLength = n;
                    return;
                }
                n += n2;
            }
        }

        public void setScript(String string2) {
            try {
                this.mProgram = string2.getBytes("UTF-8");
                this.mProgramLength = this.mProgram.length;
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
    }
}

