/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Dimension;
import android.renderscript.Element;
import android.renderscript.Primitive;
import android.renderscript.RenderScript;
import android.renderscript.Type;

public class SimpleMesh
extends BaseObj {
    Type mIndexType;
    Primitive mPrimitive;
    Type[] mVertexTypes;

    SimpleMesh(int n, RenderScript renderScript) {
        super(renderScript);
        this.mID = n;
    }

    public void bindIndexAllocation(Allocation allocation) {
        this.mRS.validate();
        this.mRS.nSimpleMeshBindIndex(this.mID, allocation.mID);
    }

    public void bindVertexAllocation(Allocation allocation, int n) {
        this.mRS.validate();
        this.mRS.nSimpleMeshBindVertex(this.mID, allocation.mID, n);
    }

    public Allocation createIndexAllocation() {
        this.mRS.validate();
        return Allocation.createTyped(this.mRS, this.mIndexType);
    }

    public Allocation createVertexAllocation(int n) {
        this.mRS.validate();
        return Allocation.createTyped(this.mRS, this.mVertexTypes[n]);
    }

    public Type getIndexType() {
        return this.mIndexType;
    }

    public Type getVertexType(int n) {
        return this.mVertexTypes[n];
    }

    public static class Builder {
        Entry mIndexType;
        Primitive mPrimitive;
        RenderScript mRS;
        int mVertexTypeCount;
        Entry[] mVertexTypes;

        public Builder(RenderScript renderScript) {
            this.mRS = renderScript;
            this.mVertexTypeCount = 0;
            this.mVertexTypes = new Entry[16];
            this.mIndexType = new Entry();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static SimpleMesh internalCreate(RenderScript renderScript, Builder builder) {
            synchronized (Builder.class) {
                int n;
                Type[] typeArray = new Type[18];
                int n2 = 0;
                if (builder.mIndexType.t != null) {
                    n = builder.mIndexType.t.mID;
                } else {
                    int n3 = builder.mIndexType.size;
                    n = 0;
                    n2 = 0;
                    if (n3 != 0) {
                        builder.mIndexType.t = builder.newType(builder.mIndexType.e, builder.mIndexType.size);
                        n = builder.mIndexType.t.mID;
                        int n4 = 0 + 1;
                        typeArray[0] = builder.mIndexType.t;
                        n2 = n4;
                    }
                }
                int[] nArray = new int[builder.mVertexTypeCount];
                int n5 = 0;
                int n6 = n2;
                while (true) {
                    int n7;
                    if (n5 < builder.mVertexTypeCount) {
                        if (builder.mVertexTypes[n5].t != null) {
                            nArray[n5] = builder.mVertexTypes[n5].t.mID;
                            n7 = n6;
                        } else {
                            builder.mVertexTypes[n5].t = builder.newType(builder.mVertexTypes[n5].e, builder.mVertexTypes[n5].size);
                            nArray[n5] = builder.mVertexTypes[n5].t.mID;
                            n7 = n6 + 1;
                            typeArray[n6] = builder.mVertexTypes[n5].t;
                        }
                    } else {
                        int n8 = renderScript.nSimpleMeshCreate(0, n, nArray, builder.mPrimitive.mID);
                        int n9 = 0;
                        while (true) {
                            if (n9 >= n6) {
                                return new SimpleMesh(n8, renderScript);
                            }
                            typeArray[n9].destroy();
                            ++n9;
                        }
                    }
                    ++n5;
                    n6 = n7;
                }
            }
        }

        public int addVertexType(Element element, int n) throws IllegalStateException {
            if (this.mVertexTypeCount >= this.mVertexTypes.length) {
                throw new IllegalStateException("Max vertex types exceeded.");
            }
            int n2 = this.mVertexTypeCount;
            this.mVertexTypes[this.mVertexTypeCount] = new Entry();
            this.mVertexTypes[this.mVertexTypeCount].e = element;
            this.mVertexTypes[this.mVertexTypeCount].size = n;
            this.mVertexTypeCount = 1 + this.mVertexTypeCount;
            return n2;
        }

        public int addVertexType(Type type) throws IllegalStateException {
            if (this.mVertexTypeCount >= this.mVertexTypes.length) {
                throw new IllegalStateException("Max vertex types exceeded.");
            }
            int n = this.mVertexTypeCount;
            this.mVertexTypes[this.mVertexTypeCount] = new Entry();
            this.mVertexTypes[this.mVertexTypeCount].t = type;
            this.mVertexTypeCount = 1 + this.mVertexTypeCount;
            return n;
        }

        public SimpleMesh create() {
            this.mRS.validate();
            SimpleMesh simpleMesh = Builder.internalCreate(this.mRS, this);
            simpleMesh.mVertexTypes = new Type[this.mVertexTypeCount];
            for (int i = 0; i < this.mVertexTypeCount; ++i) {
                simpleMesh.mVertexTypes[i] = this.mVertexTypes[i].t;
            }
            simpleMesh.mIndexType = this.mIndexType.t;
            simpleMesh.mPrimitive = this.mPrimitive;
            return simpleMesh;
        }

        Type newType(Element element, int n) {
            Type.Builder builder = new Type.Builder(this.mRS, element);
            builder.add(Dimension.X, n);
            return builder.create();
        }

        public void setIndexType(Element element, int n) {
            this.mIndexType.t = null;
            this.mIndexType.e = element;
            this.mIndexType.size = n;
        }

        public void setIndexType(Type type) {
            this.mIndexType.t = type;
            this.mIndexType.e = null;
            this.mIndexType.size = 0;
        }

        public void setPrimitive(Primitive primitive) {
            this.mPrimitive = primitive;
        }

        class Entry {
            Element e;
            int size;
            Type t;

            Entry() {
            }
        }
    }

    public static class TriangleMeshBuilder {
        public static final int COLOR = 1;
        public static final int NORMAL = 2;
        public static final int TEXTURE_0 = 256;
        float mA = 1.0f;
        float mB = 1.0f;
        Element mElement;
        int mFlags;
        float mG = 1.0f;
        int mIndexCount;
        short[] mIndexData;
        float mNX = 0.0f;
        float mNY = 0.0f;
        float mNZ = -1.0f;
        float mR = 1.0f;
        RenderScript mRS;
        float mS0 = 0.0f;
        float mT0 = 0.0f;
        int mVtxCount;
        float[] mVtxData;
        int mVtxSize;

        public TriangleMeshBuilder(RenderScript renderScript, int n, int n2) {
            this.mRS = renderScript;
            this.mVtxCount = 0;
            this.mIndexCount = 0;
            this.mVtxData = new float[128];
            this.mIndexData = new short[128];
            this.mVtxSize = n;
            this.mFlags = n2;
            if (n < 2 || n > 3) {
                throw new IllegalArgumentException("Vertex size out of range.");
            }
        }

        private void latch() {
            if ((1 & this.mFlags) != 0) {
                this.makeSpace(4);
                float[] fArray = this.mVtxData;
                int n = this.mVtxCount;
                this.mVtxCount = n + 1;
                fArray[n] = this.mR;
                float[] fArray2 = this.mVtxData;
                int n2 = this.mVtxCount;
                this.mVtxCount = n2 + 1;
                fArray2[n2] = this.mG;
                float[] fArray3 = this.mVtxData;
                int n3 = this.mVtxCount;
                this.mVtxCount = n3 + 1;
                fArray3[n3] = this.mB;
                float[] fArray4 = this.mVtxData;
                int n4 = this.mVtxCount;
                this.mVtxCount = n4 + 1;
                fArray4[n4] = this.mA;
            }
            if ((0x100 & this.mFlags) != 0) {
                this.makeSpace(2);
                float[] fArray = this.mVtxData;
                int n = this.mVtxCount;
                this.mVtxCount = n + 1;
                fArray[n] = this.mS0;
                float[] fArray5 = this.mVtxData;
                int n5 = this.mVtxCount;
                this.mVtxCount = n5 + 1;
                fArray5[n5] = this.mT0;
            }
            if ((2 & this.mFlags) != 0) {
                this.makeSpace(3);
                float[] fArray = this.mVtxData;
                int n = this.mVtxCount;
                this.mVtxCount = n + 1;
                fArray[n] = this.mNX;
                float[] fArray6 = this.mVtxData;
                int n6 = this.mVtxCount;
                this.mVtxCount = n6 + 1;
                fArray6[n6] = this.mNY;
                float[] fArray7 = this.mVtxData;
                int n7 = this.mVtxCount;
                this.mVtxCount = n7 + 1;
                fArray7[n7] = this.mNZ;
            }
        }

        private void makeSpace(int n) {
            if (n + this.mVtxCount >= this.mVtxData.length) {
                float[] fArray = new float[2 * this.mVtxData.length];
                System.arraycopy(this.mVtxData, 0, fArray, 0, this.mVtxData.length);
                this.mVtxData = fArray;
            }
        }

        public void addTriangle(int n, int n2, int n3) {
            if (n >= this.mVtxCount || n < 0 || n2 >= this.mVtxCount || n2 < 0 || n3 >= this.mVtxCount || n3 < 0) {
                throw new IllegalStateException("Index provided greater than vertex count.");
            }
            if (3 + this.mIndexCount >= this.mIndexData.length) {
                short[] sArray = new short[2 * this.mIndexData.length];
                System.arraycopy(this.mIndexData, 0, sArray, 0, this.mIndexData.length);
                this.mIndexData = sArray;
            }
            short[] sArray = this.mIndexData;
            int n4 = this.mIndexCount;
            this.mIndexCount = n4 + 1;
            sArray[n4] = (short)n;
            short[] sArray2 = this.mIndexData;
            int n5 = this.mIndexCount;
            this.mIndexCount = n5 + 1;
            sArray2[n5] = (short)n2;
            short[] sArray3 = this.mIndexData;
            int n6 = this.mIndexCount;
            this.mIndexCount = n6 + 1;
            sArray3[n6] = (short)n3;
        }

        public void addVertex(float f, float f2) {
            if (this.mVtxSize != 2) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.makeSpace(2);
            float[] fArray = this.mVtxData;
            int n = this.mVtxCount;
            this.mVtxCount = n + 1;
            fArray[n] = f;
            float[] fArray2 = this.mVtxData;
            int n2 = this.mVtxCount;
            this.mVtxCount = n2 + 1;
            fArray2[n2] = f2;
            this.latch();
        }

        public void addVertex(float f, float f2, float f3) {
            if (this.mVtxSize != 3) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.makeSpace(3);
            float[] fArray = this.mVtxData;
            int n = this.mVtxCount;
            this.mVtxCount = n + 1;
            fArray[n] = f;
            float[] fArray2 = this.mVtxData;
            int n2 = this.mVtxCount;
            this.mVtxCount = n2 + 1;
            fArray2[n2] = f2;
            float[] fArray3 = this.mVtxData;
            int n3 = this.mVtxCount;
            this.mVtxCount = n3 + 1;
            fArray3[n3] = f3;
            this.latch();
        }

        public SimpleMesh create() {
            Element.Builder builder = new Element.Builder(this.mRS);
            int n = this.mVtxSize;
            builder.add(Element.createAttrib(this.mRS, Element.DataType.FLOAT_32, Element.DataKind.POSITION, this.mVtxSize), "position");
            if ((1 & this.mFlags) != 0) {
                n += 4;
                builder.add(Element.createAttrib(this.mRS, Element.DataType.FLOAT_32, Element.DataKind.COLOR, 4), "color");
            }
            if ((0x100 & this.mFlags) != 0) {
                n += 2;
                builder.add(Element.createAttrib(this.mRS, Element.DataType.FLOAT_32, Element.DataKind.TEXTURE, 2), "texture");
            }
            if ((2 & this.mFlags) != 0) {
                n += 3;
                builder.add(Element.createAttrib(this.mRS, Element.DataType.FLOAT_32, Element.DataKind.NORMAL, 3), "normal");
            }
            this.mElement = builder.create();
            Builder builder2 = new Builder(this.mRS);
            builder2.addVertexType(this.mElement, this.mVtxCount / n);
            builder2.setIndexType(Element.createIndex(this.mRS), this.mIndexCount);
            builder2.setPrimitive(Primitive.TRIANGLE);
            SimpleMesh simpleMesh = builder2.create();
            Allocation allocation = simpleMesh.createVertexAllocation(0);
            Allocation allocation2 = simpleMesh.createIndexAllocation();
            simpleMesh.bindVertexAllocation(allocation, 0);
            simpleMesh.bindIndexAllocation(allocation2);
            allocation.data(this.mVtxData);
            allocation.uploadToBufferObject();
            allocation2.data(this.mIndexData);
            allocation2.uploadToBufferObject();
            return simpleMesh;
        }

        public void setColor(float f, float f2, float f3, float f4) {
            if ((1 & this.mFlags) == 0) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.mR = f;
            this.mG = f2;
            this.mB = f3;
            this.mA = f4;
        }

        public void setNormal(float f, float f2, float f3) {
            if ((2 & this.mFlags) == 0) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.mNX = f;
            this.mNY = f2;
            this.mNZ = f3;
        }

        public void setTexture(float f, float f2) {
            if ((0x100 & this.mFlags) == 0) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.mS0 = f;
            this.mT0 = f2;
        }
    }
}

