/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Dimension;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import java.lang.reflect.Field;

public class Type
extends BaseObj {
    boolean mDimFaces;
    boolean mDimLOD;
    int mDimX;
    int mDimY;
    int mDimZ;
    Element mElement;
    int mElementCount;
    Class mJavaClass;
    private int mNativeCache;

    Type(int n, RenderScript renderScript) {
        super(renderScript);
        this.mID = n;
        this.mNativeCache = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Type createFromClass(RenderScript renderScript, Class clazz, int n) {
        Element element = Element.createFromClass(renderScript, clazz);
        Builder builder = new Builder(renderScript, element);
        builder.add(Dimension.X, n);
        Type type = builder.create();
        element.destroy();
        Field[] fieldArray = clazz.getFields();
        int[] nArray = new int[fieldArray.length];
        int[] nArray2 = new int[fieldArray.length];
        int n2 = 0;
        while (true) {
            if (n2 >= fieldArray.length) {
                renderScript.nTypeSetupFields(type, nArray, nArray2, fieldArray);
                type.mJavaClass = clazz;
                return type;
            }
            Class<?> clazz2 = fieldArray[n2].getType();
            if (clazz2 == Integer.TYPE) {
                nArray[n2] = Element.DataType.SIGNED_32.mID;
                nArray2[n2] = 32;
            } else if (clazz2 == Short.TYPE) {
                nArray[n2] = Element.DataType.SIGNED_16.mID;
                nArray2[n2] = 16;
            } else if (clazz2 == Byte.TYPE) {
                nArray[n2] = Element.DataType.SIGNED_8.mID;
                nArray2[n2] = 8;
            } else {
                if (clazz2 != Float.TYPE) {
                    throw new IllegalArgumentException("Unkown field type");
                }
                nArray[n2] = Element.DataType.FLOAT_32.mID;
                nArray2[n2] = 32;
            }
            ++n2;
        }
    }

    public static Type createFromClass(RenderScript renderScript, Class clazz, int n, String string2) {
        Type type = Type.createFromClass(renderScript, clazz, n);
        type.setName(string2);
        return type;
    }

    void calcElementCount() {
        boolean bl = this.getLOD();
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getZ();
        int n4 = 1;
        if (this.getFaces()) {
            n4 = 6;
        }
        if (n == 0) {
            n = 1;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        int n5 = n4 * (n3 * (n * n2));
        if (bl && n > 1 && n2 > 1 && n3 > 1) {
            if (n > 1) {
                n >>= 1;
            }
            if (n2 > 1) {
                n2 >>= 1;
            }
            if (n3 > 1) {
                n3 >>= 1;
            }
            n5 += n4 * (n3 * (n * n2));
        }
        this.mElementCount = n5;
    }

    @Override
    protected void finalize() throws Throwable {
        if (this.mNativeCache != 0) {
            this.mRS.nTypeFinalDestroy(this);
            this.mNativeCache = 0;
        }
        super.finalize();
    }

    public Element getElement() {
        return this.mElement;
    }

    public int getElementCount() {
        return this.mElementCount;
    }

    public boolean getFaces() {
        return this.mDimFaces;
    }

    public boolean getLOD() {
        return this.mDimLOD;
    }

    public int getX() {
        return this.mDimX;
    }

    public int getY() {
        return this.mDimY;
    }

    public int getZ() {
        return this.mDimZ;
    }

    public static class Builder {
        Element mElement;
        Entry[] mEntries;
        int mEntryCount;
        RenderScript mRS;

        public Builder(RenderScript renderScript, Element element) {
            if (element.mID == 0) {
                throw new IllegalArgumentException("Invalid element.");
            }
            this.mRS = renderScript;
            this.mEntries = new Entry[4];
            this.mElement = element;
        }

        static Type internalCreate(RenderScript renderScript, Builder builder) {
            synchronized (Builder.class) {
                renderScript.nTypeBegin(builder.mElement.mID);
                int n = 0;
                while (true) {
                    if (n >= builder.mEntryCount) break;
                    Entry entry = builder.mEntries[n];
                    renderScript.nTypeAdd(entry.mDim.mID, entry.mValue);
                    ++n;
                    continue;
                    break;
                }
                try {
                    Type type = new Type(renderScript.nTypeCreate(), renderScript);
                    return type;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                }
            }
        }

        public void add(Dimension dimension, int n) {
            if (n < 1) {
                throw new IllegalArgumentException("Values of less than 1 for Dimensions are not valid.");
            }
            if (this.mEntries.length >= this.mEntryCount) {
                Entry[] entryArray = new Entry[8 + this.mEntryCount];
                System.arraycopy(this.mEntries, 0, entryArray, 0, this.mEntries.length);
                this.mEntries = entryArray;
            }
            this.mEntries[this.mEntryCount] = new Entry();
            this.mEntries[this.mEntryCount].mDim = dimension;
            this.mEntries[this.mEntryCount].mValue = n;
            this.mEntryCount = 1 + this.mEntryCount;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Type create() {
            Type type = Builder.internalCreate(this.mRS, this);
            type.mElement = this.mElement;
            int n = 0;
            while (true) {
                if (n >= this.mEntryCount) {
                    type.calcElementCount();
                    return type;
                }
                if (this.mEntries[n].mDim == Dimension.X) {
                    type.mDimX = this.mEntries[n].mValue;
                }
                if (this.mEntries[n].mDim == Dimension.Y) {
                    type.mDimY = this.mEntries[n].mValue;
                }
                if (this.mEntries[n].mDim == Dimension.Z) {
                    type.mDimZ = this.mEntries[n].mValue;
                }
                if (this.mEntries[n].mDim == Dimension.LOD) {
                    boolean bl = this.mEntries[n].mValue != 0;
                    type.mDimLOD = bl;
                }
                if (this.mEntries[n].mDim == Dimension.FACE) {
                    boolean bl = this.mEntries[n].mValue != 0;
                    type.mDimFaces = bl;
                }
                ++n;
            }
        }

        class Entry {
            Dimension mDim;
            int mValue;

            Entry() {
            }
        }
    }
}

