/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import java.security.KeyPair;

public class Credentials {
    public static final String CA_CERTIFICATE = "CACERT_";
    public static final String CERTIFICATE = "CERT";
    public static final String INSTALL_ACTION = "android.credentials.INSTALL";
    private static final String LOGTAG = "Credentials";
    public static final String PKCS12 = "PKCS12";
    public static final String PRIVATE_KEY = "PKEY";
    public static final String PUBLIC_KEY = "KEY";
    public static final String SYSTEM_INSTALL_ACTION = "android.credentials.SYSTEM_INSTALL";
    public static final String UNLOCK_ACTION = "android.credentials.UNLOCK";
    public static final String USER_CERTIFICATE = "USRCERT_";
    public static final String USER_PRIVATE_KEY = "USRPKEY_";
    public static final String VPN = "VPN_";
    public static final String WIFI = "WIFI_";
    private static Credentials singleton;

    private Intent createInstallIntent() {
        Intent intent = new Intent(INSTALL_ACTION);
        intent.setClassName("com.android.certinstaller", "com.android.certinstaller.CertInstallerMain");
        return intent;
    }

    public static Credentials getInstance() {
        if (singleton == null) {
            singleton = new Credentials();
        }
        return singleton;
    }

    public void install(Context context, String string2, byte[] byArray) {
        try {
            Intent intent = this.createInstallIntent();
            intent.putExtra(string2, byArray);
            context.startActivity(intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w(LOGTAG, activityNotFoundException.toString());
            return;
        }
    }

    public void install(Context context, KeyPair keyPair) {
        try {
            Intent intent = this.createInstallIntent();
            intent.putExtra(PRIVATE_KEY, keyPair.getPrivate().getEncoded());
            intent.putExtra(PUBLIC_KEY, keyPair.getPublic().getEncoded());
            context.startActivity(intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w(LOGTAG, activityNotFoundException.toString());
            return;
        }
    }

    public void installFromSdCard(Context context) {
        try {
            context.startActivity(this.createInstallIntent());
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w(LOGTAG, activityNotFoundException.toString());
            return;
        }
    }

    public void unlock(Context context) {
        try {
            context.startActivity(new Intent(UNLOCK_ACTION));
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Log.w(LOGTAG, activityNotFoundException.toString());
            return;
        }
    }
}

