/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.os.Environment;
import android.os.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import org.apache.harmony.luni.util.InputStreamHelper;

public class SystemKeyStore {
    private static final String KEY_FILE_EXTENSION = ".sks";
    private static final String SYSTEM_KEYSTORE_DIRECTORY = "misc/systemkeys";
    private static SystemKeyStore mInstance = new SystemKeyStore();

    private SystemKeyStore() {
    }

    public static SystemKeyStore getInstance() {
        return mInstance;
    }

    private File getKeyFile(String string2) {
        return new File(new File(Environment.getDataDirectory(), SYSTEM_KEYSTORE_DIRECTORY), string2 + KEY_FILE_EXTENSION);
    }

    public static String toHexString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int cfr_ignored_0 = byArray.length;
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toString(0xFF & byArray[i], 16);
            if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public void deleteKey(String string2) {
        File file = this.getKeyFile(string2);
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        file.delete();
    }

    public byte[] generateNewKey(int n, String string2, String string3) throws NoSuchAlgorithmException {
        File file = this.getKeyFile(string3);
        if (file.exists()) {
            throw new IllegalArgumentException();
        }
        KeyGenerator keyGenerator = KeyGenerator.getInstance(string2);
        keyGenerator.init(n, SecureRandom.getInstance("SHA1PRNG"));
        byte[] byArray = keyGenerator.generateKey().getEncoded();
        try {
            if (!file.createNewFile()) {
                throw new IllegalArgumentException();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            FileUtils.sync(fileOutputStream);
            fileOutputStream.close();
            FileUtils.setPermissions(file.getName(), 384, -1, -1);
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String generateNewKeyHexString(int n, String string2, String string3) throws NoSuchAlgorithmException {
        return SystemKeyStore.toHexString(this.generateNewKey(n, string2, string3));
    }

    public byte[] retrieveKey(String string2) throws IOException {
        File file = this.getKeyFile(string2);
        if (!file.exists()) {
            return null;
        }
        return InputStreamHelper.readFullyAndClose((InputStream)new FileInputStream(file));
    }

    public String retrieveKeyHexString(String string2) throws IOException {
        return SystemKeyStore.toHexString(this.retrieveKey(string2));
    }
}

