/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetoothA2dp;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.ParcelUuid;
import android.provider.Settings;
import android.server.BluetoothService;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class BluetoothA2dpService
extends IBluetoothA2dp.Stub {
    public static final String BLUETOOTH_A2DP_SERVICE = "bluetooth_a2dp";
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    private static final String BLUETOOTH_ENABLED = "bluetooth_enabled";
    private static final String BLUETOOTH_PERM = "android.permission.BLUETOOTH";
    private static final boolean DBG = true;
    private static final String PROPERTY_STATE = "State";
    private static final String SINK_STATE_CONNECTED = "connected";
    private static final String SINK_STATE_CONNECTING = "connecting";
    private static final String SINK_STATE_DISCONNECTED = "disconnected";
    private static final String SINK_STATE_PLAYING = "playing";
    private static final String TAG = "BluetoothA2dpService";
    private static int mSinkCount;
    private final BluetoothAdapter mAdapter;
    private HashMap<BluetoothDevice, Integer> mAudioDevices;
    private final AudioManager mAudioManager;
    private final BluetoothService mBluetoothService;
    private final Context mContext;
    private final IntentFilter mIntentFilter;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String string2 = intent.getAction();
            BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (string2.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                switch (intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE)) {
                    default: {
                        return;
                    }
                    case 12: {
                        BluetoothA2dpService.this.onBluetoothEnable();
                        return;
                    }
                    case 13: {
                        BluetoothA2dpService.this.onBluetoothDisable();
                        return;
                    }
                }
            }
            if (string2.equals("android.bluetooth.device.action.BOND_STATE_CHANGED")) {
                switch (intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", Integer.MIN_VALUE)) {
                    default: {
                        return;
                    }
                    case 10: {
                        BluetoothA2dpService.this.setSinkPriority(bluetoothDevice, -1);
                        return;
                    }
                    case 12: 
                }
                if (BluetoothA2dpService.this.getSinkPriority(bluetoothDevice) != -1) return;
                BluetoothA2dpService.this.setSinkPriority(bluetoothDevice, 100);
                return;
            } else {
                BluetoothDevice[] bluetoothDeviceArray;
                if (string2.equals("android.bluetooth.device.action.ACL_DISCONNECTED")) {
                    synchronized (this) {
                        if (!BluetoothA2dpService.this.mAudioDevices.containsKey(bluetoothDevice)) return;
                        int n = (Integer)BluetoothA2dpService.this.mAudioDevices.get(bluetoothDevice);
                        BluetoothA2dpService.this.handleSinkStateChange(bluetoothDevice, n, 0);
                        return;
                    }
                }
                if (!string2.equals("android.media.VOLUME_CHANGED_ACTION") || intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", -1) != 3 || (bluetoothDeviceArray = BluetoothA2dpService.this.getConnectedSinks()).length == 0 || !BluetoothA2dpService.this.isPhoneDocked(bluetoothDeviceArray[0])) return;
                String string3 = bluetoothDeviceArray[0].getAddress();
                int n = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", 0);
                int n2 = intent.getIntExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", 0);
                String string4 = BluetoothA2dpService.this.mBluetoothService.getObjectPathFromAddress(string3);
                if (n > n2) {
                    BluetoothA2dpService.this.avrcpVolumeUpNative(string4);
                    return;
                }
                if (n >= n2) return;
                BluetoothA2dpService.this.avrcpVolumeDownNative(string4);
                return;
            }
        }
    };
    private int mTargetA2dpState;

    public BluetoothA2dpService(Context context, BluetoothService bluetoothService) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mBluetoothService = bluetoothService;
        if (this.mBluetoothService == null) {
            throw new RuntimeException("Platform does not support Bluetooth");
        }
        if (!this.initNative()) {
            throw new RuntimeException("Could not init BluetoothA2dpService");
        }
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mIntentFilter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
        this.mIntentFilter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        this.mIntentFilter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        this.mIntentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        this.mIntentFilter.addAction("android.media.VOLUME_CHANGED_ACTION");
        this.mContext.registerReceiver(this.mReceiver, this.mIntentFilter);
        this.mAudioDevices = new HashMap();
        if (this.mBluetoothService.isEnabled()) {
            this.onBluetoothEnable();
        }
        this.mTargetA2dpState = -1;
        this.mBluetoothService.setA2dpService(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addAudioSink(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            String[] stringArray = (String[])this.getSinkPropertiesNative(this.mBluetoothService.getObjectPathFromAddress(bluetoothDevice.getAddress()));
            if (stringArray == null) {
                Log.e(TAG, "Error while getting AudioSink properties for device: " + bluetoothDevice);
                return false;
            }
            int n = 0;
            while (true) {
                block9: {
                    Integer n2;
                    block8: {
                        int n3 = stringArray.length;
                        n2 = null;
                        if (n >= n3) break block8;
                        if (!stringArray[n].equals(PROPERTY_STATE)) break block9;
                        n2 = new Integer(this.convertBluezSinkStringtoState(stringArray[n + 1]));
                    }
                    this.mAudioDevices.put(bluetoothDevice, n2);
                    this.handleSinkStateChange(bluetoothDevice, 0, n2);
                    return true;
                }
                n += 2;
            }
        }
    }

    private void adjustOtherSinkPriorities(BluetoothDevice bluetoothDevice) {
        for (BluetoothDevice bluetoothDevice2 : this.mAdapter.getBondedDevices()) {
            if (this.getSinkPriority(bluetoothDevice2) < 1000 || bluetoothDevice2.equals(bluetoothDevice)) continue;
            this.setSinkPriority(bluetoothDevice2, 100);
        }
    }

    private synchronized native boolean avrcpVolumeDownNative(String var1);

    private synchronized native boolean avrcpVolumeUpNative(String var1);

    private boolean checkSinkSuspendState(int n) {
        block5: {
            block4: {
                if (n == this.mTargetA2dpState) break block4;
                if (n != 4 || this.mTargetA2dpState != 2) break block5;
                this.mAudioManager.setParameters("A2dpSuspended=true");
            }
            return true;
        }
        if (n == 2 && this.mTargetA2dpState == 4) {
            this.mAudioManager.setParameters("A2dpSuspended=false");
            return true;
        }
        return false;
    }

    private native void cleanupNative();

    private synchronized native boolean connectSinkNative(String var1);

    private int convertBluezSinkStringtoState(String string2) {
        if (string2.equalsIgnoreCase(SINK_STATE_DISCONNECTED)) {
            return 0;
        }
        if (string2.equalsIgnoreCase(SINK_STATE_CONNECTING)) {
            return 1;
        }
        if (string2.equalsIgnoreCase(SINK_STATE_CONNECTED)) {
            return 2;
        }
        if (string2.equalsIgnoreCase(SINK_STATE_PLAYING)) {
            return 4;
        }
        return -1;
    }

    private synchronized native boolean disconnectSinkNative(String var1);

    private synchronized native Object[] getSinkPropertiesNative(String var1);

    /*
     * Enabled aggressive block sorting
     */
    private void handleSinkStateChange(BluetoothDevice bluetoothDevice, int n, int n2) {
        if (n2 != n) {
            if (n2 == 0 || n2 == 3) {
                --mSinkCount;
            } else if (n2 == 2) {
                mSinkCount = 1 + mSinkCount;
            }
            this.mAudioDevices.put(bluetoothDevice, n2);
            this.checkSinkSuspendState(n2);
            this.mTargetA2dpState = -1;
            if (this.getSinkPriority(bluetoothDevice) > 0 && n2 == 2) {
                this.setSinkPriority(bluetoothDevice, 1000);
                this.adjustOtherSinkPriorities(bluetoothDevice);
            }
            Intent intent = new Intent("android.bluetooth.a2dp.action.SINK_STATE_CHANGED");
            intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
            intent.putExtra("android.bluetooth.a2dp.extra.PREVIOUS_SINK_STATE", n);
            intent.putExtra("android.bluetooth.a2dp.extra.SINK_STATE", n2);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            BluetoothA2dpService.log("A2DP state : device: " + bluetoothDevice + " State:" + n + "->" + n2);
        }
    }

    private native boolean initNative();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isConnectSinkFeasible(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            block6: {
                block5: {
                    if (!this.mBluetoothService.isEnabled()) return false;
                    if (!this.isSinkDevice(bluetoothDevice)) return false;
                    int n = this.getSinkPriority(bluetoothDevice);
                    if (n != 0) break block5;
                    return false;
                }
                if (this.mAudioDevices.get(bluetoothDevice) != null || this.addAudioSink(bluetoothDevice)) break block6;
                return false;
            }
            String string2 = this.mBluetoothService.getObjectPathFromAddress(bluetoothDevice.getAddress());
            if (string2 != null) return true;
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDisconnectSinkFeasible(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            block8: {
                String string2 = this.mBluetoothService.getObjectPathFromAddress(bluetoothDevice.getAddress());
                if (string2 != null) break block8;
                return false;
            }
            int n = this.getSinkState(bluetoothDevice);
            switch (n) {
                default: {
                    return true;
                }
                case 0: {
                    return false;
                }
                case 3: 
            }
            return true;
        }
    }

    private boolean isPhoneDocked(BluetoothDevice bluetoothDevice) {
        BluetoothDevice bluetoothDevice2;
        Intent intent = this.mContext.registerReceiver(null, new IntentFilter("android.intent.action.DOCK_EVENT"));
        return intent != null && intent.getIntExtra("android.intent.extra.DOCK_STATE", 0) != 0 && (bluetoothDevice2 = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE")) != null && bluetoothDevice.equals(bluetoothDevice2);
    }

    private boolean isSinkDevice(BluetoothDevice bluetoothDevice) {
        ParcelUuid[] parcelUuidArray = this.mBluetoothService.getRemoteUuids(bluetoothDevice.getAddress());
        return parcelUuidArray != null && BluetoothUuid.isUuidPresent(parcelUuidArray, BluetoothUuid.AudioSink);
    }

    private static void log(String string2) {
        Log.d(TAG, string2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<BluetoothDevice> lookupSinksMatchingStates(int[] var1_1) {
        synchronized (this) {
            var2_2 = new HashSet<BluetoothDevice>();
            var4_3 = this.mAudioDevices.isEmpty();
            if (var4_3) ** GOTO lbl8
            var5_4 = this.mAudioDevices.keySet().iterator();
            block3: while (true) {
                block9: {
                    if (var5_4.hasNext()) break block9;
lbl8:
                    // 2 sources

                    return var2_2;
                }
                var6_5 = var5_4.next();
                var7_6 = this.getSinkState(var6_5);
                var8_7 = var1_1.length;
                var9_8 = 0;
                while (true) {
                    if (var9_8 >= var8_7) continue block3;
                    if (var1_1[var9_8] == var7_6) {
                        var2_2.add(var6_5);
                        continue block3;
                    }
                    ++var9_8;
                }
                break;
            }
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onBluetoothDisable() {
        synchronized (this) {
            block9: {
                if (this.mAudioDevices.isEmpty()) break block9;
                var2_1 = new BluetoothDevice[this.mAudioDevices.size()];
                var3_2 = this.mAudioDevices.keySet().toArray(var2_1);
                var4_3 = var3_2.length;
                var5_4 = 0;
                block8: while (true) {
                    if (var5_4 >= var4_3) ** GOTO lbl20
                    var6_5 = var3_2[var5_4];
                    var7_6 = this.getSinkState(var6_5);
                    switch (var7_6) {
                        case 1: 
                        case 2: 
                        case 4: {
                            this.disconnectSinkNative(this.mBluetoothService.getObjectPathFromAddress(var6_5.getAddress()));
                            this.handleSinkStateChange(var6_5, var7_6, 0);
                            break;
                        }
                        case 3: {
                            this.handleSinkStateChange(var6_5, 3, 0);
                            break;
                        }
lbl20:
                        // 1 sources

                        this.mAudioDevices.clear();
                        break block8;
                    }
                    ++var5_4;
                }
            }
            this.mAudioManager.setParameters("bluetooth_enabled=false");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onBluetoothEnable() {
        synchronized (this) {
            String string2 = this.mBluetoothService.getProperty("Devices");
            mSinkCount = 0;
            if (string2 != null) {
                for (String string3 : string2.split(",")) {
                    String string4 = this.mBluetoothService.getAddressFromObjectPath(string3);
                    BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string4);
                    ParcelUuid[] parcelUuidArray = this.mBluetoothService.getRemoteUuids(string4);
                    if (parcelUuidArray == null) continue;
                    ParcelUuid[] parcelUuidArray2 = new ParcelUuid[]{BluetoothUuid.AudioSink, BluetoothUuid.AdvAudioDist};
                    if (!BluetoothUuid.containsAnyUuid(parcelUuidArray, parcelUuidArray2)) continue;
                    this.addAudioSink(bluetoothDevice);
                }
            }
            this.mAudioManager.setParameters("bluetooth_enabled=true");
            this.mAudioManager.setParameters("A2dpSuspended=false");
            return;
        }
    }

    private void onConnectSinkResult(String string2, boolean bl) {
        String string3;
        if (bl || string2 == null || (string3 = this.mBluetoothService.getAddressFromObjectPath(string2)) == null) {
            return;
        }
        BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string3);
        this.handleSinkStateChange(bluetoothDevice, this.getSinkState(bluetoothDevice), 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onSinkPropertyChanged(String string2, String[] stringArray) {
        synchronized (this) {
            boolean bl = this.mBluetoothService.isEnabled();
            if (bl) {
                String string3 = stringArray[0];
                String string4 = this.mBluetoothService.getAddressFromObjectPath(string2);
                if (string4 == null) {
                    Log.e(TAG, "onSinkPropertyChanged: Address of the remote device in null");
                } else {
                    BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string4);
                    if (string3.equals(PROPERTY_STATE)) {
                        int n = this.convertBluezSinkStringtoState(stringArray[1]);
                        if (this.mAudioDevices.get(bluetoothDevice) == null) {
                            this.addAudioSink(bluetoothDevice);
                        } else {
                            this.handleSinkStateChange(bluetoothDevice, this.mAudioDevices.get(bluetoothDevice), n);
                        }
                    }
                }
            }
            return;
        }
    }

    private synchronized native boolean resumeSinkNative(String var1);

    private synchronized native boolean suspendSinkNative(String var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean connectSink(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                BluetoothA2dpService.log("connectSink(" + bluetoothDevice + ")");
                boolean bl = this.isConnectSinkFeasible(bluetoothDevice);
                if (bl) break block4;
                return false;
            }
            boolean bl = this.mBluetoothService.connectSink(bluetoothDevice.getAddress());
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean connectSinkInternal(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            boolean bl = this.mBluetoothService.isEnabled();
            if (!bl) {
                return false;
            }
            int n = this.mAudioDevices.get(bluetoothDevice);
            if (this.lookupSinksMatchingStates(new int[]{1, 2, 4, 3}).size() != 0) {
                return false;
            }
            switch (n) {
                default: {
                    String string2 = this.mBluetoothService.getObjectPathFromAddress(bluetoothDevice.getAddress());
                    if (this.getSinkPriority(bluetoothDevice) < 1000) {
                        this.setSinkPriority(bluetoothDevice, 1000);
                    }
                    this.handleSinkStateChange(bluetoothDevice, n, 1);
                    if (this.connectSinkNative(string2)) return true;
                    this.handleSinkStateChange(bluetoothDevice, this.mAudioDevices.get(bluetoothDevice), n);
                    return false;
                }
                case 2: 
                case 3: 
                case 4: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean disconnectSink(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                BluetoothA2dpService.log("disconnectSink(" + bluetoothDevice + ")");
                boolean bl = this.isDisconnectSinkFeasible(bluetoothDevice);
                if (bl) break block4;
                return false;
            }
            boolean bl = this.mBluetoothService.disconnectSink(bluetoothDevice.getAddress());
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean disconnectSinkInternal(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            int n = this.getSinkState(bluetoothDevice);
            String string2 = this.mBluetoothService.getObjectPathFromAddress(bluetoothDevice.getAddress());
            switch (n) {
                default: {
                    this.handleSinkStateChange(bluetoothDevice, n, 3);
                    if (this.disconnectSinkNative(string2)) return true;
                    this.handleSinkStateChange(bluetoothDevice, this.mAudioDevices.get(bluetoothDevice), n);
                    return false;
                }
                case 0: 
                case 3: {
                    return false;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        synchronized (this) {
            boolean bl = this.mAudioDevices.isEmpty();
            if (!bl) {
                printWriter.println("Cached audio devices:");
                for (BluetoothDevice bluetoothDevice : this.mAudioDevices.keySet()) {
                    int n = this.mAudioDevices.get(bluetoothDevice);
                    printWriter.println(bluetoothDevice + " " + BluetoothA2dp.stateToString(n));
                }
            }
            return;
        }
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            this.cleanupNative();
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public BluetoothDevice[] getConnectedSinks() {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            Set<BluetoothDevice> set = this.lookupSinksMatchingStates(new int[]{2, 4});
            BluetoothDevice[] bluetoothDeviceArray = set.toArray(new BluetoothDevice[set.size()]);
            return bluetoothDeviceArray;
        }
    }

    @Override
    public BluetoothDevice[] getNonDisconnectedSinks() {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            Set<BluetoothDevice> set = this.lookupSinksMatchingStates(new int[]{2, 4, 1, 3});
            BluetoothDevice[] bluetoothDeviceArray = set.toArray(new BluetoothDevice[set.size()]);
            return bluetoothDeviceArray;
        }
    }

    @Override
    public int getSinkPriority(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            int n = Settings.Secure.getInt(this.mContext.getContentResolver(), Settings.Secure.getBluetoothA2dpSinkPriorityKey((String)bluetoothDevice.getAddress()), -1);
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getSinkState(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            Integer n;
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
                n = this.mAudioDevices.get(bluetoothDevice);
                if (n != null) break block4;
                return 0;
            }
            int n2 = n;
            return n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean resumeSink(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            block6: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                BluetoothA2dpService.log("resumeSink(" + bluetoothDevice + "), mTargetA2dpState: " + this.mTargetA2dpState);
                if (bluetoothDevice == null) return false;
                HashMap<BluetoothDevice, Integer> hashMap = this.mAudioDevices;
                if (hashMap != null) break block6;
                return false;
            }
            String string2 = this.mBluetoothService.getObjectPathFromAddress(bluetoothDevice.getAddress());
            Integer n = this.mAudioDevices.get(bluetoothDevice);
            if (string2 == null) return false;
            if (n == null) return false;
            this.mTargetA2dpState = 4;
            boolean bl = this.checkSinkSuspendState(n);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setSinkPriority(BluetoothDevice bluetoothDevice, int n) {
        synchronized (this) {
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                boolean bl = BluetoothAdapter.checkBluetoothAddress(bluetoothDevice.getAddress());
                if (bl) break block4;
                return false;
            }
            boolean bl = Settings.Secure.putInt(this.mContext.getContentResolver(), Settings.Secure.getBluetoothA2dpSinkPriorityKey((String)bluetoothDevice.getAddress()), n);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean suspendSink(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            block6: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                BluetoothA2dpService.log("suspendSink(" + bluetoothDevice + "), mTargetA2dpState: " + this.mTargetA2dpState);
                if (bluetoothDevice == null) return false;
                HashMap<BluetoothDevice, Integer> hashMap = this.mAudioDevices;
                if (hashMap != null) break block6;
                return false;
            }
            String string2 = this.mBluetoothService.getObjectPathFromAddress(bluetoothDevice.getAddress());
            Integer n = this.mAudioDevices.get(bluetoothDevice);
            if (string2 == null) return false;
            if (n == null) return false;
            this.mTargetA2dpState = 2;
            boolean bl = this.checkSinkSuspendState(n);
            return bl;
        }
    }
}

