/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothUuid;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelUuid;
import android.server.BluetoothService;
import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

class BluetoothEventLoop {
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    private static final String BLUETOOTH_PERM = "android.permission.BLUETOOTH";
    private static final int CREATE_DEVICE_ALREADY_EXISTS = 1;
    private static final int CREATE_DEVICE_FAILED = -1;
    private static final int CREATE_DEVICE_SUCCESS = 0;
    private static final boolean DBG = false;
    private static final int EVENT_AGENT_CANCEL = 3;
    private static final int EVENT_PAIRING_CONSENT_DELAYED_ACCEPT = 2;
    private static final int EVENT_RESTART_BLUETOOTH = 1;
    private static final String TAG = "BluetoothEventLoop";
    private final BluetoothAdapter mAdapter;
    private final BluetoothService mBluetoothService;
    private final Context mContext;
    private final Handler mHandler = new Handler(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            String[] stringArray;
            switch (message.what) {
                case 1: {
                    BluetoothEventLoop.this.mBluetoothService.restart();
                    return;
                }
                case 2: {
                    String string2 = (String)message.obj;
                    if (string2 == null) return;
                    BluetoothEventLoop.this.mBluetoothService.setPairingConfirmation(string2, true);
                    return;
                }
                default: {
                    return;
                }
                case 3: {
                    stringArray = BluetoothEventLoop.this.mBluetoothService.listInState(11);
                    if (stringArray.length == 0) return;
                    if (stringArray.length > 1) {
                        Log.e(BluetoothEventLoop.TAG, " There is more than one device in the Bonding State");
                        return;
                    } else {
                        break;
                    }
                }
            }
            String string3 = stringArray[0];
            BluetoothEventLoop.this.mBluetoothService.setBondState(string3, 10, 8);
        }
    };
    private boolean mInterrupted;
    private int mNativeData;
    private final HashMap<String, Integer> mPasskeyAgentRequestData;
    private boolean mStarted;
    private Thread mThread;

    static {
        BluetoothEventLoop.classInitNative();
    }

    BluetoothEventLoop(Context context, BluetoothAdapter bluetoothAdapter, BluetoothService bluetoothService) {
        this.mBluetoothService = bluetoothService;
        this.mContext = context;
        this.mPasskeyAgentRequestData = new HashMap();
        this.mAdapter = bluetoothAdapter;
        this.initializeNativeDataNative();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addDevice(String string2, String[] stringArray) {
        this.mBluetoothService.addRemoteDeviceProperties(string2, stringArray);
        String string3 = this.mBluetoothService.getRemoteDeviceProperty(string2, "RSSI");
        String string4 = this.mBluetoothService.getRemoteDeviceProperty(string2, "Class");
        String string5 = this.mBluetoothService.getRemoteDeviceProperty(string2, "Name");
        short s = string3 != null ? (short)((short)Integer.valueOf(string3).intValue()) : (short)Short.MIN_VALUE;
        if (string4 != null) {
            Intent intent = new Intent("android.bluetooth.device.action.FOUND");
            intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(string2));
            intent.putExtra("android.bluetooth.device.extra.CLASS", new BluetoothClass(Integer.valueOf(string4).intValue()));
            intent.putExtra("android.bluetooth.device.extra.RSSI", s);
            intent.putExtra("android.bluetooth.device.extra.NAME", string5);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            return;
        }
        BluetoothEventLoop.log("ClassValue: " + string4 + " for remote device: " + string2 + " is null");
    }

    private String checkPairingRequestAndGetAddress(String string2, int n) {
        String string3 = this.mBluetoothService.getAddressFromObjectPath(string2);
        if (string3 == null) {
            Log.e(TAG, "Unable to get device address in checkPairingRequestAndGetAddress, returning null");
            return null;
        }
        String string4 = string3.toUpperCase();
        this.mPasskeyAgentRequestData.put(string4, new Integer(n));
        if (this.mBluetoothService.getBluetoothState() == 13) {
            this.mBluetoothService.cancelPairingUserInput(string4);
            return null;
        }
        if (this.mBluetoothService.getBondState(string4) != 12) {
            this.mBluetoothService.setBondState(string4, 11);
        }
        return string4;
    }

    private static native void classInitNative();

    private native void cleanupNativeDataNative();

    private native void initializeNativeDataNative();

    private native boolean isEventLoopRunningNative();

    private boolean isOtherSinkInNonDisconnectingState(String string2) {
        Set<BluetoothDevice> set = new BluetoothA2dp(this.mContext).getNonDisconnectedSinks();
        if (set.size() == 0) {
            return false;
        }
        Iterator<BluetoothDevice> iterator = set.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getAddress().equals(string2)) continue;
            return true;
        }
        return false;
    }

    private static void log(String string2) {
        Log.d(TAG, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean onAgentAuthorize(String string2, String string3) {
        boolean bl;
        block5: {
            String string4;
            block4: {
                string4 = this.mBluetoothService.getAddressFromObjectPath(string2);
                if (string4 == null) {
                    Log.e(TAG, "Unable to get device address in onAuthAgentAuthorize");
                    return false;
                }
                ParcelUuid parcelUuid = ParcelUuid.fromString(string3);
                BluetoothA2dp bluetoothA2dp = new BluetoothA2dp(this.mContext);
                if (!this.mBluetoothService.isEnabled() || !BluetoothUuid.isAudioSource(parcelUuid) && !BluetoothUuid.isAvrcpTarget(parcelUuid) && !BluetoothUuid.isAdvAudioDist(parcelUuid) || this.isOtherSinkInNonDisconnectingState(string4)) break block4;
                bl = bluetoothA2dp.getSinkPriority(this.mAdapter.getRemoteDevice(string4)) > 0;
                if (bl) {
                    Log.i(TAG, "Allowing incoming A2DP / AVRCP connection from " + string4);
                    if (!BluetoothUuid.isAvrcpTarget(parcelUuid)) {
                        this.mBluetoothService.notifyIncomingA2dpConnection(string4);
                    }
                    break block5;
                } else {
                    Log.i(TAG, "Rejecting incoming A2DP / AVRCP connection from " + string4);
                }
                break block5;
            }
            Log.i(TAG, "Rejecting incoming " + string3 + " connection from " + string4);
            bl = false;
        }
        BluetoothEventLoop.log("onAgentAuthorize(" + string2 + ", " + string3 + ") = " + bl);
        return bl;
    }

    private void onAgentCancel() {
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_CANCEL");
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(3), 1500L);
    }

    private boolean onAgentOutOfBandDataAvailable(String string2) {
        if (!this.mBluetoothService.isEnabled()) {
            return false;
        }
        String string3 = this.mBluetoothService.getAddressFromObjectPath(string2);
        if (string3 == null) {
            return false;
        }
        return this.mBluetoothService.getDeviceOutOfBandData(this.mAdapter.getRemoteDevice(string3)) != null;
    }

    private void onCreateDeviceResult(String string2, int n) {
        switch (n) {
            default: {
                return;
            }
            case 1: {
                String string3 = this.mBluetoothService.getObjectPathFromAddress(string2);
                if (string3 != null) {
                    this.mBluetoothService.discoverServicesNative(string3, "");
                    return;
                }
                Log.w(TAG, "Device exists, but we dont have the bluez path, failing");
            }
            case -1: 
        }
        this.mBluetoothService.sendUuidIntent(string2);
        this.mBluetoothService.makeServiceChannelCallbacks(string2);
    }

    private void onCreatePairedDeviceResult(String string2, int n) {
        String string3 = string2.toUpperCase();
        this.mBluetoothService.onCreatePairedDeviceResult(string3, n);
    }

    private void onDeviceCreated(String string2) {
        String[] stringArray;
        String string3 = this.mBluetoothService.getAddressFromObjectPath(string2);
        if (!this.mBluetoothService.isRemoteDeviceInCache(string3) && (stringArray = this.mBluetoothService.getRemoteDeviceProperties(string3)) != null) {
            this.addDevice(string3, stringArray);
        }
    }

    private void onDeviceDisappeared(String string2) {
        Intent intent = new Intent("android.bluetooth.device.action.DISAPPEARED");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(string2));
        this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
    }

    private void onDeviceDisconnectRequested(String string2) {
        String string3 = this.mBluetoothService.getAddressFromObjectPath(string2);
        if (string3 == null) {
            Log.e(TAG, "onDeviceDisconnectRequested: Address of the remote device in null");
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(string3));
        this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
    }

    private void onDeviceFound(String string2, String[] stringArray) {
        if (stringArray == null) {
            Log.e(TAG, "ERROR: Remote device properties are null");
            return;
        }
        this.addDevice(string2, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onDevicePropertyChanged(String string2, String[] stringArray) {
        String string3 = stringArray[0];
        String string4 = this.mBluetoothService.getAddressFromObjectPath(string2);
        if (string4 == null) {
            Log.e(TAG, "onDevicePropertyChanged: Address of the remote device in null");
            return;
        }
        BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string4);
        if (string3.equals("Name")) {
            this.mBluetoothService.setRemoteDeviceProperty(string4, string3, stringArray[1]);
            Intent intent = new Intent("android.bluetooth.device.action.NAME_CHANGED");
            intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
            intent.putExtra("android.bluetooth.device.extra.NAME", stringArray[1]);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            return;
        }
        if (string3.equals("Class")) {
            this.mBluetoothService.setRemoteDeviceProperty(string4, string3, stringArray[1]);
            Intent intent = new Intent("android.bluetooth.device.action.CLASS_CHANGED");
            intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
            intent.putExtra("android.bluetooth.device.extra.CLASS", new BluetoothClass(Integer.valueOf(stringArray[1]).intValue()));
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            return;
        }
        if (string3.equals("Connected")) {
            Intent intent;
            this.mBluetoothService.setRemoteDeviceProperty(string4, string3, stringArray[1]);
            if (stringArray[1].equals("true")) {
                intent = new Intent("android.bluetooth.device.action.ACL_CONNECTED");
                if (this.mBluetoothService.isBluetoothDock(string4)) {
                    this.mBluetoothService.setLinkTimeout(string4, 8000);
                }
            } else {
                intent = new Intent("android.bluetooth.device.action.ACL_DISCONNECTED");
            }
            intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            return;
        }
        if (string3.equals("UUIDs")) {
            int n = Integer.valueOf(stringArray[1]);
            String string5 = null;
            if (n > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 2; i < stringArray.length; ++i) {
                    stringBuilder.append(stringArray[i]);
                    stringBuilder.append(",");
                }
                string5 = stringBuilder.toString();
            }
            this.mBluetoothService.setRemoteDeviceProperty(string4, string3, string5);
            this.mBluetoothService.updateDeviceServiceChannelCache(string4);
            this.mBluetoothService.sendUuidIntent(string4);
            return;
        }
        if (string3.equals("Paired")) {
            if (!stringArray[1].equals("true")) {
                this.mBluetoothService.setBondState(string4, 10);
                this.mBluetoothService.setRemoteDeviceProperty(string4, "Trusted", "false");
                return;
            }
            if (this.mBluetoothService.getPendingOutgoingBonding() != null) return;
            this.mBluetoothService.setBondState(string4, 12);
            return;
        } else {
            if (!string3.equals("Trusted")) return;
            this.mBluetoothService.setRemoteDeviceProperty(string4, string3, stringArray[1]);
            return;
        }
    }

    private void onDeviceRemoved(String string2) {
        String string3 = this.mBluetoothService.getAddressFromObjectPath(string2);
        if (string3 != null) {
            this.mBluetoothService.setBondState(string3.toUpperCase(), 10, 9);
            this.mBluetoothService.setRemoteDeviceProperty(string3, "UUIDs", null);
        }
    }

    private void onDiscoverServicesResult(String string2, boolean bl) {
        String string3 = this.mBluetoothService.getAddressFromObjectPath(string2);
        if (bl) {
            this.mBluetoothService.updateRemoteDevicePropertiesCache(string3);
        }
        this.mBluetoothService.sendUuidIntent(string3);
        this.mBluetoothService.makeServiceChannelCallbacks(string3);
    }

    private void onDisplayPasskey(String string2, int n, int n2) {
        String string3 = this.checkPairingRequestAndGetAddress(string2, n2);
        if (string3 == null) {
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(string3));
        intent.putExtra("android.bluetooth.device.extra.PASSKEY", n);
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 4);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onRequestOobData(String string2, int n) {
        String string3 = this.checkPairingRequestAndGetAddress(string2, n);
        if (string3 == null) {
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(string3));
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 5);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onRequestPairingConsent(String string2, int n) {
        String string3 = this.checkPairingRequestAndGetAddress(string2, n);
        if (string3 == null) {
            return;
        }
        if (this.mBluetoothService.getBondState(string3) == 12) {
            Message message = this.mHandler.obtainMessage(2);
            message.obj = string3;
            this.mHandler.sendMessageDelayed(message, 1500L);
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(string3));
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 3);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onRequestPasskey(String string2, int n) {
        String string3 = this.checkPairingRequestAndGetAddress(string2, n);
        if (string3 == null) {
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(string3));
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 1);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onRequestPasskeyConfirmation(String string2, int n, int n2) {
        String string3 = this.checkPairingRequestAndGetAddress(string2, n2);
        if (string3 == null) {
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(string3));
        intent.putExtra("android.bluetooth.device.extra.PASSKEY", n);
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 2);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onRequestPinCode(String string2, int n) {
        String string3 = this.checkPairingRequestAndGetAddress(string2, n);
        if (string3 == null) {
            return;
        }
        if (string3.equals(this.mBluetoothService.getPendingOutgoingBonding())) {
            if (this.mBluetoothService.isBluetoothDock(string3)) {
                String string4 = this.mBluetoothService.getDockPin();
                this.mBluetoothService.setPin(string3, BluetoothDevice.convertPinToBytes((String)string4));
                return;
            }
            switch (new BluetoothClass(this.mBluetoothService.getRemoteClass(string3)).getDeviceClass()) {
                default: {
                    break;
                }
                case 1028: 
                case 1032: 
                case 1048: 
                case 1052: 
                case 1056: 
                case 1064: {
                    if (!this.mBluetoothService.attemptAutoPair(string3)) break;
                    return;
                }
            }
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(string3));
        intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 0);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onRestartRequired() {
        if (this.mBluetoothService.isEnabled()) {
            Log.e(TAG, "*** A serious error occurred (did bluetoothd crash?) - restarting Bluetooth ***");
            this.mHandler.sendEmptyMessage(1);
        }
    }

    private native void startEventLoopNative();

    private native void stopEventLoopNative();

    protected void finalize() throws Throwable {
        try {
            this.cleanupNativeDataNative();
            return;
        }
        finally {
            super.finalize();
        }
    }

    HashMap<String, Integer> getPasskeyAgentRequestData() {
        return this.mPasskeyAgentRequestData;
    }

    public boolean isEventLoopRunning() {
        return this.isEventLoopRunningNative();
    }

    /*
     * Enabled aggressive block sorting
     */
    void onPropertyChanged(String[] stringArray) {
        String string2;
        if (this.mBluetoothService.isAdapterPropertiesEmpty()) {
            this.mBluetoothService.getAllProperties();
        }
        if ((string2 = stringArray[0]).equals("Name")) {
            this.mBluetoothService.setProperty(string2, stringArray[1]);
            Intent intent = new Intent("android.bluetooth.adapter.action.LOCAL_NAME_CHANGED");
            intent.putExtra("android.bluetooth.adapter.extra.LOCAL_NAME", stringArray[1]);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            return;
        } else if (string2.equals("Pairable") || string2.equals("Discoverable")) {
            String string3 = string2.equals("Pairable") ? stringArray[1] : this.mBluetoothService.getPropertyInternal("Pairable");
            String string4 = string2.equals("Discoverable") ? stringArray[1] : this.mBluetoothService.getPropertyInternal("Discoverable");
            if (string3 == null || string4 == null) return;
            this.mBluetoothService.setProperty(string2, stringArray[1]);
            int n = BluetoothService.bluezStringToScanMode(string3.equals("true"), string4.equals("true"));
            if (n < 0) return;
            Intent intent = new Intent("android.bluetooth.adapter.action.SCAN_MODE_CHANGED");
            intent.putExtra("android.bluetooth.adapter.extra.SCAN_MODE", n);
            intent.addFlags(0x10000000);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            return;
        } else {
            if (string2.equals("Discovering")) {
                Intent intent;
                this.mBluetoothService.setProperty(string2, stringArray[1]);
                if (stringArray[1].equals("true")) {
                    this.mBluetoothService.setIsDiscovering(true);
                    intent = new Intent("android.bluetooth.adapter.action.DISCOVERY_STARTED");
                } else {
                    this.mBluetoothService.cancelDiscovery();
                    this.mBluetoothService.setIsDiscovering(false);
                    intent = new Intent("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
                }
                this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
                return;
            }
            if (string2.equals("Devices")) {
                int n = Integer.valueOf(stringArray[1]);
                String string5 = null;
                if (n > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 2; i < stringArray.length; ++i) {
                        stringBuilder.append(stringArray[i]);
                        stringBuilder.append(",");
                    }
                    string5 = stringBuilder.toString();
                }
                this.mBluetoothService.setProperty(string2, string5);
                return;
            }
            if (!string2.equals("Powered") || !stringArray[1].equals("true")) return;
            this.onRestartRequired();
            return;
        }
    }

    void start() {
        if (!this.isEventLoopRunningNative()) {
            this.startEventLoopNative();
        }
    }

    public void stop() {
        if (this.isEventLoopRunningNative()) {
            this.stopEventLoopNative();
        }
    }
}

