/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothDeviceProfileState;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfileState;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothCallback;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemService;
import android.provider.Settings;
import android.server.BluetoothA2dpService;
import android.server.BluetoothEventLoop;
import android.util.Log;
import android.util.Pair;
import com.android.internal.app.IBatteryStats;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BluetoothService
extends IBluetooth.Stub {
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    private static final String BLUETOOTH_PERM = "android.permission.BLUETOOTH";
    private static final boolean DBG = true;
    private static final String DOCK_ADDRESS_PATH = "/sys/class/switch/dock/bt_addr";
    private static final String DOCK_PIN_PATH = "/sys/class/switch/dock/bt_pin";
    private static final long INIT_AUTO_PAIRING_FAILURE_ATTEMPT_DELAY = 3000L;
    private static final long MAX_AUTO_PAIRING_FAILURE_ATTEMPT_DELAY = 12000L;
    private static final int MESSAGE_AUTO_PAIRING_FAILURE_ATTEMPT_DELAY = 5;
    private static final int MESSAGE_DISCOVERABLE_TIMEOUT = 4;
    private static final int MESSAGE_FINISH_DISABLE = 2;
    private static final int MESSAGE_REGISTER_SDP_RECORDS = 1;
    private static final int MESSAGE_UUID_INTENT = 3;
    private static final ParcelUuid[] RFCOMM_UUIDS;
    private static final String SHARED_PREFERENCES_NAME = "bluetooth_service_settings";
    private static final String SHARED_PREFERENCE_DOCK_ADDRESS = "dock_bluetooth_address";
    private static final String TAG = "BluetoothService";
    private static final int UUID_INTENT_DELAY = 6000;
    private static String mDockAddress;
    private final BluetoothProfileState mA2dpProfileState;
    private BluetoothA2dpService mA2dpService;
    private BluetoothAdapter mAdapter;
    private final Map<String, String> mAdapterProperties;
    private final IBatteryStats mBatteryStats;
    private int mBluetoothState;
    private final BondState mBondState = new BondState();
    private final Context mContext;
    private final HashMap<String, Pair<byte[], byte[]>> mDeviceOobData;
    private final HashMap<String, BluetoothDeviceProfileState> mDeviceProfileState;
    private final HashMap<String, Map<String, String>> mDeviceProperties;
    private final HashMap<String, Map<ParcelUuid, Integer>> mDeviceServiceChannelCache;
    private String mDockPin;
    private EnableThread mEnableThread;
    private BluetoothEventLoop mEventLoop;
    private final Handler mHandler = new Handler(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    if (!BluetoothService.this.isEnabledInternal()) return;
                    switch (message.arg1) {
                        default: {
                            return;
                        }
                        case 1: {
                            Log.d(BluetoothService.TAG, "Registering hfag record");
                            SystemService.start("hfag");
                            BluetoothService.this.mHandler.sendMessageDelayed(BluetoothService.this.mHandler.obtainMessage(1, 2, -1), 500L);
                            return;
                        }
                        case 2: {
                            Log.d(BluetoothService.TAG, "Registering hsag record");
                            SystemService.start("hsag");
                            BluetoothService.this.mHandler.sendMessageDelayed(BluetoothService.this.mHandler.obtainMessage(1, 3, -1), 500L);
                            return;
                        }
                        case 3: {
                            Log.d(BluetoothService.TAG, "Registering opush record");
                            SystemService.start("opush");
                            BluetoothService.this.mHandler.sendMessageDelayed(BluetoothService.this.mHandler.obtainMessage(1, 4, -1), 500L);
                            return;
                        }
                        case 4: 
                    }
                    Log.d(BluetoothService.TAG, "Registering pbap record");
                    SystemService.start("pbap");
                    return;
                }
                case 2: {
                    BluetoothService bluetoothService = BluetoothService.this;
                    boolean bl = message.arg1 != 0;
                    bluetoothService.finishDisable(bl);
                    return;
                }
                case 3: {
                    String string2 = (String)message.obj;
                    if (string2 == null) return;
                    BluetoothService.this.sendUuidIntent(string2);
                    BluetoothService.this.makeServiceChannelCallbacks(string2);
                    return;
                }
                case 4: {
                    int cfr_ignored_0 = message.arg1;
                    if (!BluetoothService.this.isEnabledInternal()) return;
                    BluetoothService.this.setScanMode(21, -1);
                    return;
                }
                default: {
                    return;
                }
                case 5: 
            }
            String string3 = (String)message.obj;
            if (string3 == null) return;
            BluetoothService.this.createBond(string3);
        }
    };
    private final BluetoothProfileState mHfpProfileState;
    private boolean mIsAirplaneSensitive;
    private boolean mIsAirplaneToggleable;
    private boolean mIsDiscovering;
    private int mNativeData;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent == null) return;
            String string2 = intent.getAction();
            if (string2.equals("android.intent.action.AIRPLANE_MODE")) {
                ContentResolver contentResolver = context.getContentResolver();
                boolean bl = !BluetoothService.this.isAirplaneModeOn();
                if (Settings.Secure.getInt(contentResolver, "bluetooth_on", 0) <= 0) return;
                if (bl) {
                    BluetoothService.this.enable(false);
                    return;
                }
                BluetoothService.this.disable(false);
                return;
            }
            if (!"android.intent.action.DOCK_EVENT".equals(string2)) {
                return;
            }
            int n = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
            Log.v(BluetoothService.TAG, "Received ACTION_DOCK_EVENT with State:" + n);
            if (n == 0) {
                BluetoothService.access$2502(null);
                BluetoothService.access$2602(BluetoothService.this, null);
                return;
            }
            Context context2 = BluetoothService.this.mContext;
            BluetoothService.this.mContext;
            SharedPreferences.Editor editor = context2.getSharedPreferences(BluetoothService.SHARED_PREFERENCES_NAME, 0).edit();
            editor.putBoolean(BluetoothService.SHARED_PREFERENCE_DOCK_ADDRESS + mDockAddress, true);
            editor.apply();
        }
    };
    private boolean mRestart = false;
    private final HashMap<Integer, Integer> mServiceRecordToPid;
    private final HashMap<RemoteService, IBluetoothCallback> mUuidCallbackTracker;
    private final ArrayList<String> mUuidIntentTracker;

    static {
        ParcelUuid[] parcelUuidArray = new ParcelUuid[]{BluetoothUuid.Handsfree, BluetoothUuid.HSP, BluetoothUuid.ObexObjectPush};
        RFCOMM_UUIDS = parcelUuidArray;
        BluetoothService.classInitNative();
    }

    public BluetoothService(Context context) {
        this.mContext = context;
        this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batteryinfo"));
        this.initializeNativeDataNative();
        if (this.isEnabledNative() == 1) {
            Log.w(TAG, "Bluetooth daemons already running - runtime restart? ");
            this.disableNative();
        }
        this.mBluetoothState = 10;
        this.mIsDiscovering = false;
        this.mAdapterProperties = new HashMap<String, String>();
        this.mDeviceProperties = new HashMap();
        this.mDeviceServiceChannelCache = new HashMap();
        this.mDeviceOobData = new HashMap();
        this.mUuidIntentTracker = new ArrayList();
        this.mUuidCallbackTracker = new HashMap();
        this.mServiceRecordToPid = new HashMap();
        this.mDeviceProfileState = new HashMap();
        this.mA2dpProfileState = new BluetoothProfileState(this.mContext, 1);
        this.mHfpProfileState = new BluetoothProfileState(this.mContext, 0);
        this.mHfpProfileState.start();
        this.mA2dpProfileState.start();
        IntentFilter intentFilter = new IntentFilter();
        this.registerForAirplaneMode(intentFilter);
        intentFilter.addAction("android.intent.action.DOCK_EVENT");
        this.mContext.registerReceiver(this.mReceiver, intentFilter);
    }

    static /* synthetic */ BondState access$1000(BluetoothService bluetoothService) {
        return bluetoothService.mBondState;
    }

    static /* synthetic */ void access$1100(BluetoothService bluetoothService) {
        bluetoothService.initProfileState();
    }

    static /* synthetic */ IBatteryStats access$1200(BluetoothService bluetoothService) {
        return bluetoothService.mBatteryStats;
    }

    static /* synthetic */ EnableThread access$1302(BluetoothService bluetoothService, EnableThread enableThread) {
        bluetoothService.mEnableThread = enableThread;
        return enableThread;
    }

    static /* synthetic */ void access$1400(BluetoothService bluetoothService, int n) {
        bluetoothService.setBluetoothState(n);
    }

    static /* synthetic */ boolean access$1500(BluetoothService bluetoothService) {
        return bluetoothService.mIsAirplaneSensitive;
    }

    static /* synthetic */ boolean access$1700(BluetoothService bluetoothService) {
        return bluetoothService.mIsAirplaneToggleable;
    }

    static /* synthetic */ String access$2502(String string2) {
        mDockAddress = string2;
        return string2;
    }

    static /* synthetic */ String access$2602(BluetoothService bluetoothService, String string2) {
        bluetoothService.mDockPin = string2;
        return string2;
    }

    static /* synthetic */ int access$300(BluetoothService bluetoothService) {
        return bluetoothService.enableNative();
    }

    static /* synthetic */ BluetoothEventLoop access$400(BluetoothService bluetoothService) {
        return bluetoothService.mEventLoop;
    }

    static /* synthetic */ int access$600(BluetoothService bluetoothService) {
        return bluetoothService.disableNative();
    }

    static /* synthetic */ boolean access$700(BluetoothService bluetoothService) {
        return bluetoothService.setupNativeDataNative();
    }

    static /* synthetic */ void access$800(BluetoothService bluetoothService, boolean bl) {
        bluetoothService.persistBluetoothOnSetting(bl);
    }

    static /* synthetic */ boolean access$902(BluetoothService bluetoothService, boolean bl) {
        bluetoothService.mIsDiscovering = bl;
        return bl;
    }

    private BluetoothDeviceProfileState addProfileState(String string2) {
        BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
        if (bluetoothDeviceProfileState != null) {
            return bluetoothDeviceProfileState;
        }
        BluetoothDeviceProfileState bluetoothDeviceProfileState2 = new BluetoothDeviceProfileState(this.mContext, string2, this, this.mA2dpService);
        this.mDeviceProfileState.put(string2, bluetoothDeviceProfileState2);
        bluetoothDeviceProfileState2.start();
        return bluetoothDeviceProfileState2;
    }

    private native int addRfcommServiceRecordNative(String var1, long var2, long var4, short var6);

    static int bluezStringToScanMode(boolean bl, boolean bl2) {
        if (bl && bl2) {
            return 23;
        }
        if (bl && !bl2) {
            return 21;
        }
        return 20;
    }

    private native boolean cancelDeviceCreationNative(String var1);

    private native boolean cancelPairingUserInputNative(String var1, int var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkAndRemoveRecord(int n, int n2) {
        synchronized (this) {
            Integer n3 = new Integer(n);
            Integer n4 = this.mServiceRecordToPid.get(n3);
            if (n4 != null && n2 == n4) {
                BluetoothService.log("Removing service record " + Integer.toHexString(n) + " for pid " + n2);
                this.mServiceRecordToPid.remove(n3);
                this.removeServiceRecordNative(n);
            }
            return;
        }
    }

    private static native void classInitNative();

    private native void cleanupNativeDataNative();

    private native boolean createDeviceNative(String var1);

    private native boolean createPairedDeviceNative(String var1, int var2);

    private native boolean createPairedDeviceOutOfBandNative(String var1, int var2);

    private native int disableNative();

    private native int enableNative();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void finishDisable(boolean bl) {
        synchronized (this) {
            block14: {
                block13: {
                    int n = this.mBluetoothState;
                    if (n != 13) break block14;
                    this.mEventLoop.stop();
                    this.tearDownNativeDataNative();
                    this.disableNative();
                    for (String string2 : this.mBondState.listInState(11)) {
                        this.mBondState.setBondState(string2, 10, 3);
                    }
                    Intent intent = new Intent("android.bluetooth.adapter.action.SCAN_MODE_CHANGED");
                    intent.putExtra("android.bluetooth.adapter.extra.SCAN_MODE", 20);
                    this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
                    this.mIsDiscovering = false;
                    this.mAdapterProperties.clear();
                    this.mServiceRecordToPid.clear();
                    if (bl) {
                        this.persistBluetoothOnSetting(false);
                    }
                    this.setBluetoothState(10);
                    long l = Binder.clearCallingIdentity();
                    try {
                        this.mBatteryStats.noteBluetoothOff();
                        break block13;
                    }
                    catch (RemoteException remoteException) {}
                    break block13;
                    finally {
                        Binder.restoreCallingIdentity(l);
                    }
                }
                if (this.mRestart) {
                    this.mRestart = false;
                    this.enable();
                }
            }
            return;
        }
    }

    private native String getAdapterPathNative();

    private native Object[] getAdapterPropertiesNative();

    private native Object[] getDevicePropertiesNative(String var1);

    private native int getDeviceServiceChannelNative(String var1, String var2, int var3);

    private ParcelUuid[] getUuidFromCache(String string2) {
        String string3 = this.getRemoteDeviceProperty(string2, "UUIDs");
        if (string3 == null) {
            return null;
        }
        String[] stringArray = string3.split(",");
        ParcelUuid[] parcelUuidArray = new ParcelUuid[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            parcelUuidArray[i] = ParcelUuid.fromString(stringArray[i]);
        }
        return parcelUuidArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initProfileState() {
        String string2 = this.getPropertyInternal("Devices");
        String[] stringArray = null;
        if (string2 != null) {
            stringArray = string2.split(",");
        }
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                BluetoothDeviceProfileState bluetoothDeviceProfileState = this.addProfileState(this.getAddressFromObjectPath(stringArray2[i]));
                Message message = new Message();
                message.what = 101;
                bluetoothDeviceProfileState.sendMessageDelayed(message, 8000L);
            }
        }
    }

    private native void initializeNativeDataNative();

    private final boolean isAirplaneModeOn() {
        return Settings.System.getInt(this.mContext.getContentResolver(), "airplane_mode_on", 0) == 1;
    }

    private boolean isBondingFeasible(String string2) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
            return false;
        }
        String string3 = string2.toUpperCase();
        if (this.mBondState.getPendingOutgoingBonding() != null) {
            BluetoothService.log("Ignoring createBond(): another device is bonding");
            return false;
        }
        if (!this.mBondState.isAutoPairingAttemptsInProgress(string3) && this.mBondState.getBondState(string3) != 10) {
            BluetoothService.log("Ignoring createBond(): this device is already bonding or bonded");
            return false;
        }
        if (string3.equals(mDockAddress) && !this.writeDockPin()) {
            BluetoothService.log("Error while writing Pin for the dock");
            return false;
        }
        return true;
    }

    private boolean isEnabledInternal() {
        return this.mBluetoothState == 12;
    }

    private native int isEnabledNative();

    private static void log(String string2) {
        Log.d(TAG, string2);
    }

    private void pairingAttempt(String string2, int n) {
        int n2 = this.mBondState.getAttempt(string2);
        if (3000L * (long)n2 > 12000L) {
            this.mBondState.clearPinAttempts(string2);
            this.setBondState(string2, 10, n);
            return;
        }
        Message message = this.mHandler.obtainMessage(5);
        message.obj = string2;
        if (!this.mHandler.sendMessageDelayed(message, 3000L * (long)n2)) {
            this.mBondState.clearPinAttempts(string2);
            this.setBondState(string2, 10, n);
            return;
        }
        this.mBondState.attempt(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void persistBluetoothOnSetting(boolean bl) {
        long l = Binder.clearCallingIdentity();
        ContentResolver contentResolver = this.mContext.getContentResolver();
        int n = bl ? 1 : 0;
        Settings.Secure.putInt(contentResolver, "bluetooth_on", n);
        Binder.restoreCallingIdentity(l);
    }

    private native byte[] readAdapterOutOfBandDataNative();

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readDockBluetoothAddress() {
        synchronized (BluetoothService.class) {
            block25: {
                if (BluetoothService.mDockAddress != null) {
                    return BluetoothService.mDockAddress;
                }
                var1_1 = null;
                var2_2 = new BufferedInputStream(new FileInputStream("/sys/class/switch/dock/bt_addr"));
                var9_3 = new byte[17];
                var2_2.read(var9_3);
                var11_4 = new String(var9_3).toUpperCase();
                if (!BluetoothAdapter.checkBluetoothAddress(var11_4)) break block25;
                var7 = BluetoothService.mDockAddress = var11_4;
                if (var2_2 == null) return var7;
                try {
                    var2_2.close();
                }
                catch (IOException var13_5) {}
                ** GOTO lbl63
            }
            BluetoothService.log("CheckBluetoothAddress failed for car dock address:" + var11_4);
            if (var2_2 == null) ** GOTO lbl60
            try {
                var2_2.close();
            }
            catch (IOException var12_13) {}
            catch (FileNotFoundException var15_6) {}
            ** GOTO lbl-1000
            catch (IOException var14_8) {}
            ** GOTO lbl-1000
            ** GOTO lbl60
            catch (Throwable var4_11) {
                var1_1 = var2_2;
                ** GOTO lbl-1000
            }
            catch (IOException var8_14) {
                var1_1 = var2_2;
            }
lbl-1000:
            // 2 sources

            {
                BluetoothService.log("IOException while trying to read dock address");
                if (var1_1 == null) ** GOTO lbl60
                var1_1.close();
                ** GOTO lbl60
                {
                    catch (IOException var6_7) {}
                }
                catch (FileNotFoundException var3_15) {
                    var1_1 = var2_2;
                }
lbl-1000:
                // 2 sources

                {
                    block26: {
                        try {
                            BluetoothService.log("FileNotFoundException while trying to read dock address");
                            if (var1_1 == null) break block26;
                        }
                        catch (Throwable var4_9) lbl-1000:
                        // 2 sources

                        {
                            if (var1_1 == null) throw var4_10;
                            try {
                                var1_1.close();
                            }
                            catch (IOException var5_12) {
                                throw var4_10;
                            }
                            throw var4_10;
                        }
                        var1_1.close();
                    }
                    BluetoothService.mDockAddress = null;
                    return null;
lbl63:
                    // 2 sources

                    return var7;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void registerForAirplaneMode(IntentFilter intentFilter) {
        ContentResolver contentResolver = this.mContext.getContentResolver();
        String string2 = Settings.System.getString(contentResolver, "airplane_mode_radios");
        String string3 = Settings.System.getString(contentResolver, "airplane_mode_toggleable_radios");
        boolean bl = string2 == null ? true : string2.contains("bluetooth");
        this.mIsAirplaneSensitive = bl;
        boolean bl2 = string3 == null ? false : string3.contains("bluetooth");
        this.mIsAirplaneToggleable = bl2;
        if (this.mIsAirplaneSensitive) {
            intentFilter.addAction("android.intent.action.AIRPLANE_MODE");
        }
    }

    private native boolean removeDeviceNative(String var1);

    private void removeProfileState(String string2) {
        this.mDeviceProfileState.remove(string2);
    }

    private native boolean removeServiceRecordNative(int var1);

    static String scanModeToBluezString(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 20: {
                return "off";
            }
            case 21: {
                return "connectable";
            }
            case 23: 
        }
        return "discoverable";
    }

    private native boolean setAdapterPropertyBooleanNative(String var1, int var2);

    private native boolean setAdapterPropertyIntegerNative(String var1, int var2);

    private native boolean setAdapterPropertyStringNative(String var1, String var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setBluetoothState(int n) {
        synchronized (this) {
            block6: {
                int n2 = this.mBluetoothState;
                if (n != n2) break block6;
                return;
            }
            BluetoothService.log("Bluetooth state " + this.mBluetoothState + " -> " + n);
            Intent intent = new Intent("android.bluetooth.adapter.action.STATE_CHANGED");
            intent.putExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", this.mBluetoothState);
            intent.putExtra("android.bluetooth.adapter.extra.STATE", n);
            intent.addFlags(0x10000000);
            this.mBluetoothState = n;
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            return;
        }
    }

    private native boolean setDevicePropertyBooleanNative(String var1, String var2, int var3);

    private native boolean setLinkTimeoutNative(String var1, int var2);

    private native boolean setPairingConfirmationNative(String var1, boolean var2, int var3);

    private native boolean setPasskeyNative(String var1, int var2, int var3);

    private native boolean setPinNative(String var1, String var2, int var3);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setPropertyBoolean(String string2, boolean bl) {
        int n;
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (bl) {
            n = 1;
            return this.setAdapterPropertyBooleanNative(string2, n);
        }
        n = 0;
        return this.setAdapterPropertyBooleanNative(string2, n);
    }

    private boolean setPropertyInteger(String string2, int n) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        return this.setAdapterPropertyIntegerNative(string2, n);
    }

    private boolean setPropertyString(String string2, String string3) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        return this.setAdapterPropertyStringNative(string2, string3);
    }

    private native boolean setRemoteOutOfBandDataNative(String var1, byte[] var2, byte[] var3, int var4);

    private native boolean setupNativeDataNative();

    private native boolean startDiscoveryNative();

    private native boolean stopDiscoveryNative();

    private native boolean tearDownNativeDataNative();

    private static String toBondStateString(int n) {
        switch (n) {
            default: {
                return "??????";
            }
            case 10: {
                return "not bonded";
            }
            case 11: {
                return "bonding";
            }
            case 12: 
        }
        return "bonded";
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeDockPin() {
        synchronized (this) {
            var1_1 = null;
            var2_2 = new BufferedWriter(new FileWriter("/sys/class/switch/dock/bt_pin"));
            var10_3 = (int)Math.floor(10000.0 * Math.random());
            var11_4 = new Object[]{var10_3};
            this.mDockPin = String.format("%04d", var11_4);
            var2_2.write(this.mDockPin);
            if (var2_2 == null) return true;
            var2_2.close();
            return true;
            catch (FileNotFoundException var14_6) {}
            ** GOTO lbl-1000
            catch (IOException var13_7) {}
            ** GOTO lbl-1000
            catch (IOException var12_14) {}
            return true;
            catch (Throwable var4_11) {
                var1_1 = var2_2;
                ** GOTO lbl-1000
            }
            catch (IOException var9_15) {
                var1_1 = var2_2;
            }
lbl-1000:
            // 2 sources

            {
                BluetoothService.log("IOException while while trying to write dock pairing pin");
                if (var1_1 == null) ** GOTO lbl47
                var1_1.close();
                {
                    catch (IOException var8_8) {}
                }
                catch (FileNotFoundException var3_16) {
                    var1_1 = var2_2;
                }
lbl-1000:
                // 2 sources

                {
                    block21: {
                        try {
                            BluetoothService.log("FileNotFoundException while trying to write dock pairing pin");
                            if (var1_1 == null) break block21;
                        }
                        catch (Throwable var4_9) lbl-1000:
                        // 2 sources

                        {
                            if (var1_1 == null) throw var4_10;
                            try {
                                var1_1.close();
                            }
                            catch (IOException var6_13) {
                                throw var4_10;
                            }
                            throw var4_10;
                        }
                        var1_1.close();
                    }
                    this.mDockPin = null;
                    return false;
                }
            }
            catch (Throwable var5_12) {}
            throw var5_12;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addRemoteDeviceProperties(String string2, String[] stringArray) {
        synchronized (this) {
            Map<String, String> map = this.mDeviceProperties.get(string2);
            if (map == null) {
                map = new HashMap<String, String>();
            }
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    this.mDeviceProperties.put(string2, map);
                    this.updateDeviceServiceChannelCache(string2);
                    return;
                }
                String string3 = stringArray[n];
                if (string3 == null) {
                    Log.e(TAG, "Error: Remote Device Property at index" + n + "is null");
                } else {
                    String string4;
                    if (string3.equals("UUIDs") || string3.equals("Nodes")) {
                        StringBuilder stringBuilder = new StringBuilder();
                        int n2 = Integer.valueOf(stringArray[++n]);
                        for (int i = 0; i < n2; ++i) {
                            stringBuilder.append(stringArray[++n]);
                            stringBuilder.append(",");
                        }
                        string4 = null;
                        if (n2 > 0) {
                            string4 = stringBuilder.toString();
                        }
                    } else {
                        string4 = stringArray[++n];
                    }
                    map.put(string3, string4);
                }
                ++n;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int addRfcommServiceRecord(String string2, ParcelUuid parcelUuid, int n, IBinder iBinder) {
        synchronized (this) {
            int n2;
            block12: {
                block11: {
                    block10: {
                        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
                        boolean bl = this.isEnabledInternal();
                        if (bl) break block10;
                        return -1;
                    }
                    if (string2 == null) return -1;
                    if (parcelUuid == null) return -1;
                    if (n < 1) return -1;
                    if (n > 30) {
                        return -1;
                    }
                    if (!BluetoothUuid.isUuidPresent(BluetoothUuid.RESERVED_UUIDS, parcelUuid)) break block11;
                    Log.w(TAG, "Attempted to register a reserved UUID: " + parcelUuid);
                    return -1;
                }
                n2 = this.addRfcommServiceRecordNative(string2, parcelUuid.getUuid().getMostSignificantBits(), parcelUuid.getUuid().getLeastSignificantBits(), (short)n);
                BluetoothService.log("new handle " + Integer.toHexString(n2));
                if (n2 != -1) break block12;
                return -1;
            }
            int n3 = Binder.getCallingPid();
            this.mServiceRecordToPid.put(new Integer(n2), new Integer(n3));
            try {
                iBinder.linkToDeath(new Reaper(n2, n3), 0);
                return n2;
            }
            catch (RemoteException remoteException) {
                return n2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean attemptAutoPair(String string2) {
        synchronized (this) {
            if (this.mBondState.hasAutoPairingFailed(string2)) return false;
            if (this.mBondState.isAutoPairingBlacklisted(string2)) return false;
            this.mBondState.attempt(string2);
            this.setPin(string2, BluetoothDevice.convertPinToBytes((String)"0000"));
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cancelBondProcess(String string2) {
        synchronized (this) {
            String string3;
            block8: {
                block7: {
                    block6: {
                        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                        boolean bl = this.isEnabledInternal();
                        if (bl) break block6;
                        return false;
                    }
                    if (BluetoothAdapter.checkBluetoothAddress(string2)) break block7;
                    return false;
                }
                string3 = string2.toUpperCase();
                if (this.mBondState.getBondState(string3) == 11) break block8;
                return false;
            }
            this.mBondState.setBondState(string3, 10, 3);
            this.cancelDeviceCreationNative(string3);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cancelDiscovery() {
        synchronized (this) {
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                boolean bl = this.isEnabledInternal();
                if (bl) break block4;
                return false;
            }
            boolean bl = this.stopDiscoveryNative();
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cancelPairingUserInput(String string2) {
        synchronized (this) {
            Integer n;
            String string3;
            block9: {
                block8: {
                    block7: {
                        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                        boolean bl = this.isEnabledInternal();
                        if (bl) break block7;
                        return false;
                    }
                    if (BluetoothAdapter.checkBluetoothAddress(string2)) break block8;
                    return false;
                }
                this.mBondState.setBondState(string2, 10, 3);
                string3 = string2.toUpperCase();
                n = this.mEventLoop.getPasskeyAgentRequestData().remove(string3);
                if (n != null) break block9;
                Log.w(TAG, "cancelUserInputNative(" + string3 + ") called but no native data " + "available, ignoring. Maybe the PasskeyAgent Request was already cancelled " + "by the remote or by bluez.\n");
                return false;
            }
            boolean bl = this.cancelPairingUserInputNative(string3, n);
            return bl;
        }
    }

    @Override
    public boolean connectHeadset(String string2) {
        BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
        if (bluetoothDeviceProfileState != null) {
            Message message = new Message();
            message.arg1 = 1;
            message.obj = bluetoothDeviceProfileState;
            this.mHfpProfileState.sendMessage(message);
            return true;
        }
        return false;
    }

    public boolean connectSink(String string2) {
        BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
        if (bluetoothDeviceProfileState != null) {
            Message message = new Message();
            message.arg1 = 3;
            message.obj = bluetoothDeviceProfileState;
            this.mA2dpProfileState.sendMessage(message);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean createBond(String string2) {
        synchronized (this) {
            block6: {
                block5: {
                    boolean bl = this.isBondingFeasible(string2);
                    if (bl) break block5;
                    return false;
                }
                if (this.createPairedDeviceNative(string2, 60000)) break block6;
                return false;
            }
            this.mBondState.setPendingOutgoingBonding(string2);
            this.mBondState.setBondState(string2, 11);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean createBondOutOfBand(String string2, byte[] byArray, byte[] byArray2) {
        synchronized (this) {
            block6: {
                block5: {
                    boolean bl = this.isBondingFeasible(string2);
                    if (bl) break block5;
                    return false;
                }
                if (this.createPairedDeviceOutOfBandNative(string2, 60000)) break block6;
                return false;
            }
            this.setDeviceOutOfBandData(string2, byArray, byArray2);
            this.mBondState.setPendingOutgoingBonding(string2);
            this.mBondState.setBondState(string2, 11);
            return true;
        }
    }

    public boolean disable() {
        return this.disable(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean disable(boolean bl) {
        synchronized (this) {
            int n;
            Handler handler;
            Handler handler2;
            block11: {
                block10: {
                    this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                    int n2 = this.mBluetoothState;
                    switch (n2) {
                        default: {
                            return false;
                        }
                        case 10: {
                            return true;
                        }
                        case 12: 
                    }
                    if (this.mEnableThread == null || !this.mEnableThread.isAlive()) break block10;
                    return false;
                }
                this.setBluetoothState(13);
                this.mHandler.removeMessages(1);
                handler2 = this.mHandler;
                handler = this.mHandler;
                n = 0;
                if (!bl) break block11;
                n = 1;
            }
            handler2.sendMessageDelayed(handler.obtainMessage(2, n, 0), 3000L);
            return true;
        }
    }

    @Override
    public boolean disconnectHeadset(String string2) {
        BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
        if (bluetoothDeviceProfileState != null) {
            Message message = new Message();
            message.arg1 = 5;
            message.obj = bluetoothDeviceProfileState;
            this.mHfpProfileState.sendMessage(message);
            return true;
        }
        return false;
    }

    public boolean disconnectSink(String string2) {
        BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
        if (bluetoothDeviceProfileState != null) {
            Message message = new Message();
            message.arg1 = 7;
            message.obj = bluetoothDeviceProfileState;
            this.mA2dpProfileState.sendMessage(message);
            return true;
        }
        return false;
    }

    native boolean discoverServicesNative(String var1, String var2);

    /*
     * Unable to fully structure code
     */
    @Override
    protected void dump(FileDescriptor var1_1, PrintWriter var2_2, String[] var3_3) {
        block25: {
            block0 : switch (this.mBluetoothState) lbl-1000:
            // 2 sources

            {
                default: {
                    var2_2.println("mIsAirplaneSensitive = " + this.mIsAirplaneSensitive);
                    var2_2.println("mIsAirplaneToggleable = " + this.mIsAirplaneToggleable);
                    var2_2.println("Local address = " + this.getAddress());
                    var2_2.println("Local name = " + this.getName());
                    var2_2.println("isDiscovering() = " + this.isDiscovering());
                    var4_4 = new BluetoothHeadset(this.mContext, null);
                    var2_2.println("\n--Known devices--");
                    block13: for (String var14_6 : this.mDeviceProperties.keySet()) {
                        var15_7 = this.mBondState.getBondState(var14_6);
                        var16_8 = new Object[]{var14_6, BluetoothService.toBondStateString(var15_7), this.mBondState.getAttempt(var14_6), this.getRemoteName(var14_6)};
                        var2_2.printf("%s %10s (%d) %s\n", var16_8);
                        var18_9 = this.mDeviceServiceChannelCache.get(var14_6);
                        if (var18_9 != null) break block0;
                        var2_2.println("\tuuids = null");
                        while (true) {
                            for (RemoteService var23_14 : this.mUuidCallbackTracker.keySet()) {
                                if (!var23_14.address.equals(var14_6)) continue;
                                var2_2.println("\tPENDING CALLBACK: " + var23_14.uuid);
                            }
                            continue block13;
                            break;
                        }
                    }
                    break block25;
                }
                case 10: {
                    var2_2.println("Bluetooth OFF\n");
                    return;
                }
                case 11: {
                    var2_2.println("Bluetooth TURNING ON\n");
                    return;
                }
                case 13: {
                    var2_2.println("Bluetooth TURNING OFF\n");
                    return;
                }
                case 12: {
                    var2_2.println("Bluetooth ON\n");
                    ** GOTO lbl-1000
                }
            }
            var19_10 = var18_9.keySet().iterator();
            while (true) lbl-1000:
            // 3 sources

            {
                if (!var19_10.hasNext()) ** continue;
                var20_11 = var19_10.next();
                var21_12 = var18_9.get(var20_11);
                if (var21_12 == null) {
                    var2_2.println("\t" + var20_11);
                    ** continue;
                }
                var2_2.println("\t" + var20_11 + " RFCOMM channel = " + var21_12);
            }
        }
        var6_15 = this.getProperty("Devices");
        var7_16 = null;
        if (var6_15 != null) {
            var7_16 = var6_15.split(",");
        }
        var2_2.println("\n--ACL connected devices--");
        if (var7_16 != null) {
            var11_17 = var7_16;
            var12_18 = var11_17.length;
            for (var13_19 = 0; var13_19 < var12_18; ++var13_19) {
                var2_2.println(this.getAddressFromObjectPath(var11_17[var13_19]));
            }
        }
        var2_2.println("\n--Headset Service--");
        switch (var4_4.getState(var4_4.getCurrentHeadset())) lbl-1000:
        // 4 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    var2_2.println("\ngetCurrentHeadset() = " + var4_4.getCurrentHeadset());
                    var2_2.println("getBatteryUsageHint() = " + var4_4.getBatteryUsageHint());
                    var4_4.close();
                    var2_2.println("\n--Application Service Records--");
                    var8_20 = this.mServiceRecordToPid.keySet().iterator();
                    while (true) {
                        if (!var8_20.hasNext()) ** continue;
                        var9_21 = var8_20.next();
                        var10_22 = this.mServiceRecordToPid.get(var9_21);
                        var2_2.println("\tpid " + var10_22 + " handle " + Integer.toHexString(var9_21));
                    }
                    break;
                }
            }
            case 0: {
                var2_2.println("getState() = STATE_DISCONNECTED");
                ** GOTO lbl-1000
            }
            case 1: {
                var2_2.println("getState() = STATE_CONNECTING");
                ** GOTO lbl-1000
            }
            case 2: {
                var2_2.println("getState() = STATE_CONNECTED");
                ** GOTO lbl-1000
            }
            case -1: 
        }
        var2_2.println("getState() = STATE_ERROR");
        ** while (true)
    }

    @Override
    public boolean enable() {
        return this.enable(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enable(boolean bl) {
        synchronized (this) {
            block8: {
                block7: {
                    block6: {
                        boolean bl2;
                        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                        if (!this.mIsAirplaneSensitive || !this.isAirplaneModeOn() || (bl2 = this.mIsAirplaneToggleable)) break block6;
                        return false;
                    }
                    if (this.mBluetoothState == 10) break block7;
                    return false;
                }
                if (this.mEnableThread == null || !this.mEnableThread.isAlive()) break block8;
                return false;
            }
            this.setBluetoothState(11);
            this.mEnableThread = new EnableThread(bl);
            this.mEnableThread.start();
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean fetchRemoteUuids(String string2, ParcelUuid parcelUuid, IBluetoothCallback iBluetoothCallback) {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            boolean bl = this.isEnabledInternal();
            if (!bl) {
                return false;
            }
            if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
                return false;
            }
            RemoteService remoteService = new RemoteService(string2, parcelUuid);
            if (parcelUuid != null && this.mUuidCallbackTracker.get(remoteService) != null) {
                return false;
            }
            if (!this.mUuidIntentTracker.contains(string2)) {
                boolean bl2;
                if (this.isRemoteDeviceInCache(string2) && this.getRemoteUuids(string2) != null) {
                    String string3 = this.getObjectPathFromAddress(string2);
                    if (string3 == null) {
                        return false;
                    }
                    bl2 = this.discoverServicesNative(string3, "");
                } else {
                    boolean bl3;
                    bl2 = bl3 = this.createDeviceNative(string2);
                }
                this.mUuidIntentTracker.add(string2);
                if (parcelUuid != null) {
                    this.mUuidCallbackTracker.put(new RemoteService(string2, parcelUuid), iBluetoothCallback);
                }
                Message message = this.mHandler.obtainMessage(3);
                message.obj = string2;
                this.mHandler.sendMessageDelayed(message, 6000L);
                return bl2;
            }
            if (parcelUuid == null) return true;
            this.mUuidCallbackTracker.put(new RemoteService(string2, parcelUuid), iBluetoothCallback);
            return true;
        }
    }

    @Override
    protected void finalize() throws Throwable {
        this.mContext.unregisterReceiver(this.mReceiver);
        try {
            this.cleanupNativeDataNative();
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String getAddress() {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            String string2 = this.getProperty("Address");
            return string2;
        }
    }

    String getAddressFromObjectPath(String string2) {
        String string3 = this.getPropertyInternal("ObjectPath");
        if (string3 == null || string2 == null) {
            Log.e(TAG, "getAddressFromObjectPath: AdapterObjectPath:" + string3 + "  or deviceObjectPath:" + string2 + " is null");
            return null;
        }
        if (!string2.startsWith(string3)) {
            Log.e(TAG, "getAddressFromObjectPath: AdapterObjectPath:" + string3 + "  is not a prefix of deviceObjectPath:" + string2 + "bluetoothd crashed ?");
            return null;
        }
        String string4 = string2.substring(string3.length());
        if (string4 != null) {
            return string4.replace('_', ':');
        }
        Log.e(TAG, "getAddressFromObjectPath: Address being returned is null");
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void getAllProperties() {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
            this.mAdapterProperties.clear();
            var2_1 = (String[])this.getAdapterPropertiesNative();
            if (var2_1 == null) {
                Log.e("BluetoothService", "*Error*: GetAdapterProperties returned NULL");
lbl8:
                // 3 sources

                return;
            }
            var4_2 = 0;
            while (true) {
                block16: {
                    block15: {
                        if (var4_2 >= var2_1.length) break block15;
                        var7_3 = var2_1[var4_2];
                        if (var7_3 == null) {
                            Log.e("BluetoothService", "Error:Adapter Property at index" + var4_2 + "is null");
                            break block16;
                        } else {
                            if (var7_3.equals("Devices") || var7_3.equals("UUIDs")) {
                                var9_4 = new StringBuilder();
                                var10_5 = Integer.valueOf(var2_1[++var4_2]);
                                for (var11_6 = 0; var11_6 < var10_5; ++var11_6) {
                                    var9_4.append(var2_1[++var4_2]);
                                    var9_4.append(",");
                                }
                                var12_7 = null;
                                if (var10_5 > 0) {
                                    var12_7 = var9_4.toString();
                                }
                            } else {
                                var12_7 = var2_1[++var4_2];
                            }
                            this.mAdapterProperties.put(var7_3, var12_7);
                        }
                        break block16;
                    }
                    var5_8 = this.getAdapterPathNative();
                    if (var5_8 == null) ** GOTO lbl8
                    this.mAdapterProperties.put("ObjectPath", var5_8 + "/dev_");
                    ** continue;
                }
                ++var4_2;
            }
        }
    }

    @Override
    public int getBluetoothState() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        return this.mBluetoothState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getBondState(String string2) {
        synchronized (this) {
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
                boolean bl = BluetoothAdapter.checkBluetoothAddress(string2);
                if (bl) break block4;
                return Integer.MIN_VALUE;
            }
            int n = this.mBondState.getBondState(string2.toUpperCase());
            return n;
        }
    }

    Pair<byte[], byte[]> getDeviceOutOfBandData(BluetoothDevice bluetoothDevice) {
        return this.mDeviceOobData.get(bluetoothDevice.getAddress());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getDiscoverableTimeout() {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            String string2 = this.getProperty("DiscoverableTimeout");
            if (string2 == null) return -1;
            int n = Integer.valueOf(string2);
            return n;
        }
    }

    String getDockPin() {
        synchronized (this) {
            String string2 = this.mDockPin;
            return string2;
        }
    }

    @Override
    public String getName() {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            String string2 = this.getProperty("Name");
            return string2;
        }
    }

    String getObjectPathFromAddress(String string2) {
        String string3 = this.getPropertyInternal("ObjectPath");
        if (string3 == null) {
            Log.e(TAG, "Error: Object Path is null");
            return null;
        }
        return string3 + string2.replace(":", "_");
    }

    String getPendingOutgoingBonding() {
        synchronized (this) {
            String string2 = this.mBondState.getPendingOutgoingBonding();
            return string2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getProperty(String string2) {
        synchronized (this) {
            block4: {
                boolean bl = this.isEnabledInternal();
                if (bl) break block4;
                return null;
            }
            String string3 = this.getPropertyInternal(string2);
            return string3;
        }
    }

    String getPropertyInternal(String string2) {
        synchronized (this) {
            String string3;
            if (!this.mAdapterProperties.isEmpty()) {
                string3 = this.mAdapterProperties.get(string2);
                return string3;
            }
            this.getAllProperties();
            string3 = this.mAdapterProperties.get(string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getRemoteClass(String string2) {
        synchronized (this) {
            String string3;
            block6: {
                block5: {
                    if (BluetoothAdapter.checkBluetoothAddress(string2)) break block5;
                    this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
                    return -16777216;
                }
                string3 = this.getRemoteDeviceProperty(string2, "Class");
                if (string3 != null) break block6;
                return -16777216;
            }
            int n = Integer.valueOf(string3);
            return n;
        }
    }

    String[] getRemoteDeviceProperties(String string2) {
        if (!this.isEnabledInternal()) {
            return null;
        }
        return (String[])this.getDevicePropertiesNative(this.getObjectPathFromAddress(string2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getRemoteDeviceProperty(String string2, String string3) {
        synchronized (this) {
            block6: {
                Map<String, String> map = this.mDeviceProperties.get(string2);
                if (map == null) break block6;
                return map.get(string3);
            }
            if (this.updateRemoteDevicePropertiesCache(string2)) {
                return this.getRemoteDeviceProperty(string2, string3);
            }
            Log.e(TAG, "getRemoteDeviceProperty: " + string3 + "not present:" + string2);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getRemoteName(String string2) {
        synchronized (this) {
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
                boolean bl = BluetoothAdapter.checkBluetoothAddress(string2);
                if (bl) break block4;
                return null;
            }
            String string3 = this.getRemoteDeviceProperty(string2, "Name");
            return string3;
        }
    }

    @Override
    public int getRemoteServiceChannel(String string2, ParcelUuid parcelUuid) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return -1;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
            return Integer.MIN_VALUE;
        }
        if (this.mDeviceProperties.isEmpty() && !this.updateRemoteDevicePropertiesCache(string2)) {
            return -1;
        }
        Map<ParcelUuid, Integer> map = this.mDeviceServiceChannelCache.get(string2);
        if (map != null && map.containsKey(parcelUuid)) {
            return map.get(parcelUuid);
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ParcelUuid[] getRemoteUuids(String string2) {
        synchronized (this) {
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
                boolean bl = BluetoothAdapter.checkBluetoothAddress(string2);
                if (bl) break block4;
                return null;
            }
            ParcelUuid[] parcelUuidArray = this.getUuidFromCache(string2);
            return parcelUuidArray;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getScanMode() {
        synchronized (this) {
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
                boolean bl = this.isEnabledInternal();
                if (bl) break block4;
                return 20;
            }
            int n = BluetoothService.bluezStringToScanMode(this.getProperty("Pairable").equals("true"), this.getProperty("Discoverable").equals("true"));
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getTrustState(String string2) {
        synchronized (this) {
            String string3;
            block6: {
                block5: {
                    if (BluetoothAdapter.checkBluetoothAddress(string2)) break block5;
                    this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
                    return false;
                }
                string3 = this.getRemoteDeviceProperty(string2, "Trusted");
                if (string3 != null) break block6;
                return false;
            }
            boolean bl = string3.equals("true");
            if (!bl) return false;
            return true;
        }
    }

    public void initAfterRegistration() {
        synchronized (this) {
            this.mAdapter = BluetoothAdapter.getDefaultAdapter();
            this.mEventLoop = new BluetoothEventLoop(this.mContext, this.mAdapter, this);
            return;
        }
    }

    boolean isAdapterPropertiesEmpty() {
        synchronized (this) {
            boolean bl = this.mAdapterProperties.isEmpty();
            return bl;
        }
    }

    @Override
    public boolean isBluetoothDock(String string2) {
        synchronized (this) {
            Context context = this.mContext;
            boolean bl = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 0).contains(SHARED_PREFERENCE_DOCK_ADDRESS + string2);
            return bl;
        }
    }

    @Override
    public boolean isDiscovering() {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            boolean bl = this.mIsDiscovering;
            return bl;
        }
    }

    @Override
    public boolean isEnabled() {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        return this.isEnabledInternal();
    }

    boolean isRemoteDeviceInCache(String string2) {
        return this.mDeviceProperties.get(string2) != null;
    }

    @Override
    public String[] listBonds() {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            String[] stringArray = this.mBondState.listInState(12);
            return stringArray;
        }
    }

    String[] listInState(int n) {
        synchronized (this) {
            String[] stringArray = this.mBondState.listInState(n);
            return stringArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void makeServiceChannelCallbacks(String string2) {
        synchronized (this) {
            Iterator<RemoteService> iterator = this.mUuidCallbackTracker.keySet().iterator();
            while (iterator.hasNext()) {
                RemoteService remoteService = iterator.next();
                if (!remoteService.address.equals(string2)) continue;
                BluetoothService.log("Cleaning up failed UUID channel lookup: " + remoteService.address + " " + remoteService.uuid);
                IBluetoothCallback iBluetoothCallback = this.mUuidCallbackTracker.get(remoteService);
                if (iBluetoothCallback != null) {
                    try {
                        iBluetoothCallback.onRfcommChannelFound(-1);
                    }
                    catch (RemoteException remoteException) {
                        Log.e(TAG, "", remoteException);
                    }
                }
                iterator.remove();
            }
            return;
        }
    }

    boolean notifyIncomingA2dpConnection(String string2) {
        BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
        if (bluetoothDeviceProfileState != null) {
            Message message = new Message();
            message.what = 4;
            bluetoothDeviceProfileState.sendMessage(message);
            return true;
        }
        return false;
    }

    @Override
    public boolean notifyIncomingConnection(String string2) {
        BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
        if (bluetoothDeviceProfileState != null) {
            Message message = new Message();
            message.what = 2;
            bluetoothDeviceProfileState.sendMessage(message);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void onCreatePairedDeviceResult(String string2, int n) {
        synchronized (this) {
            if (n == 0) {
                this.setBondState(string2, 12);
                if (this.mBondState.isAutoPairingAttemptsInProgress(string2)) {
                    this.mBondState.clearPinAttempts(string2);
                }
            } else if (n == 1 && this.mBondState.getAttempt(string2) == 1) {
                this.mBondState.addAutoPairingFailure(string2);
                this.pairingAttempt(string2, n);
            } else if (n == 4 && this.mBondState.isAutoPairingAttemptsInProgress(string2)) {
                this.pairingAttempt(string2, n);
            } else {
                this.setBondState(string2, 10, n);
                if (this.mBondState.isAutoPairingAttemptsInProgress(string2)) {
                    this.mBondState.clearPinAttempts(string2);
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] readOutOfBandData() {
        synchronized (this) {
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
                boolean bl = this.isEnabledInternal();
                if (bl) break block4;
                return null;
            }
            byte[] byArray = this.readAdapterOutOfBandDataNative();
            return byArray;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean removeBond(String string2) {
        synchronized (this) {
            block7: {
                block6: {
                    this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                    boolean bl = this.isEnabledInternal();
                    if (bl) break block6;
                    return false;
                }
                if (BluetoothAdapter.checkBluetoothAddress(string2)) break block7;
                return false;
            }
            BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
            if (bluetoothDeviceProfileState == null) return false;
            bluetoothDeviceProfileState.sendMessage(100);
            return true;
        }
    }

    public boolean removeBondInternal(String string2) {
        synchronized (this) {
            boolean bl = this.removeDeviceNative(this.getObjectPathFromAddress(string2));
            return bl;
        }
    }

    void removeRemoteDeviceProperties(String string2) {
        this.mDeviceProperties.remove(string2);
    }

    @Override
    public void removeServiceRecord(int n) {
        this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
        this.checkAndRemoveRecord(n, Binder.getCallingPid());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void restart() {
        synchronized (this) {
            int n = this.mBluetoothState;
            if (n == 12) {
                this.mRestart = true;
                if (!this.disable(false)) {
                    this.mRestart = false;
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void sendProfileStateMessage(int n, int n2) {
        Message message = new Message();
        message.what = n2;
        if (n == 0) {
            this.mHfpProfileState.sendMessage(message);
            return;
        } else {
            if (n != 1) return;
            this.mA2dpProfileState.sendMessage(message);
            return;
        }
    }

    void sendUuidIntent(String string2) {
        synchronized (this) {
            Parcelable[] parcelableArray = this.getUuidFromCache(string2);
            Intent intent = new Intent("android.bleutooth.device.action.UUID");
            intent.putExtra("android.bluetooth.device.extra.DEVICE", this.mAdapter.getRemoteDevice(string2));
            intent.putExtra("android.bluetooth.device.extra.UUID", parcelableArray);
            this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
            if (this.mUuidIntentTracker.contains(string2)) {
                this.mUuidIntentTracker.remove(string2);
            }
            return;
        }
    }

    void setA2dpService(BluetoothA2dpService bluetoothA2dpService) {
        this.mA2dpService = bluetoothA2dpService;
    }

    boolean setBondState(String string2, int n) {
        synchronized (this) {
            boolean bl = this.setBondState(string2, n, 0);
            return bl;
        }
    }

    boolean setBondState(String string2, int n, int n2) {
        synchronized (this) {
            this.mBondState.setBondState(string2.toUpperCase(), n);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setDeviceOutOfBandData(String string2, byte[] byArray, byte[] byArray2) {
        synchronized (this) {
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                boolean bl = this.isEnabledInternal();
                if (bl) break block4;
                return false;
            }
            Pair<byte[], byte[]> pair = new Pair<byte[], byte[]>(byArray, byArray2);
            BluetoothService.log("Setting out of band data for:" + string2 + ":" + Arrays.toString(byArray) + ":" + Arrays.toString(byArray2));
            this.mDeviceOobData.put(string2, pair);
            return true;
        }
    }

    @Override
    public boolean setDiscoverableTimeout(int n) {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
            boolean bl = this.setPropertyInteger("DiscoverableTimeout", n);
            return bl;
        }
    }

    void setIsDiscovering(boolean bl) {
        this.mIsDiscovering = bl;
    }

    void setLinkTimeout(String string2, int n) {
        if (!this.setLinkTimeoutNative(this.getObjectPathFromAddress(string2), n)) {
            BluetoothService.log("Set Link Timeout to:" + n + " slots failed");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setName(String string2) {
        synchronized (this) {
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                if (string2 != null) break block4;
                return false;
            }
            boolean bl = this.setPropertyString("Name", string2);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setPairingConfirmation(String string2, boolean bl) {
        synchronized (this) {
            Integer n;
            String string3;
            block7: {
                block6: {
                    this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                    boolean bl2 = this.isEnabledInternal();
                    if (bl2) break block6;
                    return false;
                }
                string3 = string2.toUpperCase();
                n = this.mEventLoop.getPasskeyAgentRequestData().remove(string3);
                if (n != null) break block7;
                Log.w(TAG, "setPasskey(" + string3 + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n");
                return false;
            }
            boolean bl3 = this.setPairingConfirmationNative(string3, bl, n);
            return bl3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setPasskey(String string2, int n) {
        synchronized (this) {
            Integer n2;
            String string3;
            block7: {
                block6: {
                    this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                    boolean bl = this.isEnabledInternal();
                    if (bl) break block6;
                    return false;
                }
                if (n < 0) return false;
                if (n > 999999) return false;
                if (!BluetoothAdapter.checkBluetoothAddress(string2)) return false;
                string3 = string2.toUpperCase();
                n2 = this.mEventLoop.getPasskeyAgentRequestData().remove(string3);
                if (n2 != null) break block7;
                Log.w(TAG, "setPasskey(" + string3 + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n");
                return false;
            }
            boolean bl = this.setPasskeyNative(string3, n, n2);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setPin(String string2, byte[] byArray) {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
            boolean bl = this.isEnabledInternal();
            if (!bl) {
                return false;
            }
            if (byArray == null) return false;
            if (byArray.length <= 0) return false;
            if (byArray.length > 16) return false;
            if (BluetoothAdapter.checkBluetoothAddress(string2)) {
                String string3 = string2.toUpperCase();
                Integer n = this.mEventLoop.getPasskeyAgentRequestData().remove(string3);
                if (n == null) {
                    Log.w(TAG, "setPin(" + string3 + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n");
                    return false;
                }
                try {
                    String string4 = new String(byArray, "UTF8");
                    return this.setPinNative(string3, string4, n);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Log.e(TAG, "UTF8 not supported?!?");
                    return false;
                }
            }
            return false;
        }
    }

    void setProperty(String string2, String string3) {
        synchronized (this) {
            this.mAdapterProperties.put(string2, string3);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setRemoteDeviceProperty(String string2, String string3, String string4) {
        synchronized (this) {
            Map<String, String> map = this.mDeviceProperties.get(string2);
            if (map != null) {
                map.put(string3, string4);
                this.mDeviceProperties.put(string2, map);
            } else {
                Log.e(TAG, "setRemoteDeviceProperty for a device not in cache:" + string2);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setRemoteOutOfBandData(String string2) {
        synchronized (this) {
            byte[] byArray;
            byte[] byArray2;
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
            boolean bl = this.isEnabledInternal();
            if (!bl) {
                return false;
            }
            String string3 = string2.toUpperCase();
            Integer n = this.mEventLoop.getPasskeyAgentRequestData().remove(string3);
            if (n == null) {
                Log.w(TAG, "setRemoteOobData(" + string3 + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n");
                return false;
            }
            Pair<byte[], byte[]> pair = this.mDeviceOobData.get(string3);
            if (pair == null) {
                byArray2 = new byte[16];
                byArray = new byte[16];
                return this.setRemoteOutOfBandDataNative(string3, byArray2, byArray, n);
            } else {
                byArray2 = (byte[])pair.first;
                byArray = (byte[])pair.second;
            }
            return this.setRemoteOutOfBandDataNative(string3, byArray2, byArray, n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setScanMode(int n, int n2) {
        synchronized (this) {
            boolean bl;
            boolean bl2;
            this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS", "Need WRITE_SECURE_SETTINGS permission");
            switch (n) {
                default: {
                    Log.w(TAG, "Requested invalid scan mode " + n);
                    return false;
                }
                case 20: {
                    this.mHandler.removeMessages(4);
                    bl2 = false;
                    bl = false;
                    break;
                }
                case 21: {
                    this.mHandler.removeMessages(4);
                    bl2 = true;
                    bl = false;
                    break;
                }
                case 23: {
                    this.mHandler.removeMessages(4);
                    bl2 = true;
                    bl = true;
                    Message message = this.mHandler.obtainMessage(4);
                    this.mHandler.sendMessageDelayed(message, n2 * 1000);
                    Log.d(TAG, "BT Discoverable for " + n2 + " seconds");
                }
            }
            this.setPropertyBoolean("Pairable", bl2);
            this.setPropertyBoolean("Discoverable", bl);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setTrust(String string2, boolean bl) {
        synchronized (this) {
            if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                return false;
            }
            if (!this.isEnabledInternal()) {
                return false;
            }
            String string3 = this.getObjectPathFromAddress(string2);
            int n = bl ? 1 : 0;
            boolean bl2 = this.setDevicePropertyBooleanNative(string3, "Trusted", n);
            return bl2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean startDiscovery() {
        synchronized (this) {
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                boolean bl = this.isEnabledInternal();
                if (bl) break block4;
                return false;
            }
            boolean bl = this.startDiscoveryNative();
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateDeviceServiceChannelCache(String string2) {
        ParcelUuid[] parcelUuidArray = this.getRemoteUuids(string2);
        BluetoothService.log("updateDeviceServiceChannelCache(" + string2 + ")");
        ArrayList<ParcelUuid> arrayList = new ArrayList<ParcelUuid>();
        synchronized (this) {
            for (RemoteService remoteService : this.mUuidCallbackTracker.keySet()) {
                if (!remoteService.address.equals(string2)) continue;
                arrayList.add(remoteService.uuid);
            }
        }
        HashMap<ParcelUuid, Integer> hashMap = new HashMap<ParcelUuid, Integer>();
        for (ParcelUuid parcelUuid : RFCOMM_UUIDS) {
            if (!BluetoothUuid.isUuidPresent(parcelUuidArray, parcelUuid)) continue;
            int n = this.getDeviceServiceChannelNative(this.getObjectPathFromAddress(string2), parcelUuid.toString(), 4);
            BluetoothService.log("\tuuid(system): " + parcelUuid + " " + n);
            hashMap.put(parcelUuid, n);
        }
        for (ParcelUuid parcelUuid : arrayList) {
            if (!BluetoothUuid.isUuidPresent(parcelUuidArray, parcelUuid)) continue;
            int n = this.getDeviceServiceChannelNative(this.getObjectPathFromAddress(string2), parcelUuid.toString(), 4);
            BluetoothService.log("\tuuid(application): " + parcelUuid + " " + n);
            hashMap.put(parcelUuid, n);
        }
        synchronized (this) {
            Iterator<RemoteService> iterator = this.mUuidCallbackTracker.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.mDeviceServiceChannelCache.put(string2, hashMap);
                    return;
                }
                RemoteService remoteService = iterator.next();
                if (!remoteService.address.equals(string2)) continue;
                int n = -1;
                if (hashMap.get(remoteService.uuid) != null) {
                    n = (Integer)hashMap.get(remoteService.uuid);
                }
                if (n == -1) continue;
                BluetoothService.log("Making callback for " + remoteService.uuid + " with result " + n);
                IBluetoothCallback iBluetoothCallback = this.mUuidCallbackTracker.get(remoteService);
                if (iBluetoothCallback != null) {
                    try {
                        iBluetoothCallback.onRfcommChannelFound(n);
                    }
                    catch (RemoteException remoteException) {
                        Log.e(TAG, "", remoteException);
                    }
                }
                iterator.remove();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean updateRemoteDevicePropertiesCache(String string2) {
        synchronized (this) {
            String[] stringArray = this.getRemoteDeviceProperties(string2);
            if (stringArray == null) return false;
            this.addRemoteDeviceProperties(string2, stringArray);
            return true;
        }
    }

    public class BondState {
        private static final String AUTO_PAIRING_BLACKLIST = "/etc/bluetooth/auto_pairing.conf";
        private static final String DYNAMIC_AUTO_PAIRING_BLACKLIST = "/data/misc/bluetooth/dynamic_auto_pairing.conf";
        private ArrayList<String> mAutoPairingAddressBlacklist;
        private ArrayList<String> mAutoPairingDynamicAddressBlacklist;
        private ArrayList<String> mAutoPairingExactNameBlacklist;
        private ArrayList<String> mAutoPairingPartialNameBlacklist;
        private String mPendingOutgoingBonding;
        private final HashMap<String, Integer> mPinAttempt;
        private final HashMap<String, Integer> mState = new HashMap();

        public BondState() {
            this.mPinAttempt = new HashMap();
        }

        /*
         * Exception decompiling
         */
        private void copyAutoPairingData() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 14[TRYBLOCK] [29 : 163->167)] java.io.IOException
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void setPendingOutgoingBonding(String string2) {
            synchronized (this) {
                this.mPendingOutgoingBonding = string2;
                return;
            }
        }

        /*
         * Exception decompiling
         */
        private void updateAutoPairingData(String var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [13 : 160->165)] java.io.IOException
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void addAutoPairingFailure(String string2) {
            synchronized (this) {
                if (this.mAutoPairingDynamicAddressBlacklist == null) {
                    this.mAutoPairingDynamicAddressBlacklist = new ArrayList();
                }
                this.updateAutoPairingData(string2);
                this.mAutoPairingDynamicAddressBlacklist.add(string2);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void attempt(String string2) {
            synchronized (this) {
                int n;
                Integer n2 = this.mPinAttempt.get(string2);
                if (n2 == null) {
                    n = 1;
                } else {
                    int n3 = n2;
                    n = n3 + 1;
                }
                this.mPinAttempt.put(string2, new Integer(n));
                return;
            }
        }

        public void clearPinAttempts(String string2) {
            synchronized (this) {
                this.mPinAttempt.remove(string2);
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getAttempt(String string2) {
            synchronized (this) {
                Integer n;
                block4: {
                    n = this.mPinAttempt.get(string2);
                    if (n != null) break block4;
                    return 0;
                }
                int n2 = n;
                return n2;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getBondState(String string2) {
            synchronized (this) {
                Integer n;
                block4: {
                    n = this.mState.get(string2);
                    if (n != null) break block4;
                    return 10;
                }
                int n2 = n;
                return n2;
            }
        }

        public String getPendingOutgoingBonding() {
            synchronized (this) {
                String string2 = this.mPendingOutgoingBonding;
                return string2;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean hasAutoPairingFailed(String string2) {
            synchronized (this) {
                block4: {
                    ArrayList<String> arrayList = this.mAutoPairingDynamicAddressBlacklist;
                    if (arrayList != null) break block4;
                    return false;
                }
                boolean bl = this.mAutoPairingDynamicAddressBlacklist.contains(string2);
                return bl;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isAutoPairingAttemptsInProgress(String string2) {
            synchronized (this) {
                int n = this.getAttempt(string2);
                if (n == 0) return false;
                return true;
            }
        }

        public boolean isAutoPairingBlacklisted(String string2) {
            String string3;
            if (this.mAutoPairingAddressBlacklist != null) {
                Iterator<String> iterator = this.mAutoPairingAddressBlacklist.iterator();
                while (iterator.hasNext()) {
                    if (!string2.startsWith(iterator.next())) continue;
                    return true;
                }
            }
            if (this.mAutoPairingDynamicAddressBlacklist != null) {
                Iterator<String> iterator = this.mAutoPairingDynamicAddressBlacklist.iterator();
                while (iterator.hasNext()) {
                    if (!string2.equals(iterator.next())) continue;
                    return true;
                }
            }
            if ((string3 = BluetoothService.this.getRemoteName(string2)) != null) {
                if (this.mAutoPairingExactNameBlacklist != null) {
                    Iterator<String> iterator = this.mAutoPairingExactNameBlacklist.iterator();
                    while (iterator.hasNext()) {
                        if (!string3.equals(iterator.next())) continue;
                        return true;
                    }
                }
                if (this.mAutoPairingPartialNameBlacklist != null) {
                    Iterator<String> iterator = this.mAutoPairingPartialNameBlacklist.iterator();
                    while (iterator.hasNext()) {
                        if (!string3.startsWith(iterator.next())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String[] listInState(int n) {
            synchronized (this) {
                ArrayList<String> arrayList = new ArrayList<String>(this.mState.size());
                Iterator<Map.Entry<String, Integer>> iterator = this.mState.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Integer> entry = iterator.next();
                    if (entry.getValue() != n) continue;
                    arrayList.add(entry.getKey());
                }
                return arrayList.toArray(new String[arrayList.size()]);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void loadBondState() {
            synchronized (this) {
                int n = BluetoothService.this.mBluetoothState;
                if (n == 11) {
                    String string2 = BluetoothService.this.getPropertyInternal("Devices");
                    String[] stringArray = null;
                    if (string2 != null) {
                        stringArray = string2.split(",");
                    }
                    if (stringArray != null) {
                        this.mState.clear();
                        BluetoothService.log("found " + stringArray.length + " bonded devices");
                        for (String string3 : stringArray) {
                            this.mState.put(BluetoothService.this.getAddressFromObjectPath(string3).toUpperCase(), 12);
                        }
                    }
                }
                return;
            }
        }

        /*
         * Exception decompiling
         */
        public void readAutoPairingData() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [17, 18, 19 : 196->228)] java.io.FileNotFoundException
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void setBondState(String string2, int n) {
            synchronized (this) {
                this.setBondState(string2, n, 0);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setBondState(String string2, int n, int n2) {
            synchronized (this) {
                int n3 = this.getBondState(string2);
                if (n3 != n) {
                    if (n3 == 11 && string2.equals(this.mPendingOutgoingBonding)) {
                        this.mPendingOutgoingBonding = null;
                    }
                    if (n == 12) {
                        BluetoothService.this.addProfileState(string2);
                    } else if (n == 10) {
                        BluetoothService.this.removeProfileState(string2);
                    }
                    BluetoothService.log(string2 + " bond state " + n3 + " -> " + n + " (" + n2 + ")");
                    Intent intent = new Intent("android.bluetooth.device.action.BOND_STATE_CHANGED");
                    intent.putExtra("android.bluetooth.device.extra.DEVICE", BluetoothService.this.mAdapter.getRemoteDevice(string2));
                    intent.putExtra("android.bluetooth.device.extra.BOND_STATE", n);
                    intent.putExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", n3);
                    if (n == 10) {
                        if (n2 <= 0) {
                            Log.w(BluetoothService.TAG, "setBondState() called to unbond device, but reason code is invalid. Overriding reason code with BOND_RESULT_REMOVED");
                            n2 = 9;
                        }
                        intent.putExtra("android.bluetooth.device.extra.REASON", n2);
                        this.mState.remove(string2);
                    } else {
                        this.mState.put(string2, n);
                    }
                    BluetoothService.this.mContext.sendBroadcast(intent, BluetoothService.BLUETOOTH_PERM);
                }
                return;
            }
        }
    }

    private class EnableThread
    extends Thread {
        private final boolean mSaveSetting;

        public EnableThread(boolean bl) {
            this.mSaveSetting = bl;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block23: {
                block19: {
                    block20: {
                        block22: {
                            if (BluetoothService.access$300(BluetoothService.this) != 0) break block22;
                            var1_1 = true;
lbl3:
                            // 2 sources

                            while (var1_1) {
                                var13_2 = false;
                                var14_3 = 2;
                                block6: while (true) {
                                    var15_7 = var14_3 - 1;
                                    if (var14_3 <= 0 || var13_2) break block19;
                                    BluetoothService.access$400(BluetoothService.this).start();
                                    var17_4 = 5;
lbl11:
                                    // 2 sources

                                    while (true) {
                                        var18_5 = var17_4 - 1;
                                        if (var17_4 > 0 && !var13_2) {
                                            if (!BluetoothService.access$400(BluetoothService.this).isEventLoopRunning()) break block20;
                                            var13_2 = true;
                                        }
                                        var14_3 = var15_7;
                                        continue block6;
                                        break;
                                    }
                                    break;
                                }
                            }
                            break block23;
                        }
                        var1_1 = false;
                        ** GOTO lbl3
                    }
                    try {
                        Thread.sleep(100L);
                        var17_4 = var18_5;
                    }
                    catch (InterruptedException var19_6) {
                        var17_4 = var18_5;
                    }
                    ** while (true)
                }
                if (!var13_2) {
                    BluetoothService.access$500("bt EnableThread giving up");
                    var1_1 = false;
                    BluetoothService.access$600(BluetoothService.this);
                }
            }
            if (!var1_1) ** GOTO lbl55
            if (!BluetoothService.access$700(BluetoothService.this)) {
                return;
            }
            if (this.mSaveSetting) {
                BluetoothService.access$800(BluetoothService.this, true);
            }
            BluetoothService.access$902(BluetoothService.this, false);
            BluetoothService.access$1000(BluetoothService.this).readAutoPairingData();
            BluetoothService.access$1000(BluetoothService.this).loadBondState();
            BluetoothService.access$1100(BluetoothService.this);
            BluetoothService.access$100(BluetoothService.this).sendMessageDelayed(BluetoothService.access$100(BluetoothService.this).obtainMessage(1, 1, -1), 3000L);
            var9_8 = Binder.clearCallingIdentity();
            try {
                BluetoothService.access$1200(BluetoothService.this).noteBluetoothOn();
            }
            catch (Throwable var12_12) {
                Binder.restoreCallingIdentity(var9_8);
                throw var12_12;
            }
lbl53:
            // 2 sources

            while (true) {
                Binder.restoreCallingIdentity(var9_8);
lbl55:
                // 2 sources

                BluetoothService.access$1302(BluetoothService.this, null);
                var3_9 = BluetoothService.this;
                if (var1_1) {
                    var4_10 = 12;
lbl60:
                    // 2 sources

                    while (true) {
                        BluetoothService.access$1400(var3_9, var4_10);
                        if (var1_1) {
                            var6_11 = new String[]{"Pairable", BluetoothService.this.getProperty("Pairable")};
                            BluetoothService.access$400(BluetoothService.this).onPropertyChanged(var6_11);
                        }
                        if (!BluetoothService.access$1500(BluetoothService.this) || !BluetoothService.access$1600(BluetoothService.this) || BluetoothService.access$1700(BluetoothService.this)) ** continue;
                        BluetoothService.this.disable(false);
                        return;
                    }
                }
                break;
            }
            var4_10 = 10;
            ** while (true)
            catch (RemoteException var11_13) {
                ** continue;
            }
        }
    }

    private class Reaper
    implements IBinder.DeathRecipient {
        int handle;
        int pid;

        Reaper(int n, int n2) {
            this.pid = n2;
            this.handle = n;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void binderDied() {
            BluetoothService bluetoothService = BluetoothService.this;
            synchronized (bluetoothService) {
                BluetoothService.log("Tracked app " + this.pid + " died");
                BluetoothService.this.checkAndRemoveRecord(this.handle, this.pid);
                return;
            }
        }
    }

    private static class RemoteService {
        public String address;
        public ParcelUuid uuid;

        public RemoteService(String string2, ParcelUuid parcelUuid) {
            this.address = string2;
            this.uuid = parcelUuid;
        }

        public boolean equals(Object object) {
            if (object instanceof RemoteService) {
                RemoteService remoteService = (RemoteService)object;
                return this.address.equals(remoteService.address) && this.uuid.equals(remoteService.uuid);
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public int hashCode() {
            int n;
            int cfr_ignored_0 = 1 * 31;
            int n2 = this.address == null ? 0 : this.address.hashCode();
            int n3 = 31 * (n2 + 31);
            if (this.uuid == null) {
                n = 0;
                return n3 + n;
            }
            n = this.uuid.hashCode();
            return n3 + n;
        }
    }
}

