/*
 * Decompiled with CFR 0.152.
 */
package android.server.search;

import android.app.ISearchManager;
import android.app.SearchableInfo;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Process;
import android.server.search.Searchables;
import android.util.Log;
import com.android.internal.content.PackageMonitor;
import java.util.List;

public class SearchManagerService
extends ISearchManager.Stub {
    private static final String TAG = "SearchManagerService";
    private final Context mContext;
    private Searchables mSearchables;

    public SearchManagerService(Context context) {
        this.mContext = context;
        this.mContext.registerReceiver(new BootCompletedReceiver(), new IntentFilter("android.intent.action.BOOT_COMPLETED"));
    }

    private Searchables getSearchables() {
        synchronized (this) {
            if (this.mSearchables == null) {
                Log.i(TAG, "Building list of searchable activities");
                new MyPackageMonitor().register(this.mContext, true);
                this.mSearchables = new Searchables(this.mContext);
                this.mSearchables.buildSearchableList();
            }
            Searchables searchables = this.mSearchables;
            return searchables;
        }
    }

    @Override
    public ComponentName getGlobalSearchActivity() {
        return this.getSearchables().getGlobalSearchActivity();
    }

    @Override
    public SearchableInfo getSearchableInfo(ComponentName componentName) {
        if (componentName == null) {
            Log.e(TAG, "getSearchableInfo(), activity == null");
            return null;
        }
        return this.getSearchables().getSearchableInfo(componentName);
    }

    @Override
    public List<SearchableInfo> getSearchablesInGlobalSearch() {
        return this.getSearchables().getSearchablesInGlobalSearchList();
    }

    @Override
    public ComponentName getWebSearchActivity() {
        return this.getSearchables().getWebSearchActivity();
    }

    private final class BootCompletedReceiver
    extends BroadcastReceiver {
        private BootCompletedReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            new Thread(){

                @Override
                public void run() {
                    Process.setThreadPriority(10);
                    SearchManagerService.this.mContext.unregisterReceiver(BootCompletedReceiver.this);
                    SearchManagerService.this.getSearchables();
                }
            }.start();
        }
    }

    class MyPackageMonitor
    extends PackageMonitor {
        MyPackageMonitor() {
        }

        @Override
        public void onSomePackagesChanged() {
            SearchManagerService.this.getSearchables().buildSearchableList();
            Intent intent = new Intent("android.search.action.SEARCHABLES_CHANGED");
            intent.addFlags(0x20000000);
            SearchManagerService.this.mContext.sendBroadcast(intent);
        }
    }
}

